/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataInput;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.MQBufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQField;
import com.ibm.ws.sib.mfp.mqinterop.MQHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderInfo;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.ws.sib.mfp.mqinterop.impl.ByteBufferReadableByteChannel;
import com.ibm.ws.sib.mfp.mqinterop.impl.CharArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.HeaderArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntField;
import com.ibm.ws.sib.mfp.mqinterop.impl.LongField;
import com.ibm.ws.sib.mfp.mqinterop.impl.ShortField;
import com.ibm.ws.sib.mfp.mqinterop.impl.SingleByteField;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class BufferedHeader
implements MQHeader,
MQBufferedHeader,
Cloneable {
    private final boolean switchable;
    private BufferedHeaderType type;
    private ByteBuffer backingBuffer;
    private BufferedHeader parent;
    private int origin;
    private int encoding = 273;
    private int characterSet = 1208;

    public BufferedHeader(BufferedHeaderType bufferedHeaderType) {
        this.type = bufferedHeaderType;
        if (bufferedHeaderType.typeRule.next() == null) {
            this.switchable = false;
        } else {
            this.switchable = true;
            this.checkSwitchType(true);
        }
    }

    protected BufferedHeader(BufferedHeaderType bufferedHeaderType, DataInput dataInput, int n, int n2) throws IOException {
        this(bufferedHeaderType);
        this.read(dataInput, n, n2);
    }

    protected BufferedHeader(BufferedHeaderType bufferedHeaderType, WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        this(bufferedHeaderType);
        this.read(wsByteBuffer, n, n2);
    }

    public BufferedHeaderType getType() {
        return this.type;
    }

    protected void setType(BufferedHeaderType bufferedHeaderType) {
        if (bufferedHeaderType != this.type) {
            if (bufferedHeaderType.typeRule == this.type.typeRule && (this.backingBuffer == null || bufferedHeaderType.size() <= this.type.size())) {
                this.type = bufferedHeaderType;
            } else {
                throw new RuntimeException("Type change from " + this.type.getName() + " to " + bufferedHeaderType.getName() + "vetoed");
            }
        }
    }

    public int encoding() {
        return this.encoding;
    }

    protected void encoding(int n) {
        if (this.backingBuffer != null) {
            if ((n & 0xF) == 2) {
                this.backingBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.backingBuffer.order(ByteOrder.BIG_ENDIAN);
            }
        }
        this.encoding = n;
    }

    public int characterSet() {
        return this.characterSet;
    }

    protected void characterSet(int n) {
        this.characterSet = n;
    }

    public int read(DataInput dataInput, int n, int n2) throws IOException {
        if (dataInput instanceof ByteBufferDataInput) {
            return this.read(((ByteBufferDataInput)dataInput).getByteBuffer(), n, n2);
        }
        int n3 = this.type.minSize;
        byte[] byArray = new byte[n3];
        dataInput.readFully(byArray);
        this.parent = null;
        this.backingBuffer = ByteBuffer.wrap(byArray);
        this.origin = 0;
        this.encoding = n;
        this.characterSet = n2;
        if ((n & 0xF) == 2) {
            this.backingBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.checkSwitchType(true);
        this.type.validate(this);
        int n4 = this.size();
        if (n4 > n3) {
            byte[] byArray2 = byArray;
            byArray = new byte[n4];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            dataInput.readFully(byArray, n3, n4 - n3);
            this.backingBuffer = ByteBuffer.wrap(byArray);
            if ((n & 0xF) == 2) {
                this.backingBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        return n4;
    }

    public int write(DataOutput dataOutput, int n, int n2) throws IOException {
        this.type.validate(this);
        BufferedField[] bufferedFieldArray = this.type.getFields();
        int n3 = 0;
        for (int i = 0; i < bufferedFieldArray.length; ++i) {
            n3 += bufferedFieldArray[i].write(this, dataOutput, n, n2);
        }
        return n3;
    }

    public int size() {
        if (this.type.isVariableSize) {
            int n = this.type.fixedSize;
            for (int i = this.type.getFixedFieldCount(); i < this.type.getFieldCount(); ++i) {
                n += this.type.getField(i).size(this);
            }
            return n;
        }
        return this.type.fixedSize;
    }

    public Iterator fields() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < BufferedHeader.this.type.getFieldCount();
            }

            public Object next() {
                try {
                    InternalField internalField = new InternalField(BufferedHeader.this.type.getField(this.index));
                    ++this.index;
                    return internalField;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ConcurrentModificationException("No field for index " + this.index + " in type " + BufferedHeader.this.type);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove fields");
            }
        };
    }

    public Object getValue(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            return ((BufferedHeader)this.getValue(string.substring(0, n))).getValue(string.substring(n + 1));
        }
        return this.getValue(this.type.getFieldIndex(string));
    }

    public void setValue(String string, Object object) {
        int n = string.indexOf(46);
        if (n >= 0) {
            ((BufferedHeader)this.getValue(string.substring(0, n))).setValue(string.substring(n + 1), object);
        } else {
            this.setValue(this.type.getFieldIndex(string), object);
        }
    }

    public int getIntValue(String string) {
        return (Integer)this.getValue(string);
    }

    public void setIntValue(String string, int n) {
        this.setValue(string, (Object)new Integer(n));
    }

    public byte getByteValue(String string) {
        return (Byte)this.getValue(string);
    }

    public void setByteValue(String string, byte by) {
        this.setValue(string, (Object)new Byte(by));
    }

    public short getShortValue(String string) {
        return (Short)this.getValue(string);
    }

    public void setShortValue(String string, short s) {
        this.setValue(string, (Object)new Short(s));
    }

    public long getLongValue(String string) {
        return (Long)this.getValue(string);
    }

    public void setLongValue(String string, long l) {
        this.setValue(string, (Object)new Long(l));
    }

    public byte[] getBytesValue(String string) {
        return (byte[])this.getValue(string);
    }

    public void setBytesValue(String string, byte[] byArray) {
        this.setValue(string, (Object)byArray);
    }

    public String getStringValue(String string) {
        return (String)this.getValue(string);
    }

    public void setStringValue(String string, String string2) {
        this.setValue(string, (Object)string2);
    }

    public MQHeaderInfo headerInfo() {
        return this.type;
    }

    public int nextEncoding() {
        return this.encoding();
    }

    public int nextCharacterSet() {
        return this.characterSet;
    }

    public String nextFormat() {
        return null;
    }

    public int read(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        return this.read(wsByteBuffer.getWrappedByteBuffer(), n, n2);
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        this.parent = null;
        this.backingBuffer = byteBuffer.slice();
        this.encoding = n;
        this.characterSet = n2;
        this.origin = byteBuffer.position();
        if ((n & 0xF) == 2) {
            this.backingBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.checkSwitchType(true);
        this.type.validate(this);
        int n3 = this.size();
        this.backingBuffer.limit(n3);
        byteBuffer.position(this.origin + n3);
        return n3;
    }

    public int write(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        return this.write(wsByteBuffer.getWrappedByteBuffer(), n, n2);
    }

    public int write(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        this.type.validate(this);
        int n3 = this.size();
        ByteBuffer byteBuffer2 = this.getBuffer(0);
        if (byteBuffer2 != null && this.characterSet == n2 && this.getByteOrder(n) == byteBuffer2.order()) {
            if (byteBuffer2.hasArray() && byteBuffer.hasArray() && byteBuffer2.array() == byteBuffer.array() && byteBuffer2.arrayOffset() + byteBuffer2.position() == byteBuffer.arrayOffset() + byteBuffer.position()) {
                byteBuffer.position(byteBuffer.position() + n3);
            } else {
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.put(byteBuffer2.get());
                }
            }
        } else {
            this.write(new ByteBufferDataOutput(byteBuffer), n, n2);
        }
        return n3;
    }

    protected final ByteOrder getByteOrder(int n) {
        if ((n & 0xF) == 2) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    protected final ByteBuffer getBuffer(int n) {
        ByteBuffer byteBuffer = this.backingBuffer;
        if (byteBuffer != null) {
            byteBuffer.position(n);
        } else if (this.parent != null && (byteBuffer = this.parent.getBuffer(n)) != null) {
            byteBuffer.position(byteBuffer.position() + this.origin);
        }
        return byteBuffer;
    }

    protected final ByteBuffer getBuffer(int n, int n2) {
        ByteBuffer byteBuffer = this.backingBuffer;
        if (byteBuffer != null) {
            if (n + n2 > byteBuffer.limit()) {
                byte[] byArray = new byte[Math.max(this.type.size(), n + n2)];
                byteBuffer.position(0);
                byteBuffer.get(byArray, 0, byteBuffer.limit());
                byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(this.backingBuffer.order());
                this.backingBuffer = byteBuffer;
            }
            byteBuffer.position(n);
        } else if (this.parent == null) {
            byteBuffer = ByteBuffer.allocate(Math.max(this.type.size(), n + n2));
            try {
                this.encoding = 273;
                this.characterSet = 1208;
                this.write(new ByteBufferDataOutput(byteBuffer), 273, 1208);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader.getBuffer", (String)"739", (Object)this);
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
            this.backingBuffer = byteBuffer;
            byteBuffer.position(n);
        } else {
            byteBuffer = this.parent.getBuffer(n, this.parent.size() - n);
            byteBuffer.position(byteBuffer.position() + this.origin);
        }
        return byteBuffer;
    }

    void setParent(BufferedHeader bufferedHeader, int n) {
        this.parent = bufferedHeader;
        this.backingBuffer = null;
        this.origin = n;
        this.encoding = bufferedHeader.encoding;
        this.characterSet = bufferedHeader.characterSet;
    }

    private final void checkSwitchType(boolean bl) {
        BufferedHeaderType bufferedHeaderType;
        if (this.switchable && (bufferedHeaderType = this.type.typeRule.getMatchingType(this)) != null && bufferedHeaderType != this.type) {
            if (this.parent == null) {
                if (!bl && this.backingBuffer != null && bufferedHeaderType.size() > this.backingBuffer.limit()) {
                    BufferedHeaderType bufferedHeaderType2 = this.type;
                    ByteBuffer byteBuffer = this.backingBuffer;
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(bufferedHeaderType.size());
                    byteBuffer2.order(byteBuffer.order());
                    byteBuffer.position(0);
                    byteBuffer.get(byteBuffer2.array(), 0, bufferedHeaderType2.size());
                    byteBuffer2.position(byteBuffer.position());
                    this.type = bufferedHeaderType;
                    this.backingBuffer = null;
                    ByteBufferDataOutput byteBufferDataOutput = new ByteBufferDataOutput(byteBuffer2);
                    BufferedField[] bufferedFieldArray = bufferedHeaderType.getFields();
                    try {
                        for (int i = bufferedHeaderType2.getFieldCount(); i < bufferedFieldArray.length; ++i) {
                            bufferedFieldArray[i].write(this, byteBufferDataOutput, this.encoding(), this.characterSet);
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader.checkSwitchType", (String)"804", (Object)this);
                        throw new RuntimeException(iOException.getMessage(), iOException);
                    }
                    this.backingBuffer = byteBuffer2;
                } else {
                    this.type = bufferedHeaderType;
                }
            } else {
                if (!bl && this.backingBuffer != null && bufferedHeaderType.size() > this.type.size()) {
                    throw new IllegalArgumentException("Error switching type " + this.type.getName() + " --> " + bufferedHeaderType.getName() + ": Can't switch header type to larger size when embedded.");
                }
                this.type = bufferedHeaderType;
            }
        }
    }

    public Object getValue(int n) {
        return this.type.getField(n).getValue(this);
    }

    public void setValue(int n, Object object) {
        this.type.getField(n).setValue(this, object);
        this.checkSwitchType(false);
    }

    public int getIntValue(int n) {
        return this.type.getField(n).getIntValue(this);
    }

    public void setIntValue(int n, int n2) {
        ((IntField)this.type.getField(n)).setIntValue(this, n2);
        this.checkSwitchType(false);
    }

    public String getStringValue(int n) {
        return (String)this.getValue(n);
    }

    public void setStringValue(int n, String string) {
        ((CharArrayField)this.type.getField(n)).setStringValue(this, string);
        this.checkSwitchType(false);
    }

    public byte getByteValue(int n) {
        return ((SingleByteField)this.type.getField(n)).getByteValue(this);
    }

    public void setByteValue(int n, byte by) {
        ((SingleByteField)this.type.getField(n)).setByteValue(this, by);
        this.checkSwitchType(false);
    }

    public short getShortValue(int n) {
        return ((ShortField)this.type.getField(n)).getShortValue(this);
    }

    public void setShortValue(int n, short s) {
        ((ShortField)this.type.getField(n)).setShortValue(this, s);
        this.checkSwitchType(false);
    }

    public long getLongValue(int n) {
        return ((LongField)this.type.getField(n)).getLongValue(this);
    }

    public void setLongValue(int n, long l) {
        ((LongField)this.type.getField(n)).setLongValue(this, l);
        this.checkSwitchType(false);
    }

    public byte[] getBytesValue(int n) {
        return (byte[])this.getValue(n);
    }

    public void setBytesValue(int n, byte[] byArray) {
        this.type.getField(n).setValue(this, byArray);
        this.checkSwitchType(false);
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = this.getBuffer(0);
        byte[] byArray = null;
        if (byteBuffer != null) {
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    public int[] getIntArrayValue(int n) {
        return ((IntArrayField)this.type.getField(n)).getIntArrayValue(this);
    }

    public void setIntArrayValue(int n, int[] nArray) {
        ((IntArrayField)this.type.getField(n)).setIntArrayValue(this, nArray);
    }

    public MQHeader[] getHeaderArrayValue(int n) {
        return ((HeaderArrayField)this.type.getField(n)).getHeaderArrayValue(this);
    }

    public void setHeaderArrayValue(int n, MQHeader[] mQHeaderArray) {
        ((HeaderArrayField)this.type.getField(n)).setHeaderArrayValue(this, mQHeaderArray);
    }

    public Object clone() {
        try {
            BufferedHeader bufferedHeader = (BufferedHeader)super.clone();
            ByteBuffer byteBuffer = this.getBuffer(0);
            if (byteBuffer != null) {
                bufferedHeader.backingBuffer = ByteBuffer.allocate(this.size()).order(byteBuffer.order());
                new ByteBufferReadableByteChannel(this.getBuffer(0)).read(bufferedHeader.backingBuffer);
            }
            bufferedHeader.parent = null;
            bufferedHeader.origin = 0;
            return bufferedHeader;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader.clone", (String)"1047", (Object)this);
            throw new RuntimeException("Error cloning header content: " + iOException.toString());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader.clone", (String)"1054", (Object)this);
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer('{' + this.getClass().getName() + " [type '" + this.type.getName() + "', size: " + this.size() + ", variable: " + this.type.isVariableSize() + "; ");
        stringBuffer.append("\n\tbuffer: " + this.backingBuffer + ", origin: " + this.origin + ", order: " + (this.backingBuffer != null ? this.backingBuffer.order().toString() : "none") + ", parent: " + (this.parent != null) + ']');
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            stringBuffer.append("\n\t");
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append('}');
        return new String(stringBuffer);
    }

    class InternalField
    implements MQField {
        final BufferedField field;

        public InternalField(BufferedField bufferedField) {
            this.field = bufferedField;
        }

        public String getName() {
            return this.field.getName();
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            return this.field.read(BufferedHeader.this, dataInput, n, n2);
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            return this.field.write(BufferedHeader.this, dataOutput, n, n2);
        }

        public int size() {
            return this.field.size(BufferedHeader.this);
        }

        public Object getValue() {
            return this.field.getValue(BufferedHeader.this);
        }

        public void setValue(Object object) {
            this.field.setValue(BufferedHeader.this, object);
        }

        public String toString() {
            return this.getName() + " = " + this.print(this.getValue());
        }

        String print(Object object) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                return n + " (0x" + HexString.hexString(n) + ')';
            }
            if (object instanceof Short) {
                short s = (Short)object;
                return s + " (0x" + HexString.hexString(s) + ')';
            }
            if (object instanceof Byte) {
                byte by = (Byte)object;
                return by + " (0x" + HexString.hexString(by) + ')';
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return "0x" + HexString.hexString(byArray) + " (" + byArray.length + " bytes)";
            }
            if (object instanceof int[]) {
                StringBuffer stringBuffer = new StringBuffer("{");
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(Integer.toString(nArray[i]));
                    stringBuffer.append(' ');
                }
                return new String(stringBuffer).trim() + '}';
            }
            if (object instanceof String) {
                return "\"" + object + "\" (0x" + HexString.hexString((String)object) + ", " + ((String)object).length() + " chars)";
            }
            if (object == null) {
                return "null";
            }
            return object.toString();
        }
    }
}

