/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.api.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2ElementImpl;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2FolderParser;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MQRFH2Impl
extends BufferedHeader
implements MQRFH2 {
    public static final BufferedHeaderType type = new BufferedHeaderType("MQRFH2"){

        protected void createFields() {
            this.createMQChar(MQRFH2.StrucId.name, "RFH ");
            this.createMQLong(MQRFH2.Version.name, 2);
            this.createMQLong(MQRFH2.StrucLength.name, 36);
            this.createMQLong(MQRFH2.Encoding.name);
            this.createMQLong(MQRFH2.CodedCharSetId.name);
            this.createMQChar(MQRFH2.Format.name, 8);
            this.createMQLong(MQRFH2.Flags.name);
            this.createMQLong(MQRFH2.NameValueCCSID.name, 1208);
            this.createMQByte(MQRFH2.NameValueData.name, MQRFH2.StrucLength.index, 4, 36);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "RFH ", MQRFH2.StrucId.index);
            this.checkVersion(bufferedHeader, 2, MQRFH2.Version.index);
            this.checkMinimumLength(bufferedHeader, 36, MQRFH2.StrucLength.index);
        }
    };
    private MQRFH2ElementImpl[] folders;
    private MQRFH2FolderParser parser;
    private boolean changed;

    public MQRFH2Impl() {
        super(type);
    }

    public MQRFH2Impl(DataInput dataInput, int n, int n2) throws IOException {
        super(type, dataInput, n, n2);
    }

    public MQRFH2Impl(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        super(type, wsByteBuffer, n, n2);
    }

    public int read(DataInput dataInput, int n, int n2) throws IOException {
        this.clearFolders();
        return super.read(dataInput, n, n2);
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        this.clearFolders();
        return super.read(byteBuffer, n, n2);
    }

    public int read(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        this.clearFolders();
        return super.read(wsByteBuffer, n, n2);
    }

    public int write(DataOutput dataOutput, int n, int n2) throws IOException {
        int n3 = this.size();
        if (n3 <= 36 || this.isReversed(n) == this.isReversed(this.encoding())) {
            super.write(dataOutput, n, n2);
        } else {
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            super.write(new ByteBufferDataOutput(byteBuffer), n, n2);
            this.reverseFolderEncoding(byteBuffer, 36, this.isReversed(n));
            dataOutput.write(byArray);
        }
        return n3;
    }

    private void reverseFolderEncoding(ByteBuffer byteBuffer, int n, boolean bl) {
        int n2 = this.getIntValue(MQRFH2Impl.StrucLength.index);
        int n3 = 36;
        int n4 = n - n3;
        ByteBuffer byteBuffer2 = this.getBuffer(n3);
        if (byteBuffer2 != null) {
            while (n3 < n2) {
                int n5 = byteBuffer2.getInt();
                byteBuffer.putInt(n3 + n4, bl ? this.reverse(n5) : n5);
                n3 = n3 + n5 + 4;
                byteBuffer2.position(n3);
            }
        }
    }

    private boolean isReversed(int n) {
        return (n & 0xF) == 2;
    }

    private int reverse(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    public int size() {
        try {
            this.writeFolders();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl.size", (String)"216", (Object)this);
        }
        return super.size();
    }

    MQRFH2FolderParser getFolderParser() throws ParserConfigurationException, SAXException {
        if (this.parser == null) {
            this.parser = new MQRFH2FolderParser();
        }
        return this.parser;
    }

    private synchronized void clearFolders() {
        this.folders = null;
        this.changed = false;
    }

    private synchronized void writeFolders() throws IOException {
        if (this.changed && this.folders != null) {
            String[] stringArray = new String[this.folders.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.folders[i].toXML();
            }
            this.folders = null;
            this.changed = false;
            this.setFolderStrings(stringArray);
        }
    }

    void setChanged() {
        this.changed = true;
    }

    public int nextEncoding() {
        return this.getEncoding();
    }

    public int nextCharacterSet() {
        return this.getCodedCharSetId();
    }

    public String nextFormat() {
        return this.getFormat();
    }

    public String getStrucId() {
        return this.getStringValue(MQRFH2Impl.StrucId.index);
    }

    public int getVersion() {
        return this.getIntValue(MQRFH2Impl.Version.index);
    }

    public int getStrucLength() {
        try {
            this.writeFolders();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl.getStrucLength", (String)"312", (Object)this);
        }
        return this.getIntValue(MQRFH2Impl.StrucLength.index);
    }

    public int getEncoding() {
        return this.getIntValue(MQRFH2Impl.Encoding.index);
    }

    public void setEncoding(int n) {
        this.setIntValue(MQRFH2Impl.Encoding.index, n);
    }

    public int getCodedCharSetId() {
        return this.getIntValue(MQRFH2Impl.CodedCharSetId.index);
    }

    public void setCodedCharSetId(int n) {
        this.setIntValue(MQRFH2Impl.CodedCharSetId.index, n);
    }

    public String getFormat() {
        return this.getStringValue(MQRFH2Impl.Format.index);
    }

    public void setFormat(String string) {
        this.setStringValue(MQRFH2Impl.Format.index, string);
    }

    public int getFlags() {
        return this.getIntValue(MQRFH2Impl.Flags.index);
    }

    public void setFlags(int n) {
        this.setIntValue(MQRFH2Impl.Flags.index, n);
    }

    public int getNameValueCCSID() {
        return this.getIntValue(MQRFH2Impl.NameValueCCSID.index);
    }

    public void setNameValueCCSID(int n) {
        this.setIntValue(MQRFH2Impl.NameValueCCSID.index, n);
    }

    public int getNameValueLength() {
        try {
            this.writeFolders();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl.getNameValueLength", (String)"386", (Object)this);
        }
        return this.getIntValue(MQRFH2Impl.StrucLength.index) - 36;
    }

    public byte[] getNameValueData() {
        try {
            this.writeFolders();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl.getNameValueData", (String)"403", (Object)this);
        }
        return this.getBytesValue(MQRFH2Impl.NameValueData.index);
    }

    public void setNameValueData(byte[] byArray) {
        this.clearFolders();
        this.setBytesValue(MQRFH2Impl.NameValueData.index, byArray);
    }

    public void setNameValueData(String string) throws UnsupportedEncodingException {
        this.clearFolders();
        this.setFolderStrings(new String[]{string == null ? "" : string});
    }

    public String[] getFolderStrings() throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getNameValueData());
        String string = CCSID.getCodepage(this.getNameValueCCSID());
        Vector<String> vector = new Vector<String>();
        if (this.isReversed(this.encoding())) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int n = byteBuffer.capacity();
        while (n > 4) {
            byte[] byArray = new byte[byteBuffer.getInt()];
            byteBuffer.get(byArray);
            vector.addElement(new String(byArray, string).trim());
            n = byteBuffer.capacity() - byteBuffer.position();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setFolderStrings(String[] stringArray) throws UnsupportedEncodingException {
        byte[] byArray;
        String string = CCSID.getCodepage(this.getNameValueCCSID());
        byte by = " ".getBytes(string)[0];
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            byArray = stringArray[i].getBytes(string);
            n += 4 + byArray.length + this.getPadLength(byArray.length);
            objectArray[i] = byArray;
        }
        ByteBuffer byteBuffer = this.getBuffer(36, n);
        for (int i = 0; i < objectArray.length; ++i) {
            byArray = (byte[])objectArray[i];
            if (byArray == null) continue;
            int n2 = this.getPadLength(byArray.length);
            byteBuffer.putInt(byArray.length + n2);
            byteBuffer.put(byArray);
            while (n2-- > 0) {
                byteBuffer.put(by);
            }
        }
        this.setIntValue(MQRFH2Impl.StrucLength.index, 36 + n);
    }

    public String getFolderContent(String string) throws IOException {
        MQRFH2.Element element = this.getFolder(string, false);
        if (element == null) {
            return null;
        }
        return element.getContent();
    }

    public synchronized void setFolderContent(String string, String string2) throws IOException {
        MQRFH2.Element element = this.getFolder(string, false);
        if (element == null) {
            if (string2 != null && string != null) {
                int n = this.folders.length;
                this.folders = new MQRFH2ElementImpl[n + 1];
                System.arraycopy(this.folders, 0, this.folders, 0, n);
                this.folders[n] = new MQRFH2ElementImpl(this, '<' + string + '>' + string2 + "</" + string + '>');
                this.changed = true;
            }
        } else if (string2 == null) {
            MQRFH2ElementImpl[] mQRFH2ElementImplArray = new MQRFH2ElementImpl[this.folders.length - 1];
            int n = 0;
            for (int i = 0; i < this.folders.length; ++i) {
                if (element == this.folders[i]) continue;
                mQRFH2ElementImplArray[n++] = this.folders[i];
            }
            this.folders = mQRFH2ElementImplArray;
            this.changed = true;
        } else {
            element.setStringValue(string2, false);
            this.changed = true;
        }
    }

    public synchronized MQRFH2.Element[] getFolders() throws IOException {
        if (this.folders == null) {
            String[] stringArray = this.getFolderStrings();
            this.folders = new MQRFH2ElementImpl[stringArray.length];
            for (int i = 0; i < this.folders.length; ++i) {
                this.folders[i] = new MQRFH2ElementImpl(this, stringArray[i]);
            }
        }
        return (MQRFH2.Element[])this.folders.clone();
    }

    public synchronized MQRFH2.Element getFolder(String string, boolean bl) throws IOException {
        int n;
        MQRFH2.Element[] elementArray = this.getFolders();
        MQRFH2.Element element = null;
        for (n = 0; n < elementArray.length && element == null; ++n) {
            if (!string.equals(elementArray[n].getName())) continue;
            element = elementArray[n];
        }
        if (element == null && bl) {
            n = elementArray.length;
            this.folders = new MQRFH2ElementImpl[n + 1];
            System.arraycopy(elementArray, 0, this.folders, 0, n);
            this.folders[n] = new MQRFH2ElementImpl(this, string, null);
            this.changed = true;
            element = this.folders[n];
        }
        return element;
    }

    public Object getFieldValue(String string, String string2) throws IOException {
        return this.getFieldValue(string, string2, 0);
    }

    public Object getFieldValue(String string, String string2, int n) throws IOException {
        MQRFH2.Element element = this.getFolder(string, false);
        Object object = null;
        if (element != null) {
            MQRFH2.Element[] elementArray = element.getChildren();
            for (int i = 0; i < elementArray.length && object == null; ++i) {
                if (!string2.equals(elementArray[i].getName()) || n-- < 0) continue;
                object = elementArray[i].getValue();
            }
        }
        return object;
    }

    public List getFieldValues(String string, String string2) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MQRFH2.Element element = this.getFolder(string, false);
        Object var5_5 = null;
        if (element != null) {
            MQRFH2.Element[] elementArray = element.getChildren();
            for (int i = 0; i < elementArray.length && var5_5 == null; ++i) {
                if (!string2.equals(elementArray[i].getName())) continue;
                arrayList.add(elementArray[i].getValue());
            }
        }
        return arrayList;
    }

    public void setFieldValue(String string, String string2, Object object) throws IOException {
        this.setFieldValue(string, string2, object, false);
    }

    public void setFieldValue(String string, String string2, Object object, boolean bl) throws IOException {
        this.getFolder(string, true).setValue(string2, object, bl);
        this.changed = true;
    }

    public void setFieldValues(String string, String string2, List list) throws IOException {
        MQRFH2.Element element = this.getFolder(string, true);
        MQRFH2.Element[] elementArray = element.getChildren();
        Object var6_6 = null;
        for (int i = 0; i < elementArray.length; ++i) {
            if (!string2.equals(elementArray[i].getName())) continue;
            element.setValue(string2, null, false);
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                element.addElement(string2, iterator.next());
            }
        }
        this.changed = true;
    }

    public int getIntFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getIntValue();
    }

    public void setIntFieldValue(String string, String string2, int n) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setIntValue(n, false);
        this.changed = true;
    }

    public byte getByteFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getByteValue();
    }

    public void setByteFieldValue(String string, String string2, byte by) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setByteValue(by, false);
        this.changed = true;
    }

    public short getShortFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getShortValue();
    }

    public void setShortFieldValue(String string, String string2, short s) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setShortValue(s, false);
        this.changed = true;
    }

    public char getCharFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getCharValue();
    }

    public void setCharFieldValue(String string, String string2, char c) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setCharValue(c, false);
        this.changed = true;
    }

    public long getLongFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getLongValue();
    }

    public void setLongFieldValue(String string, String string2, long l) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setLongValue(l, false);
        this.changed = true;
    }

    public float getFloatFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getFloatValue();
    }

    public void setFloatFieldValue(String string, String string2, float f) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setFloatValue(f, false);
        this.changed = true;
    }

    public double getDoubleFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getDoubleValue();
    }

    public void setDoubleFieldValue(String string, String string2, double d) throws IOException {
        this.getFolder(string, true).getElement(string2, true).setDoubleValue(d, false);
        this.changed = true;
    }

    public byte[] getBytesFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getBytesValue();
    }

    public String getStringFieldValue(String string, String string2) throws IOException {
        return this.getField(string, string2).getStringValue();
    }

    private MQRFH2.Element getField(String string, String string2) throws IOException, NoSuchElementException {
        MQRFH2.Element element = this.getFolder(string, false);
        if (element == null || (element = element.getChild(string2)) == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    private int getPadLength(String string) {
        return this.getPadLength(string == null ? 0 : string.length());
    }

    private int getPadLength(int n) {
        int n2 = n % 4;
        return n2 > 0 ? 4 - n2 : 0;
    }

    public MQRFH2 coalesce(MQRFH2 mQRFH2, boolean bl) throws IOException {
        if (mQRFH2 == null || mQRFH2 == this) {
            return this;
        }
        if (bl) {
            this.setFormat(mQRFH2.getFormat());
            this.setEncoding(mQRFH2.getEncoding());
            this.setCodedCharSetId(mQRFH2.getCodedCharSetId());
        }
        MQRFH2.Element[] elementArray = mQRFH2.getFolders();
        for (int i = 0; i < elementArray.length; ++i) {
            String string = elementArray[i].getName();
            if (this.getFolder(string, false) != null) continue;
            this.setFolderContent(string, elementArray[i].getContent());
        }
        return this;
    }

    public Object clone() {
        try {
            this.writeFolders();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl.clone", (String)"897", (Object)this);
        }
        return super.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.folders != null) {
            stringBuffer.append("\n\t" + this.folders.length + (this.folders.length == 1 ? " cached folder: " : " cached folders: "));
            for (int i = 0; i < this.folders.length; ++i) {
                stringBuffer.append("\n\t");
                stringBuffer.append(this.folders[i]);
            }
        }
        return new String(stringBuffer);
    }
}

