/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.api.impl;

import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMDE;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.IOException;

public class MQMDEImpl
extends BufferedHeader
implements MQMDE {
    public static final BufferedHeaderType type = new BufferedHeaderType("MQMDE"){

        public void createFields() {
            this.createMQChar(MQMDE.StrucId.name, "MDE ");
            this.createMQLong(MQMDE.Version.name, 2);
            this.createMQLong(MQMDE.StrucLength.name, 72);
            this.createMQLong(MQMDE.Encoding.name);
            this.createMQLong(MQMDE.CodedCharSetId.name);
            this.createMQChar(MQMDE.Format.name, 8);
            this.createMQLong(MQMDE.Flags.name);
            this.createMQByte(MQMDE.GroupId.name, 24);
            this.createMQLong(MQMDE.MsgSeqNumber.name);
            this.createMQLong(MQMDE.Offset.name);
            this.createMQLong(MQMDE.MsgFlags.name);
            this.createMQLong(MQMDE.OriginalLength.name);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "MDE ", MQMDE.StrucId.index);
            this.checkVersion(bufferedHeader, 2, MQMDE.Version.index);
            this.checkExactLength(bufferedHeader, 72, MQMDE.StrucLength.index);
        }
    };

    public MQMDEImpl() {
        super(type);
    }

    public MQMDEImpl(DataInput dataInput, int n, int n2) throws IOException {
        super(type, dataInput, n, n2);
    }

    public MQMDEImpl(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        super(type, wsByteBuffer, n, n2);
    }

    public MQMDEImpl(MQMD1 mQMD1, boolean bl) throws IOException {
        super(type);
        if (mQMD1 != null && mQMD1.hasExtensionContent() && mQMD1 instanceof MQMD) {
            MQMD mQMD = (MQMD)mQMD1;
            this.setGroupId(mQMD.getGroupId());
            this.setMsgSeqNumber(mQMD.getMsgSeqNumber());
            this.setOffset(mQMD.getOffset());
            this.setMsgFlags(mQMD.getMsgFlags());
            this.setOriginalLength(mQMD.getOriginalLength());
            if (bl) {
                mQMD.setVersion(1);
            }
        }
        this.setEncoding(mQMD1.nextEncoding());
        this.setCodedCharSetId(mQMD1.nextCharacterSet());
        this.setFormat(mQMD1.nextFormat());
        if (bl && !"MQHMDE  ".equals(mQMD1.nextFormat())) {
            mQMD1.setFormat("MQHMDE  ");
        }
    }

    public int nextEncoding() {
        return this.getEncoding();
    }

    public int nextCharacterSet() {
        return this.getCodedCharSetId();
    }

    public String nextFormat() {
        return this.getFormat();
    }

    public String getStrucId() {
        return this.getStringValue(MQMDEImpl.StrucId.index);
    }

    public int getVersion() {
        return this.getIntValue(MQMDEImpl.Version.index);
    }

    public int getStrucLength() {
        return this.getIntValue(MQMDEImpl.StrucLength.index);
    }

    public int getEncoding() {
        return this.getIntValue(MQMDEImpl.Encoding.index);
    }

    public void setEncoding(int n) {
        this.setIntValue(MQMDEImpl.Encoding.index, n);
    }

    public int getCodedCharSetId() {
        return this.getIntValue(MQMDEImpl.CodedCharSetId.index);
    }

    public void setCodedCharSetId(int n) {
        this.setIntValue(MQMDEImpl.CodedCharSetId.index, n);
    }

    public String getFormat() {
        return this.getStringValue(MQMDEImpl.Format.index);
    }

    public void setFormat(String string) {
        this.setStringValue(MQMDEImpl.Format.index, string);
    }

    public int getFlags() {
        return this.getIntValue(MQMDEImpl.Flags.index);
    }

    public void setFlags(int n) {
        this.setIntValue(MQMDEImpl.Flags.index, n);
    }

    public byte[] getGroupId() {
        return this.getBytesValue(MQMDEImpl.GroupId.index);
    }

    public void setGroupId(byte[] byArray) {
        this.setBytesValue(MQMDEImpl.GroupId.index, byArray);
    }

    public int getMsgSeqNumber() {
        return this.getIntValue(MQMDEImpl.MsgSeqNumber.index);
    }

    public void setMsgSeqNumber(int n) {
        this.setIntValue(MQMDEImpl.MsgSeqNumber.index, n);
    }

    public int getOffset() {
        return this.getIntValue(MQMDEImpl.Offset.index);
    }

    public void setOffset(int n) {
        this.setIntValue(MQMDEImpl.Offset.index, n);
    }

    public int getMsgFlags() {
        return this.getIntValue(MQMDEImpl.MsgFlags.index);
    }

    public void setMsgFlags(int n) {
        this.setIntValue(MQMDEImpl.MsgFlags.index, n);
    }

    public int getOriginalLength() {
        return this.getIntValue(MQMDEImpl.OriginalLength.index);
    }

    public void setOriginalLength(int n) {
        this.setIntValue(MQMDEImpl.OriginalLength.index, n);
    }

    public boolean hasExtensionContent() {
        boolean bl = false;
        byte[] byArray = this.getGroupId();
        for (int i = 0; !bl && i < byArray.length; ++i) {
            bl = byArray[i] != 0;
        }
        if (!bl) {
            bl = this.getMsgSeqNumber() != 0 || this.getOffset() != 0 || this.getMsgFlags() != 0 || this.getOriginalLength() != 0;
        }
        return bl;
    }
}

