/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.api.impl;

import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.CMQC;
import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MQMD1Impl
extends BufferedHeader
implements MQMD1 {
    public static final BufferedHeaderType type = new BufferedHeaderType("MQMD version 1"){

        protected void createFields() {
            this.createMQChar(MQMD1.StrucId.name, "MD  ");
            this.createMQLong(MQMD1.Version.name, 2);
            this.createMQLong(MQMD1.Report.name);
            this.createMQLong(MQMD1.MsgType.name);
            this.createMQLong(MQMD1.Expiry.name);
            this.createMQLong(MQMD1.Feedback.name);
            this.createMQLong(MQMD1.Encoding.name);
            this.createMQLong(MQMD1.CodedCharSetId.name);
            this.createMQChar(MQMD1.Format.name, CMQC.MQFMT_NONE_ARRAY.length);
            this.createMQLong(MQMD1.Priority.name);
            this.createMQLong(MQMD1.Persistence.name);
            this.createMQByte(MQMD1.MsgId.name, CMQC.MQMI_NONE_ARRAY.length);
            this.createMQByte(MQMD1.CorrelId.name, CMQC.MQCI_NONE_ARRAY.length);
            this.createMQLong(MQMD1.BackoutCount.name);
            this.createMQChar(MQMD1.ReplyToQ.name, 48);
            this.createMQChar(MQMD1.ReplyToQMgr.name, 48);
            this.createMQChar(MQMD1.UserIdentifier.name, 12);
            this.createMQByte(MQMD1.AccountingToken.name, CMQC.MQACT_NONE_ARRAY.length);
            this.createMQChar(MQMD1.ApplIdentityData.name, 32);
            this.createMQLong(MQMD1.PutApplType.name);
            this.createMQChar(MQMD1.PutApplName.name, 28);
            this.createMQChar(MQMD1.PutDate.name, 8);
            this.createMQChar(MQMD1.PutTime.name, 8);
            this.createMQChar(MQMD1.ApplOriginData.name, 4);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "MD  ", MQMD1.StrucId.index);
            this.checkVersionRange(bufferedHeader, 1, 2, MQMD1.Version.index);
        }
    };
    static final DateFormat timeFormat = new SimpleDateFormat("HHmmssSSS");
    static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    static final int timeFieldLength = 8;

    protected MQMD1Impl(BufferedHeaderType bufferedHeaderType) {
        super(bufferedHeaderType);
    }

    public MQMD1Impl() {
        super(type);
        this.setIntValue(MQMD1Impl.Version.index, 1);
    }

    public MQMD1Impl(DataInput dataInput, int n, int n2) throws IOException {
        super(type, dataInput, n, n2);
    }

    public MQMD1Impl(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        super(type, wsByteBuffer, n, n2);
    }

    public MQMD1Impl(MQMD1 mQMD1) throws IOException {
        this();
        ByteBuffer byteBuffer = ByteBuffer.allocate(mQMD1.size());
        mQMD1.write(new ByteBufferDataOutput(byteBuffer), 0, 0);
        byteBuffer.flip();
        this.read(byteBuffer, 0, 0);
        this.setIntValue(MQMD1Impl.Version.index, 1);
    }

    public int nextEncoding() {
        return this.getEncoding();
    }

    public int nextCharacterSet() {
        return this.getCodedCharSetId();
    }

    public String nextFormat() {
        return this.getFormat();
    }

    public String getStrucId() {
        return this.getStringValue(MQMD1Impl.StrucId.index);
    }

    public int getVersion() {
        return this.getIntValue(MQMD1Impl.Version.index);
    }

    public int getReport() {
        return this.getIntValue(MQMD1Impl.Report.index);
    }

    public void setReport(int n) {
        this.setIntValue(MQMD1Impl.Report.index, n);
    }

    public int getMsgType() {
        return this.getIntValue(MQMD1Impl.MsgType.index);
    }

    public void setMsgType(int n) {
        this.setIntValue(MQMD1Impl.MsgType.index, n);
    }

    public int getExpiry() {
        return this.getIntValue(MQMD1Impl.Expiry.index);
    }

    public void setExpiry(int n) {
        this.setIntValue(MQMD1Impl.Expiry.index, n);
    }

    public int getFeedback() {
        return this.getIntValue(MQMD1Impl.Feedback.index);
    }

    public void setFeedback(int n) {
        this.setIntValue(MQMD1Impl.Feedback.index, n);
    }

    public int getEncoding() {
        return this.getIntValue(MQMD1Impl.Encoding.index);
    }

    public void setEncoding(int n) {
        this.setIntValue(MQMD1Impl.Encoding.index, n);
    }

    public int getCodedCharSetId() {
        return this.getIntValue(MQMD1Impl.CodedCharSetId.index);
    }

    public void setCodedCharSetId(int n) {
        this.setIntValue(MQMD1Impl.CodedCharSetId.index, n);
    }

    public String getFormat() {
        return this.getStringValue(MQMD1Impl.Format.index);
    }

    public void setFormat(String string) {
        this.setStringValue(MQMD1Impl.Format.index, string);
    }

    public int getPriority() {
        return this.getIntValue(MQMD1Impl.Priority.index);
    }

    public void setPriority(int n) {
        this.setIntValue(MQMD1Impl.Priority.index, n);
    }

    public int getPersistence() {
        return this.getIntValue(MQMD1Impl.Persistence.index);
    }

    public void setPersistence(int n) {
        this.setIntValue(MQMD1Impl.Persistence.index, n);
    }

    public byte[] getMsgId() {
        return this.getBytesValue(MQMD1Impl.MsgId.index);
    }

    public void setMsgId(byte[] byArray) {
        this.setBytesValue(MQMD1Impl.MsgId.index, byArray);
    }

    public byte[] getCorrelId() {
        return this.getBytesValue(MQMD1Impl.CorrelId.index);
    }

    public void setCorrelId(byte[] byArray) {
        this.setBytesValue(MQMD1Impl.CorrelId.index, byArray);
    }

    public int getBackoutCount() {
        return this.getIntValue(MQMD1Impl.BackoutCount.index);
    }

    public void setBackoutCount(int n) {
        this.setIntValue(MQMD1Impl.BackoutCount.index, n);
    }

    public String getReplyToQ() {
        return this.getStringValue(MQMD1Impl.ReplyToQ.index);
    }

    public void setReplyToQ(String string) {
        this.setStringValue(MQMD1Impl.ReplyToQ.index, string);
    }

    public String getReplyToQMgr() {
        return this.getStringValue(MQMD1Impl.ReplyToQMgr.index);
    }

    public void setReplyToQMgr(String string) {
        this.setStringValue(MQMD1Impl.ReplyToQMgr.index, string);
    }

    public String getUserIdentifier() {
        return this.getStringValue(MQMD1Impl.UserIdentifier.index);
    }

    public void setUserIdentifier(String string) {
        this.setStringValue(MQMD1Impl.UserIdentifier.index, string);
    }

    public byte[] getAccountingToken() {
        return this.getBytesValue(MQMD1Impl.AccountingToken.index);
    }

    public void setAccountingToken(byte[] byArray) {
        this.setBytesValue(MQMD1Impl.AccountingToken.index, byArray);
    }

    public String getApplIdentityData() {
        return this.getStringValue(MQMD1Impl.ApplIdentityData.index);
    }

    public void setApplIdentityData(String string) {
        this.setStringValue(MQMD1Impl.ApplIdentityData.index, string);
    }

    public int getPutApplType() {
        return this.getIntValue(MQMD1Impl.PutApplType.index);
    }

    public void setPutApplType(int n) {
        this.setIntValue(MQMD1Impl.PutApplType.index, n);
    }

    public String getPutApplName() {
        return this.getStringValue(MQMD1Impl.PutApplName.index);
    }

    public void setPutApplName(String string) {
        this.setStringValue(MQMD1Impl.PutApplName.index, string);
    }

    public String getPutDate() {
        return this.getStringValue(MQMD1Impl.PutDate.index);
    }

    public void setPutDate(String string) {
        this.setStringValue(MQMD1Impl.PutDate.index, string);
    }

    public String getPutTime() {
        return this.getStringValue(MQMD1Impl.PutTime.index);
    }

    public void setPutTime(String string) {
        this.setStringValue(MQMD1Impl.PutTime.index, string);
    }

    public void setPutDateTime(long l) {
        Date date = new Date(l);
        this.setPutDate(dateFormat.format(date));
        this.setPutTime(timeFormat.format(date).substring(0, 8));
    }

    public String getApplOriginData() {
        return this.getStringValue(MQMD1Impl.ApplOriginData.index);
    }

    public void setApplOriginData(String string) {
        this.setStringValue(MQMD1Impl.ApplOriginData.index, string);
    }

    public boolean hasExtensionContent() {
        return false;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT+0:00");
        timeFormat.setTimeZone(timeZone);
        dateFormat.setTimeZone(timeZone);
    }
}

