/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.util.ArrayUtil;

public interface JSCoder {
    public static final JSCoder BOOLEAN = new BooleanJSCoder();
    public static final JSCoder BYTE = new ByteJSCoder();
    public static final JSCoder SHORT = new ShortJSCoder();
    public static final JSCoder CHAR = new CharJSCoder();
    public static final JSCoder INT = new IntJSCoder();
    public static final JSCoder LONG = new LongJSCoder();
    public static final JSCoder FLOAT = new FloatJSCoder();
    public static final JSCoder DOUBLE = new DoubleJSCoder();

    public int getEncodedLength(Object var1, int var2, JMFMessage var3) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public int encode(byte[] var1, int var2, Object var3, int var4, JMFMessage var5) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public Object decode(byte[] var1, int var2, int var3, JMFMessage var4) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public Object validate(Object var1, int var2) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException;

    public Object copy(Object var1, int var2) throws JMFSchemaViolationException;

    public static class DoubleJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.LONG_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Double) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("double==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeLong(byArray, n, Double.doubleToLongBits(((Number)object).doubleValue()));
            return n + ArrayUtil.LONG_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Double(Double.longBitsToDouble(ArrayUtil.readLong(byArray, n)));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class FloatJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.INT_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Float) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("float==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeInt(byArray, n, Float.floatToIntBits(((Number)object).floatValue()));
            return n + ArrayUtil.INT_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Float(Float.intBitsToFloat(ArrayUtil.readInt(byArray, n)));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class LongJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.LONG_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Long) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("long==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeLong(byArray, n, ((Number)object).longValue());
            return n + ArrayUtil.LONG_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Long(ArrayUtil.readLong(byArray, n));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class IntJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.INT_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Integer) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("int==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeInt(byArray, n, ((Number)object).intValue());
            return n + ArrayUtil.INT_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Integer(ArrayUtil.readInt(byArray, n));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class CharJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.SHORT_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Character) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("char==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeShort(byArray, n, (short)((Character)object).charValue());
            return n + ArrayUtil.SHORT_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Character((char)ArrayUtil.readShort(byArray, n));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class ShortJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.SHORT_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Short) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("short==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeShort(byArray, n, ((Number)object).shortValue());
            return n + ArrayUtil.SHORT_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Short(ArrayUtil.readShort(byArray, n));
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class ByteJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.BYTE_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Byte) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("byte==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            byArray[n] = ((Number)object).byteValue();
            return n + ArrayUtil.BYTE_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return new Byte(byArray[n]);
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }

    public static class BooleanJSCoder
    implements JSCoder {
        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return ArrayUtil.BYTE_SIZE;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object instanceof Boolean) {
                return object;
            }
            if (object == null) {
                throw new JMFSchemaViolationException("boolean==null");
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                throw new NullPointerException();
            }
            byArray[n] = (byte)((Boolean)object != false ? 1 : 0);
            return n + ArrayUtil.BYTE_SIZE;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
            return byArray[n] != 0;
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }
}

