/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.mfp.impl.SchemaStoreItemStream;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Map;

public class SchemaStore {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$SchemaStore == null ? (class$com$ibm$ws$sib$mfp$impl$SchemaStore = SchemaStore.class$("com.ibm.ws.sib.mfp.impl.SchemaStore")) : class$com$ibm$ws$sib$mfp$impl$SchemaStore, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    static Map schemaStores;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$SchemaStore;

    static void saveSchemas(MessageStore messageStore, JMFSchema[] jMFSchemaArray) throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "saveSchemas");
        }
        try {
            SchemaStoreItemStream schemaStoreItemStream = SchemaStore.getSchemaStore(messageStore);
            for (int i = 0; i < jMFSchemaArray.length; ++i) {
                if (schemaStoreItemStream.containsSchema(jMFSchemaArray[i].getLongID())) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Saving schema:" + jMFSchemaArray[i].getID());
                }
                schemaStoreItemStream.addSchema(jMFSchemaArray[i], (Transaction)messageStore.getTransactionFactory().createAutoCommitTransaction());
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)messageStoreException, (String)"saveSchemas", (String)"83");
            throw new MessageEncodeFailedException(messageStoreException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "saveSchemas");
        }
    }

    static void loadSchemas(MessageStore messageStore, long[] lArray) throws MessageRestoreFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadSchemas");
        }
        try {
            SchemaStoreItemStream schemaStoreItemStream = SchemaStore.getSchemaStore(messageStore);
            for (int i = 0; i < lArray.length; ++i) {
                if (JMFRegistry.instance.retrieve(lArray[i]) != null) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Restoring schema:" + lArray[i]);
                }
                JMFRegistry.instance.register(schemaStoreItemStream.findSchema(lArray[i]));
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)messageStoreException, (String)"loadSchemas", (String)"105");
            throw new MessageRestoreFailedException(messageStoreException);
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"loadSchemas", (String)"108");
            throw new MessageRestoreFailedException(jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadSchemas");
        }
    }

    private static SchemaStoreItemStream getSchemaStore(MessageStore messageStore) throws MessageStoreException {
        SchemaStoreItemStream schemaStoreItemStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSchemaStore");
        }
        if ((schemaStoreItemStream = (SchemaStoreItemStream)((Object)schemaStores.get(messageStore))) == null) {
            Filter filter = new Filter(){

                public boolean filterMatches(AbstractItem abstractItem) {
                    return abstractItem instanceof SchemaStoreItemStream;
                }
            };
            schemaStoreItemStream = (SchemaStoreItemStream)messageStore.findFirstMatching(filter);
            if (tc.isDebugEnabled() && schemaStoreItemStream != null) {
                SibTr.debug(tc, "Schema store found in message store");
            }
            if (schemaStoreItemStream == null) {
                schemaStoreItemStream = new SchemaStoreItemStream();
                messageStore.add((ItemStream)schemaStoreItemStream, (Transaction)messageStore.getTransactionFactory().createAutoCommitTransaction());
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "New schema store created");
                }
            }
            schemaStores.put(messageStore, schemaStoreItemStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSchemaStore");
        }
        return schemaStoreItemStream;
    }

    public static void messageStoreStoppingNotify(MessageStore messageStore) {
        schemaStores.remove(messageStore);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/SchemaStore.java, SIB.mfp, WAS602.SIB, o0610.11 1.7");
        }
        schemaStores = new HashMap();
    }
}

