/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.MfpDiagnostics;
import com.ibm.ws.sib.mfp.impl.SchemaSet;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaIdException;
import com.ibm.ws.sib.mfp.mqimpl.MQEncapsulationManager;
import com.ibm.ws.sib.mfp.schema.ControlAccess;
import com.ibm.ws.sib.mfp.schema.JmsBytesBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsMapBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsObjectBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsStreamBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsTextBodyAccess;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.schema.JsHdr2Access;
import com.ibm.ws.sib.mfp.schema.JsHdrAccess;
import com.ibm.ws.sib.mfp.schema.JsPayloadAccess;
import com.ibm.ws.sib.mfp.schema.MQBrokerAdminAccess;
import com.ibm.ws.sib.mfp.schema.MQBrokerSubscriptionAccess;
import com.ibm.ws.sib.mfp.schema.SdoBodyAccess;
import com.ibm.ws.sib.mfp.schema.SubscriptionAccess;
import com.ibm.ws.sib.mfp.schema.TrmAccess;
import com.ibm.ws.sib.mfp.schema.TrmFirstContactAccess;
import com.ibm.ws.sib.mfp.sdo.SdoEncapsulationManager;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.Map;
import java.util.WeakHashMap;

public class SchemaManager {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$SchemaManager == null ? (class$com$ibm$ws$sib$mfp$impl$SchemaManager = SchemaManager.class$("com.ibm.ws.sib.mfp.impl.SchemaManager")) : class$com$ibm$ws$sib$mfp$impl$SchemaManager, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    static Map destinations;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$SchemaManager;

    public static void init() {
        MfpDiagnostics.initialize();
        try {
            JMFRegistry.instance.register(JsHdrAccess.schema);
            JMFRegistry.instance.register(JsHdr2Access.schema);
            JMFRegistry.instance.register(JsApiAccess.schema);
            JMFRegistry.instance.register(JsPayloadAccess.schema);
            JMFRegistry.instance.register(JmsBytesBodyAccess.schema);
            JMFRegistry.instance.register(JmsTextBodyAccess.schema);
            JMFRegistry.instance.register(JmsObjectBodyAccess.schema);
            JMFRegistry.instance.register(JmsStreamBodyAccess.schema);
            JMFRegistry.instance.register(JmsMapBodyAccess.schema);
            JMFRegistry.instance.register(SdoBodyAccess.schema);
            JMFRegistry.instance.register(TrmAccess.schema);
            JMFRegistry.instance.register(SubscriptionAccess.schema);
            JMFRegistry.instance.register(ControlAccess.schema);
            JMFRegistry.instance.register(TrmFirstContactAccess.schema);
            JMFRegistry.instance.register(MQBrokerAdminAccess.schema);
            JMFRegistry.instance.register(MQBrokerSubscriptionAccess.schema);
            JMFRegistry.instance.register(SdoEncapsulationManager.getInstance(), 1);
            JMFRegistry.instance.register(new MQEncapsulationManager(), 3);
        }
        catch (JMFSchemaIdException jMFSchemaIdException) {
            FFDCFilter.processException((Throwable)jMFSchemaIdException, (String)"com.ibm.ws.sib.mfp.impl.SchemaManager.<clinit>", (String)"149");
        }
    }

    static void openLink(CommsConnection commsConnection) throws NoCapacityException, SIConnectionLostException, SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "openLink", commsConnection.getUniqueLinkObject());
        }
        JMFSchema[] jMFSchemaArray = JMFRegistry.instance.retrieveAll();
        byte[] byArray = commsConnection.mfpHandshakeExchange(SchemaManager.makeSchemaIdList(jMFSchemaArray));
        Coder coder = new Coder(byArray);
        destinations.put(commsConnection.getUniqueLinkObject(), SchemaManager.makeSchemaIdSet(coder));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "openLink");
        }
    }

    static void closeLink(CommsConnection commsConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "closeLink", commsConnection);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "getULO: ", commsConnection.getUniqueLinkObject());
        }
        destinations.remove(commsConnection.getUniqueLinkObject());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "closeLink");
        }
    }

    static byte[] receiveHandshake(CommsConnection commsConnection, byte[] byArray) throws JMFException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receiveHandshake", commsConnection);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "getULO: ", commsConnection.getUniqueLinkObject());
        }
        Coder coder = new Coder(byArray);
        destinations.put(commsConnection.getUniqueLinkObject(), SchemaManager.makeSchemaIdSet(coder));
        byte[] byArray2 = SchemaManager.makeSchemaIdList(JMFRegistry.instance.retrieveAll());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receiveHandshake");
        }
        return byArray2;
    }

    static void receiveSchemas(CommsConnection commsConnection, byte[] byArray) throws JMFException {
        SchemaSet schemaSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receiveSchemas", commsConnection);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "getULO: ", commsConnection.getUniqueLinkObject());
        }
        if ((schemaSet = (SchemaSet)destinations.get(commsConnection.getUniqueLinkObject())) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid UniqueLinkObject from CommsConnection");
            }
            throw new IllegalStateException("UniqueLinkObject not seen on handshake");
        }
        Coder coder = new Coder(byArray);
        SchemaManager.addSchemaDefinitions(schemaSet, coder);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receiveSchemas");
        }
    }

    static void sendSchemas(CommsConnection commsConnection, JMFSchema[] jMFSchemaArray) throws NoCapacityException, SIConnectionLostException, SIConnectionUnavailableException {
        int n;
        SchemaSet schemaSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendSchemas", commsConnection);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "getULO: ", commsConnection.getUniqueLinkObject());
        }
        if ((schemaSet = (SchemaSet)destinations.get(commsConnection.getUniqueLinkObject())) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid UniqueLinkObject from CommsConnection");
            }
            throw new IllegalStateException("UniqueLinkObject not seen on handshake");
        }
        JMFSchema[] jMFSchemaArray2 = new JMFSchema[jMFSchemaArray.length];
        int n2 = 0;
        for (n = 0; n < jMFSchemaArray.length; ++n) {
            if (schemaSet.contains(jMFSchemaArray[n].getLongID())) continue;
            jMFSchemaArray2[n2++] = jMFSchemaArray[n];
        }
        if (n2 > 0) {
            commsConnection.sendMFPSchema(SchemaManager.makeSchemaDefinitionList(jMFSchemaArray2, n2));
            for (n = 0; n < n2; ++n) {
                schemaSet.add(jMFSchemaArray2[n].getLongID());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendSchemas");
        }
    }

    static byte[] getEncodedSchemataByEncodedIDs(byte[] byArray) {
        if (byArray != null && byArray.length >= 8) {
            int n = byArray.length / 8;
            long[] lArray = new long[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = ArrayUtil.readLong(byArray, n2);
                n2 += 8;
            }
            return SchemaManager.getEncodedSchemataBySchemaIDs(lArray);
        }
        return new byte[0];
    }

    static byte[] getEncodedSchemataBySchemaIDs(long[] lArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncodedSchemataBySchemaIDs", lArray);
        }
        JMFSchema[] jMFSchemaArray = new JMFSchema[lArray.length];
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            JMFSchema jMFSchema = JMFRegistry.instance.retrieve(lArray[i]);
            if (jMFSchema == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Unable to retrieve message schema " + lArray[i]);
                }
                MessageDecodeFailedException messageDecodeFailedException = new MessageDecodeFailedException("No schema registered for schema id " + lArray[i]);
                FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.SchemaManager.getEncodedSchemasBySchemaIDs", (String)"281");
                continue;
            }
            jMFSchemaArray[n++] = jMFSchema;
        }
        JMFSchema[] jMFSchemaArray2 = new JMFSchema[n];
        System.arraycopy(jMFSchemaArray, 0, jMFSchemaArray2, 0, n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncodedSchemataBySchemaIDs");
        }
        return SchemaManager.makeSchemaDefinitionList(jMFSchemaArray2, n);
    }

    private static byte[] makeSchemaIdList(JMFSchema[] jMFSchemaArray) {
        Coder coder = new Coder(ArrayUtil.LONG_SIZE * jMFSchemaArray.length, jMFSchemaArray.length);
        for (int i = 0; i < coder.count; ++i) {
            ArrayUtil.writeLong(coder.buffer, coder.offset, jMFSchemaArray[i].getID());
            coder.offset += ArrayUtil.LONG_SIZE;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoding " + coder.count + " schema ids for handshake");
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes(tc, coder.buffer, Coder.HDR_LENGTH);
        }
        return coder.buffer;
    }

    private static SchemaSet makeSchemaIdSet(Coder coder) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Decoding " + coder.count + "schema ids from handshake");
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes(tc, coder.buffer, Coder.HDR_LENGTH);
        }
        SchemaSet schemaSet = new SchemaSet();
        for (int i = 0; i < coder.count; ++i) {
            long l = ArrayUtil.readLong(coder.buffer, coder.offset);
            coder.offset += ArrayUtil.LONG_SIZE;
            schemaSet.add(new Long(l));
        }
        return schemaSet;
    }

    private static byte[] makeSchemaDefinitionList(JMFSchema[] jMFSchemaArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += ArrayUtil.INT_SIZE + jMFSchemaArray[i].toByteArray().length;
        }
        Coder coder = new Coder(n2, n);
        for (int i = 0; i < coder.count; ++i) {
            byte[] byArray = jMFSchemaArray[i].toByteArray();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "   Encoded Schema " + SchemaManager.debugSchema(jMFSchemaArray[i]) + " for transmission");
            }
            ArrayUtil.writeInt(coder.buffer, coder.offset, byArray.length);
            coder.offset += ArrayUtil.INT_SIZE;
            System.arraycopy(byArray, 0, coder.buffer, coder.offset, byArray.length);
            coder.offset += byArray.length;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoding " + coder.count + "new schema definitions");
        }
        return coder.buffer;
    }

    private static void addSchemaDefinitions(SchemaSet schemaSet, Coder coder) throws JMFException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Decoding " + coder.count + "new schema definitions");
        }
        for (int i = 0; i < coder.count; ++i) {
            int n = ArrayUtil.readInt(coder.buffer, coder.offset);
            coder.offset += ArrayUtil.INT_SIZE;
            JMFSchema jMFSchema = JMFRegistry.instance.createJMFSchema(coder.buffer, coder.offset, n);
            JMFRegistry.instance.register(jMFSchema);
            schemaSet.add(jMFSchema.getLongID());
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "   Added Schema " + SchemaManager.debugSchema(jMFSchema));
            }
            coder.offset += n;
        }
    }

    private static String debugSchema(JMFSchema jMFSchema) {
        if (jMFSchema != null) {
            return jMFSchema.getName() + "(" + Long.toHexString(jMFSchema.getID()) + ")";
        }
        return "<null>";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/SchemaManager.java, SIB.mfp, WAS602.SIB, o0610.11 1.31");
        }
        SchemaManager.init();
        destinations = new WeakHashMap();
    }

    static class Coder {
        static final int HDR_LENGTH = ArrayUtil.BYTE_SIZE + 3 * ArrayUtil.INT_SIZE;
        private int length;
        private int count;
        private byte[] buffer;
        private int offset;

        Coder(byte[] byArray) {
            this.buffer = byArray;
            this.offset = 0;
            this.offset += ArrayUtil.INT_SIZE;
            this.length = ArrayUtil.readInt(this.buffer, this.offset);
            this.offset += ArrayUtil.INT_SIZE;
            this.count = ArrayUtil.readInt(this.buffer, this.offset);
            this.offset += ArrayUtil.INT_SIZE;
        }

        Coder(int n, int n2) {
            this.length = n;
            this.count = n2;
            this.buffer = new byte[n + HDR_LENGTH];
            this.offset = 0;
            ArrayUtil.writeInt(this.buffer, this.offset, 1);
            this.offset += ArrayUtil.INT_SIZE;
            ArrayUtil.writeInt(this.buffer, this.offset, n);
            this.offset += ArrayUtil.INT_SIZE;
            ArrayUtil.writeInt(this.buffer, this.offset, n2);
            this.offset += ArrayUtil.INT_SIZE;
        }
    }
}

