/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class JsJmsMessageFactory {
    private static TraceComponent tc = SibTr.register(JsJmsMessageFactory.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JsJmsMessageFactory instance = null;
    private static Exception createException = null;

    public static JsJmsMessageFactory getInstance() throws Exception {
        if (instance == null) {
            throw createException;
        }
        return instance;
    }

    public abstract JsJmsMessage createJmsMessage() throws MessageCreateFailedException;

    public abstract JsJmsBytesMessage createJmsBytesMessage() throws MessageCreateFailedException;

    public abstract JsJmsMapMessage createJmsMapMessage() throws MessageCreateFailedException;

    public abstract JsJmsObjectMessage createJmsObjectMessage() throws MessageCreateFailedException;

    public abstract JsJmsStreamMessage createJmsStreamMessage() throws MessageCreateFailedException;

    public abstract JsJmsTextMessage createJmsTextMessage() throws MessageCreateFailedException;

    private static void createFactoryInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createFactoryInstance");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl");
            instance = (JsJmsMessageFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.JsJmsMessageFactory.createFactoryInstance", (String)"133");
            SibTr.error(tc, "UNABLE_TO_CREATE_JMSFACTORY_CWSIF0011", exception);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createFactoryInstance");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.mfp/src/com/ibm/ws/sib/mfp/JsJmsMessageFactory.java, SIB.mfp, WAS602.SIB, o0610.11 1.18");
        }
        try {
            JsJmsMessageFactory.createFactoryInstance();
        }
        catch (Exception exception) {
            createException = exception;
        }
    }
}

