/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapConnectFailedException;
import com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapAddress;
import com.ibm.ws.sib.jfapchannel.impl.JFapOutboundConnLink;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ClientConnectionReadyCallback;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.jfapchannel.impl.octracker.IdleConnectionPool;
import com.ibm.ws.sib.jfapchannel.impl.octracker.JFapOutboundChannelDefinitionImpl;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ConnectionDataGroup {
    private static final TraceComponent tc = SibTr.register(ConnectionDataGroup.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls;
    private OutboundConnectionTracker tracker;
    private LinkedList connectionData = new LinkedList();
    private EndPointDescriptor groupEndpointDescriptor;
    private int connectAttemptsPending = 0;
    private int conversationsPerConnection;
    private VirtualConnectionFactory outboundVirtualConnectionFactory;
    private ChannelFramework framework = null;
    private int heartbeatInterval;
    private int heartbeatTimeout;

    protected ConnectionDataGroup(OutboundConnectionTracker outboundConnectionTracker, VirtualConnectionFactory virtualConnectionFactory, EndPointDescriptor endPointDescriptor, int n, int n2, int n3) {
        this(outboundConnectionTracker, endPointDescriptor, n, null, n2, n3);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{outboundConnectionTracker, virtualConnectionFactory, endPointDescriptor, "" + n});
        }
        this.outboundVirtualConnectionFactory = virtualConnectionFactory;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected ConnectionDataGroup(OutboundConnectionTracker outboundConnectionTracker, EndPointDescriptor endPointDescriptor, int n, ChannelFramework channelFramework, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{outboundConnectionTracker, endPointDescriptor, "" + n, channelFramework, "" + n2, "" + n3});
        }
        this.groupEndpointDescriptor = endPointDescriptor;
        this.tracker = outboundConnectionTracker;
        this.conversationsPerConnection = n;
        this.framework = channelFramework;
        this.heartbeatInterval = n2;
        this.heartbeatTimeout = n3;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected ConnectionDataGroup(OutboundConnectionTracker outboundConnectionTracker, VirtualConnectionFactory virtualConnectionFactory, EndPointDescriptor endPointDescriptor, ChannelFramework channelFramework) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{outboundConnectionTracker, virtualConnectionFactory, endPointDescriptor, channelFramework});
        }
        this.tracker = outboundConnectionTracker;
        this.outboundVirtualConnectionFactory = virtualConnectionFactory;
        this.groupEndpointDescriptor = endPointDescriptor;
        this.framework = channelFramework;
        this.heartbeatInterval = Integer.MAX_VALUE;
        this.heartbeatTimeout = Integer.MAX_VALUE;
        this.conversationsPerConnection = Integer.MAX_VALUE;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    private ConnectionData findConnectionDataToUse() {
        IdleConnectionPool idleConnectionPool;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "findConnectionDataToUse");
        }
        Object object2 = null;
        int n = this.conversationsPerConnection;
        for (int i = 0; i < this.connectionData.size(); ++i) {
            object = (ConnectionData)this.connectionData.get(i);
            if (((ConnectionData)object).getUseCount() >= n) continue;
            n = ((ConnectionData)object).getUseCount();
            object2 = object;
        }
        if (object2 == null && (object = (idleConnectionPool = IdleConnectionPool.getInstance()).remove(this.groupEndpointDescriptor)) != null) {
            object2 = new ConnectionData(this, this.groupEndpointDescriptor);
            ((OutboundConnection)object).setConnectionData((ConnectionData)object2);
            ((ConnectionData)object2).setConnection((OutboundConnection)object);
            this.connectionData.add(object2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "findConnectionDataToUse", object2);
        }
        return object2;
    }

    protected synchronized Conversation connect(CFEndPoint cFEndPoint, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{cFEndPoint, conversationReceiveListener});
        }
        if (this.outboundVirtualConnectionFactory != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "type of endpoint does not match group");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        --this.connectAttemptsPending;
        ConversationImpl conversationImpl = null;
        ConnectionData connectionData = this.findConnectionDataToUse();
        if (connectionData == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection data does not already exist");
            }
            try {
                Object object;
                Object object2;
                Class<?> clazz;
                WSVirtualConnectionFactory wSVirtualConnectionFactory;
                Map<Object, Object> map = null;
                if (cFEndPoint.isSSLEnabled()) {
                    wSVirtualConnectionFactory = null;
                    try {
                        wSVirtualConnectionFactory = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240001");
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, tc, classNotFoundException);
                        }
                        throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"), classNotFoundException);
                    }
                    if (RuntimeInfo.isClientContainer() || RuntimeInfo.isThinClient()) {
                        map = ChannelFrameworkReference.loadSSLProperties();
                    } else {
                        clazz = cFEndPoint.getName();
                        ChainData chainData = ChannelFrameworkReference.getInstance().getChain((String)((Object)clazz));
                        if (chainData == null) {
                            SibTr.warning(tc, "CONNDATAGROUP_BADSLLCHAINNAME_SICJ0066", new Object[]{cFEndPoint.getName(), cFEndPoint.getAddress().getHostAddress()});
                        } else {
                            object2 = null;
                            object = chainData.getChannelList();
                            for (int i = 0; i < ((ChannelData[])object).length && object2 == null; ++i) {
                                if (!object[i].getFactoryType().equals(wSVirtualConnectionFactory)) continue;
                                object2 = object[i];
                            }
                            if (object2 == null) {
                                SibTr.warning(tc, "CONNDATAGROUP_NOTSSLCHAIN_SICJ0067", new Object[]{cFEndPoint.getName(), cFEndPoint.getAddress().getHostAddress()});
                            } else {
                                map = object2.getPropertyBag();
                            }
                        }
                    }
                }
                wSVirtualConnectionFactory = null;
                if (map != null) {
                    clazz = null;
                    try {
                        clazz = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                        this.modifyEndpointChannelProperties(cFEndPoint, clazz, map, true);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240004");
                        classNotFoundException.printStackTrace();
                    }
                }
                clazz = null;
                try {
                    boolean bl;
                    boolean bl2 = bl = this.framework.getThreadPool("SIBFAPThreadPool") != null;
                    if (bl) {
                        clazz = Class.forName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
                        object2 = new HashMap();
                        object2.put("threadPoolName", "SIBFAPThreadPool");
                        this.modifyEndpointChannelProperties(cFEndPoint, clazz, (Map)object2, false);
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Cannot find threadpool: SIBFAPThreadPool using default");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240004");
                    classNotFoundException.printStackTrace();
                }
                ((ChannelFrameworkService)this.framework).prepareEndPoint(cFEndPoint);
                wSVirtualConnectionFactory = cFEndPoint.getOutboundVCFactory();
                if (wSVirtualConnectionFactory == null) {
                    JFapConnectFailedException jFapConnectFailedException = new JFapConnectFailedException(nls.getFormattedMessage("CONNDATAGROUP_CONNFAILED_SICJ0063", new Object[]{cFEndPoint.getAddress().getHostAddress(), "" + cFEndPoint.getPort()}, "CONNDATAGROUP_CONNFAILED_SICJ0063"));
                    FFDCFilter.processException((Throwable)jFapConnectFailedException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240004", (Object)cFEndPoint);
                    throw jFapConnectFailedException;
                }
                OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)wSVirtualConnectionFactory.createConnection(cFEndPoint);
                object2 = new Semaphore();
                object = new ClientConnectionReadyCallback((Semaphore)object2);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(cFEndPoint.getAddress(), cFEndPoint.getPort());
                JFapAddress jFapAddress = new JFapAddress(inetSocketAddress);
                outboundVirtualConnection.connectAsynch((Object)jFapAddress, (ConnectionReadyCallback)object);
                ((Semaphore)object2).waitOnIgnoringInterruptions();
                if (!((ClientConnectionReadyCallback)object).connectionSucceeded()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connect has failed due to ", ((ClientConnectionReadyCallback)object).getException());
                    }
                    throw new JFapConnectFailedException(nls.getFormattedMessage("CONNDATAGROUP_CONNFAILED_SICJ0063", new Object[]{cFEndPoint.getAddress().getHostAddress(), "" + cFEndPoint.getPort()}, "CONNDATAGROUP_CONNFAILED_SICJ0063"), ((ClientConnectionReadyCallback)object).getException());
                }
                JFapOutboundConnLink jFapOutboundConnLink = (JFapOutboundConnLink)((Object)outboundVirtualConnection.getChannelAccessor());
                connectionData = new ConnectionData(this, this.groupEndpointDescriptor);
                OutboundConnection outboundConnection = new OutboundConnection((ConnectionLink)jFapOutboundConnLink, (VirtualConnection)outboundVirtualConnection, this.tracker, this.heartbeatInterval, this.heartbeatTimeout, connectionData);
                connectionData.setConnection(outboundConnection);
                this.connectionData.add(connectionData);
            }
            catch (ChannelFrameworkException channelFrameworkException) {
                FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240002", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, (Exception)((Object)channelFrameworkException));
                }
                throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"), channelFrameworkException);
            }
        }
        conversationImpl = connectionData.getConnection().startNewConversation(conversationReceiveListener);
        connectionData.incrementUseCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversationImpl);
        }
        return conversationImpl;
    }

    protected synchronized Conversation connect(InetSocketAddress inetSocketAddress, String string, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{inetSocketAddress, string, conversationReceiveListener});
        }
        if (this.outboundVirtualConnectionFactory == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "type of endpoint does not match group");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        --this.connectAttemptsPending;
        ConversationImpl conversationImpl = null;
        ConnectionData connectionData = this.findConnectionDataToUse();
        if (connectionData == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection data does not already exist");
            }
            try {
                OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)this.outboundVirtualConnectionFactory.createConnection();
                Semaphore semaphore = new Semaphore();
                ClientConnectionReadyCallback clientConnectionReadyCallback = new ClientConnectionReadyCallback(semaphore);
                JFapAddress jFapAddress = new JFapAddress(inetSocketAddress);
                outboundVirtualConnection.connectAsynch((Object)jFapAddress, (ConnectionReadyCallback)clientConnectionReadyCallback);
                semaphore.waitOnIgnoringInterruptions();
                if (!clientConnectionReadyCallback.connectionSucceeded()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connect has failed due to ", clientConnectionReadyCallback.getException());
                    }
                    String string2 = inetSocketAddress.toString();
                    if (inetSocketAddress.getAddress() != null) {
                        string2 = inetSocketAddress.getAddress().getHostAddress();
                    }
                    String string3 = nls.getFormattedMessage("CONNDATAGROUP_CONNFAILED_SICJ0063", new Object[]{string2, "" + inetSocketAddress.getPort()}, "CONNDATAGROUP_CONNFAILED_SICJ0063");
                    throw new JFapConnectFailedException(string3, clientConnectionReadyCallback.getException());
                }
                JFapOutboundConnLink jFapOutboundConnLink = (JFapOutboundConnLink)((Object)outboundVirtualConnection.getChannelAccessor());
                connectionData = new ConnectionData(this, this.groupEndpointDescriptor);
                OutboundConnection outboundConnection = new OutboundConnection((ConnectionLink)jFapOutboundConnLink, (VirtualConnection)outboundVirtualConnection, this.tracker, this.heartbeatInterval, this.heartbeatTimeout, connectionData);
                connectionData.setConnection(outboundConnection);
                this.connectionData.add(connectionData);
            }
            catch (ChannelFrameworkException channelFrameworkException) {
                FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240003", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, (Exception)((Object)channelFrameworkException));
                }
                throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"), channelFrameworkException);
            }
        }
        conversationImpl = connectionData.getConnection().startNewConversation(conversationReceiveListener);
        connectionData.incrementUseCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversationImpl);
        }
        return conversationImpl;
    }

    protected synchronized Conversation connect(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{conversationReceiveListener});
        }
        --this.connectAttemptsPending;
        ConversationImpl conversationImpl = null;
        ConnectionData connectionData = this.findConnectionDataToUse();
        if (connectionData == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection data does not already exist");
            }
            try {
                OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)this.outboundVirtualConnectionFactory.createConnection();
                Semaphore semaphore = new Semaphore();
                ClientConnectionReadyCallback clientConnectionReadyCallback = new ClientConnectionReadyCallback(semaphore);
                outboundVirtualConnection.connectAsynch(null, (ConnectionReadyCallback)clientConnectionReadyCallback);
                semaphore.waitOnIgnoringInterruptions();
                if (!clientConnectionReadyCallback.connectionSucceeded()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connect has failed due to ", clientConnectionReadyCallback.getException());
                    }
                    String string = nls.getFormattedMessage("CONNDATAGROUP_CONNFAILED_SICJ0063", new Object[]{null, null}, "CONNDATAGROUP_CONNFAILED_SICJ0063");
                    throw new JFapConnectFailedException(string, clientConnectionReadyCallback.getException());
                }
                JFapOutboundConnLink jFapOutboundConnLink = (JFapOutboundConnLink)((Object)outboundVirtualConnection.getChannelAccessor());
                connectionData = new ConnectionData(this, this.groupEndpointDescriptor);
                OutboundConnection outboundConnection = new OutboundConnection((ConnectionLink)jFapOutboundConnLink, (VirtualConnection)outboundVirtualConnection, this.tracker, this.heartbeatInterval, this.heartbeatTimeout, connectionData);
                connectionData.setConnection(outboundConnection);
                this.connectionData.add(connectionData);
            }
            catch (ChannelFrameworkException channelFrameworkException) {
                FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240004", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, (Exception)((Object)channelFrameworkException));
                }
                throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"), channelFrameworkException);
            }
        }
        conversationImpl = connectionData.getConnection().startNewConversation(conversationReceiveListener);
        connectionData.incrementUseCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversationImpl);
        }
        return conversationImpl;
    }

    protected synchronized void connectionPending() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connectionPending");
        }
        ++this.connectAttemptsPending;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connectionPending", "" + this.connectAttemptsPending);
        }
    }

    protected synchronized void close(OutboundConnection outboundConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close", outboundConnection);
        }
        if (outboundConnection.getConnectionData().getConnectionDataGroup() != this) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection does not belong to this group", outboundConnection.getConnectionData().getConnectionDataGroup());
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        ConnectionData connectionData = outboundConnection.getConnectionData();
        connectionData.decrementUseCount();
        if (connectionData.getUseCount() == 0) {
            this.connectionData.remove(connectionData);
            IdleConnectionPool.getInstance().add(connectionData.getConnection(), this.groupEndpointDescriptor);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    protected EndPointDescriptor getEndPointDescriptor() {
        return this.groupEndpointDescriptor;
    }

    protected synchronized boolean isEmpty() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isEmpty");
        }
        boolean bl2 = bl = this.connectionData.isEmpty() && this.connectAttemptsPending == 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isEmpty", "" + bl);
        }
        return bl;
    }

    public synchronized Conversation clone(OutboundConnection outboundConnection, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "clone", new Object[]{outboundConnection, conversationReceiveListener});
        }
        if (outboundConnection.getConnectionData().getConnectionDataGroup() != this) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection not part of this data group", outboundConnection.getConnectionData().getConnectionDataGroup());
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        ConnectionData connectionData = outboundConnection.getConnectionData();
        ConversationImpl conversationImpl = connectionData.getConnection().startNewConversation(conversationReceiveListener);
        connectionData.incrementUseCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "clone", conversationImpl);
        }
        return conversationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge(OutboundConnection outboundConnection, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "purge", new Object[]{outboundConnection, "" + bl});
        }
        boolean bl2 = false;
        OutboundConnection outboundConnection2 = outboundConnection;
        synchronized (outboundConnection2) {
            bl2 = outboundConnection.isBeingPurged();
            if (!bl2) {
                outboundConnection.beingPurged();
            }
        }
        if (!bl2) {
            boolean bl3;
            ConnectionDataGroup connectionDataGroup = this;
            synchronized (connectionDataGroup) {
                bl3 = this.connectionData.remove(outboundConnection.getConnectionData());
            }
            if (bl && bl3) {
                outboundConnection.physicalClose(bl);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "purge");
        }
    }

    private void modifyEndpointChannelProperties(CFEndPoint cFEndPoint, Class clazz, Map map, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "modifyEndpointChannelProperties", new Object[]{cFEndPoint, clazz, map, "" + bl});
        }
        OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPoint.getOutboundChannelDefs();
        Class clazz2 = null;
        OutboundChannelDefinition outboundChannelDefinition = null;
        int n = 0;
        boolean bl2 = false;
        for (n = 0; n < outboundChannelDefinitionArray.length; ++n) {
            outboundChannelDefinition = outboundChannelDefinitionArray[n];
            clazz2 = outboundChannelDefinitionArray[n].getOutboundFactory();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            JFapOutboundChannelDefinitionImpl jFapOutboundChannelDefinitionImpl = new JFapOutboundChannelDefinitionImpl(outboundChannelDefinition, map, bl);
            outboundChannelDefinitionArray[n] = jFapOutboundChannelDefinitionImpl;
        } else {
            SibTr.debug(this, tc, "did not find desired channel");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "modifyEndpointChannelProperties");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/ConnectionDataGroup.java, SIB.comms, WAS602.SIB, o0610.11 1.29");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    }
}

