/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class RequestIdTable {
    private static final TraceComponent tc = SibTr.register(RequestIdTable.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private HashMap table = null;
    private RequestIdTableEntry testReqIdTableEntry = null;

    public RequestIdTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.table = new HashMap();
        this.testReqIdTableEntry = new RequestIdTableEntry(0, null, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public synchronized void add(int n, ReceiveListener receiveListener, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "add", new Object[]{"" + n, receiveListener, sendListener});
        }
        if (this.containsId(n)) {
            if (tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + n + ") already in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        RequestIdTableEntry requestIdTableEntry = new RequestIdTableEntry(n, receiveListener, sendListener);
        this.table.put(requestIdTableEntry, requestIdTableEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "add");
        }
    }

    public synchronized void remove(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "remove");
        }
        if (!this.containsId(n)) {
            if (tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + n + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = n;
        this.table.remove(this.testReqIdTableEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "remove");
        }
    }

    public synchronized SendListener getSendListener(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getSendListener", "" + n);
        }
        if (!this.containsId(n)) {
            if (tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + n + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = n;
        RequestIdTableEntry requestIdTableEntry = (RequestIdTableEntry)this.table.get(this.testReqIdTableEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSendListener", requestIdTableEntry.sendListener);
        }
        return requestIdTableEntry.sendListener;
    }

    public synchronized ReceiveListener getListener(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getListener", "" + n);
        }
        if (!this.containsId(n)) {
            if (tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + n + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = n;
        RequestIdTableEntry requestIdTableEntry = (RequestIdTableEntry)this.table.get(this.testReqIdTableEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getListener", requestIdTableEntry.receiveListener);
        }
        return requestIdTableEntry.receiveListener;
    }

    public synchronized boolean containsId(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "containsId", "" + n);
        }
        this.testReqIdTableEntry.requestId = n;
        boolean bl = this.table.containsKey(this.testReqIdTableEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "containsId", "" + bl);
        }
        return bl;
    }

    public synchronized Iterator receiveListenerIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "receiveListenerIterator");
        }
        LinkedList<ReceiveListener> linkedList = new LinkedList<ReceiveListener>();
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            object = (RequestIdTableEntry)iterator.next();
            if (((RequestIdTableEntry)object).receiveListener == null) continue;
            linkedList.add(((RequestIdTableEntry)object).receiveListener);
        }
        object = linkedList.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "receiveListenerIterator", object);
        }
        return object;
    }

    public synchronized Iterator sendListenerIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "sendListenerIterator");
        }
        LinkedList<SendListener> linkedList = new LinkedList<SendListener>();
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            object = (RequestIdTableEntry)iterator.next();
            if (((RequestIdTableEntry)object).sendListener == null) continue;
            linkedList.add(((RequestIdTableEntry)object).sendListener);
        }
        object = linkedList.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "sendListenerIterator", object);
        }
        return object;
    }

    public synchronized boolean hasReceiveListeners() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasReceiveListeners");
        }
        boolean bl = false;
        if (!this.table.values().isEmpty()) {
            bl = this.receiveListenerIterator().hasNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasReceiveListeners", "" + bl);
        }
        return bl;
    }

    public synchronized boolean hasSendListeners() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasSendListeners");
        }
        boolean bl = false;
        if (!this.table.values().isEmpty()) {
            bl = this.sendListenerIterator().hasNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasSendListeners", "" + bl);
        }
        return bl;
    }

    public synchronized Iterator idIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "idIterator");
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            object = (RequestIdTableEntry)iterator.next();
            linkedList.add(new Integer(((RequestIdTableEntry)object).requestId));
        }
        object = linkedList.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "idIterator", object);
        }
        return object;
    }

    public synchronized void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "clear");
        }
        this.table.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "clear");
        }
    }

    private void debugTraceTable(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("table:\n");
        Iterator iterator = this.table.keySet().iterator();
        if (!iterator.hasNext()) {
            stringBuffer.append("   <empty>\n");
        } else {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = this.table.get(k);
                stringBuffer.append("   [key: " + k + "] -> [value: " + v + "]\n");
            }
        }
        SibTr.debug(this, tc, stringBuffer.toString());
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/RequestIdTable.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }

    private class RequestIdTableEntry {
        public int requestId;
        public ReceiveListener receiveListener;
        public SendListener sendListener;

        public RequestIdTableEntry(int n, ReceiveListener receiveListener, SendListener sendListener) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "RequestIdTableEntry.<init>", new Object[]{"" + n, receiveListener, sendListener});
            }
            this.requestId = n;
            this.receiveListener = receiveListener;
            this.sendListener = sendListener;
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "RequestIdTableEntry.<init>");
            }
        }

        public boolean equals(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "RequstIdTableEntry.equals", object);
            }
            boolean bl = false;
            if (object instanceof RequestIdTableEntry) {
                boolean bl2 = bl = ((RequestIdTableEntry)object).requestId == this.requestId;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "RequstIdTableEntry.equals", "" + bl);
            }
            return bl;
        }

        public int hashCode() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "RequstIdTableEntry.hashCode");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "RequstIdTableEntry.hashCode", "" + this.requestId);
            }
            return this.requestId;
        }

        public String toString() {
            return this.getClass() + "@" + System.identityHashCode(this) + " requestid:" + this.requestId + " receiveListener:" + this.receiveListener + " sendListener";
        }
    }
}

