/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.pmi.StatsUpdateListener;
import com.ibm.ws.sib.jfapchannel.CapacityListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.NoCapacityException;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionDataIterator;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.ArrayList;

public class PriorityQueue {
    private static final TraceComponent tc = SibTr.register(PriorityQueue.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final StateEnum OPEN = new StateEnum("OPEN");
    private static final StateEnum CLOSING = new StateEnum("CLOSING");
    private static final StateEnum CLOSED = new StateEnum("CLOSED");
    private StateEnum state = OPEN;
    public static PriorityQueueMode REJECT = new PriorityQueueMode("reject");
    public static PriorityQueueMode BLOCK = new PriorityQueueMode("block");
    private PriorityQueueMode mode = BLOCK;
    private Conversation.ConversationType type = Conversation.UNKNOWN;
    private static volatile int clientQueuedBytes = 0;
    private static volatile int meQueuedBytes = 0;
    private static int maxQueueDepth = 100;
    private static int maxQueueBytes = 102400;
    private static StatsUpdateListener clientStatsListener = new StatsUpdateListener(){

        public int statChanged() {
            return clientQueuedBytes;
        }
    };
    private static StatsUpdateListener meStatsListener = new StatsUpdateListener(){

        public int statChanged() {
            return meQueuedBytes;
        }
    };
    private Queue[] queueArray = new Queue[16];
    private int lowestPriorityWithCapacity = 0;
    private int totalQueueDepth = 0;
    private int lastReportedLowestPriorityWithCapacity = 0;
    public Object queueMonitor;
    private ActivatableMonitor closeWaitersMonitor = new ActivatableMonitor(true);
    private ArrayList capacityListeners = new ArrayList();

    public PriorityQueue() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        for (int i = 0; i < 16; ++i) {
            this.queueArray[i] = new Queue();
        }
        this.queueMonitor = this;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(PriorityQueueMode priorityQueueMode) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setMode", priorityQueueMode);
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            if (this.state == OPEN && this.mode != priorityQueueMode) {
                this.mode = priorityQueueMode;
                for (int i = 0; i < 16; ++i) {
                    this.queueArray[i].monitor.setActive(priorityQueueMode == PriorityQueue.BLOCK);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setMode");
        }
    }

    public boolean queue(WsByteBuffer[] wsByteBufferArray, int n, int n2, int n3, SendListener sendListener, Conversation conversation, Connection connection, int n4, boolean bl, boolean bl2, long l, boolean bl3, boolean bl4) throws NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "queue");
        }
        TransmissionDataIterator transmissionDataIterator = TransmissionDataIterator.allocateFromPool(connection, wsByteBufferArray, n3, bl, bl2, n, n4, n2, conversation, sendListener, bl4, bl3, (int)l);
        if (this.type == Conversation.ME) {
            meQueuedBytes = (int)((long)meQueuedBytes + l);
        } else if (this.type == Conversation.CLIENT) {
            clientQueuedBytes = (int)((long)clientQueuedBytes + l);
        }
        boolean bl5 = this.queueInternal(transmissionDataIterator, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "queue", "" + bl5);
        }
        return bl5;
    }

    public boolean queue(WsByteBuffer[] wsByteBufferArray, int n, int n2, ReceiveListener receiveListener, SendListener sendListener, Connection connection, boolean bl, boolean bl2, long l, boolean bl3, boolean bl4) throws NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "queue");
        }
        TransmissionDataIterator transmissionDataIterator = TransmissionDataIterator.allocateFromPool(connection, wsByteBufferArray, n2, bl, bl2, n, sendListener, bl4, bl3, (int)l);
        if (this.type == Conversation.ME) {
            meQueuedBytes = (int)((long)meQueuedBytes + l);
        } else if (this.type == Conversation.CLIENT) {
            clientQueuedBytes = (int)((long)clientQueuedBytes + l);
        }
        boolean bl5 = this.queueInternal(transmissionDataIterator, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "queue", "" + bl5);
        }
        return bl5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueInternal(TransmissionDataIterator transmissionDataIterator, boolean bl) throws NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "queueInternal", transmissionDataIterator);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        ActivatableMonitor activatableMonitor = null;
        int n = transmissionDataIterator.getPriority();
        int n2 = transmissionDataIterator.getSize();
        CircularFIFOArrayBuffer circularFIFOArrayBuffer = null;
        while (!bl3) {
            Object object = this.queueMonitor;
            synchronized (object) {
                if (this.state == CLOSED) {
                    bl3 = true;
                } else {
                    if (bl) {
                        this.state = CLOSING;
                    }
                    if (circularFIFOArrayBuffer == null) {
                        if (n == -1) {
                            int n3 = 15;
                            for (n = 0; n < n3 && this.queueArray[n].depth == 0; ++n) {
                            }
                            transmissionDataIterator.setPriority(n);
                            circularFIFOArrayBuffer = this.queueArray[n];
                        } else {
                            circularFIFOArrayBuffer = this.queueArray[n];
                        }
                    }
                    if (!transmissionDataIterator.isUserRequest() || ((Queue)circularFIFOArrayBuffer).hasCapacity) {
                        circularFIFOArrayBuffer.enqueue(transmissionDataIterator);
                        ((Queue)circularFIFOArrayBuffer).bytes += transmissionDataIterator.getSize();
                        ++((Queue)circularFIFOArrayBuffer).depth;
                        ++this.totalQueueDepth;
                        bl3 = true;
                        if (((Queue)circularFIFOArrayBuffer).hasCapacity && ((Queue)circularFIFOArrayBuffer).depth >= maxQueueDepth || ((Queue)circularFIFOArrayBuffer).bytes >= maxQueueBytes) {
                            ((Queue)circularFIFOArrayBuffer).hasCapacity = false;
                            ((Queue)circularFIFOArrayBuffer).monitor.setActive(true);
                            if (n >= this.lowestPriorityWithCapacity) {
                                this.lowestPriorityWithCapacity = n + 1;
                                bl2 = true;
                            }
                        }
                    } else if (this.mode == BLOCK) {
                        activatableMonitor = ((Queue)circularFIFOArrayBuffer).monitor;
                    } else {
                        throw new NoCapacityException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"PRIORITYQUEUE_INTERNAL_SICJ0057", null, (String)"PRIORITYQUEUE_INTERNAL_SICJ0057"));
                    }
                }
            }
            if (activatableMonitor == null) continue;
            activatableMonitor.waitOn();
        }
        if (this.type == Conversation.CLIENT) {
            clientQueuedBytes += n2;
        } else {
            meQueuedBytes += n2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "queueInternal", "" + bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionData dequeue(CapacityChangeHint capacityChangeHint) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dequeue");
        }
        TransmissionData transmissionData = null;
        capacityChangeHint.changed = false;
        Queue queue = null;
        Object object = this.queueMonitor;
        synchronized (object) {
            if (this.state != CLOSED) {
                int n;
                for (n = 15; n >= 0 && this.queueArray[n].depth == 0; --n) {
                }
                if (n >= 0) {
                    queue = this.queueArray[n];
                    TransmissionDataIterator transmissionDataIterator = queue.head();
                    transmissionData = transmissionDataIterator.next();
                    queue.bytes -= transmissionData.getSize();
                    if (!transmissionDataIterator.hasNext()) {
                        queue.dequeue();
                        --queue.depth;
                        --this.totalQueueDepth;
                    }
                    if (this.totalQueueDepth == 0 && this.state == CLOSING) {
                        this.state = CLOSED;
                        this.closeWaitersMonitor.setActive(false);
                    }
                    if (!queue.hasCapacity && queue.bytes < maxQueueBytes && queue.depth < maxQueueDepth) {
                        queue.hasCapacity = true;
                        if (n < this.lowestPriorityWithCapacity) {
                            int n2 = n;
                            if (this.mode == BLOCK) {
                                queue.monitor.setActive(false);
                            }
                            while (n2 > 0 && this.queueArray[n2 - 1].hasCapacity) {
                                --n2;
                            }
                            this.lowestPriorityWithCapacity = n2;
                            capacityChangeHint.changed = true;
                        }
                    }
                }
            }
        }
        if (transmissionData != null) {
            if (this.type == Conversation.CLIENT) {
                clientQueuedBytes -= transmissionData.getSize();
            } else {
                meQueuedBytes -= transmissionData.getSize();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dequeue", transmissionData);
        }
        return transmissionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCapacity(int n) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasCapacity", "" + n);
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            bl = n >= this.lowestPriorityWithCapacity;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasCapacity", "" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapacityListener(CapacityListener capacityListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addCapacityListener", capacityListener);
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            this.capacityListeners.add(capacityListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addCapacityListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCapacityListener(CapacityListener capacityListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeCapacityListener", capacityListener);
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            this.capacityListeners.remove(capacityListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeCapacityListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close", "" + bl);
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            if (bl || this.totalQueueDepth == 0) {
                this.state = CLOSED;
                this.closeWaitersMonitor.setActive(false);
            } else {
                this.state = CLOSING;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    public void waitForCloseToComplete() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "waitForCloseToComplete");
        }
        this.closeWaitersMonitor.waitOn();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "waitForCloseToComplete");
        }
    }

    protected void setType(Conversation.ConversationType conversationType) {
        this.type = conversationType;
    }

    public void notifyListeners() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "notifyListeners");
        }
        for (int i = 0; i < this.capacityListeners.size(); ++i) {
            CapacityListener capacityListener = (CapacityListener)this.capacityListeners.get(i);
            capacityListener.capacityChange();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "notifyListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.queueMonitor;
        synchronized (object) {
            return this.totalQueueDepth == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLowestPrioityWithCapacity() {
        Object object = this.queueMonitor;
        synchronized (object) {
            return this.lowestPriorityWithCapacity;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/PriorityQueue.java, SIB.comms, WAS602.SIB, o0610.11 1.34");
        }
        CommsPMI.getClientStats().addBufferedWritesUpdateListener(clientStatsListener);
        CommsPMI.getMEStats().addBufferedWritesUpdateListener(meStatsListener);
        try {
            maxQueueDepth = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.maxPriorityQueueDepth"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            maxQueueBytes = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.maxPriorityQueueBytes"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class Queue
    extends CircularFIFOArrayBuffer {
        int depth;
        int bytes;
        boolean hasCapacity;
        ActivatableMonitor monitor;

        private Queue() {
            super(maxQueueDepth);
            this.depth = 0;
            this.bytes = 0;
            this.hasCapacity = true;
            this.monitor = new ActivatableMonitor(false);
        }
    }

    private class CircularFIFOArrayBuffer {
        private TransmissionDataIterator[] array;
        private int size = 0;
        private int firstElementIndex = 0;
        private int maxSize = 0;

        public CircularFIFOArrayBuffer(int n) {
            this.array = new TransmissionDataIterator[n];
            this.maxSize = n;
        }

        public void enqueue(TransmissionDataIterator transmissionDataIterator) {
            this.array[(this.firstElementIndex + this.size) % this.maxSize] = transmissionDataIterator;
            ++this.size;
        }

        public TransmissionDataIterator dequeue() {
            TransmissionDataIterator transmissionDataIterator = null;
            if (this.size > 0) {
                transmissionDataIterator = this.array[this.firstElementIndex];
                this.array[this.firstElementIndex] = null;
                this.firstElementIndex = (this.firstElementIndex + 1) % this.maxSize;
                --this.size;
            }
            return transmissionDataIterator;
        }

        public TransmissionDataIterator head() {
            TransmissionDataIterator transmissionDataIterator = null;
            if (this.size > 0) {
                transmissionDataIterator = this.array[this.firstElementIndex];
            }
            return transmissionDataIterator;
        }
    }

    public static class CapacityChangeHint {
        private boolean changed;

        public boolean hasChanged() {
            return this.changed;
        }

        public void set() {
            this.changed = true;
        }
    }

    private class ActivatableMonitor {
        private boolean enabled = true;

        public ActivatableMonitor(boolean bl) {
            this.enabled = bl;
        }

        public synchronized void waitOn() {
            if (this.enabled) {
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        private synchronized void setActive(boolean bl) {
            if (this.enabled != bl) {
                this.enabled = bl;
                if (!bl) {
                    this.notifyAll();
                }
            }
        }
    }

    private static final class StateEnum {
        private String description;

        private StateEnum(String string) {
            this.description = "PriorityQueue state: " + string;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class PriorityQueueMode {
        private String name;

        private PriorityQueueMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

