/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapConnectionBrokenException;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.jfapchannel.impl.JFapOutboundConnLink;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class OutboundConnection
extends Connection {
    private static final TraceComponent tc = SibTr.register(OutboundConnection.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private short conversationId = 1;
    private VirtualConnection vc = null;
    private ConnectionLink connLink = null;
    private OutboundConnectionTracker tracker = null;
    private boolean handshakeComplete = false;
    private Object handshakeMonitor = new Object();
    private ConnectionData connectionData;
    private boolean beingPurged = false;
    private int handshakersWaiting = 0;

    public OutboundConnection(ConnectionLink connectionLink, VirtualConnection virtualConnection, OutboundConnectionTracker outboundConnectionTracker, int n, int n2, ConnectionData connectionData) {
        super(connectionLink, virtualConnection, n, n2);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{connectionLink, virtualConnection, outboundConnectionTracker, "" + n, "" + n2});
        }
        this.vc = virtualConnection;
        this.connLink = connectionLink;
        this.connectionData = connectionData;
        this.tracker = outboundConnectionTracker;
        TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)connectionLink.getDeviceLink().getChannelAccessor();
        this.description = "OUT " + tCPConnectionContext.getLocalAddress().getHostAddress() + ":" + tCPConnectionContext.getLocalPort() + "->" + tCPConnectionContext.getRemoteAddress().getHostAddress() + ":" + tCPConnectionContext.getRemotePort();
        this.remoteHostAddress = tCPConnectionContext.getRemoteAddress().getHostAddress();
        this.chainName = this.getMetaData().getChainName();
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "New outbound connection established");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationImpl startNewConversation(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "startNewClientConversation", conversationReceiveListener);
        }
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (!this.handshakeComplete) {
                if (this.handshakersWaiting == 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "first conversation on connection");
                    }
                    ++this.handshakersWaiting;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "waiting for handshaking to be complete");
                    }
                    boolean bl = false;
                    do {
                        ++this.handshakersWaiting;
                        bl = false;
                        try {
                            this.handshakeMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "interrupted whilst waiting for handshaking");
                            }
                            bl = true;
                        }
                    } while (bl);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "finsihed waiting for handshaking");
                    }
                }
            }
        }
        int n = 0;
        try {
            n = this.conversationTable.reserveId();
        }
        catch (IdTableFullException idTableFullException) {
            throw new SIResourceException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"OUTBOUNDCONN_IDTABLEFULL_SICJ0055", null, (String)"OUTBOUNDCONN_IDTABLEFULL_SICJ0055"), idTableFullException);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "connection table allocated conversation id: " + n);
        }
        ConversationImpl conversationImpl = new ConversationImpl((short)n, !this.handshakeComplete, this, conversationReceiveListener);
        ConversationImpl conversationImpl2 = this.startNewConversationGeneric(conversationImpl, true, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "startNewClientConversation", conversationImpl2);
        }
        return conversationImpl2;
    }

    public void closeNotification(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeNotification", conversation);
        }
        this.tracker.closeConversation(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeNotification");
        }
    }

    public void invalidateImpl(boolean bl, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "invalidateImpl", new Object[]{"" + bl, throwable});
        }
        if (throwable != null && tc.isEventEnabled()) {
            SibTr.exception(tc, throwable);
        }
        JFapConnectionBrokenException jFapConnectionBrokenException = new JFapConnectionBrokenException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"OUTBOUNDCONV_INVALIDATE_SICJ0056", null, (String)"OUTBOUNDCONV_INVALIDATE_SICJ0056"));
        if (throwable != null) {
            jFapConnectionBrokenException.initCause(throwable);
        }
        this.wakeupAllConversationsWithException(jFapConnectionBrokenException, true);
        this.tracker.purge(this, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "invalidateImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshakeComplete() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "handshakeComplete");
        }
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (!this.handshakeComplete) {
                this.handshakeComplete = true;
                this.handshakersWaiting = 0;
                this.handshakeMonitor.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "handshakeComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshakeFailed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "handshakeFailed");
        }
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (!this.handshakeComplete) {
                --this.handshakersWaiting;
                this.handshakeMonitor.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "handshakeFailed");
        }
    }

    public void setConnectionData(ConnectionData connectionData) {
        this.connectionData = connectionData;
    }

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public boolean isBeingPurged() {
        return this.beingPurged;
    }

    public void beingPurged() {
        this.beingPurged = true;
    }

    protected Conversation cloneConversation(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cloneConnection", conversationReceiveListener);
        }
        Conversation conversation = this.tracker.cloneConversation(this, conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cloneConnection", conversation);
        }
        return conversation;
    }

    protected ConversationMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMetaData");
        }
        ConversationMetaData conversationMetaData = ((JFapOutboundConnLink)this.connChannel).getMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMetaData", conversationMetaData);
        }
        return conversationMetaData;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/OutboundConnection.java, SIB.comms, WAS602.SIB, o0610.11 1.28");
        }
    }
}

