/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.ConversationMetaDataImpl;
import com.ibm.ws.sib.jfapchannel.impl.InboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.impl.BaseConnectionLink;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.Map;

public class JFapInboundConnLink
extends InboundApplicationLink {
    private static final TraceComponent tc = SibTr.register(JFapInboundConnLink.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ChannelData config;
    private ConversationMetaData metaData;

    public JFapInboundConnLink(VirtualConnection virtualConnection, ChannelFactoryData channelFactoryData, ChannelData channelData) {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, tc, "<init>", new Object[]{virtualConnection, channelFactoryData, channelData});
            }
            ChannelFramework channelFramework = channelFactoryData.getChannelFramework();
            this.config = channelData;
            try {
                ChainData[] chainDataArray = null;
                String string = this.config.getName();
                chainDataArray = channelFramework.getInternalRunningChains(string);
                if (chainDataArray != null) {
                    if (chainDataArray.length != 1 && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, tc, "chain data contains more than one entry!");
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, tc, "channelName=" + string + " chainData=" + chainDataArray[0]);
                    }
                    this.metaData = new ConversationMetaDataImpl(chainDataArray[0], (BaseConnectionLink)this);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, tc, "cannot find a running chain for channel: " + string);
                }
            }
            catch (ChannelException channelException) {
                FFDCFilter.processException((Throwable)channelException, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090003", (Object)channelFramework);
                if (!tc.isEventEnabled()) break block9;
                SibTr.exception((Object)this, tc, (Exception)((Object)channelException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, tc, "<init>");
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        ConversationReceiveListener conversationReceiveListener;
        ConversationImpl conversationImpl;
        InboundConnection inboundConnection;
        block13: {
            AcceptListener acceptListener;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, tc, "ready", virtualConnection);
            }
            if ((acceptListener = (AcceptListener)this.config.getPropertyBag().get("jfapchannel.ACCEPT_LISTENER")) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, tc, "null accept listener - obtaining one from factory");
                }
                acceptListener = ServerConnectionManagerImpl.getAcceptListenerFactory().manufactureAcceptListener();
            }
            Map map = this.config.getPropertyBag();
            int n = this.determineHeartbeatInterval(map);
            int n2 = this.determineHeartbeatTimeout(map);
            ServerConnectionManager serverConnectionManager = ServerConnectionManager.getRef();
            inboundConnection = new InboundConnection((ConnectionLink)this, virtualConnection, acceptListener, n, n2);
            conversationImpl = new ConversationImpl(1, true, inboundConnection, null);
            conversationReceiveListener = null;
            try {
                conversationReceiveListener = acceptListener.acceptConnection(conversationImpl);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090001");
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, tc, "Exception occurred in acceptConnection callback");
                }
                if (!tc.isEventEnabled()) break block13;
                SibTr.exception((Object)this, tc, throwable);
            }
        }
        if (conversationReceiveListener == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Null receive listener, closing conversation");
            }
            conversationImpl.setDefaultRecevieListner(new CloseConversationReceiveListener());
            conversationImpl = inboundConnection.startNewConversation(conversationImpl);
            try {
                conversationImpl.close();
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090002");
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIConnectionLostException);
                }
                inboundConnection.invalidate(true, sIConnectionLostException, "SIConnectionLostException thrown during conversation close");
            }
        } else {
            conversationImpl.setDefaultRecevieListner(conversationReceiveListener);
            conversationImpl = inboundConnection.startNewConversation(conversationImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, tc, "ready");
        }
    }

    private int determineHeartbeatInterval(Map map) {
        String string;
        int n = 300;
        try {
            n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL", "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (map != null && (string = (String)map.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private int determineHeartbeatTimeout(Map map) {
        String string;
        int n = 7;
        try {
            n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT", "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (map != null && (string = (String)map.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, tc, "close", new Object[]{virtualConnection, exception});
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)this, tc, exception);
        }
        super.close(virtualConnection, exception);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, tc, "close");
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, tc, "destroy", exception);
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)this, tc, exception);
        }
        super.destroy(exception);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, tc, "destroy");
        }
    }

    protected ConversationMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, tc, "getMetaData");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, tc, "getMetaData", this.metaData);
        }
        return this.metaData;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/JFapInboundConnLink.java, SIB.comms, WAS602.SIB, o0610.11 1.28");
        }
    }

    private class CloseConversationReceiveListener
    implements ConversationReceiveListener {
        private CloseConversationReceiveListener() {
        }

        public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "CloseConversationReceiveListener.dataReceived");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "CloseConversationReceiveListener.dataReceived");
            }
            return null;
        }

        public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "CloseConversationReceiveListener.errorOccurred");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIConnectionLostException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "CloseConversationReceiveListener.errorOccurred");
            }
        }

        public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "CloseConversationReceiveListener.getThreadContext");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "CloseConversationReceiveListener.getThreadContext");
            }
            return null;
        }
    }
}

