/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.pmi.StatsUpdateListener;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.InboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.RequestIdTable;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class InboundTransmissionParser {
    private static final TraceComponent tc = SibTr.register(InboundTransmissionParser.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Connection connection;
    private Throwable throwable;
    private AcceptListener acceptListener;
    private boolean onClientSide;
    private byte expectedPacketNumber = 0;
    private int transmissionPayloadDataLength;
    private int transmissionPayloadRemaining;
    private WsByteBuffer[] inFlightSegmentedTransmissions = new WsByteBuffer[16];
    private boolean needMoreData = false;
    private int state = 0;
    private static final int STATE_PARSING_PRIMARY_HEADER = 0;
    private static final int STATE_PARSING_CONVERSATION_HEADER = 1;
    private static final int STATE_PARSING_SEGMENT_START_HEADER = 2;
    private static final int STATE_PARSING_PRIMARY_ONLY_PAYLOAD = 3;
    private static final int STATE_PARSE_CONVERSATION_PAYLOAD = 4;
    private static final int STATE_PARSE_SEGMENT_START_PAYLOAD = 5;
    private static final int STATE_PARSE_SEGMENT_MIDDLE_PAYLOAD = 6;
    private static final int STATE_PARSE_SEGMENT_END_PAYLOAD = 7;
    private static final int STATE_ERROR = 8;
    private WsByteBuffer unparsedPrimaryHeader;
    private WsByteBuffer unparsedConversationHeader;
    private WsByteBuffer unparsedFirstSegment;
    private WsByteBuffer unparsedPayloadData = null;
    private PrimaryHeaderFields primaryHeaderFields = new PrimaryHeaderFields();
    private ConversationHeaderFields conversationHeaderFields = new ConversationHeaderFields();
    private SegmentedTransmissionHeaderFields[] segmentedTransmissionHeaderFields = new SegmentedTransmissionHeaderFields[16];
    private JFapChannelConstants.TransmissionLayout transmissionLayout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
    private static volatile int clientReadBytes = 0;
    private static volatile int meReadBytes = 0;
    private static StatsUpdateListener clientListener = new StatsUpdateListener(){

        public int statChanged() {
            return clientReadBytes;
        }
    };
    private static StatsUpdateListener meListener = new StatsUpdateListener(){

        public int statChanged() {
            return meReadBytes;
        }
    };
    private Conversation.ConversationType type = Conversation.UNKNOWN;

    public InboundTransmissionParser(Connection connection, AcceptListener acceptListener, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{connection, acceptListener, "" + bl});
        }
        this.connection = connection;
        this.acceptListener = acceptListener;
        this.onClientSide = bl;
        this.unparsedPrimaryHeader = this.allocateWsByteBuffer(10, false);
        this.unparsedPrimaryHeader.position(0);
        this.unparsedPrimaryHeader.limit(10);
        this.unparsedConversationHeader = this.allocateWsByteBuffer(4, false);
        this.unparsedConversationHeader.position(0);
        this.unparsedConversationHeader.limit(4);
        this.unparsedFirstSegment = this.allocateWsByteBuffer(12, false);
        this.unparsedFirstSegment.position(0);
        this.unparsedFirstSegment.limit(12);
        for (int i = 0; i < this.segmentedTransmissionHeaderFields.length; ++i) {
            this.segmentedTransmissionHeaderFields[i] = new SegmentedTransmissionHeaderFields();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void parse(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parse", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "transmissionBuffer");
        }
        this.needMoreData = false;
        boolean bl = false;
        block11: while (!this.needMoreData && !bl) {
            switch (this.state) {
                case 0: {
                    this.parsePrimaryHeader(wsByteBuffer);
                    continue block11;
                }
                case 1: {
                    this.parseConversationHeader(wsByteBuffer);
                    continue block11;
                }
                case 2: {
                    this.parseSegmentStartHeader(wsByteBuffer);
                    continue block11;
                }
                case 3: {
                    this.parsePrimaryOnlyPayload(wsByteBuffer);
                    continue block11;
                }
                case 4: {
                    this.parseConversationPayload(wsByteBuffer);
                    continue block11;
                }
                case 5: {
                    this.parseSegmentStartPayload(wsByteBuffer);
                    continue block11;
                }
                case 6: {
                    this.parseSegmentMiddlePayload(wsByteBuffer);
                    continue block11;
                }
                case 7: {
                    this.parseSegmentEndPayload(wsByteBuffer);
                    continue block11;
                }
                case 8: {
                    bl = true;
                    continue block11;
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "got into default branch of parse() method case statement");
            }
            this.throwable = new SIErrorException("Should not have entered default branch of parse() method case statement");
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170001");
            this.state = 8;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "encountered error parsing");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, this.throwable);
            }
            this.connection.invalidate(false, this.throwable, "parse error while parsing transmission");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parse");
        }
    }

    private void parsePrimaryHeader(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parsePrimaryHeader", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPrimaryHeader, "unparsedPrimaryHeader");
        }
        int n = this.unparsedPrimaryHeader.position();
        WsByteBuffer wsByteBuffer2 = this.readData(wsByteBuffer, this.unparsedPrimaryHeader);
        if (wsByteBuffer2 != null) {
            short s;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "parse header buffer not null");
            }
            if ((s = wsByteBuffer2.getShort()) != -16657) {
                this.state = 8;
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170002", (Object)this.getFormattedBytes(wsByteBuffer));
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "bad eyecatcer (as short): " + s);
                }
            } else {
                this.primaryHeaderFields.segmentLength = wsByteBuffer2.getInt();
                if (this.primaryHeaderFields.segmentLength < 0) {
                    this.primaryHeaderFields.segmentLength = (int)((long)this.primaryHeaderFields.segmentLength + 0x100000000L);
                }
                if (this.primaryHeaderFields.segmentLength > this.connection.getMaxTransmissionSize()) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170003", (Object)this.getFormattedBytes(wsByteBuffer));
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "max transmission size exceeded");
                    }
                } else {
                    this.transmissionPayloadRemaining = this.primaryHeaderFields.segmentLength - 10;
                    short s2 = wsByteBuffer2.getShort();
                    this.primaryHeaderFields.priority = s2 & 0xF;
                    this.primaryHeaderFields.isPooled = (s2 & 0x1000) == 4096;
                    boolean bl = this.primaryHeaderFields.isExchange = (s2 & 0x4000) == 16384;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "flags: " + s2);
                    }
                    this.primaryHeaderFields.packetNumber = wsByteBuffer2.get();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "packet number: " + this.primaryHeaderFields.packetNumber + " expected: " + this.expectedPacketNumber);
                    }
                    if (this.type == Conversation.ME) {
                        CommsPMI.getMEDetailedStats().onReceiveBytes(this.primaryHeaderFields.segmentLength, this.primaryHeaderFields.priority);
                    }
                    if (this.type == Conversation.CLIENT) {
                        CommsPMI.getClientDetailedStats().onReceiveBytes(this.primaryHeaderFields.segmentLength, this.primaryHeaderFields.priority);
                    }
                    if (this.primaryHeaderFields.packetNumber != this.expectedPacketNumber) {
                        this.state = 8;
                        this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                        FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170004", (Object)this.getFormattedBytes(wsByteBuffer));
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "sequence number mis-match - expected:" + this.expectedPacketNumber + " got:" + this.primaryHeaderFields.packetNumber);
                        }
                    } else {
                        this.expectedPacketNumber = (byte)(this.expectedPacketNumber + 1);
                        this.primaryHeaderFields.segmentType = wsByteBuffer2.get();
                        if (this.primaryHeaderFields.segmentType < 0) {
                            this.primaryHeaderFields.segmentType += 256;
                        }
                        this.transmissionLayout = JFapChannelConstants.segmentToLayout(this.primaryHeaderFields.segmentType);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "layout = " + this.transmissionLayout);
                        }
                        if (this.transmissionLayout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                            this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 10;
                            this.state = 3;
                        } else if (this.transmissionLayout == JFapChannelConstants.XMIT_CONVERSATION || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_START || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_END) {
                            this.state = 1;
                        } else if (this.transmissionLayout == JFapChannelConstants.XMIT_LAYOUT_UNKNOWN) {
                            this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170005", (Object)this.getFormattedBytes(wsByteBuffer));
                            this.state = 8;
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "invalid layout");
                            }
                        } else {
                            this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170006", (Object)this.getFormattedBytes(wsByteBuffer));
                            this.state = 8;
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "JFapChannelConstants.segmentToLayout method returned unknown enumeration value");
                            }
                        }
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPrimaryHeader, "unparsedPrimaryHEader");
            }
            int n2 = this.unparsedPrimaryHeader.position();
            if (n < 2 && n2 > n) {
                int n3 = n2 - n;
                if (n3 > 2) {
                    n3 = 2;
                }
                int n4 = n;
                this.unparsedPrimaryHeader.position(n4);
                boolean bl = false;
                for (int i = n4; i < n3 && !bl; ++i) {
                    bl = this.unparsedPrimaryHeader.get() != JFapChannelConstants.EYECATCHER_AS_BYTES[i];
                }
                if (bl) {
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170007", (Object)this.getFormattedBytes(wsByteBuffer));
                    this.state = 8;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "invalid eyecatcher");
                    }
                } else {
                    this.unparsedPrimaryHeader.position(n2);
                }
            }
            if (this.state != 8) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "need more data");
                }
                this.needMoreData = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parsePrimaryHeader");
        }
    }

    private void parseConversationHeader(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseConversationHeader", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        WsByteBuffer wsByteBuffer2 = this.readData(wsByteBuffer, this.unparsedConversationHeader);
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer2, "parseConversationBuffer");
        }
        if (wsByteBuffer2 != null) {
            this.conversationHeaderFields.conversationId = wsByteBuffer2.getShort();
            this.conversationHeaderFields.requestNumber = wsByteBuffer2.getShort();
            this.transmissionPayloadRemaining -= 4;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "conversationId:" + this.conversationHeaderFields.conversationId + " requestNumber:" + this.conversationHeaderFields.requestNumber);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "transmissionLayout:" + this.transmissionLayout);
            }
            if (this.transmissionLayout == JFapChannelConstants.XMIT_CONVERSATION) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 4;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 6;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_END) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 7;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_START) {
                this.state = 2;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170008", (Object)this.getFormattedBytes(wsByteBuffer));
                this.state = 8;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Invalid state detected - Entered parseConversationHeader method when transmission only contained a primary header");
                }
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_LAYOUT_UNKNOWN) {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170009", (Object)this.getFormattedBytes(wsByteBuffer));
                this.state = 8;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Invalid state detected - Entered parseConversationHeader method when transmission layout could not be determined");
                }
            } else {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170010", (Object)this.getFormattedBytes(wsByteBuffer));
                this.state = 8;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Unknown transmission layout detected in parseConversationHeader");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "need more data");
            }
            this.needMoreData = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseConversationHeader");
        }
    }

    private void parseSegmentStartHeader(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseSegmentStartHeader", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        WsByteBuffer wsByteBuffer2 = this.readData(wsByteBuffer, this.unparsedFirstSegment);
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer2, "rawData");
        }
        if (wsByteBuffer2 != null) {
            this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength = wsByteBuffer2.getLong();
            this.transmissionPayloadRemaining -= 12;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "totalLenght: " + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength);
            }
            if (this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength < 0L) {
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170011", (Object)this.getFormattedBytes(wsByteBuffer));
                this.state = 8;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Conversation lost after peer transmitted more data than initially indicated in first part of segmented transmission");
                }
            } else {
                this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType = wsByteBuffer2.get();
                if (this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType < 0) {
                    this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType += 256;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "segmentType: " + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType);
                }
                wsByteBuffer2.position(wsByteBuffer2.position() + 3);
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 26;
                this.state = 5;
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "need more data");
            }
            this.needMoreData = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseSegmentStartHeader");
        }
    }

    private void parsePrimaryOnlyPayload(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parsePrimaryOnlyPayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        WsByteBuffer wsByteBuffer2 = null;
        if (this.unparsedPayloadData == null && this.transmissionPayloadDataLength > wsByteBuffer.remaining()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "allocating unparsed payload data area, size=" + this.transmissionPayloadDataLength);
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer(this.transmissionPayloadDataLength, false);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit(this.transmissionPayloadDataLength);
        }
        if (this.unparsedPayloadData != null) {
            if (tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPayloadData, "unparsedPayloadData");
            }
            if ((wsByteBuffer2 = this.readData(wsByteBuffer, this.unparsedPayloadData)) != null) {
                this.dispatchToConnection(wsByteBuffer2);
                this.reset();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "need more data");
                }
                this.needMoreData = true;
            }
        } else {
            int n = wsByteBuffer.position();
            int n2 = wsByteBuffer.limit();
            wsByteBuffer.limit(n + this.transmissionPayloadDataLength);
            this.dispatchToConnection(wsByteBuffer);
            wsByteBuffer.limit(n2);
            wsByteBuffer.position(n + this.transmissionPayloadDataLength);
            this.reset();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parsePrimaryOnlyPayload");
        }
    }

    private void parseConversationPayload(WsByteBuffer wsByteBuffer) {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseConversationPayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        if (this.unparsedPayloadData == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "allocating unparsed data buffer, size=" + this.transmissionPayloadDataLength);
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer(this.transmissionPayloadDataLength, this.primaryHeaderFields.isPooled);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit(this.transmissionPayloadDataLength);
        }
        if ((n2 = JFapUtils.copyWsByteBuffer(wsByteBuffer, this.unparsedPayloadData, n = this.unparsedPayloadData.remaining())) == n) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "dispatching to conversation - amount cpoied = " + n2);
            }
            this.dispatchToConversation(this.unparsedPayloadData);
            if (this.state != 8) {
                this.reset();
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "need more data");
            }
            this.needMoreData = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseConversationPayload");
        }
    }

    private void parseSegmentStartPayload(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseSegmentStartPayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        if (this.unparsedPayloadData == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "allocating unparsed payload data buffe, size=" + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength);
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer((int)this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength, this.primaryHeaderFields.isPooled);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit((int)this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength);
        }
        int n = this.unparsedPayloadData.remaining();
        int n2 = JFapUtils.copyWsByteBuffer(wsByteBuffer, this.unparsedPayloadData, this.transmissionPayloadRemaining);
        this.transmissionPayloadRemaining -= n2;
        if (this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] != null) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170012", (Object)this.getFormattedBytes(wsByteBuffer));
            this.state = 8;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Received the start of a segmented transmission whilst already processing a segmented transmission at the same priority level");
            }
        } else {
            boolean bl = this.needMoreData = wsByteBuffer.remaining() == 0;
            if (!this.needMoreData) {
                this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] = this.unparsedPayloadData;
                if (this.type == Conversation.ME) {
                    meReadBytes += this.unparsedPayloadData.remaining();
                } else if (this.type == Conversation.CLIENT) {
                    clientReadBytes -= this.unparsedPayloadData.remaining();
                }
                this.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseSegmentStartPayload");
        }
    }

    private void parseSegmentMiddlePayload(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseSegmentMiddlePayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        WsByteBuffer wsByteBuffer2 = this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority];
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "partial transmission in slot " + this.primaryHeaderFields.priority + " = " + wsByteBuffer2);
        }
        int n = wsByteBuffer.remaining();
        if (wsByteBuffer2 == null) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170013", (Object)this.getFormattedBytes(wsByteBuffer));
            this.state = 8;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Received the middle segment of a segmented transmission prior to receiving a start segment.");
            }
        } else if (wsByteBuffer2.remaining() < this.transmissionPayloadRemaining) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170014", (Object)this.getFormattedBytes(wsByteBuffer));
            this.state = 8;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Received a middle segment for a segmented transmission which makes the transmission larger than the peer indicated in the first segment.");
            }
        } else {
            int n2 = JFapUtils.copyWsByteBuffer(wsByteBuffer, wsByteBuffer2, this.transmissionPayloadRemaining);
            this.transmissionPayloadRemaining -= n2;
            if (this.type == Conversation.ME) {
                meReadBytes -= n2;
            } else if (this.type == Conversation.CLIENT) {
                clientReadBytes -= n2;
            }
            boolean bl = this.needMoreData = n2 == n;
            if (!this.needMoreData) {
                this.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseSegmentMiddlePayload");
        }
    }

    private void parseSegmentEndPayload(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "parseSegmentEndPayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "contextBuffer");
        }
        WsByteBuffer wsByteBuffer2 = this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority];
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "partial transmission in slot " + this.primaryHeaderFields.priority + " = " + wsByteBuffer2);
        }
        int n = wsByteBuffer2.remaining();
        if (wsByteBuffer2 == null) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170015", (Object)this.getFormattedBytes(wsByteBuffer));
            this.state = 8;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Peer sent a segment end transmission prior to sending a segment start transmission for the segmented transmission.");
            }
        } else if (n > this.transmissionPayloadRemaining) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170016", (Object)this.getFormattedBytes(wsByteBuffer));
            this.state = 8;
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Peer sent the end segment of a segmented transmission which contains more data than origioinally suggested by first segment in segmented transmission.");
            }
        } else {
            int n2 = JFapUtils.copyWsByteBuffer(wsByteBuffer, wsByteBuffer2, this.transmissionPayloadRemaining);
            this.transmissionPayloadRemaining -= n2;
            if (this.type == Conversation.ME) {
                meReadBytes -= n2;
            } else if (this.type == Conversation.CLIENT) {
                clientReadBytes -= n2;
            }
            boolean bl = this.needMoreData = wsByteBuffer.remaining() == 0;
            if (this.transmissionPayloadRemaining == 0) {
                this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] = null;
                this.primaryHeaderFields.segmentType = this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType;
                this.dispatchToConversation(wsByteBuffer2);
                this.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "parseSegmentEndPayload");
        }
    }

    private void dispatchToConnection(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dispatchToConnection", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this.connection, null, "received connection data with segment " + Integer.toHexString(this.primaryHeaderFields.segmentType) + " (" + JFapChannelConstants.getSegmentName(this.primaryHeaderFields.segmentType) + ")");
        }
        this.connection.processData(this.primaryHeaderFields.segmentType, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, wsByteBuffer);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchToConnection");
        }
    }

    private void dispatchToConversation(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dispatchToConversation", wsByteBuffer);
        }
        ConversationImpl conversationImpl = this.connection.getConversationById(this.conversationHeaderFields.conversationId);
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this.connection, conversationImpl, "received conversation data with segment " + Integer.toHexString(this.primaryHeaderFields.segmentType) + " (" + JFapChannelConstants.getSegmentName(this.primaryHeaderFields.segmentType) + ")");
        }
        switch (this.primaryHeaderFields.segmentType) {
            case 10: {
                if (conversationImpl == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170017", (Object)this.getFormattedBytes(wsByteBuffer));
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug(this, tc, "Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")");
                    break;
                }
                conversationImpl.processLogicalClose(wsByteBuffer);
                break;
            }
            case 14: {
                if (conversationImpl == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170018", (Object)this.getFormattedBytes(wsByteBuffer));
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug(this, tc, "Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")");
                    break;
                }
                conversationImpl.processPing(this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, wsByteBuffer);
                break;
            }
            case 15: {
                if (conversationImpl == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170019", (Object)this.getFormattedBytes(wsByteBuffer));
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug(this, tc, "Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")");
                    break;
                }
                conversationImpl.processPingResponse(wsByteBuffer);
                break;
            }
            default: {
                this.dispatchToConversationListenerMethod(wsByteBuffer);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchToConversation");
        }
    }

    private void dispatchToConversationListenerMethod(WsByteBuffer wsByteBuffer) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dispatchToConversationListenerMethod", wsByteBuffer);
        }
        boolean bl = false;
        ConversationImpl conversationImpl = this.connection.getConversationById(this.conversationHeaderFields.conversationId);
        if (conversationImpl == null) {
            if (this.onClientSide) {
                bl = true;
            } else {
                conversationImpl = new ConversationImpl((short)this.conversationHeaderFields.conversationId, false, this.connection, null);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "accepting new conversation");
                }
                object = null;
                boolean bl2 = false;
                try {
                    object = this.acceptListener.acceptConnection(conversationImpl);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback", (String)"00170020");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "exception thrown from acceptConnection");
                    }
                    if (tc.isEventEnabled()) {
                        SibTr.event(this, tc, throwable.getMessage());
                    }
                    bl2 = true;
                    bl = true;
                }
                if (object == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "bad receive listener");
                    }
                    bl2 = true;
                    bl = true;
                    object = new BadReceiveListener();
                }
                conversationImpl.setDefaultRecevieListner((ConversationReceiveListener)object);
                conversationImpl = ((InboundConnection)this.connection).startNewConversation(conversationImpl);
                if (bl2) {
                    try {
                        conversationImpl.close();
                    }
                    catch (SIResourceException sIResourceException) {
                        FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback", (String)"00170020");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "exception thrown closing conversation");
                        }
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, tc, sIResourceException);
                        }
                        this.connection.invalidate(false, sIResourceException, "SIResourceError when closing conversation - " + sIResourceException.getMessage());
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            object = null;
            if (conversationImpl != null) {
                object = conversationImpl.getRequestIdTable();
            }
            if (object != null && ((RequestIdTable)object).containsId(this.conversationHeaderFields.requestNumber)) {
                ReceiveListener receiveListener = ((RequestIdTable)object).getListener(this.conversationHeaderFields.requestNumber);
                ((RequestIdTable)object).remove(this.conversationHeaderFields.requestNumber);
                if (receiveListener != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "listener: " + receiveListener + " conversaion: " + conversationImpl);
                    }
                    ReceiveListenerDispatcher.getInstance(conversationImpl.getConversationType(), conversationImpl.isOnClientSide()).queueDataReceivedInvocation(this.connection, receiveListener, wsByteBuffer, this.primaryHeaderFields.segmentType, this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, (Conversation)conversationImpl);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Entry " + this.conversationHeaderFields.requestNumber + " in request table has null listener");
                    }
                    this.connection.invalidate(true, null, "no receive listener for conversation " + this.conversationHeaderFields.requestNumber);
                }
            } else {
                ConversationReceiveListener conversationReceiveListener = conversationImpl.getDefaultReceiveListener();
                if (conversationReceiveListener == null) {
                    this.connection.invalidate(true, null, "no default receive listener");
                } else {
                    ReceiveListenerDispatcher.getInstance(conversationImpl.getConversationType(), conversationImpl.isOnClientSide()).queueDataReceivedInvocation(this.connection, conversationReceiveListener, wsByteBuffer, this.primaryHeaderFields.segmentType, this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, (Conversation)conversationImpl);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchToConversationListenerMethod");
        }
    }

    private void reset() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reset");
        }
        this.throwable = null;
        this.state = 0;
        this.unparsedPrimaryHeader.position(0);
        this.unparsedPrimaryHeader.limit(10);
        this.unparsedConversationHeader.position(0);
        this.unparsedConversationHeader.limit(4);
        this.unparsedFirstSegment.position(0);
        this.unparsedFirstSegment.limit(12);
        this.unparsedPayloadData = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reset");
        }
    }

    private WsByteBuffer readData(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "readData", new Object[]{wsByteBuffer, wsByteBuffer2});
        }
        int n = wsByteBuffer2.remaining();
        int n2 = wsByteBuffer2.position();
        WsByteBuffer wsByteBuffer3 = null;
        if (n2 == 0 && wsByteBuffer.remaining() >= n) {
            wsByteBuffer3 = wsByteBuffer;
        } else {
            int n3 = JFapUtils.copyWsByteBuffer(wsByteBuffer, wsByteBuffer2, n);
            if (n3 >= n) {
                wsByteBuffer3 = wsByteBuffer2;
                wsByteBuffer3.flip();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "readData", wsByteBuffer3);
        }
        return wsByteBuffer3;
    }

    private WsByteBuffer allocateWsByteBuffer(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "allocateWsByteBuffer", new Object[]{"" + n, "" + bl});
        }
        WsByteBuffer wsByteBuffer = null;
        if (bl) {
            wsByteBuffer = BufferPoolManagerReference.getInstance().allocate(n);
        } else {
            byte[] byArray = new byte[n];
            wsByteBuffer = BufferPoolManagerReference.getInstance().wrap(byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "allocateWsByteBuffer", wsByteBuffer);
        }
        return wsByteBuffer;
    }

    protected void setType(Conversation.ConversationType conversationType) {
        this.type = conversationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedBytes(WsByteBuffer wsByteBuffer) {
        int n = wsByteBuffer.position();
        int n2 = wsByteBuffer.limit();
        wsByteBuffer.rewind();
        try {
            if (wsByteBuffer.hasArray()) {
                String string = SibTr.formatBytes(wsByteBuffer.array(), wsByteBuffer.arrayOffset() + wsByteBuffer.position(), wsByteBuffer.remaining());
                return string;
            }
            byte[] byArray = new byte[wsByteBuffer.remaining()];
            wsByteBuffer.get(byArray);
            String string = SibTr.formatBytes(byArray, 0, byArray.length);
            return string;
        }
        finally {
            wsByteBuffer.position(n);
            wsByteBuffer.limit(n2);
        }
    }

    static {
        CommsPMI.getClientStats().addBufferedReadsUpdateListener(clientListener);
        CommsPMI.getMEStats().addBufferedReadsUpdateListener(meListener);
    }

    private class BadReceiveListener
    implements ConversationReceiveListener {
        private BadReceiveListener() {
        }

        public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "BadReceiveListener.dataReceived");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "BadReceiveListener.dataReceived");
            }
            return null;
        }

        public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "BadReceiveListener.errorOccurred");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIConnectionLostException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "BadReceiveListener.errorOccurred");
            }
        }

        public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "BadReceiveListener.getThreadContext");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "BadReceiveListener.getThreadContext");
            }
            return null;
        }
    }

    private class SegmentedTransmissionHeaderFields {
        private long totalLength;
        private int segmentType;

        private SegmentedTransmissionHeaderFields() {
        }
    }

    private class ConversationHeaderFields {
        private int conversationId;
        private int requestNumber;

        private ConversationHeaderFields() {
        }
    }

    private class PrimaryHeaderFields {
        int segmentLength;
        int priority;
        boolean isPooled;
        boolean isExchange;
        int packetNumber;
        int segmentType;

        private PrimaryHeaderFields() {
        }
    }
}

