/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.utils.ras.SibTr;

public class IdTable {
    private static final TraceComponent tc = SibTr.register(IdTable.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Object[] table = null;
    private int maxSize = 0;
    private int highWaterMark = 0;
    private int lowestPossibleFree = 0;
    private static final int DEFAULT_INITIAL_SIZE = 50;
    private static final int TABLE_GROWTH_INCREMENT = 50;

    public IdTable(int n) throws IllegalArgumentException {
        this(n, Math.min(n, 50));
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public IdTable(int n, int n2) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "idTable", new Object[]{"" + n, "" + n2});
        }
        if (n < 1) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        if (n2 < 1 || n2 > n) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        this.maxSize = n;
        this.table = new Object[n2 + 1];
        this.lowestPossibleFree = 1;
        this.highWaterMark = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "idTable");
        }
    }

    public synchronized int add(Object object) throws IdTableFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "add", object);
        }
        if (object == null) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        int n = 0;
        if (this.highWaterMark < this.table.length) {
            n = this.highWaterMark;
            if (this.table[n] != null) {
                throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
            }
            this.table[n] = object;
            if (this.lowestPossibleFree == this.highWaterMark) {
                ++this.lowestPossibleFree;
            }
            ++this.highWaterMark;
        } else if (this.table.length < this.maxSize) {
            this.growTable();
            n = this.highWaterMark;
            if (this.table[n] != null) {
                throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
            }
            this.table[n] = object;
            if (this.lowestPossibleFree == this.highWaterMark) {
                ++this.lowestPossibleFree;
            }
            ++this.highWaterMark;
        } else {
            n = this.findFreeSlot();
            if (n == 0) {
                throw new IdTableFullException();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "add", "" + n);
        }
        return n;
    }

    public synchronized Object remove(int n) throws IllegalArgumentException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "remove", "" + n);
        }
        if ((object = this.get(n)) != null) {
            this.table[n] = null;
        }
        if (n < this.lowestPossibleFree) {
            this.lowestPossibleFree = n;
        }
        if (n + 1 == this.highWaterMark) {
            for (int i = n; i >= this.lowestPossibleFree; --i) {
                if (this.table[i] != null) continue;
                this.highWaterMark = i;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "remove", object);
        }
        return object;
    }

    public synchronized boolean contains(int n) throws IllegalArgumentException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "contains", "" + n);
        }
        if (n < 1 || n > this.maxSize) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        boolean bl2 = bl = n < this.table.length && this.table[n] != null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "contains", "" + bl);
        }
        return bl;
    }

    public synchronized Object get(int n) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "get", "" + n);
        }
        if (n < 1 || n > this.maxSize) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        Object object = null;
        if (n < this.table.length) {
            object = this.table[n];
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "get", "" + object);
        }
        return object;
    }

    private void growTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "growTable");
        }
        int n = Math.min(this.table.length + 50, this.maxSize);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "existing size=" + this.table.length + " new size=" + n);
        }
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.table, 0, objectArray, 0, this.table.length);
        this.table = objectArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "growTable");
        }
    }

    private int findFreeSlot() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "findFreeSlot");
        }
        boolean bl = false;
        int n2 = Math.min(this.highWaterMark, this.table.length - 1);
        for (n = this.lowestPossibleFree; !bl && n <= n2; ++n) {
            bl = this.table[n] == null;
        }
        int n3 = 0;
        if (bl) {
            n3 = n - 1;
            if (n * 2 > n2) {
                boolean bl2 = false;
                int n4 = n;
                for (n = n2; !bl2 && n >= n4; --n) {
                    if (this.table[n] == null) {
                        this.highWaterMark = n;
                        continue;
                    }
                    bl2 = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "findFreeSlot", "" + n3);
        }
        return n3;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/IdTable.java, SIB.comms, WAS602.SIB, o0610.11 1.12");
        }
    }
}

