/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapHeartbeatTimeoutException;
import com.ibm.ws.sib.jfapchannel.NoCapacityException;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.ConversationTable;
import com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class ConnectionReadCompletedCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = SibTr.register(ConnectionReadCompletedCallback.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Connection thisConnection = null;
    private boolean onClientSide;
    private AcceptListener acceptListener;
    private ConversationTable conversationTable;
    private ConversationImpl conversation;
    private TCPConnectionContext tcpCtx;
    private TCPReadRequestContext readCtx;
    private byte expectedPacketNumber = 0;
    private volatile boolean receivePhysicalCloseRequest = false;
    private volatile boolean awaitingHeartbeatResponse = false;
    private long awaitingHeartbeatTimestamp;
    private int currentHeartbeatTimeout;
    private boolean connectionClosing = false;
    private Object connectionClosingLock = new Object();
    private InboundTransmissionParser xmitParser;
    private boolean isFirstCompleteInvocation = true;
    private Object invocationCountLock = new Object();
    private int invocationCount = 0;
    private Thread lastInvokedOnThread = null;
    private static final int MAX_INVOCATIONS_BEFORE_THREAD_SWITCH = 10;

    protected ConnectionReadCompletedCallback(Connection connection, boolean bl, AcceptListener acceptListener, ConversationTable conversationTable, ConversationImpl conversationImpl, TCPConnectionContext tCPConnectionContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{connection, "" + bl, acceptListener, conversationTable, conversationImpl, tCPConnectionContext});
        }
        this.thisConnection = connection;
        this.onClientSide = bl;
        this.acceptListener = acceptListener;
        this.conversationTable = conversationTable;
        this.conversation = conversationImpl;
        this.tcpCtx = tCPConnectionContext;
        this.readCtx = tCPConnectionContext.getReadInterface();
        this.xmitParser = new InboundTransmissionParser(connection, acceptListener, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    private WsByteBuffer allocateWsByteBuffer(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "allocateWsByteBuffer", new Object[]{"" + n, "" + bl});
        }
        WsByteBuffer wsByteBuffer = null;
        if (bl) {
            wsByteBuffer = BufferPoolManagerReference.getInstance().allocate(n);
        } else {
            byte[] byArray = new byte[n];
            wsByteBuffer = BufferPoolManagerReference.getInstance().wrap(byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "allocateWsByteBuffer");
        }
        return wsByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "complete", new Object[]{virtualConnection, tCPReadRequestContext});
        }
        Object object = this.invocationCountLock;
        synchronized (object) {
            if (this.lastInvokedOnThread == Thread.currentThread()) {
                ++this.invocationCount;
            } else {
                this.invocationCount = 1;
                this.lastInvokedOnThread = Thread.currentThread();
            }
        }
        boolean bl = false;
        do {
            int n;
            bl = true;
            WsByteBuffer wsByteBuffer = tCPReadRequestContext.getBuffer();
            wsByteBuffer.limit(wsByteBuffer.position());
            wsByteBuffer.position(0);
            if (this.conversation.getConversationType() == Conversation.CLIENT) {
                this.xmitParser.setType(Conversation.CLIENT);
                CommsPMI.getClientStats().onRead();
                CommsPMI.getClientStats().onReadBytes(wsByteBuffer.remaining());
            } else if (this.conversation.getConversationType() == Conversation.ME) {
                this.xmitParser.setType(Conversation.ME);
                CommsPMI.getMEStats().onRead();
                CommsPMI.getMEStats().onReadBytes(wsByteBuffer.remaining());
            }
            if (tc.isEntryEnabled()) {
                JFapUtils.debugTraceWsByteBuffer(this, tc, wsByteBuffer, 16, "data received");
            }
            this.xmitParser.parse(wsByteBuffer);
            if (this.isFirstCompleteInvocation) {
                n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.DEFAULT_READ_BUFFER_SIZE", "32768"));
                if (!wsByteBuffer.isDirect() || wsByteBuffer.capacity() < n) {
                    wsByteBuffer = BufferPoolManagerReference.getInstance().allocateDirect(n);
                    tCPReadRequestContext.setBuffer(wsByteBuffer);
                }
                this.isFirstCompleteInvocation = false;
            }
            wsByteBuffer.clear();
            if (tCPReadRequestContext == null || this.receivePhysicalCloseRequest) continue;
            if (this.awaitingHeartbeatResponse) {
                long l = System.currentTimeMillis() - this.awaitingHeartbeatTimestamp;
                n = (int)((long)(this.currentHeartbeatTimeout * 1000) - l);
                if (n < 1) {
                    n = 1;
                }
            } else {
                n = this.thisConnection.getHeartbeatInterval() * 1000;
            }
            if (n > 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "setting heartbeat timeout to: " + n + " milliseconds");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "not using a heartbeat timeout");
                }
                n = -1;
            }
            boolean bl2 = false;
            Object object2 = this.connectionClosingLock;
            synchronized (object2) {
                bl2 = this.connectionClosing;
            }
            if (bl2) continue;
            boolean bl3 = false;
            Object object3 = this.invocationCountLock;
            synchronized (object3) {
                if (this.invocationCount > 10) {
                    bl3 = true;
                    this.lastInvokedOnThread = null;
                }
            }
            boolean bl4 = bl = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)this, bl3, n) == null;
            if (!bl) continue;
            if (this.conversation.getConversationType() == Conversation.ME) {
                CommsPMI.getMEStats().onReadBlocked();
                continue;
            }
            if (this.conversation.getConversationType() != Conversation.CLIENT) continue;
            CommsPMI.getClientStats().onReadBlocked();
        } while (!bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "error", new Object[]{virtualConnection, tCPReadRequestContext, iOException});
        }
        if (tc.isEventEnabled() && iOException != null) {
            SibTr.exception((Object)this, tc, iOException);
        }
        if (this.receivePhysicalCloseRequest) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "ignoring as in process of close");
            }
        } else if (iOException instanceof SocketTimeoutException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "error is as a result of a timeout");
            }
            if (this.awaitingHeartbeatResponse) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "timed out waiting for heartbeat response");
                }
                JFapHeartbeatTimeoutException jFapHeartbeatTimeoutException = new JFapHeartbeatTimeoutException("Connection dropped after heartbeat request went unacknowledged");
                jFapHeartbeatTimeoutException.initCause(iOException);
                this.thisConnection.invalidate(false, jFapHeartbeatTimeoutException, "heartbeat request was not acknowledged");
                if (this.conversation.getConversationType() == Conversation.ME) {
                    CommsPMI.getMEStats().onError();
                } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                    CommsPMI.getClientStats().onError();
                }
            } else if (this.thisConnection.getHeartbeatInterval() == 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "timed out but heartbeating now switched off");
                }
                VirtualConnection virtualConnection2 = null;
                Object object = this.connectionClosingLock;
                synchronized (object) {
                    if (!this.connectionClosing) {
                        virtualConnection2 = this.readCtx.read(1L, (TCPReadCompletedCallback)this, false, -1);
                    }
                }
                if (virtualConnection2 != null) {
                    this.complete(virtualConnection2, this.readCtx);
                } else if (this.conversation.getConversationType() == Conversation.ME) {
                    CommsPMI.getMEStats().onReadBlocked();
                } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                    CommsPMI.getClientStats().onReadBlocked();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "sending heartbeat request");
                }
                this.awaitingHeartbeatResponse = true;
                this.awaitingHeartbeatTimestamp = System.currentTimeMillis();
                this.currentHeartbeatTimeout = this.thisConnection.getHeartbeatTimeout();
                ArrayList arrayList = new ArrayList(1);
                SIException sIException = null;
                try {
                    this.thisConnection.send(arrayList, 1, 15, true, false, null, null, false);
                }
                catch (NoCapacityException noCapacityException) {
                    FFDCFilter.processException((Throwable)noCapacityException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback", (String)"00050006");
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, noCapacityException);
                    }
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Exception received when heartbeating peer (" + sIConnectionLostException.toString() + ").  Dropping connection");
                    }
                    sIException = sIConnectionLostException;
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Exception received when heartbeating peer (" + sIConnectionDroppedException.toString() + ").  Dropping connection");
                    }
                    sIException = sIConnectionDroppedException;
                }
                if (sIException == null) {
                    int n = this.currentHeartbeatTimeout * 1000;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "setting heartbeat timeout to: " + n + " milliseconds");
                    }
                    VirtualConnection virtualConnection3 = null;
                    Object object = this.connectionClosingLock;
                    synchronized (object) {
                        if (!this.connectionClosing) {
                            virtualConnection3 = this.readCtx.read(1L, (TCPReadCompletedCallback)this, false, n);
                        }
                    }
                    if (virtualConnection3 != null) {
                        this.complete(virtualConnection3, this.readCtx);
                    }
                } else {
                    this.thisConnection.invalidate(false, sIException, "exception caught while attempting to send heartbeat");
                    if (this.conversation.getConversationType() == Conversation.ME) {
                        CommsPMI.getMEStats().onError();
                    } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                        CommsPMI.getClientStats().onError();
                    }
                }
            }
        } else {
            this.thisConnection.invalidate(false, iOException, "IOException received for connection - " + iOException.getMessage());
            if (this.conversation.getConversationType() == Conversation.ME) {
                CommsPMI.getMEStats().onError();
            } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                CommsPMI.getClientStats().onError();
            }
            TCPReadRequestContext tCPReadRequestContext2 = this.readCtx;
            if (tCPReadRequestContext2.getBuffers() != null) {
                WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])tCPReadRequestContext2.getBuffers());
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Request has no buffers: " + tCPReadRequestContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "error");
        }
    }

    private void processSegmentedFlowStart(ConversationImpl conversationImpl) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Unimplemented (segmented flow start)");
        }
    }

    private void processSegmentedFlowMiddle(ConversationImpl conversationImpl) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Unimplemented (segmented flow middle)");
        }
    }

    private void processSegmentedFlowEnd(ConversationImpl conversationImpl) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Unimplemented (segmented flow end)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void physicalCloseNotification() {
        Object object = this.connectionClosingLock;
        synchronized (object) {
            this.connectionClosing = true;
        }
    }

    protected void heartbeatReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "heartbeatReceived");
        }
        if (this.awaitingHeartbeatResponse) {
            this.awaitingHeartbeatResponse = false;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Spurious heartbeat!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "heartbeatReceived");
        }
    }

    protected void stopReceiving() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "stopReceiving");
        }
        this.receivePhysicalCloseRequest = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "stopReceiving", "" + this.receivePhysicalCloseRequest);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConnectionReadCompletedCallback.java, SIB.comms, WAS602.SIB, o0610.11 1.39.1.1");
        }
    }
}

