/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;

public abstract class ServerConnectionManager {
    private static final TraceComponent tc;
    private static ServerConnectionManager instance;
    private static boolean initialised;

    public static void initialise(AcceptListenerFactory acceptListenerFactory) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialise");
        }
        if (!initialised) {
            block7: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "not previously initialised");
                }
                Class<?> clazz = instance.getClass();
                try {
                    Method method = clazz.getMethod("initialise", AcceptListenerFactory.class);
                    method.invoke(clazz, acceptListenerFactory);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.{}", (String)"00010001");
                    Throwable throwable = exception;
                    if (exception instanceof InvocationTargetException) {
                        throwable = exception.getCause();
                    }
                    SibTr.error(tc, "EXCP_DURING_INIT_SICJ0003", new Object[]{clazz, throwable});
                    if (!tc.isEventEnabled()) break block7;
                    SibTr.exception(tc, exception);
                }
            }
            initialised = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialise");
        }
    }

    public static synchronized ServerConnectionManager getRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRef");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRef");
        }
        return instance;
    }

    public abstract void closeAll(boolean var1);

    public abstract WsByteBufferPoolManager getBufferPoolManager();

    public abstract Conversation connect(InetSocketAddress var1, ConversationReceiveListener var2, String var3) throws SIResourceException;

    public abstract Conversation connect(CFEndPoint var1, ConversationReceiveListener var2) throws SIResourceException;

    static {
        block5: {
            tc = SibTr.register(ServerConnectionManager.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "@(#) ws/code/sib.jfapchannel/src/com/ibm/ws/sib/jfapchannel/ServerConnectionManager.java, SIB.comms, jstream 1.10");
            }
            initialised = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "static <init>");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl");
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                instance = (ServerConnectionManager)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.initialise", (String)"00010002");
                SibTr.error(tc, "EXCP_DURING_INIT_SICJ0004", new Object[]{"<init>", "com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl", exception});
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception(tc, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "static <init>");
        }
    }
}

