/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel;

import java.lang.reflect.Field;

public class JFapChannelConstants {
    public static final String MSG_GROUP = "SIBJFapChannel";
    public static final String MSG_BUNDLE = "com.ibm.ws.sib.jfapchannel.CWSIJMessages";
    public static final String CLIENT_MANAGER_CLASS = "com.ibm.ws.sib.jfapchannel.impl.ClientConnectionManagerImpl";
    public static final String SERVER_MANAGER_CLASS = "com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl";
    public static final String NON_THREAD_SWITCHING_DISPATCHER_CLASS = "com.ibm.ws.sib.jfapchannel.impl.rldispatcher.NonThreadSwitchingDispatchableImpl";
    public static final String DISPATCH_TO_ALL_NONEMPTY_DISPATCHER_CLASS = "com.ibm.ws.sib.jfapchannel.impl.rldispatcher.DispatchToAllNonEmptyDispatchableImpl";
    public static final String CLIENT_TCP_CHANNEL_THREADPOOL_NAME = "SIBFAPThreadPool";
    public static final String CLIENT_TCP_CHANNEL_THREADPOOL_MIN_SIZE_PROPERTY = "com.ibm.ws.sib.jfapchannel.impl.MinimumClientTCPThreadPoolSize";
    public static final int CLIENT_TCP_CHANNEL_THREADPOOL_MIN_SIZE_DEFAULT = 1;
    public static final String CLIENT_TCP_CHANNEL_THREADPOOL_MAX_SIZE_PROPERTY = "com.ibm.ws.sib.jfapchannel.impl.MaximumClientTCPThreadPoolSize";
    public static final int CLIENT_TCP_CHANNEL_THREADPOOL_MAX_SIZE_DEFAULT = 15;
    public static final String RLD_REPOOL_THREAD_DELAY_PROPERTY = "com.ibm.ws.sib.jfapchannel.impl.rldRepoolThreadDelayProperty";
    public static final int RLD_REPOOL_THREAD_DELAY_DEFAULT = 10000;
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 300;
    public static final int DEFAULT_HEARTBEAT_TIMEOUT = 7;
    public static final int DEFAULT_MAX_TRANSMISSION_SIZE = 0x100000;
    public static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_CONVERSATIONS_PER_CONN = 20;
    public static final String CHAIN_NAME_DEFAULT_OUTBOUND_JFAP_TCP = "BootstrapBasicMessaging";
    public static final String CHAIN_NAME_DEFAULT_OUTBOUND_JFAP_SSL_TCP = "BootstrapSecureMessaging";
    public static final String CHAIN_NAME_DEFAULT_OUTBOUND_JFAP_HTTPT_TCP = "BootstrapTunneledMessaging";
    public static final String CHAIN_NAME_DEFAULT_OUTBOUND_JFAP_HTTPT_SSL_TCP = "BootstrapTunneledSecureMessaging";
    public static final String CHANNEL_NAME_OUTBOUND_JFAP = "BootstrapMessagingJFAPChannel";
    public static final String CHANNEL_NAME_OUTBOUND_TCP = "BootstrapMessagingTCPChannel";
    public static final String CHANNEL_NAME_OUTBOUND_SSL = "BootstrapMessagingSSLChannel";
    public static final String CHANNEL_NAME_OUTBOUND_HTTP = "BootstrapMessagingHTTPChannel";
    public static final String CHANNEL_NAME_OUTBOUND_HTTPT = "BootstrapMessagingHTTPTChannel";
    public static final String CHANNEL_NAME_OUTBOUND_JFAP_TCPPROXY = "OutboundJFAPChannelTCPProxy";
    public static final String CHANNEL_NAME_OUTBOUND_TCPPROXY = "OutboundTCPProxyChannelTCP";
    public static final String CHANNEL_NAME_INBOUND_JFAP_TCPPROXY = "InboundJFAPChannelTCPProxy";
    public static final String CHANNEL_NAME_INBOUND_TCPPROXY = "InboundTCPProxyChannelTCP";
    public static final String CHAIN_NAME_TCPPROXYBRIDGESERVICE_INBOUND = "_InboundTCPProxyBridgeService";
    public static final String CHAIN_NAME_TCPPROXYBRIDGESERVICE_OUTBOUND = "_OutboundTCPProxyBridgeService";
    public static final String CLIENT_SSL_PROPERTIES_FILE = "sib.client.ssl.properties";
    public static final String CUSTOM_PROPERTY_TRUSTED = "trusted";
    public static final String CUSTOM_PROPERTY_TRUSTED_VALUE_TRUE = "true";
    public static final String CLASS_JFAP_CHANNEL_FACTORY = "com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory";
    public static final String CLASS_TCP_CHANNEL_FACTORY = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    public static final String CLASS_SSL_CHANNEL_FACTORY = "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory";
    public static final String CLASS_HTTPT_CHANNEL_FACTORY = "com.ibm.ws.httptunnel.channel.WSHttpTunnelOutboundChannelFactory";
    public static final String CLASS_HTTP_CHANNEL_FACTORY = "com.ibm.ws.http.channel.outbound.impl.WSHttpOutboundChannelFactory";
    public static final String CLASS_TCPPROXY_CHANNEL_FACTORY = "com.ibm.ws.tcpchannelproxy.jfap.impl.TCPProxyChannelFactory";
    private static final int SECONDS_PER_YEAR = 31536000;
    public static final int MIN_HEARTBEAT_INTERVAL = 0;
    public static final int MAX_HEARTBEAT_INTERVAL = 31536000;
    public static final int MIN_HEARTBEAT_TIMEOUT = 0;
    public static final int MAX_HEARTBEAT_TIMEOUT = 31536000;
    public static final String CHANNEL_CONFIG_HEARTBEAT_INTERVAL_PROPERTY = "com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY";
    public static final String CHANNEL_CONFIG_HEARTBEAT_TIMEOUT_PROPERTY = "com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY";
    public static final String RUNTIMEINFO_KEY_HEARTBEAT_INTERVAL = "com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL";
    public static final String RUNTIMEINFO_KEY_HEARTBEAT_TIMEOUT = "com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT";
    public static final String RUNTIMEINFO_KEY_CF_THREADPOOL_MIN = "com.ibm.ws.sib.jfapchannel.MIN_CF_THREADPOOL_SIZE";
    public static final String RUNTIMEINFO_KEY_CF_THREADPOOL_MAX = "com.ibm.ws.sib.jfapchannel.MAX_CF_THREADPOOL_SIZE";
    public static final String RUNTIMEINFO_KEY_MAX_PRIORITY_QUEUE_DEPTH = "com.ibm.ws.sib.jfapchannel.maxPriorityQueueDepth";
    public static final String RUNTIMEINFO_KEY_MAX_PRIORITY_QUEUE_BYTES = "com.ibm.ws.sib.jfapchannel.maxPriorityQueueBytes";
    public static final int SEGMENT_HEARTBEAT = 1;
    public static final int SEGMENT_HEARTBEAT_RESPONSE = 2;
    public static final int SEGMENT_SEGMENTED_FLOW_START = 3;
    public static final int SEGMENT_SEGMENTED_FLOW_MIDDLE = 4;
    public static final int SEGMENT_SEGMENTED_FLOW_END = 5;
    public static final int SEGMENT_LOGICAL_CLOSE = 10;
    public static final int SEGMENT_PING = 14;
    public static final int SEGMENT_PING_RESPONSE = 15;
    public static final int SEGMENT_PHYSICAL_CLOSE = 255;
    public static final int LOGICAL_CLOSE_IMMEDIATE_BIT = 1;
    public static final int PHYSICAL_CLOSE_IMMEDIATE_BIT = 1;
    public static final TransmissionLayout XMIT_LAYOUT_UNKNOWN = new TransmissionLayout("unknown");
    public static final TransmissionLayout XMIT_PRIMARY_ONLY = new TransmissionLayout("primary only");
    public static final TransmissionLayout XMIT_CONVERSATION = new TransmissionLayout("conversation");
    public static final TransmissionLayout XMIT_SEGMENT_START = new TransmissionLayout("segment start");
    public static final TransmissionLayout XMIT_SEGMENT_MIDDLE = new TransmissionLayout("segment middle");
    public static final TransmissionLayout XMIT_SEGMENT_END = new TransmissionLayout("segment end");
    public static final int SIZEOF_PRIMARY_HEADER = 10;
    public static final int SIZEOF_CONVERSATION_HEADER = 4;
    public static final int SIZEOF_SEGMENT_START_HEADER = 12;
    public static final int SIZEOF_EYECATCHER = 2;
    public static final byte[] EYECATCHER_AS_BYTES = new byte[]{-66, -17};
    public static final short EYECATCHER_AS_SHORT = -16657;
    public static final int MAX_PRIORITY_LEVELS = 16;
    public static final String JFAP_CHANNEL_ACCEPTOR_ID = "JFapChannelAcceptorID";
    public static final short FAP_VERSION_1 = 1;
    public static final short FAP_VERSION_2 = 2;
    public static final int SEG_HANDSHAKE = 6;
    public static final int SEG_USER_IDENTITY = 7;
    public static final int SEG_TOPOLOGY = 8;
    public static final int SEG_MESSAGE_FORMAT_INFO = 9;
    public static final int SEG_EXCEPTION = 11;
    public static final int SEG_DIRECT_CONNECT = 12;
    public static final int SEG_DIRECT_CONNECT_R = 13;
    public static final int SEG_XAOPEN = 48;
    public static final int SEG_XAOPEN_R = 176;
    public static final int SEG_XASTART = 49;
    public static final int SEG_XASTART_R = 177;
    public static final int SEG_XAEND = 50;
    public static final int SEG_XAEND_R = 178;
    public static final int SEG_XAPREPARE = 51;
    public static final int SEG_XAPREPARE_R = 179;
    public static final int SEG_XACOMMIT = 52;
    public static final int SEG_XACOMMIT_R = 180;
    public static final int SEG_XAROLLBACK = 53;
    public static final int SEG_XAROLLBACK_R = 181;
    public static final int SEG_XARECOVER = 54;
    public static final int SEG_XARECOVER_R = 182;
    public static final int SEG_XAFORGET = 55;
    public static final int SEG_XAFORGET_R = 183;
    public static final int SEG_XA_GETTXTIMEOUT = 56;
    public static final int SEG_XA_GETTXTIMEOUT_R = 184;
    public static final int SEG_XA_SETTXTIMEOUT = 57;
    public static final int SEG_XA_SETTXTIMEOUT_R = 185;
    public static final int SEG_CLOSE_CONNECTION = 64;
    public static final int SEG_CLOSE_CONNECTION_R = 192;
    public static final int SEG_CREATE_TEMP_DESTINATION = 65;
    public static final int SEG_CREATE_TEMP_DESTINATION_R = 193;
    public static final int SEG_DELETE_TEMP_DESTINATION = 66;
    public static final int SEG_DELETE_TEMP_DESTINATION_R = 194;
    public static final int SEG_CREATE_DURABLE_SUB = 67;
    public static final int SEG_CREATE_DURABLE_SUB_R = 195;
    public static final int SEG_DELETE_DURABLE_SUB = 68;
    public static final int SEG_DELETE_DURABLE_SUB_R = 196;
    public static final int SEG_SEND_CONN_MSG = 69;
    public static final int SEG_SEND_CONN_MSG_R = 197;
    public static final int SEG_SEND_CONN_MSG_NOREPLY = 70;
    public static final int SEG_RECEIVE_CONN_MSG = 71;
    public static final int SEG_RECEIVE_CONN_MSG_R = 199;
    public static final int SEG_CREATE_PRODUCER_SESS = 72;
    public static final int SEG_CREATE_PRODUCER_SESS_R = 200;
    public static final int SEG_CLOSE_CONSUMER_SESS = 73;
    public static final int SEG_CLOSE_CONSUMER_SESS_R = 201;
    public static final int SEG_CLOSE_PRODUCER_SESS = 74;
    public static final int SEG_CLOSE_PRODUCER_SESS_R = 202;
    public static final int SEG_SEND_SESS_MSG = 75;
    public static final int SEG_SEND_SESS_MSG_R = 203;
    public static final int SEG_SEND_SESS_MSG_NOREPLY = 76;
    public static final int SEG_CREATE_CONSUMER_SESS = 77;
    public static final int SEG_CREATE_CONSUMER_SESS_R = 205;
    public static final int SEG_RECEIVE_SESS_MSG = 78;
    public static final int SEG_RECEIVE_SESS_MSG_R = 206;
    public static final int SEG_REQUEST_MSGS = 79;
    public static final int SEG_CREATE_UCTRANSACTION = 80;
    public static final int SEG_COMMIT_TRANSACTION = 81;
    public static final int SEG_COMMIT_TRANSACTION_R = 209;
    public static final int SEG_ROLLBACK_TRANSACTION = 82;
    public static final int SEG_ROLLBACK_TRANSACTION_R = 210;
    public static final int SEG_REGISTER_ASYNC_CONSUMER = 83;
    public static final int SEG_REGISTER_ASYNC_CONSUMER_R = 211;
    public static final int SEG_DEREGISTER_ASYNC_CONSUMER = 84;
    public static final int SEG_DEREGISTER_ASYNC_CONSUMER_R = 212;
    public static final int SEG_START_SESS = 85;
    public static final int SEG_STOP_SESS = 86;
    public static final int SEG_STOP_SESS_R = 214;
    public static final int SEG_FLUSH_SESS = 87;
    public static final int SEG_FLUSH_SESS_R = 215;
    public static final int SEG_UNLOCK_ALL = 88;
    public static final int SEG_UNLOCK_ALL_R = 216;
    public static final int SEG_UNLOCK_SET_NOREPLY = 89;
    public static final int SEG_DELETE_SET_NOREPLY = 90;
    public static final int SEG_DELETE_SET = 91;
    public static final int SEG_DELETE_SET_R = 219;
    public static final int SEG_PROXY_MESSAGE = 220;
    public static final int SEG_ASYNC_MESSAGE = 221;
    public static final int SEG_BROWSE_MESSAGE = 222;
    public static final int SEG_CREATE_BROWSER_SESS = 95;
    public static final int SEG_CREATE_BROWSER_SESS_R = 223;
    public static final int SEG_RESET_BROWSE = 96;
    public static final int SEG_RESET_BROWSE_R = 224;
    public static final int SEG_EVENT_OCCURRED = 225;
    public static final int SEG_CONNECTION_INFO = 226;
    public static final int SEG_CREATE_CLONE_CONNECTION = 99;
    public static final int SEG_CREATE_CLONE_CONNECTION_R = 227;
    public static final int SEG_GET_UNIQUE_ID = 100;
    public static final int SEG_GET_UNIQUE_ID_R = 228;
    public static final int SEG_GET_DESTINATION_CONFIGURATION = 101;
    public static final int SEG_GET_DESTINATION_CONFIGURATION_R = 229;
    public static final int SEG_SEND_SCHEMA_NOREPLY = 230;
    public static final int SEG_CREATE_CONS_FOR_DURABLE_SUB = 102;
    public static final int SEG_CREATE_CONS_FOR_DURABLE_SUB_R = 231;
    public static final int SEG_CREATE_BIFURCATED_SESSION = 103;
    public static final int SEG_CREATE_BIFURCATED_SESSION_R = 232;
    public static final int SEG_UNLOCK_SET = 104;
    public static final int SEG_UNLOCK_SET_R = 233;
    public static final int SEG_READ_SET = 105;
    public static final int SEG_READ_SET_R = 234;
    public static final int SEG_READ_AND_DELETE_SET = 106;
    public static final int SEG_READ_AND_DELETE_SET_R = 235;
    public static final int SEG_CREATE_ORDER_CONTEXT = 107;
    public static final int SEG_CREATE_ORDER_CONTEXT_R = 236;
    public static final int SEG_SEND_TO_EXCEPTION_DESTINATION = 108;
    public static final int SEG_SEND_TO_EXCEPTION_DESTINATION_R = 237;
    public static final int SEG_CLOSE_ORDER_CONTEXT = 109;
    public static final int SEG_CLOSE_ORDER_CONTEXT_R = 238;
    public static final int SEG_REQUEST_SCHEMA = 110;
    public static final int SEG_REQUEST_SCHEMA_R = 240;
    public static final int SEG_MULTICAST_MESSAGE = 241;
    public static final int SEG_CHECK_MESSAGING_REQUIRED = 111;
    public static final int SEG_CHECK_MESSAGING_REQUIRED_R = 242;
    public static final short PRIORITY_HIGH = 11;
    public static final short PRIORITY_MEDIUM = 7;
    public static final short PRIORITY_LOW = 2;
    public static final short PRIORITY_HIGHEST = 12;
    public static final short PRIORITY_LOWEST = -1;
    public static final short PRIORITY_HANDSHAKE = 7;
    public static final String CLNTCONNMGR_STATICCONS_01 = "00000001";
    public static final String CLNTCONNMGR_INITIALISE_01 = "00000002";
    public static final String SRVRCONNMGR_INITIALISE_01 = "00010001";
    public static final String SRVRCONNMGR_STATICCONS_01 = "00010002";
    public static final String CHFWREF_LOOKUPFROMSERVICESNAMESPACE_01 = "00020001";
    public static final String CHFWREF_FINDINSTANDALONE_01 = "00020002";
    public static final String CHFWREF_LOADSSLPROPERTIES_01 = "00020003";
    public static final String CHFWREF_CREATE_OUTBOUND_CHAINS_01 = "00020004";
    public static final String CHFWREF_CREATE_OUTBOUND_CHAINS_02 = "00020005";
    public static final String CHFWREF_CREATE_OUTBOUND_CHAINS_03 = "00020006";
    public static final String CHFWREF_CREATE_OUTBOUND_CHAINS_04 = "00020007";
    public static final String CHFWREF_GETCLASSFORNAME_01 = "00020008";
    public static final String CHFWREF_FINDCLIENTCONT_01 = "00020009";
    public static final String CHFWREF_FINDCLIENTCONT_02 = "00020010";
    public static final String CHFWREF_CREATE_OUTBOUND_CHAINS_05 = "00020011";
    public static final String CHFWREF_FINDORCREATE_THREADPOOL_01 = "00020012";
    public static final String CHFWREF_DEF_OUTBOUND_BRIDGE_01 = "00020013";
    public static final String CHFWREF_DEF_INBOUND_BRIDGE_01 = "00020014";
    public static final String CHFWREF_ZOSSTARTUPRUNNABLE_01 = "00020015";
    public static final String CHFWREF_PERFORMCRASTARTUP = "00020016";
    public static final String CLNTCONNMGRIMPL_INITIALISE_01 = "00030001";
    public static final String CLNTCONNMGRIMPL_INITIALISE_02 = "00030002";
    public static final String CLNTCONNMGRIMPL_INITIALISE_03 = "00030003";
    public static final String CONNECTION_PHYSICALCLOSE_01 = "00040001";
    public static final String CONNECTION_PROCESSHEARTBEAT_01 = "00040002";
    public static final String CONNECTION_PROCESSHEARTBEAT_02 = "00040003";
    public static final String CONNECTION_PHYSICALCLOSE_02 = "00040004";
    public static final String CONNECTION_INVALIDATE_01 = "00040005";
    public static final String CONNREADCOMPCALLBACK_INVOKECALLBACK_01 = "00050001";
    public static final String CONNREADCOMPCALLBACK_INVOKECALLBACK_02 = "00050002";
    public static final String CONNREADCOMPCALLBACK_INVOKECALLBACK_03 = "00050003";
    public static final String CONNREADCOMPCALLBACK_INVOKECALLBACK_04 = "00050004";
    public static final String CONNREADCOMPCALLBACK_ERROR_02 = "00050006";
    public static final String CONNREADCOMPCALLBACK_ERROR_03 = "00050007";
    public static final String CONNREADCOMPCALLBACK_ERROR_04 = "00050008";
    public static final String CONNREADCOMPCALLBACK_PROCESSLOGICALCLOSE_01 = "00050009";
    public static final String CONNREADCOMPCALLBACK_PROCESSLOGICALCLOSE_02 = "00050010";
    public static final String CONNREADCOMPCALLBACK_PROCESSLOGICALCLOSE_03 = "00050011";
    public static final String CONNREADCOMPCALLBACK_PROCESSLOGICALCLOSE_04 = "00050012";
    public static final String CONNWRITECOMPCALLBACK_PRODDLE_01 = "00060001";
    public static final String CONNWRITECOMPCALLBACK_COMPLETE_01 = "00060002";
    public static final String CONNWRITECOMPCALLBACK_COMPLETE_02 = "00060003";
    public static final String CONVIMPL_CLOSE_01 = "00070001";
    public static final String CONVIMPL_CLOSE_02 = "00070002";
    public static final String CONVIMPL_WAKEUPALLWITHEXCP_01 = "00070003";
    public static final String CONVIMPL_WAKEUPALLWITHEXCP_02 = "00070004";
    public static final String CONVIMPL_WAKEUPALLWITHEXCP_03 = "00070005";
    public static final String CONVIMPL_PROCESSLOGICALCLOSE_01 = "00070006";
    public static final String CONVIMPL_PROCESSLOGICALCLOSE_02 = "00070007";
    public static final String CONVIMPL_PROCESSLOGICALCLOSE_03 = "00070008";
    public static final String CONVIMPL_PROCESSLOGICALCLOSE_04 = "00070009";
    public static final String CONVIMPL_PROCESSPING_01 = "00070010";
    public static final String CONVIMPL_PROCESSPING_02 = "00070011";
    public static final String CONVIMPL_PROCESSLOGICALREQUEST_01 = "00070012";
    public static final String CONVIMPL_PROCESSLOGICALRESPONSE_01 = "00070013";
    public static final String JFAPCHANNELFACT_GETDEVINTERFACE_01 = "00080001";
    public static final String JFAPINBOUNDCONNLINK_READY_01 = "00090001";
    public static final String JFAPINBOUNDCONNLINK_READY_02 = "00090002";
    public static final String JFAPINBOUNDCONNLINK_INIT_01 = "00090003";
    public static final String LISTENERPORTIMPL_CLOSE_01 = "00100001";
    public static final String LISTENERPORTIMPL_CLOSE_02 = "00100002";
    public static final String OUTBOUNDCONNTRACKER_ESTSOCKCONN_01 = "00110001";
    public static final String OUTBOUNDCONNTRACKER_ESTSOCKCONN_02 = "00110002";
    public static final String SRVRCONNMGRIMPL_LISTEN_01 = "00120001";
    public static final String SRVRCONNMGRIMPL_LISTEN_02 = "00120002";
    public static final String SRVRCONNMGRIMPL_LISTEN_03 = "00120003";
    public static final String SRVRCONNMGRIMPL_INITIALISE_01 = "00120004";
    public static final String SRVRCONNMGRIMPL_INITIALISE_02 = "00120005";
    public static final String SRVRCONNMGRIMPL_INITIALISE_03 = "00120006";
    public static final String SRVRCONNMGRIMPL_INITIALISE_04 = "00120007";
    public static final String CRLDATARECEIVEDINVOKE_INVOKE_01 = "00130001";
    public static final String CRLDATARECEIVEDINVOKE_GETTHREADCONTEXT_01 = "00130002";
    public static final String CRLERROROCCURREDINVOKE_INVOKE_01 = "00140001";
    public static final String RLDATARECEIVEDINVOKE_INVOKE_01 = "00150001";
    public static final String RLERROROCCURREDINVOKE_INVOKE_01 = "00160001";
    public static final String INBOUNDXMITPARSER_PARSE_01 = "00170001";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_01 = "00170002";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_02 = "00170003";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_03 = "00170004";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_04 = "00170005";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_05 = "00170006";
    public static final String INBOUNDXMITPARSER_PARSEPRIMHDR_06 = "00170007";
    public static final String INBOUNDXMITPARSER_PARSECONVHDR_01 = "00170008";
    public static final String INBOUNDXMITPARSER_PARSECONVHDR_02 = "00170009";
    public static final String INBOUNDXMITPARSER_PARSECONVHDR_03 = "00170010";
    public static final String INBOUNDXMITPARSER_PARSESSHDR_01 = "00170011";
    public static final String INBOUNDXMITPARSER_PARSESSPAYLOAD_01 = "00170012";
    public static final String INBOUNDXMITPARSER_PARSESMPAYLOAD_01 = "00170013";
    public static final String INBOUNDXMITPARSER_PARSESMPAYLOAD_02 = "00170014";
    public static final String INBOUNDXMITPARSER_PARSESEPAYLOAD_01 = "00170015";
    public static final String INBOUNDXMITPARSER_PARSESEPAYLOAD_02 = "00170016";
    public static final String INBOUNDXMITPARSER_DISPCONV_01 = "00170017";
    public static final String INBOUNDXMITPARSER_DISPCONV_02 = "00170018";
    public static final String INBOUNDXMITPARSER_DISPCONV_03 = "00170019";
    public static final String INBOUNDXMITPARSER_DISPCONVLST_01 = "00170020";
    public static final String INBOUNDXMITPARSER_DISPCONVLST_02 = "00170020";
    public static final String BUFFERPOOLMGRREF_CREATEINTHINCLIENT_01 = "00180001";
    public static final String BUFFERPOOLMGRREF_FINDCLIENTCONT_01 = "00180002";
    public static final String BUFFERPOOLMGRREF_FINDCLIENTCONT_02 = "00180003";
    public static final String NONTSDISPATCHABLE_STINIT_01 = "00190001";
    public static final String JFAPOUTBOUNDCONNLINK_INIT_01 = "00200001";
    public static final String DISPATCHTOALLNONEMPTY_STINIT_01 = "00210001";
    public static final String DISPATCHRUNNABLE_RUN_01 = "00210002";
    public static final String RLDISPATCHER_QUEUEINVOCCOMMON_01 = "00220001";
    public static final String RLDISPATCHQUEUE_RUN_01 = "00230001";
    public static final String CONNDATAGROUP_CONNECT_01 = "00240001";
    public static final String CONNDATAGROUP_CONNECT_02 = "00240002";
    public static final String CONNDATAGROUP_CONNECT_03 = "00240003";
    public static final String CONNDATAGROUP_CONNECT_04 = "00240004";
    public static final String CONNDATAGROUP_CONNECT_05 = "00240004";
    public static final String CONNDATAGROUP_CONNECT_06 = "00240004";
    public static final String CONNDATAGROUP_CONNECT_07 = "00240004";

    public static boolean isReservedSegmentId(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 255: {
                bl = true;
            }
        }
        return bl;
    }

    public static TransmissionLayout segmentToLayout(int n) {
        TransmissionLayout transmissionLayout = XMIT_LAYOUT_UNKNOWN;
        switch (n) {
            case 0: {
                transmissionLayout = XMIT_LAYOUT_UNKNOWN;
                break;
            }
            case 1: 
            case 2: 
            case 255: {
                transmissionLayout = XMIT_PRIMARY_ONLY;
                break;
            }
            case 3: {
                transmissionLayout = XMIT_SEGMENT_START;
                break;
            }
            case 4: {
                transmissionLayout = XMIT_SEGMENT_MIDDLE;
                break;
            }
            case 5: {
                transmissionLayout = XMIT_SEGMENT_END;
                break;
            }
            default: {
                transmissionLayout = XMIT_CONVERSATION;
            }
        }
        return transmissionLayout;
    }

    public static short getJFAPPriority(Integer n) {
        short s = (short)(n + 2);
        if (s > 11) {
            return 11;
        }
        if (s < 2) {
            return 2;
        }
        return s;
    }

    public static String getSegmentName(int n) {
        String string = "(Unknown segment type)";
        try {
            Class clazz = JFapChannelConstants.class;
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    int n2 = fieldArray[i].getInt(null);
                    if (n2 != n || !fieldArray[i].getName().startsWith("SEG_")) continue;
                    string = fieldArray[i].getName();
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static class TransmissionLayout {
        private static int globalTranmissionLayoutEnumCounter = 0;
        private String layoutName;
        private int enumValue;

        private TransmissionLayout(String string) {
            this.layoutName = string;
            this.enumValue = globalTranmissionLayoutEnumCounter++;
        }

        public String toString() {
            return this.getClass() + "@" + System.identityHashCode(this) + ":" + this.layoutName;
        }

        public int enumeratedValue() {
            return this.enumValue;
        }
    }
}

