/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.mesupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ComponentData;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionFactory;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.comms.server.mesupport.MEConnectionImpl;
import com.ibm.ws.sib.jfapchannel.CapacityListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.trm.TrmSingleton;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.List;

public class METransportReceiveListener
implements ConversationReceiveListener,
CapacityListener {
    private static String CLASS_NAME = METransportReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(METransportReceiveListener.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private MEConnectionListener ioListener = null;
    private MEConnection meConn = null;
    private WsByteBufferPoolManager bbPoolManager = null;

    public METransportReceiveListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dataReceived");
        }
        if (tc.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new String("Segment type  : " + JFapChannelConstants.getSegmentName(n) + " - " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3), new String("Exchange?     : " + bl2)};
            SibTr.debug(tc, "Data information:", objectArray);
        }
        try {
            try {
                switch (n) {
                    case 6: {
                        this.rcvHandshake(wsByteBuffer, conversation, n2, bl);
                        break;
                    }
                    case 8: {
                        this.rcvTRMExchange(wsByteBuffer, conversation, n2, bl);
                        break;
                    }
                    case 9: {
                        this.rcvMFPExchange(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 230: {
                        this.rcvMFPSchema(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 75: {
                        this.rcvMessage(wsByteBuffer, conversation, n2, bl);
                        break;
                    }
                    case 64: {
                        this.rcvCloseConnection(wsByteBuffer, conversation, n2, bl);
                        break;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Received unexpected segment type", (Object)JFapChannelConstants.getSegmentName(n));
                        }
                        try {
                            conversation.close();
                            break;
                        }
                        catch (SIConnectionLostException sIConnectionLostException) {
                            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".dataReceived"), (String)"4-002-0017", (Object)this);
                            if (!tc.isDebugEnabled()) break;
                            SibTr.debug(tc, "Failed to close the connection", sIConnectionLostException);
                        }
                    }
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".dataReceived"), (String)"4-002-0004", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught an exception:", throwable);
                }
                if (bl2) {
                    StaticCATHelper.sendExceptionToClient(throwable, "4-002-0004", conversation, n2);
                }
                Object var10_12 = null;
                if (!tc.isEntryEnabled()) return null;
                SibTr.exit(tc, "dataReceived");
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "dataReceived");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return null;
        SibTr.exit(tc, "dataReceived");
        return null;
    }

    public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "errorOccurred");
        }
        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"4-002-0006", (Object)this);
        if (tc.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new String("Segment type  : " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3)};
            SibTr.debug(tc, "Received an error in the METransportReceiveListener", objectArray);
            SibTr.debug(tc, "Primary exception:");
            SibTr.exception(tc, sIConnectionLostException);
        }
        this.ioListener.error(this.meConn, sIConnectionLostException);
        CommsPMI.getMEStats().onApiDisconnect();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "errorOccurred");
        }
    }

    private void rcvCloseConnection(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCloseConnection", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        boolean bl2 = true;
        if (this.meConn == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "The MEConnection is null - nothing to close");
            }
            bl2 = false;
        } else {
            MEConnectionImpl mEConnectionImpl = (MEConnectionImpl)this.meConn;
            if (mEConnectionImpl.getCloseState() == 4) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Connection already closed");
                }
                bl2 = false;
            } else {
                if (mEConnectionImpl.getCloseState() == 2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "We are already in the middle of a close");
                    }
                    mEConnectionImpl.setCloseState(3);
                } else if (mEConnectionImpl.getCloseState() == 3) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("ALREADY_IN_PARALLEL_CLOSE_SICO2049", null, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"4-002-0013", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "We are already in a parallel close!");
                    }
                    throw sIErrorException;
                }
                SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("REMOTE_ME_CLOSED_CONNECTION_SICO2030", new Object[]{this.meConn.getConnectionInfo()}, null));
                if (this.ioListener != null) {
                    this.ioListener.error(this.meConn, sIConnectionLostException);
                }
                CommsPMI.getMEStats().onApiDisconnect();
            }
        }
        if (bl2) {
            try {
                conversation.send(list, 192, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"4-002-0012", (Object)this);
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2016", sIException);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCloseConnection");
        }
    }

    private void rcvHandshake(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvHandshake", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
        wsByteBuffer.flip();
        WsByteBuffer wsByteBuffer2 = this.bbPoolManager.allocate(1);
        wsByteBuffer2.put(wsByteBuffer.get());
        wsByteBuffer2.flip();
        list.add(wsByteBuffer2);
        boolean bl2 = true;
        boolean bl3 = false;
        block10: while (wsByteBuffer.hasRemaining() && bl2) {
            short s;
            short s2 = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "fieldId", new Short(s2));
            }
            switch (s2) {
                case 1: {
                    short s3 = wsByteBuffer.getShort();
                    if (s3 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s3));
                        }
                        this.rejectHandshake(conversation, n, "ProductVersion length");
                        bl2 = false;
                        continue block10;
                    }
                    byte by = wsByteBuffer.get();
                    byte by2 = wsByteBuffer.get();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "ProductVersion", new Object[]{new Byte(by), new Byte(by2)});
                    }
                    cATHandshakeProperties.setMajorVersion(by);
                    cATHandshakeProperties.setMinorVersion(by2);
                    continue block10;
                }
                case 2: {
                    byte by = wsByteBuffer.getShort();
                    if (by != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(by));
                        }
                        this.rejectHandshake(conversation, n, "FAPLevel length");
                        bl2 = false;
                        continue block10;
                    }
                    byte by2 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "FAPLevel", new Object[]{new Short(by2)});
                    }
                    bl3 = true;
                    if (by2 > 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Informing client of negotiatied value:", new Short(2));
                        }
                        WsByteBuffer wsByteBuffer3 = this.bbPoolManager.allocate(6);
                        wsByteBuffer3.putShort((short)2);
                        wsByteBuffer3.putShort((short)2);
                        wsByteBuffer3.putShort((short)2);
                        wsByteBuffer3.flip();
                        list.add(wsByteBuffer3);
                        cATHandshakeProperties.setFapLevel((short)2);
                        continue block10;
                    }
                    cATHandshakeProperties.setFapLevel(by2);
                    continue block10;
                }
                case 3: {
                    byte by2 = wsByteBuffer.getShort();
                    if (by2 != 8) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(by2));
                        }
                        this.rejectHandshake(conversation, n, "MaxMessageSize length");
                        bl2 = false;
                        continue block10;
                    }
                    long l = wsByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "MessageSize", new Object[]{new Long(l)});
                    }
                    cATHandshakeProperties.setMaxMessageSize(l);
                    continue block10;
                }
                case 4: {
                    short s4 = wsByteBuffer.getShort();
                    if (s4 != 4) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s4));
                        }
                        this.rejectHandshake(conversation, n, "MaxTransmissionSize length");
                        bl2 = false;
                        continue block10;
                    }
                    short s5 = wsByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "TransmissionSize", new Object[]{new Integer(s5)});
                    }
                    cATHandshakeProperties.setMaxTransmissionSize(s5);
                    continue block10;
                }
                case 5: {
                    WsByteBuffer wsByteBuffer4;
                    short s5 = wsByteBuffer.getShort();
                    if (s5 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s5));
                        }
                        this.rejectHandshake(conversation, n, "HeartbeatInterval length");
                        bl2 = false;
                        continue block10;
                    }
                    short s6 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Received HeartbeatInterval", new Object[]{new Short(s6)});
                    }
                    if ((s = (short)Math.max(conversation.getHeartbeatInterval(), s6)) > s6) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Informing client of negotiatied value:", new Short(s));
                        }
                        wsByteBuffer4 = this.bbPoolManager.allocate(6);
                        wsByteBuffer4.putShort((short)5);
                        wsByteBuffer4.putShort((short)2);
                        wsByteBuffer4.putShort(s);
                        wsByteBuffer4.flip();
                        list.add(wsByteBuffer4);
                    } else {
                        conversation.setHeartbeatInterval(s);
                    }
                    cATHandshakeProperties.setHeartbeatInterval(s);
                    continue block10;
                }
                case 7: {
                    WsByteBuffer wsByteBuffer4;
                    short s6 = wsByteBuffer.getShort();
                    if (s6 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s6));
                        }
                        this.rejectHandshake(conversation, n, "Capability length");
                        bl2 = false;
                        continue block10;
                    }
                    s = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Capability", new Object[]{new Short(s)});
                    }
                    if ((s & 0xFFFFFFC0) != 0) {
                        s = (short)(s & 0x3F);
                        wsByteBuffer4 = this.bbPoolManager.allocate(6);
                        wsByteBuffer4.putShort((short)7);
                        wsByteBuffer4.putShort((short)2);
                        wsByteBuffer4.putShort(s);
                        wsByteBuffer4.flip();
                        list.add(wsByteBuffer4);
                    }
                    cATHandshakeProperties.setCapabilites(s);
                    continue block10;
                }
            }
            s = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Ignoring field ID: ", new Short(s2));
                SibTr.debug(tc, "Skipping " + s + " bytes");
            }
            wsByteBuffer.position(wsByteBuffer.position() + s);
        }
        if (bl2) {
            if (!bl3) {
                this.rejectHandshake(conversation, n, "FAPLevel");
            } else {
                try {
                    conversation.send(list, 6, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvHandshake"), (String)"4-002-0007", (Object)this);
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2016", sIException);
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvHandshake");
        }
    }

    private void rejectHandshake(Conversation conversation, int n, String string) {
        SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("INVALID_PROP_SICO8010", null, null));
        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".rejectHandshake"), (String)"4-002-0010", (Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Invalid handshake type received - rejecting field:", (Object)string);
        }
        StaticCATHelper.sendExceptionToClient(sIConnectionLostException, "4-002-0010", conversation, n);
        this.closeConnection();
    }

    private void rcvTRMExchange(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl) {
        List list;
        ConversationState conversationState;
        block14: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "rcvTRMExchange", new Object[]{wsByteBuffer, conversation, "" + n});
            }
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            TrmSingleton trmSingleton = TrmSingleton.getTrmSingleton();
            ComponentData componentData = (ComponentData)trmSingleton.getComponentData();
            if (this.meConn == null) {
                this.meConn = MEConnectionFactory.getReference().createMEConnection();
                ((MEConnectionImpl)this.meConn).inboundSetup(conversation);
                CommsPMI.getMEStats().onApiConnect();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "New inbound MEConnection created", new Object[]{this.meConn});
                }
            }
            try {
                conversationState.addObject(this.meConn);
                wsByteBuffer.flip();
                byte[] byArray = new byte[wsByteBuffer.remaining()];
                System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
                byte[] byArray2 = componentData.handShake(this.meConn, byArray);
                JsMessagingEngine jsMessagingEngine = this.meConn.getMessagingEngine();
                if (jsMessagingEngine != null) {
                    JsEngineComponent jsEngineComponent = jsMessagingEngine.getMessageProcessor();
                    SIMPFactory sIMPFactory = (SIMPFactory)jsEngineComponent;
                    this.ioListener = sIMPFactory.getMEConnectionListener();
                    if (this.ioListener == null) {
                        SIErrorException sIErrorException = new SIErrorException();
                        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".outBoundSetup"), (String)"4-002-0014", (Object[])new Object[]{this, sIMPFactory});
                        throw sIErrorException;
                    }
                }
                if (byArray2.length == 0) {
                    this.closeConnection();
                }
                list.add(this.bbPoolManager.wrap(byArray2));
                try {
                    conversation.send(list, 8, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"4-002-0002", (Object)this);
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2016", sIException);
                }
            }
            catch (ObjectStoreFullException objectStoreFullException) {
                FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"4-002-0003", (Object)this);
                if (!tc.isDebugEnabled()) break block14;
                SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (this.ioListener != null) {
            conversation.setCapacityListener(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvTRMExchange");
        }
    }

    private void rcvMFPExchange(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvMFPExchange", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        CompHandshake compHandshake = null;
        this.meConn = MEConnectionFactory.getReference().createMEConnection();
        ((MEConnectionImpl)this.meConn).inboundSetup(conversation);
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        conversationState.setCommsConnection(this.meConn);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "New inbound MEConnection created", new Object[]{this.meConn});
        }
        try {
            compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
            wsByteBuffer.flip();
            byte[] byArray = new byte[wsByteBuffer.remaining()];
            System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
            short s = cATHandshakeProperties.getMajorVersion();
            byte[] byArray2 = compHandshake.compHandshakeData(this.meConn, s, byArray);
            if (byArray2.length == 0) {
                this.closeConnection();
            }
            list.add(this.bbPoolManager.wrap(byArray2));
            try {
                conversation.send(list, 9, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0018", (Object)this);
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2016", sIException);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0017", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
            StaticCATHelper.sendExceptionToClient(exception, "3-004-0017", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMFPExchange");
        }
    }

    private void rcvMFPSchema(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        List list;
        ConversationState conversationState;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "rcvMFPSchema", new Object[]{wsByteBuffer, conversation, "" + n});
            }
            CompHandshake compHandshake = null;
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            CommsConnection commsConnection = conversationState.getCommsConnection();
            try {
                compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                wsByteBuffer.flip();
                byte[] byArray = new byte[wsByteBuffer.remaining()];
                System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
                LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
                short s = cATHandshakeProperties.getMajorVersion();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Passing schema to MFP with:", new Object[]{commsConnection, "" + s});
                }
                compHandshake.compData(commsConnection, s, byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMFPSchema"), (String)"3-004-0019", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMFPSchema");
        }
    }

    private void rcvMessage(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl) {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvMessage", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        wsByteBuffer.flip();
        JsMessage jsMessage = null;
        ControlMessage controlMessage = null;
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        boolean bl3 = bl2 = wsByteBuffer.get() == 1;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "connectionObjectId", new Short(s));
            SibTr.debug(tc, "messageLength", new Integer(n2));
            SibTr.debug(tc, "controlMessage", (Object)("" + bl2));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Inbound JsMessage about to be decoded");
        }
        try {
            Integer n3;
            if (bl2) {
                if (wsByteBuffer.hasArray()) {
                    controlMessage = ControlMessageFactory.getInstance().createInboundControlMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n2);
                } else {
                    byte[] byArray = new byte[n2];
                    wsByteBuffer.get(byArray);
                    controlMessage = ControlMessageFactory.getInstance().createInboundControlMessage(byArray, 0, n2);
                }
                n3 = controlMessage.getPriority();
            } else {
                if (wsByteBuffer.hasArray()) {
                    jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n2);
                } else {
                    byte[] byArray = new byte[n2];
                    wsByteBuffer.get(byArray);
                    jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(byArray, 0, n2);
                }
                n3 = jsMessage.getPriority();
            }
            CommsPMI.getMEStats().onReadMessage(n2);
            CommsPMI.getMEDetailedStats().onReceiveMessage(JFapChannelConstants.getJFAPPriority(n3));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Inbound JsMessage decoded and ready for the MEConnectionListener");
            }
            if (bl2) {
                this.ioListener.receiveMessage(this.meConn, controlMessage);
            } else {
                this.ioListener.receiveMessage(this.meConn, jsMessage);
            }
        }
        catch (MessageDecodeFailedException messageDecodeFailedException) {
            FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)(CLASS_NAME + ".rcvMessage"), (String)"4-002-0008", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to Decode inbound JsMessage");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception(tc, messageDecodeFailedException);
            }
            this.ioListener.error(this.meConn, messageDecodeFailedException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMessage"), (String)"4-002-0009", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "General exception caught whilst decoding inbound JsMessage");
            }
            this.ioListener.error(this.meConn, exception);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMessage");
        }
    }

    public void capacityChange() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "capacityChange");
        }
        this.ioListener.capacityChange(this.meConn);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "capacityChange");
        }
    }

    public void registerCapacityChangeListener(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "registerCapacityChangeListener");
        }
        conversation.setCapacityListener(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "registerCapacityChangeListener");
        }
    }

    public void outBoundSetup(MEConnection mEConnection, JsMessagingEngine jsMessagingEngine) {
        JsEngineComponent jsEngineComponent;
        SIMPFactory sIMPFactory;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "outBoundSetup", new Object[]{mEConnection, jsMessagingEngine});
        }
        if ((sIMPFactory = (SIMPFactory)(jsEngineComponent = jsMessagingEngine.getMessageProcessor())) != null) {
            this.ioListener = sIMPFactory.getMEConnectionListener();
            if (this.ioListener == null) {
                SIErrorException sIErrorException = new SIErrorException();
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".outBoundSetup"), (String)"4-002-0015", (Object[])new Object[]{this, sIMPFactory});
                throw sIErrorException;
            }
        } else {
            SIErrorException sIErrorException = new SIErrorException();
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".outBoundSetup"), (String)"4-002-0016", (Object)this);
            throw sIErrorException;
        }
        this.meConn = mEConnection;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "outBoundSetup");
        }
    }

    private void closeConnection() {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "closeConnection");
            }
            try {
                this.meConn.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".closeConnection"), (String)"4-002-0002", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "closeConnection");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getThreadContext");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getThreadContext", null);
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/mesupport/METransportReceiveListener.java, SIB.comms, WAS602.SIB, o0610.11 1.59");
        }
    }
}

