/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.List;

public class StaticCATTransaction {
    private static String CLASS_NAME = StaticCATTransaction.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATTransaction.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateUCTransaction(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateUCTransaction", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", new Short(s));
            SibTr.debug(tc, "Client transaction Id:", new Integer(n2));
        }
        CATConnection cATConnection = (CATConnection)conversationState.getObject(s);
        SICoreConnection sICoreConnection = cATConnection.getSICoreConnection();
        CATTransaction cATTransaction = null;
        try {
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            linkLevelState.getTransactionTable().addLocalTran(n2, cATConnection, sICoreConnection.createUncoordinatedTransaction());
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateUCTransaction"), (String)"3-009-0001");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to create the transaction", sIException);
            }
            cATTransaction.markAsError(sIException);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateUCTransaction");
        }
    }

    static void rcvCommitTransaction(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCommitTransaction", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", new Short(s));
            SibTr.debug(tc, "Client transaction Id:", new Integer(n2));
        }
        try {
            SIUncoordinatedTransaction sIUncoordinatedTransaction;
            CATTransaction cATTransaction;
            LinkLevelState linkLevelState;
            block18: {
                CATConnection cATConnection = (CATConnection)conversationState.getObject(s);
                linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                cATTransaction = linkLevelState.getTransactionTable().get(n2);
                sIUncoordinatedTransaction = null;
                try {
                    sIUncoordinatedTransaction = (SIUncoordinatedTransaction)cATTransaction.getSITransaction();
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    if (cATTransaction.isMarkedAsError()) break block18;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Transaction was null - but not marked as error??", sIIncorrectCallException);
                    }
                    cATTransaction.markAsError(sIIncorrectCallException);
                }
            }
            linkLevelState.getTransactionTable().removeLocalTran(n2);
            if (cATTransaction.isMarkedAsError()) {
                if (sIUncoordinatedTransaction != null) {
                    sIUncoordinatedTransaction.rollback();
                }
                SIRollbackException sIRollbackException = new SIRollbackException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2008", new Object[]{cATTransaction.getFirstException()}, null), cATTransaction.getFirstException());
                StaticCATHelper.sendExceptionToClient(sIRollbackException, null, conversation, n);
            } else {
                sIUncoordinatedTransaction.commit();
                try {
                    conversation.send(list, 209, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCommitTransaction"), (String)"3-009-0006");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2026", sIException);
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCommitTransaction"), (String)"3-009-0007");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-009-0007", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCommitTransaction");
        }
    }

    static void rcvRollbackTransaction(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvRollbackTransaction", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", new Short(s));
            SibTr.debug(tc, "Client transaction Id:", new Integer(n2));
        }
        try {
            SIUncoordinatedTransaction sIUncoordinatedTransaction;
            LinkLevelState linkLevelState;
            block15: {
                CATConnection cATConnection = (CATConnection)conversationState.getObject(s);
                linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2);
                sIUncoordinatedTransaction = null;
                try {
                    sIUncoordinatedTransaction = (SIUncoordinatedTransaction)cATTransaction.getSITransaction();
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    if (!tc.isDebugEnabled()) break block15;
                    SibTr.debug(tc, "Looks like the transaction failed to create", sIIncorrectCallException);
                }
            }
            linkLevelState.getTransactionTable().removeLocalTran(n2);
            if (sIUncoordinatedTransaction != null) {
                sIUncoordinatedTransaction.rollback();
            }
            try {
                conversation.send(list, 210, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvRollbackTransaction"), (String)"3-009-0008");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2026", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvRollbackTransaction"), (String)"3-009-0009");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-009-0009", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvRollbackTransaction");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATTransaction.java, SIB.comms, WAS602.SIB, o0610.11 1.34");
        }
    }
}

