/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.List;

public class StaticCATProducer {
    private static String CLASS_NAME = StaticCATProducer.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATProducer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateProducerSess(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateProducerSess", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        CommsString commsString = conversationState.getCommsString();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        short s3 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ConnectionObjectID", new Short(s));
            SibTr.debug(tc, "MessageOrderId", new Short(s2));
            SibTr.debug(tc, "DestinationType", new Integer(s3));
        }
        DestinationType destinationType = null;
        if (s3 != -1) {
            destinationType = DestinationType.getDestinationType(s3);
        }
        try {
            SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
            short s4 = wsByteBuffer.getShort();
            byte[] byArray = new byte[s4];
            wsByteBuffer.get(byArray);
            commsString.setBytes(byArray);
            short s5 = wsByteBuffer.getShort();
            byte[] byArray2 = new byte[s5];
            wsByteBuffer.get(byArray2);
            CommsString commsString2 = new CommsString();
            commsString2.setBytes(byArray2);
            String string = commsString2.getString();
            SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
            OrderingContext orderingContext = null;
            if (s2 != 0) {
                orderingContext = ((CATOrderingContext)conversationState.getObject(s2)).getOrderingContext();
            }
            ProducerSession producerSession = sICoreConnection.createProducerSession(sIDestinationAddress, commsString.getString(), destinationType, orderingContext, string);
            short s6 = (short)conversationState.addObject(producerSession);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Producer Session Id:", new Short(s6));
            }
            StaticCATHelper.sendSessionCreateResponse(200, n, conversation, s6, producerSession, sIDestinationAddress);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateProducerSess"), (String)"3-008-0001");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-008-0001", conversation, n);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvCreateProducerSess"), (String)"3-008-0002");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
            }
            StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-008-0002", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateProducerSess");
        }
    }

    static void rcvCloseProducerSess(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCloseProducerSess", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "connectionObjectID", new Short(s));
            SibTr.debug(tc, "producerObjectID", new Short(s2));
        }
        ProducerSession producerSession = (ProducerSession)conversationState.getObject(s2);
        try {
            producerSession.close();
            conversationState.removeObject(s2);
            try {
                conversation.send(list, 202, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseProducerSess"), (String)"3-008-0003");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2024", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseProducerSess"), (String)"3-008-0004");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-008-0004", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCloseProducerSess");
        }
    }

    static void rcvSendSessMsg(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendSessMsg");
        }
        StaticCATProducer.sendSessMsg(wsByteBuffer, conversation, n, bl2, bl, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvSendSessMsg");
        }
    }

    static void rcvSendSessMsgNoReply(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendSessMsgNoReply");
        }
        StaticCATProducer.sendSessMsg(wsByteBuffer, conversation, n, bl2, bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvSendSessMsgNoReply");
        }
    }

    private static void sendSessMsg(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2, boolean bl3) {
        List list;
        ConversationState conversationState;
        block27: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "sendSessMsg", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl2, "" + bl3});
            }
            if (tc.isDebugEnabled()) {
                if (bl3) {
                    SibTr.debug(tc, "The client will be informed of the outcome");
                } else {
                    SibTr.debug(tc, "The client will NOT be informed of the outcome");
                }
            }
            if (bbPoolManager == null) {
                bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
            }
            wsByteBuffer.flip();
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            short s = wsByteBuffer.getShort();
            short s2 = wsByteBuffer.getShort();
            int n2 = wsByteBuffer.getInt();
            int n3 = (int)wsByteBuffer.getLong();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "connectionObjectId", new Short(s));
                SibTr.debug(tc, "producerObjectId", new Short(s2));
                SibTr.debug(tc, "transactionId", new Integer(n2));
                SibTr.debug(tc, "messageLength", new Integer(n3));
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = null;
            if (n2 != 0) {
                cATTransaction = linkLevelState.getTransactionTable().get(n2);
            }
            try {
                try {
                    Object object;
                    JsMessage jsMessage;
                    if (wsByteBuffer.hasArray()) {
                        jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n3);
                    } else {
                        object = new byte[n3];
                        wsByteBuffer.get((byte[])object);
                        jsMessage = JsMessageFactory.getInstance().createInboundJsMessage((byte[])object, 0, n3);
                    }
                    CommsPMI.getClientStats().onReadMessage(n3);
                    CommsPMI.getClientDetailedStats().onReceiveMessage(JFapChannelConstants.getJFAPPriority(jsMessage.getPriority()));
                    object = (ProducerSession)conversationState.getObject(s2);
                    SITransaction sITransaction = null;
                    if (cATTransaction != null) {
                        sITransaction = cATTransaction.getSITransaction();
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Sending client message - " + jsMessage);
                        SibTr.debug(tc, "Destination: " + object.getDestinationAddress());
                        SibTr.debug(tc, "Discriminator: " + jsMessage.getDiscriminator());
                        SibTr.debug(tc, "Reliability: " + jsMessage.getReliability());
                    }
                    object.send(jsMessage, sITransaction);
                    if (!bl3) break block27;
                    try {
                        conversation.send(list, 203, n, 7, true, null, null);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0005");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, sIException.getMessage(), sIException);
                        }
                        SibTr.error(tc, "COMMUNICATION_ERROR_SICO2024", sIException);
                    }
                }
                catch (Exception exception) {
                    if (bl3) {
                        throw exception;
                    }
                    if (cATTransaction != null) {
                        cATTransaction.markAsError(exception);
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0006");
                    SibTr.error(tc, "UNABLE_TO_SEND_MESSAGE_SICO2009", exception);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Failed to send a message", exception);
                    }
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0007");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                StaticCATHelper.sendExceptionToClient(sIException, "3-008-0007", conversation, n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0008");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, exception.getMessage(), exception);
                }
                StaticCATHelper.sendExceptionToClient(exception, "3-008-0008", conversation, n);
            }
        }
        conversationState.returnList(list);
        if (bl2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendSessMsg");
        }
    }

    static void rcvSendConnMsg(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendConnMsg");
        }
        StaticCATProducer.sendConnMsg(wsByteBuffer, conversation, n, bl2, bl, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvSendConnMsg");
        }
    }

    static void rcvSendConnMsgNoReply(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendConnMsgNoReply");
        }
        StaticCATProducer.sendConnMsg(wsByteBuffer, conversation, n, bl2, bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvSendConnMsgNoReply");
        }
    }

    private static void sendConnMsg(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2, boolean bl3) {
        List list;
        ConversationState conversationState;
        block30: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "sendConnMsg", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl2, "" + bl3});
            }
            if (tc.isDebugEnabled()) {
                if (bl3) {
                    SibTr.debug(tc, "The client will be informed of the outcome");
                } else {
                    SibTr.debug(tc, "The client will NOT be informed of the outcome");
                }
            }
            if (bbPoolManager == null) {
                bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
            }
            wsByteBuffer.flip();
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            short s = wsByteBuffer.getShort();
            short s2 = wsByteBuffer.getShort();
            int n2 = wsByteBuffer.getInt();
            short s3 = wsByteBuffer.getShort();
            short s4 = wsByteBuffer.getShort();
            byte[] byArray = new byte[s4];
            wsByteBuffer.get(byArray);
            CommsString commsString = new CommsString();
            commsString.setBytes(byArray);
            String string = commsString.getString();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "connectionObjectId", new Short(s));
                SibTr.debug(tc, "orderId", new Short(s2));
                SibTr.debug(tc, "transactionId", new Integer(n2));
                SibTr.debug(tc, "destinationType", new Short(s3));
                SibTr.debug(tc, "alternateUser", (Object)string);
            }
            SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
            DestinationType destinationType = null;
            if (s3 != -1) {
                destinationType = DestinationType.getDestinationType(s3);
            }
            try {
                SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
                int n3 = (int)wsByteBuffer.getLong();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Message length", (Object)("" + n3));
                }
                LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                CATTransaction cATTransaction = null;
                if (n2 != 0) {
                    cATTransaction = linkLevelState.getTransactionTable().get(n2);
                }
                OrderingContext orderingContext = null;
                if (s2 != 0) {
                    orderingContext = ((CATOrderingContext)conversationState.getObject(s2)).getOrderingContext();
                }
                try {
                    Object object;
                    JsMessage jsMessage;
                    if (wsByteBuffer.hasArray()) {
                        jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n3);
                    } else {
                        object = new byte[n3];
                        wsByteBuffer.get(object);
                        jsMessage = JsMessageFactory.getInstance().createInboundJsMessage((byte[])object, 0, n3);
                    }
                    CommsPMI.getClientStats().onReadMessage(n3);
                    CommsPMI.getClientDetailedStats().onReceiveMessage(JFapChannelConstants.getJFAPPriority(jsMessage.getPriority()));
                    object = null;
                    if (cATTransaction != null) {
                        object = cATTransaction.getSITransaction();
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Sending client message - " + jsMessage);
                        SibTr.debug(tc, "Destination: " + sIDestinationAddress);
                        SibTr.debug(tc, "Discriminator: " + jsMessage.getDiscriminator());
                        SibTr.debug(tc, "Reliability: " + jsMessage.getReliability());
                    }
                    sICoreConnection.send(jsMessage, (SITransaction)object, sIDestinationAddress, destinationType, orderingContext, string);
                    if (!bl3) break block30;
                    try {
                        conversation.send(list, 197, n, 7, true, null, null);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0009");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, sIException.getMessage(), sIException);
                        }
                        SibTr.error(tc, "COMMUNICATION_ERROR_SICO2024", sIException);
                    }
                }
                catch (Exception exception) {
                    if (bl3) {
                        throw exception;
                    }
                    if (cATTransaction != null) {
                        cATTransaction.markAsError(exception);
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0010");
                    SibTr.error(tc, "UNABLE_TO_SEND_MESSAGE_SICO2009", exception);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Failed to send a message", exception);
                    }
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0011");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                StaticCATHelper.sendExceptionToClient(sIException, "3-008-0011", conversation, n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0012");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, exception.getMessage(), exception);
                }
                StaticCATHelper.sendExceptionToClient(exception, "3-008-0012", conversation, n);
            }
        }
        conversationState.returnList(list);
        if (bl2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendConnMsg");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATProducer.java, SIB.comms, WAS602.SIB, o0610.11 1.57");
        }
    }
}

