/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIDataGraphException;
import com.ibm.websphere.sib.exception.SIDataGraphFormatMismatchException;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIMessageDomainNotSupportedException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.MulticastConsumerSession;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.List;
import javax.transaction.xa.XAException;

public class StaticCATHelper {
    private static String CLASS_NAME = StaticCATHelper.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATHelper.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    public static void sendExceptionToClient(Throwable throwable, String string, Conversation conversation, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendExceptionToClient", new Object[]{throwable, string, conversation, new Integer(n)});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        StaticCATHelper.createExceptionBuffer(list, throwable, string);
        try {
            conversation.send(list, 11, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendExceptionToClient"), (String)"3-012-0001");
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2023", sIException);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendExceptionToClient");
        }
    }

    public static void sendAsyncExceptionToClient(Throwable throwable, String string, short s, Conversation conversation, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendAsyncExceptionToClient", new Object[]{throwable, string, "" + s, conversation, "" + n});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        StaticCATHelper.createExceptionBuffer(list, throwable, string);
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(6);
        wsByteBuffer.putShort((short)0);
        wsByteBuffer.putShort((short)4);
        wsByteBuffer.putShort(s);
        wsByteBuffer.flip();
        list.add(0, wsByteBuffer);
        try {
            conversation.send(list, 225, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendAsyncExceptionToClient"), (String)"3-012-0002");
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2023", sIException);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendAsyncExceptionToClient");
        }
    }

    private static void createExceptionBuffer(List list, Throwable throwable, String string) {
        Throwable throwable2 = throwable;
        short s = 0;
        while (throwable2 != null) {
            short s2 = StaticCATHelper.getExceptionId(throwable2);
            StaticCATHelper.addException(list, throwable2, s2, string);
            throwable2 = throwable2.getCause();
            string = null;
            s = (short)(s + 1);
        }
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(2);
        wsByteBuffer.putShort(s);
        wsByteBuffer.flip();
        list.add(0, wsByteBuffer);
    }

    private static void addException(List list, Throwable throwable, short s, String string) {
        WsByteBuffer wsByteBuffer;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "addException");
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        CommsString commsString = new CommsString();
        CommsString commsString2 = new CommsString();
        short s2 = 0;
        int n = list.size();
        String string2 = null;
        string2 = s == 256 ? throwable.toString() : throwable.getMessage();
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Adding message: " + string2);
            }
            commsString.setString(string2);
            wsByteBuffer = bbPoolManager.allocate(4 + commsString.getLength());
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort(commsString.getLength());
            wsByteBuffer.put(commsString.getBytes());
            wsByteBuffer.flip();
            list.add(wsByteBuffer);
            s2 = (short)(s2 + 1);
        }
        if (string != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Adding probe ID: " + string);
            }
            commsString2.setString(string);
            wsByteBuffer = bbPoolManager.allocate(4 + commsString2.getLength());
            wsByteBuffer.putShort((short)1);
            wsByteBuffer.putShort(commsString2.getLength());
            wsByteBuffer.put(commsString2.getBytes());
            wsByteBuffer.flip();
            list.add(wsByteBuffer);
            s2 = (short)(s2 + 1);
        }
        if (throwable instanceof XAException) {
            int n2 = ((XAException)throwable).errorCode;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Adding reason code: " + n2);
            }
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(8);
            wsByteBuffer2.putShort((short)3);
            wsByteBuffer2.putShort((short)4);
            wsByteBuffer2.putInt(n2);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            s2 = (short)(s2 + 1);
        }
        WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(4);
        wsByteBuffer3.putShort(s);
        wsByteBuffer3.putShort(s2);
        wsByteBuffer3.flip();
        list.add(n, wsByteBuffer3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "addException");
        }
    }

    private static short getExceptionId(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getExceptionId");
        }
        int n = 256;
        if (throwable instanceof SIInvalidDestinationPrefixException) {
            n = 3;
        } else if (throwable instanceof SIDiscriminatorSyntaxException) {
            n = 4;
        } else if (throwable instanceof SISelectorSyntaxException) {
            n = 5;
        } else if (throwable instanceof SIInsufficientDataForFactoryTypeException) {
            n = 6;
        } else if (throwable instanceof SIIncorrectCallException) {
            n = 2;
        } else if (throwable instanceof SIAuthenticationException) {
            n = 7;
        } else if (throwable instanceof SINotAuthorizedException) {
            n = 9;
        } else if (throwable instanceof SINotPossibleInCurrentConfigurationException) {
            n = 8;
        } else if (throwable instanceof SISessionDroppedException) {
            n = 11;
        } else if (throwable instanceof SISessionUnavailableException) {
            n = 10;
        } else if (throwable instanceof SIDurableSubscriptionAlreadyExistsException) {
            n = 12;
        } else if (throwable instanceof SIDurableSubscriptionMismatchException) {
            n = 13;
        } else if (throwable instanceof SIDurableSubscriptionNotFoundException) {
            n = 14;
        } else if (throwable instanceof SIConnectionDroppedException) {
            n = 16;
        } else if (throwable instanceof SIConnectionUnavailableException) {
            n = 15;
        } else if (throwable instanceof SIDataGraphFormatMismatchException) {
            n = 17;
        } else if (throwable instanceof SIDataGraphSchemaNotFoundException) {
            n = 18;
        } else if (throwable instanceof SIDestinationLockedException) {
            n = 19;
        } else if (throwable instanceof SITemporaryDestinationNotFoundException) {
            n = 20;
        } else if (throwable instanceof SIMessageException) {
            n = 21;
        } else if (throwable instanceof SILimitExceededException) {
            n = 23;
        } else if (throwable instanceof SIConnectionLostException) {
            n = 24;
        } else if (throwable instanceof SIRollbackException) {
            n = 25;
        } else if (throwable instanceof SIResourceException) {
            n = 22;
        } else if (throwable instanceof SIMessageDomainNotSupportedException) {
            n = 27;
        } else if (throwable instanceof SINotSupportedException) {
            n = 26;
        } else if (throwable instanceof SIDataGraphException) {
            n = 28;
        } else if (throwable instanceof SIException) {
            n = 1;
        } else if (throwable instanceof SIErrorException) {
            n = 29;
        } else if (throwable instanceof XAException) {
            n = 257;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getExceptionId", (Object)("" + n));
        }
        return (short)n;
    }

    public static void sendSessionCreateResponse(int n, int n2, Conversation conversation, short s, DestinationSession destinationSession, SIDestinationAddress sIDestinationAddress) {
        StaticCATHelper.sendSessionCreateResponse(n, n2, conversation, s, destinationSession, sIDestinationAddress, null);
    }

    public static void sendMulticastSessionCreateResponse(int n, Conversation conversation, short s, DestinationSession destinationSession, SIDestinationAddress sIDestinationAddress) {
        long l;
        WsByteBuffer wsByteBuffer;
        CommsString commsString;
        CommsString commsString2;
        MulticastConsumerSession multicastConsumerSession;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "sendMulticastSessionCreateResponse");
            }
            if (bbPoolManager == null) {
                bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
            }
            multicastConsumerSession = (MulticastConsumerSession)destinationSession;
            ConversationState conversationState = (ConversationState)conversation.getAttachment();
            commsString2 = conversationState.getCommsString();
            commsString = new CommsString();
            commsString2.setString(multicastConsumerSession.getMulticastIpAddress());
            commsString.setString(multicastConsumerSession.getMulticastStreamId());
            wsByteBuffer = bbPoolManager.allocate(16 + commsString.getLength() + commsString2.getLength());
            l = 0L;
            try {
                l = ((ConsumerSession)destinationSession).getId();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendMulticastSessionCreateResponse"), (String)"3-012-0005");
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug(tc, "Unable to get session id", sIException);
            }
        }
        short s2 = 16;
        if (multicastConsumerSession.isReliableMulticast()) {
            s2 = (short)(s2 | 0x20);
        }
        wsByteBuffer.putLong(l);
        wsByteBuffer.putShort(s2);
        wsByteBuffer.putShort(commsString2.getLength());
        wsByteBuffer.put(commsString2.getBytes());
        wsByteBuffer.putShort((short)multicastConsumerSession.getMulticastDataPort());
        wsByteBuffer.putShort(commsString.getLength());
        wsByteBuffer.put(commsString.getBytes());
        wsByteBuffer.flip();
        StaticCATHelper.sendSessionCreateResponse(205, n, conversation, s, destinationSession, sIDestinationAddress, wsByteBuffer);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMulticastSessionCreateResponse");
        }
    }

    private static void sendSessionCreateResponse(int n, int n2, Conversation conversation, short s, DestinationSession destinationSession, SIDestinationAddress sIDestinationAddress, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendSessionCreateResponse");
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CommsString commsString = conversationState.getCommsString();
        List list = conversationState.getList();
        if (wsByteBuffer != null) {
            list.add(wsByteBuffer);
        }
        WsByteBuffer wsByteBuffer2 = null;
        wsByteBuffer2 = bbPoolManager.allocate(12);
        if ((n == 231 || n == 205) && wsByteBuffer == null) {
            long l;
            block16: {
                l = 0L;
                try {
                    l = ((ConsumerSession)destinationSession).getId();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendSessionCreateResponse"), (String)"3-012-0004");
                    if (!tc.isDebugEnabled()) break block16;
                    SibTr.debug(tc, "Unable to get session id", sIException);
                }
            }
            wsByteBuffer2.putLong(l);
        }
        if (n == 205 && wsByteBuffer == null) {
            wsByteBuffer2.putShort((short)8);
        }
        wsByteBuffer2.putShort(s);
        wsByteBuffer2.flip();
        list.add(wsByteBuffer2);
        JsDestinationAddress jsDestinationAddress = (JsDestinationAddress)destinationSession.getDestinationAddress();
        if (sIDestinationAddress == null || !sIDestinationAddress.toString().equals(jsDestinationAddress.toString())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Destination address is different: Orig, New", new Object[]{sIDestinationAddress, jsDestinationAddress});
            }
            SIBUuid8 sIBUuid8 = jsDestinationAddress.getME();
            commsString.setString(jsDestinationAddress.getDestinationName());
            CommsString commsString2 = new CommsString(jsDestinationAddress.getBusName());
            short s2 = 0;
            if (sIBUuid8 != null) {
                s2 = (short)sIBUuid8.toByteArray().length;
            }
            WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(6 + s2 + commsString.getLength() + commsString2.getLength());
            if (sIBUuid8 != null) {
                wsByteBuffer3.putShort(s2);
                wsByteBuffer3.put(sIBUuid8.toByteArray());
            } else {
                wsByteBuffer3.putShort((short)0);
            }
            wsByteBuffer3.putShort(commsString.getLength());
            wsByteBuffer3.put(commsString.getBytes());
            wsByteBuffer3.putShort(commsString2.getLength());
            wsByteBuffer3.put(commsString2.getBytes());
            wsByteBuffer3.flip();
            list.add(wsByteBuffer3);
        }
        try {
            conversation.send(list, n, n2, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendSessionCreateResponse"), (String)"3-012-0003");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2023", sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendSessionCreateResponse");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATHelper.java, SIB.comms, WAS602.SIB, o0610.11 1.50");
        }
    }
}

