/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StaticCATDestination {
    private static String CLASS_NAME = StaticCATDestination.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATDestination.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateTempDestination(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateTempDestination", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CommsString commsString = conversationState.getCommsString();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", new Short(s));
            SibTr.debug(tc, "Distribution", new Short(s2));
        }
        Distribution distribution = Distribution.getDistribution(s2);
        String string = null;
        short s3 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s3];
        wsByteBuffer.get(byArray, 0, new Integer(s3).intValue());
        commsString.setBytes(byArray);
        if (commsString.isNull()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Destination prefix was null");
            }
        } else {
            string = commsString.getString();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Destination prefix:", (Object)string);
            }
        }
        try {
            JsDestinationAddress jsDestinationAddress = (JsDestinationAddress)sICoreConnection.createTemporaryDestination(distribution, string);
            byte[] byArray2 = jsDestinationAddress.getME() == null ? new byte[]{} : jsDestinationAddress.getME().toByteArray();
            commsString.setString(jsDestinationAddress.getDestinationName());
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(4 + byArray2.length + commsString.getLength());
            wsByteBuffer2.putShort((short)byArray2.length);
            wsByteBuffer2.put(byArray2);
            wsByteBuffer2.putShort(commsString.getLength());
            wsByteBuffer2.put(commsString.getBytes());
            wsByteBuffer2.flip();
            commsString.setString(jsDestinationAddress.getBusName());
            WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(2 + commsString.getLength());
            wsByteBuffer3.putShort(commsString.getLength());
            wsByteBuffer3.put(commsString.getBytes());
            wsByteBuffer3.flip();
            list.add(wsByteBuffer2);
            list.add(wsByteBuffer3);
            try {
                conversation.send(list, 193, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateTempDestination"), (String)"3-007-0001");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2022", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateTempDestination"), (String)"3-007-0002");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-007-0002", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateTempDestination");
        }
    }

    static void rcvDeleteTempDestination(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvDeleteTempDestination", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", (Object)("" + s));
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        try {
            SIDestinationAddress sIDestinationAddress;
            block16: {
                ConsumerSession consumerSession;
                sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
                CATMainConsumer cATMainConsumer = conversationState.getCachedConsumer();
                if (cATMainConsumer != null && (consumerSession = cATMainConsumer.getConsumerSession()) != null && consumerSession.getDestinationAddress().equals(sIDestinationAddress)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "The destination is currently held open by us");
                    }
                    try {
                        consumerSession.close();
                        conversationState.setCachedConsumer(null);
                    }
                    catch (SIException sIException) {
                        if (!tc.isDebugEnabled()) break block16;
                        SibTr.debug(tc, "Unable to close cached consumer", sIException);
                    }
                }
            }
            sICoreConnection.deleteTemporaryDestination(sIDestinationAddress);
            try {
                conversation.send(list, 194, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvDeleteTempDestination"), (String)"3-007-0003");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2022", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvDeleteTempDestination"), (String)"3-007-0004");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-007-0004", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvDeleteTempDestination");
        }
    }

    static void rcvGetDestinationConfiguration(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvGetDestinationConfiguration", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", (Object)("" + s));
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        try {
            SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
            DestinationConfiguration destinationConfiguration = sICoreConnection.getDestinationConfiguration(sIDestinationAddress);
            int n2 = destinationConfiguration.getDefaultPriority();
            int n3 = destinationConfiguration.getMaxFailedDeliveries();
            short s2 = 0;
            if (destinationConfiguration.isProducerQOSOverrideEnabled()) {
                s2 = (short)(s2 | 1);
            }
            if (destinationConfiguration.isReceiveAllowed()) {
                s2 = (short)(s2 | 2);
            }
            if (destinationConfiguration.isReceiveExclusive()) {
                s2 = (short)(s2 | 4);
            }
            if (destinationConfiguration.isSendAllowed()) {
                s2 = (short)(s2 | 8);
            }
            Reliability reliability = destinationConfiguration.getDefaultReliability();
            short s3 = (short)reliability.toInt();
            Reliability reliability2 = destinationConfiguration.getMaxReliability();
            short s4 = (short)reliability2.toInt();
            DestinationType destinationType = destinationConfiguration.getDestinationType();
            short s5 = (short)destinationType.toInt();
            String string = destinationConfiguration.getExceptionDestination();
            CommsString commsString = conversationState.getCommsString();
            commsString.setString(string);
            short s6 = commsString.getLength();
            String string2 = destinationConfiguration.getName();
            CommsString commsString2 = new CommsString();
            commsString2.setString(string2);
            short s7 = commsString2.getLength();
            String string3 = destinationConfiguration.getDescription();
            CommsString commsString3 = new CommsString();
            commsString3.setString(string3);
            short s8 = commsString3.getLength();
            String string4 = destinationConfiguration.getUUID();
            CommsString commsString4 = new CommsString();
            commsString4.setString(string4);
            short s9 = commsString4.getLength();
            WsByteBuffer wsByteBuffer2 = CommsUtils.getDestinationAddressAsBytes(destinationConfiguration.getReplyDestination());
            WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(24 + s6 + s7 + s9 + s8 + wsByteBuffer2.remaining());
            wsByteBuffer3.putInt(n2);
            wsByteBuffer3.putInt(n3);
            wsByteBuffer3.putShort(s3);
            wsByteBuffer3.putShort(s4);
            wsByteBuffer3.putShort(s5);
            wsByteBuffer3.putShort(s2);
            wsByteBuffer3.putShort(s9);
            wsByteBuffer3.put(commsString4.getBytes());
            wsByteBuffer3.putShort(s8);
            wsByteBuffer3.put(commsString3.getBytes());
            wsByteBuffer3.putShort(s6);
            wsByteBuffer3.put(commsString.getBytes());
            wsByteBuffer3.putShort(s7);
            wsByteBuffer3.put(commsString2.getBytes());
            wsByteBuffer3.put(wsByteBuffer2);
            wsByteBuffer2.release();
            wsByteBuffer3.flip();
            list.add(wsByteBuffer3);
            try {
                WsByteBuffer wsByteBuffer4;
                Object object;
                Object object2;
                short s10 = 0;
                Map map = destinationConfiguration.getDestinationContext();
                if (map != null) {
                    s10 = (short)map.size();
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Adding " + s10 + " name / value item(s)");
                }
                WsByteBuffer wsByteBuffer5 = bbPoolManager.allocate(2);
                wsByteBuffer5.putShort(s10);
                wsByteBuffer5.flip();
                list.add(wsByteBuffer5);
                if (s10 > 0) {
                    object2 = new CommsString();
                    CommsString commsString5 = new CommsString();
                    object = map.keySet().iterator();
                    Iterator iterator = map.values().iterator();
                    while (object.hasNext()) {
                        commsString5.setString((String)object.next());
                        ((CommsString)object2).setString((String)iterator.next());
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Adding " + commsString5.getString() + "=" + ((CommsString)object2).getString());
                        }
                        wsByteBuffer4 = bbPoolManager.allocate(4 + commsString5.getLength() + ((CommsString)object2).getLength());
                        wsByteBuffer4.putShort(commsString5.getLength());
                        wsByteBuffer4.put(commsString5.getBytes());
                        wsByteBuffer4.putShort(((CommsString)object2).getLength());
                        wsByteBuffer4.put(((CommsString)object2).getBytes());
                        wsByteBuffer4.flip();
                        list.add(wsByteBuffer4);
                    }
                }
                object2 = destinationConfiguration.getDefaultForwardRoutingPath();
                short s11 = 0;
                if (object2 != null) {
                    s11 = (short)((SIDestinationAddress[])object2).length;
                }
                object = bbPoolManager.allocate(2);
                object.putShort(s11);
                object.flip();
                list.add(object);
                if (s11 > 0) {
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        wsByteBuffer4 = CommsUtils.getDestinationAddressAsBytes((SIDestinationAddress)object2[i]);
                        list.add(wsByteBuffer4);
                    }
                }
                try {
                    conversation.send(list, 229, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0001");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2022", sIException);
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0002");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, classCastException.getMessage(), classCastException);
                }
                StaticCATHelper.sendExceptionToClient(classCastException, "3-014-0002", conversation, n);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0003");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-014-0003", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvGetDestinationConfiguration");
        }
    }

    static void rcvSendToExceptionDest(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendToExceptionDest", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            Object object;
            Object[] objectArray;
            JsMessage jsMessage;
            short s = wsByteBuffer.getShort();
            int n2 = wsByteBuffer.getInt();
            SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
            int n3 = wsByteBuffer.getInt();
            short s2 = wsByteBuffer.getShort();
            byte[] byArray = new byte[s2];
            wsByteBuffer.get(byArray);
            CommsString commsString = new CommsString();
            commsString.setBytes(byArray);
            String string = commsString.getString();
            int n4 = (int)wsByteBuffer.getLong();
            CommsPMI.getClientStats().onWriteMessage(n4);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "ConnectionObjectId", (Object)("" + s));
                SibTr.debug(tc, "DestinationAddress", sIDestinationAddress);
                SibTr.debug(tc, "Reason", (Object)("" + n3));
                SibTr.debug(tc, "TransactionId", (Object)("" + n2));
                SibTr.debug(tc, "MessageLength", (Object)("" + n4));
                SibTr.debug(tc, "AlternateUser", (Object)string);
            }
            if (wsByteBuffer.hasArray()) {
                jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n4);
                wsByteBuffer.position(wsByteBuffer.position() + n4);
            } else {
                objectArray = new byte[n4];
                wsByteBuffer.get(objectArray);
                jsMessage = JsMessageFactory.getInstance().createInboundJsMessage((byte[])objectArray, 0, n4);
            }
            objectArray = null;
            int n5 = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Number of inserts", (Object)("" + n5));
            }
            if (n5 != 0) {
                objectArray = new String[n5];
                object = conversationState.getCommsString();
                for (int i = 0; i < n5; ++i) {
                    short s3 = wsByteBuffer.getShort();
                    byte[] byArray2 = new byte[s3];
                    wsByteBuffer.get(byArray2);
                    ((CommsString)object).setBytes(byArray2);
                    objectArray[i] = (byte)((CommsString)object).getString();
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug(tc, "Insert[" + i + "] = " + (String)objectArray[i]);
                }
            }
            object = null;
            if (n2 != 0) {
                object = linkLevelState.getTransactionTable().get(n2).getSITransaction();
            }
            SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
            sICoreConnection.sendToExceptionDestination(sIDestinationAddress, jsMessage, n3, (String[])objectArray, (SITransaction)object, string);
            try {
                conversation.send(list, 237, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0004");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2022", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0005");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-014-0005", conversation, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0006");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, exception.getMessage(), exception);
            }
            StaticCATHelper.sendExceptionToClient(exception, "3-014-0006", conversation, n);
        }
        if (bl) {
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvSendToExceptionDest");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATDestination.java, SIB.comms, WAS602.SIB, o0610.11 1.49.1.1");
        }
    }
}

