/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsServiceUtility;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.GenericTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ServerTransportFactory {
    private static String CLASS_NAME = ServerTransportFactory.class.getName();
    private static TraceComponent tc = SibTr.register(ServerTransportFactory.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    public ServerTransportFactory(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        try {
            ServerConnectionManager.initialise(new AcceptListenerFactoryImpl());
            SibTr.audit(tc, "SERVER_STARTED_SICO2001", new Object[0]);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + ".<init>"), (String)"3-003-0001", (Object)this);
            SibTr.error(tc, "SERVER_FAILED_TO_START_SICO2004", sIResourceException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".<init>"), (String)"3-003-0002", (Object)this);
            SibTr.error(tc, "SERVER_FAILED_TO_START_SICO2004", throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public static void startServerComms() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startServerComms");
        }
        try {
            ServerConnectionManager.initialise(new AcceptListenerFactoryImpl());
            CommsUtils.initialise(ServerConnectionManager.getRef());
            SibTr.audit(tc, "SERVER_STARTED_SICO2001", null);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + ".startServerComms"), (String)"3-003-0001", null);
            SibTr.error(tc, "SERVER_FAILED_TO_START_SICO2004", sIResourceException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".startServerComms"), (String)"3-003-0002", null);
            SibTr.error(tc, "SERVER_FAILED_TO_START_SICO2004", throwable);
        }
        String string = RuntimeInfo.getProperty("sib.comms.ServicePort");
        if (string != null) {
            CommsServiceUtility commsServiceUtility = CommsServiceUtility.getInstance();
            commsServiceUtility.start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startServerComms");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerTransportFactory.java, SIB.comms, WAS602.SIB, o0610.11 1.21");
        }
    }

    private static class AcceptListenerFactoryImpl
    implements AcceptListenerFactory {
        private AcceptListenerFactoryImpl() {
        }

        public AcceptListener manufactureAcceptListener() {
            return new GenericTransportAcceptListener();
        }
    }
}

