/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.ClientComponentHandshake;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.common.JFAPCommunicator;
import com.ibm.ws.sib.comms.server.IdToSICoreConnectionTable;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;

public class ServerSideConnection
extends JFAPCommunicator
implements ClientConnection,
ConnectionClosedListener {
    private static String CLASS_NAME = ServerSideConnection.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerSideConnection.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private SICoreConnection conn;
    private boolean conversationClosed = false;
    private static final int NOTIFICATION_TYPE_CLIENT_CONNECT = 1;
    private static final int NOTIFICATION_TYPE_CLIENT_DISCONNECT = 2;
    private static final int NOTIFICATION_TYPE_CLIENT_FAILURE = 3;
    private String connectionUserId = null;

    public ServerSideConnection(Conversation conversation) {
        super(true);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.setConversation(conversation);
        conversation.setConnectionClosedListener(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public void connect(ConnectionProperties connectionProperties, ClientComponentHandshake clientComponentHandshake) throws SIResourceException, SIAuthenticationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "connect");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "connect");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2050", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"3-002-0002", (Object)this);
        throw sIErrorException;
    }

    public void setSICoreConnection(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setSICoreConnection");
        }
        if (this.conn != null && this.conn != sICoreConnection) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("SICONN_ALREADY_SET_SICO2051", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setSICoreConnection"), (String)"3-002-0003", (Object)this);
            throw sIErrorException;
        }
        IdToSICoreConnectionTable idToSICoreConnectionTable = ((LinkLevelState)this.getConversation().getLinkLevelAttachment()).getSICoreConnectionTable();
        idToSICoreConnectionTable.add(this.getConversation().getId(), sICoreConnection);
        this.conn = sICoreConnection;
        this.emitNotification(1);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setSICoreConnection");
        }
    }

    public SICoreConnection getSICoreConnection() throws SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSICoreConnection");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSICoreConnection");
        }
        return this.conn;
    }

    public byte[] trmHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "trmHandshakeExchange");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "trmHandshakeExchange");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2052", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".trmHandshakeExchange"), (String)"3-002-0004", (Object)this);
        throw sIErrorException;
    }

    public byte[] mfpHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "mfpHandshakeExchange");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "mfpHandshakeExchange");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2053", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"3-002-0005", (Object)this);
        throw sIErrorException;
    }

    public void sendMFPSchema(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "sendMFPSchema");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            try {
                this.JFAPSend(linkedList, 230, 12, true);
            }
            catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
                FFDCFilter.processException((Throwable)noCapacityException, (String)(CLASS_NAME + ".sendMFPSchema"), (String)"3-002-0006", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "NoCapacityException caught!");
                }
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception((Object)this, tc, noCapacityException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMFPSchema");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "close");
            }
            ServerSideConnection serverSideConnection = this;
            synchronized (serverSideConnection) {
                if (!this.conversationClosed) {
                    this.emitNotification(2);
                }
                this.conversationClosed = true;
            }
            try {
                this.getConversation().close();
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".close"), (String)"3-002-0001", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                SibTr.debug(tc, "Unable to close conversation", sIConnectionLostException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public Object getUniqueLinkObject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUniqueLinkObject");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getUniqueLinkObject");
        }
        return this.getConversation().getLinkLevelAttachment();
    }

    public String getConnectionInfo() {
        return null;
    }

    public ConnectionMetaData getMetaData() {
        LinkLevelState linkLevelState = (LinkLevelState)this.getConversation().getLinkLevelAttachment();
        return new ConnectionMetaDataImpl(this.getConversation().getMetaData(), linkLevelState.getCatHandshakeProperties());
    }

    public void connectionClosed(Object object) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "connectionClosed", object);
            }
            try {
                CompHandshake compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                compHandshake.compClose(this);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "failed");
        }
        ServerSideConnection serverSideConnection = this;
        synchronized (serverSideConnection) {
            if (!this.conversationClosed) {
                this.emitNotification(3);
            }
            this.conversationClosed = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "failed");
        }
    }

    public byte[] requestMFPSchemata(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "requestMFPSchemata", byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMFPSchemata", null);
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2053", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"3-002-0007", (Object)this);
        throw sIErrorException;
    }

    private JsMessagingEngine findJsMessagingEngineByName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "findJsMessagingEngineByName", string);
        }
        JsMessagingEngine jsMessagingEngine = null;
        Enumeration enumeration = JsAdminService.getInstance().listMessagingEngines();
        while (enumeration.hasMoreElements() && jsMessagingEngine == null) {
            JsMessagingEngine jsMessagingEngine2 = (JsMessagingEngine)enumeration.nextElement();
            if (!jsMessagingEngine2.getName().equals(string)) continue;
            jsMessagingEngine = jsMessagingEngine2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "findJsMessagingEngineByName", jsMessagingEngine);
        }
        return jsMessagingEngine;
    }

    private void emitNotification(int n) {
        block13: {
            String string;
            JsMessagingEngine jsMessagingEngine;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "emitNotification", "" + n);
            }
            if (this.conn != null && (jsMessagingEngine = this.findJsMessagingEngineByName(string = this.conn.getMeName())) != null && jsMessagingEngine.isEventNotificationEnabled()) {
                try {
                    Object object;
                    Properties properties = new Properties();
                    String string2 = null;
                    String string3 = null;
                    if (this.connectionUserId == null) {
                        this.connectionUserId = this.conn.getResolvedUserid();
                    }
                    properties.put("client.userid", this.connectionUserId);
                    switch (n) {
                        case 1: {
                            string2 = "SIB.client.connection.start";
                            properties.put("fap.type", "JFAP");
                            object = this.getConversation().getMetaData().getRemoteAddress();
                            String string4 = object == null ? "0.0.0.0" : ((InetAddress)object).getHostAddress();
                            string3 = nls.getFormattedMessage("CLIENT_CONNECTED_SICO8015", new Object[]{this.connectionUserId, string4}, null);
                            properties.put("communications.address", string4);
                            break;
                        }
                        case 2: {
                            string2 = "SIB.client.connection.stop";
                            string3 = nls.getFormattedMessage("CLIENT_DISCONNECTED_SICO8016", new Object[]{this.connectionUserId}, null);
                            properties.put("stop.reason", "client.shutdown");
                            break;
                        }
                        case 3: {
                            string2 = "SIB.client.connection.stop";
                            string3 = nls.getFormattedMessage("CLIENT_DISCONNECTED_SICO8016", new Object[]{this.connectionUserId}, null);
                            properties.put("stop.reason", "communications.failure");
                            break;
                        }
                        default: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "unknown notification type");
                            }
                            throw new SIErrorException("Unknown notification type");
                        }
                    }
                    object = ((JsEngineComponentWithEventListener)jsMessagingEngine.getMessageProcessor()).getRuntimeEventListener();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Issuing event notification on engine: " + jsMessagingEngine + "\n" + "notification: " + string2 + "\nproperties: " + properties);
                    }
                    object.runtimeEventOccurred(jsMessagingEngine, string2, string3, properties);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".emitNotification"), (String)"3-002-0008", (Object)this);
                    if (!tc.isEntryEnabled()) break block13;
                    SibTr.exception((Object)this, tc, exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "emitNotification");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerSideConnection.java, SIB.comms, WAS602.SIB, o0610.11 1.38");
        }
    }
}

