/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.NoCapacityException;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.Hashtable;
import java.util.List;

public class ServerSICoreConnectionListener
implements SICoreConnectionListener {
    private static String CLASS_NAME = ServerSICoreConnectionListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerSICoreConnectionListener.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private Hashtable quiesceNotif = new Hashtable();
    private Hashtable termNotif = new Hashtable();
    private Hashtable conversationTable = new Hashtable();

    public void addSICoreConnection(SICoreConnection sICoreConnection, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "addSICoreConnection");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: connection, conversation", new Object[]{sICoreConnection, conversation});
        }
        this.conversationTable.put(sICoreConnection, conversation);
        this.quiesceNotif.remove(sICoreConnection.getMeUuid());
        this.termNotif.remove(sICoreConnection.getMeUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "addSICoreConnection");
        }
    }

    public void removeSICoreConnection(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeSICoreConnection");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: connection", sICoreConnection);
        }
        this.conversationTable.remove(sICoreConnection);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeSICoreConnection");
        }
    }

    public void asynchronousException(ConsumerSession consumerSession, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "asynchronousException", new Object[]{consumerSession, throwable});
        }
        FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".asynchronousException"), (String)"3-005-0003", (Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Caught an async exception:", throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "asynchronousException");
        }
    }

    public void meQuiescing(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meQuiescing");
        }
        String string = sICoreConnection.getMeUuid();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ME Uuid: ", (Object)string);
        }
        if (this.quiesceNotif.get(string) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "We have not sent a notification about this ME");
            }
            try {
                this.sendMeNotificationEvent((short)2, sICoreConnection);
                this.quiesceNotif.put(string, new Object());
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".meQuiescing"), (String)"3-005-0005", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2018", sIException);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Already sent notification about this ME");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meQuiescing");
        }
    }

    public void meTerminated(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meTerminated");
        }
        String string = sICoreConnection.getMeUuid();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ME Uuid: ", (Object)string);
        }
        if (this.termNotif.get(string) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "We have not sent a notification about this ME");
            }
            try {
                this.sendMeNotificationEvent((short)3, sICoreConnection);
                this.termNotif.put(string, new Object());
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".meTerminated"), (String)"3-005-0002", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2018", sIException);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Already sent notification about this ME");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meTerminated");
        }
    }

    private void sendMeNotificationEvent(short s, SICoreConnection sICoreConnection) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        Conversation conversation;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMeNotificationEvent", new Object[]{"" + s, sICoreConnection});
        }
        if ((conversation = (Conversation)this.conversationTable.get(sICoreConnection)) == null) {
            NullPointerException nullPointerException = new NullPointerException("No conversation was located");
            FFDCFilter.processException((Throwable)nullPointerException, (String)(CLASS_NAME + ".sendMeNotificationEvent"), (String)"3-005-0001", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, nullPointerException.getMessage(), nullPointerException);
            }
        } else {
            ConversationState conversationState = (ConversationState)conversation.getAttachment();
            List list = conversationState.getList();
            WsByteBufferPoolManager wsByteBufferPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
            WsByteBuffer wsByteBuffer = wsByteBufferPoolManager.allocate(4);
            wsByteBuffer.putShort(conversationState.getConnectionObjectId());
            wsByteBuffer.putShort(s);
            wsByteBuffer.flip();
            list.add(wsByteBuffer);
            conversation.send(list, 225, 0, 11, true, null, null);
            conversationState.returnList(list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMeNotificationEvent");
        }
    }

    public void commsFailure(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "commsFailure", new Object[]{sICoreConnection, sIConnectionLostException});
        }
        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".commsFailure"), (String)"3-005-0004", (Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Caught a comms exception:", sIConnectionLostException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "commsFailure");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerSICoreConnectionListener.java, SIB.comms, WAS602.SIB, o0610.11 1.20");
        }
    }
}

