/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.multicast.MulticastFactory;
import com.ibm.ws.sib.multicast.MulticastTransmitter;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.MulticastProperties;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.Hashtable;

public class MulticastConsumerSession
implements ConsumerSession,
AsynchConsumerCallback {
    private static String CLASS_NAME = MulticastConsumerSession.class.getName();
    private static final TraceComponent tc = SibTr.register(MulticastConsumerSession.class, "SIBCommunications", "com.ibm.ws.sib.multicast.SICMMessages");
    private static Hashtable sessions = new Hashtable();
    private ConsumerSession session = null;
    private MulticastTransmitter rmmTx = null;
    private int useCount = 0;
    private String streamId = null;
    private MulticastProperties multicastProps = null;

    public static synchronized MulticastConsumerSession getMulticastConsumerSession(SICoreConnection sICoreConnection, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, String string) throws SIException {
        String string2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMulticastConsumerSession", new Object[]{sICoreConnection, sIDestinationAddress, destinationType, selectionCriteria, string});
        }
        MulticastConsumerSession multicastConsumerSession = null;
        if (((MPCoreConnection)sICoreConnection).isBusSecure()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "The bus is secure");
            }
            if (string == null) {
                string = sICoreConnection.getResolvedUserid();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Using user id: " + string);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Bus is un-secure, not using a userId");
            }
            string = null;
        }
        if ((multicastConsumerSession = (MulticastConsumerSession)sessions.get(string2 = MulticastConsumerSession.generateStreamId(sICoreConnection, sIDestinationAddress, selectionCriteria, string))) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Session already exists");
            }
        } else {
            multicastConsumerSession = new MulticastConsumerSession(sICoreConnection, sIDestinationAddress, destinationType, selectionCriteria, string, string2);
            sessions.put(string2, multicastConsumerSession);
        }
        multicastConsumerSession.incrementUseCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMulticastConsumerSession");
        }
        return multicastConsumerSession;
    }

    private static synchronized void destroyMulticastConsumer(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "destroyMulticastConsumer", (Object)string);
        }
        sessions.remove(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "destroyMulticastConsumer");
        }
    }

    private static String generateStreamId(SICoreConnection sICoreConnection, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "generateStreamId");
        }
        String string2 = sICoreConnection.getMeUuid() + ":" + string + ":" + sIDestinationAddress.toString() + ":" + selectionCriteria.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "generateStreamId", (Object)string2);
        }
        return string2;
    }

    private MulticastConsumerSession(SICoreConnection sICoreConnection, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, String string, String string2) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{sICoreConnection, sIDestinationAddress, destinationType, selectionCriteria, string, string2});
        }
        this.streamId = string2;
        this.multicastProps = ((MPCoreConnection)sICoreConnection).getMulticastProperties();
        MulticastFactory multicastFactory = MulticastFactory.getFactory();
        this.rmmTx = multicastFactory.getTransmitter(string2, this.multicastProps);
        this.session = sICoreConnection.createConsumerSession(sIDestinationAddress, destinationType, selectionCriteria, Reliability.EXPRESS_NONPERSISTENT, false, false, Reliability.ASSURED_PERSISTENT, false, string);
        this.session.registerAsynchConsumerCallback(this, 0, 0L, 1, null);
        this.session.start(false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    private synchronized void incrementUseCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "incrementUseCount");
        }
        ++this.useCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Use count is now: " + this.useCount);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "incrementUseCount");
        }
    }

    private synchronized void decrementUseCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "decrementUseCount");
        }
        --this.useCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Use count is now: " + this.useCount);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "decrementUseCount");
        }
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "consumeMessages");
            }
            try {
                SIBusMessage sIBusMessage;
                while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
                    lockedMessageEnumeration.deleteCurrent(null);
                    this.rmmTx.send(sIBusMessage);
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Unable to send message:", sIConnectionLostException);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-026-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Unable to manipulate LME:", sIException);
                }
            }
            catch (MessageEncodeFailedException messageEncodeFailedException) {
                FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-026-0002", (Object)this);
                if (!tc.isDebugEnabled()) break block9;
                SibTr.debug(this, tc, "Unable to encode message:", messageEncodeFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "consumeMessages");
        }
    }

    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        this.decrementUseCount();
        if (this.useCount == 0) {
            this.rmmTx.close();
            this.session.close();
            MulticastConsumerSession.destroyMulticastConsumer(this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    protected String getMulticastIpAddress() {
        return this.multicastProps.getMulticastGroupAddress();
    }

    protected int getMulticastDataPort() {
        return this.multicastProps.getMulticastPort();
    }

    protected String getMulticastStreamId() {
        return this.streamId;
    }

    protected boolean isReliableMulticast() {
        return this.multicastProps.isReliable();
    }

    public SIBusMessage receiveNoWait(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        return null;
    }

    public SIBusMessage receiveWithWait(SITransaction sITransaction, long l) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        return null;
    }

    public void start(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
    }

    public void stop() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
    }

    public void registerAsynchConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, OrderingContext orderingContext) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
    }

    public void deregisterAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
    }

    public void unlockSet(SIMessageHandle[] sIMessageHandleArray) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException {
    }

    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
    }

    public void deleteSet(SIMessageHandle[] sIMessageHandleArray, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
    }

    public void activateAsynchConsumer(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
    }

    public long getId() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        return this.session.getId();
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        return this.session.getConnection();
    }

    public SIDestinationAddress getDestinationAddress() {
        return this.session.getDestinationAddress();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/MulticastConsumerSession.java, SIB.comms, WAS602.SIB, o0610.11 1.17");
        }
    }
}

