/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;

public class CachedSessionProperties {
    private static TraceComponent tc = SibTr.register(CachedSessionProperties.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private SIDestinationAddress destinationAddress = null;
    private SelectionCriteria criteria = null;
    private Reliability unrecovReliability = null;

    public CachedSessionProperties(SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.destinationAddress = sIDestinationAddress;
        this.criteria = selectionCriteria;
        this.unrecovReliability = reliability;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public boolean equals(CachedSessionProperties cachedSessionProperties) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "equals");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: other", cachedSessionProperties);
        }
        boolean bl2 = bl = this.areTheyTheSame(this.destinationAddress, cachedSessionProperties.getDestinationAddress()) && this.areTheyTheSame(this.criteria, cachedSessionProperties.getSelectionCriteria()) && this.areTheyTheSame(this.unrecovReliability, cachedSessionProperties.getReliability());
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=", (Object)("" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "equals");
        }
        return bl;
    }

    private boolean areTheyTheSame(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof String) {
            return ((String)object).equals((String)object2);
        }
        if (object instanceof Reliability) {
            return ((Reliability)object).compareTo(object2) == 0;
        }
        if (object instanceof SIDestinationAddress) {
            return object.toString().equals(object2.toString());
        }
        return false;
    }

    public String toString() {
        return "Destination Addr: '" + this.destinationAddress + "', SelectionCriteria: '" + this.criteria + "' , Reliability: " + this.unrecovReliability;
    }

    public SIDestinationAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public SelectionCriteria getSelectionCriteria() {
        return this.criteria;
    }

    public Reliability getReliability() {
        return this.unrecovReliability;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CachedSessionProperties.java, SIB.comms, WAS602.SIB, o0610.11 1.10");
        }
    }
}

