/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.clientsupport.CATSyncAsynchReader;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;

public class CATTimer
implements AlarmListener {
    private static String CLASS_NAME = CATTimer.class.getName();
    private CATSyncAsynchReader asynchReader = null;
    private WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(CATTimer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    public CATTimer(CATSyncAsynchReader cATSyncAsynchReader) {
        this.asynchReader = cATSyncAsynchReader;
        if (this.bbPoolManager == null) {
            this.bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "alarm");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "User data was: " + object);
        }
        if (!this.asynchReader.isComplete()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Async reader has not yet got a message");
            }
            try {
                this.asynchReader.stopSession();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".alarm"), (String)"3-017-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                this.asynchReader.sendErrorToClient(sIException, "3-017-0001");
            }
        }
        if (this.asynchReader.isComplete()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Async reader got a message");
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "No message received");
            }
            this.asynchReader.sendNoMessageToClient();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "alarm");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATTimer.java, SIB.comms, WAS602.SIB, o0610.11 1.18");
        }
    }
}

