/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATSyncAsynchReader;
import com.ibm.ws.sib.comms.server.clientsupport.CATTimer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;

public class CATSessSynchConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATSessSynchConsumer.class.getName();
    private CATMainConsumer mainConsumer = null;
    private CATSyncAsynchReader asynchReader = null;
    private boolean logicallyStarted = false;
    private static final TraceComponent tc = SibTr.register(CATSessSynchConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    public CATSessSynchConsumer(CATMainConsumer cATMainConsumer) {
        this.mainConsumer = cATMainConsumer;
        if (cATMainConsumer.isStarted()) {
            this.logicallyStarted = true;
        }
    }

    protected ConsumerSession getConsumerSession() {
        return this.mainConsumer.getConsumerSession();
    }

    protected Conversation getConversation() {
        return this.mainConsumer.getConversation();
    }

    protected int getLowestPriority() {
        return this.mainConsumer.getLowestPriority();
    }

    protected void setLowestPriority(int n) {
        this.mainConsumer.setLowestPriority(n);
    }

    protected short getClientSessionId() {
        return this.mainConsumer.getClientSessionId();
    }

    protected Reliability getUnrecoverableReliability() {
        return this.mainConsumer.getUnrecoverableReliability();
    }

    public void receive(int n, CATTransaction cATTransaction, long l) {
        Reliability reliability;
        block33: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "receive");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "RQ: " + n + ", Timeout: " + l);
                if (l == -1L) {
                    SibTr.debug(tc, "Emulating a receiveNoWait()");
                } else if (l == 0L) {
                    SibTr.debug(tc, "Emulating an indefinate receive()");
                } else {
                    SibTr.debug(tc, "Emulating a receive() for " + l + "ms");
                }
            }
            ++this.requestsReceived;
            try {
                if (this.mainConsumer.isStarted()) {
                    this.getConsumerSession().stop();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".receive"), (String)"3-020-0001", (Object)this);
                if (!tc.isDebugEnabled()) break block33;
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
        }
        if (this.asynchReader == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Creating async reader for first time");
            }
            this.asynchReader = new CATSyncAsynchReader(cATTransaction, this.getConversation(), this.mainConsumer, n);
            try {
                boolean bl = CommsUtils.getRuntimeBooleanProperty("sib.comms.InlineAsyncCBacks", CommsConstants.INLINE_ASYNC_CBACKS);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Inline async callbacks: " + bl);
                }
                reliability = this.getUnrecoverableReliability();
                if (cATTransaction == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Setting unrecoverable reliability to max");
                    }
                    reliability = Reliability.ASSURED_PERSISTENT;
                }
                MPConsumerSession mPConsumerSession = (MPConsumerSession)this.getConsumerSession();
                mPConsumerSession.registerAsynchConsumerCallback((AsynchConsumerCallback)this.asynchReader, 0, 0L, 1, reliability, bl, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".receive"), (String)"3-020-0002", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                this.asynchReader.sendErrorToClient(sIException, "3-020-0002");
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "receive");
                }
                return;
            }
        } else {
            this.asynchReader.setComplete(false);
            this.asynchReader.setRequestNumber(n);
            this.asynchReader.setTransaction(cATTransaction);
        }
        try {
            if (this.logicallyStarted) {
                this.mainConsumer.getConsumerSession().activateAsynchConsumer(true);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".receive"), (String)"3-020-0003", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            this.asynchReader.sendErrorToClient(sIException, "3-020-0003");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "receive");
            }
            return;
        }
        if (!this.asynchReader.isComplete()) {
            if (l == -1L) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "No message received");
                }
                this.asynchReader.sendNoMessageToClient();
            } else {
                if (l != 0L) {
                    CATTimer cATTimer = new CATTimer(this.asynchReader);
                    reliability = AlarmManager.createNonDeferrable((long)l, (AlarmListener)cATTimer, (Object)new String("RQ: " + n));
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Setting async readers alarm to: " + ((Object)reliability).toString());
                    }
                    this.asynchReader.setCATTimer((Alarm)reliability);
                }
                this.asynchReader.setCurrentlyDoingReceiveWithWait(true);
                if (this.logicallyStarted) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Starting async consumer. Timeout = " + l + "ms");
                    }
                    this.mainConsumer.start(n, true);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receive");
        }
    }

    public void start(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "start");
        }
        this.logicallyStarted = true;
        if (this.asynchReader.isCurrentlyDoingReceiveWithWait()) {
            super.start(n, true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stop");
        }
        this.logicallyStarted = false;
        super.stop(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stop");
        }
    }

    public void close(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        if (this.asynchReader.isCurrentlyDoingReceiveWithWait()) {
            this.asynchReader.sendNoMessageToClient();
        }
        super.close(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public void setAsynchConsumerCallback(int n, int n2, long l, int n3, OrderingContext orderingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback");
        }
        this.mainConsumer.setAsynchConsumerCallback(n, n2, l, n3, orderingContext);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback");
        }
    }

    public String toString() {
        String string = "CATSessSyncConsumer@" + Integer.toHexString(this.hashCode()) + ": logicallyStarted: " + this.logicallyStarted + ", requestsReceived: " + this.requestsReceived + ", messagesSent: " + this.messagesSent;
        if (this.asynchReader != null) {
            string = string + ", " + this.asynchReader.toString();
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATSessSynchConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.37");
        }
    }
}

