/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATAsynchConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATBifurcatedConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATBrowseConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATProxyConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATSessSynchConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;

public class CATMainConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATMainConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATMainConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private Conversation conversation;
    private ConsumerSession consumerSession;
    private short clientSessionId;
    private CATConsumer subConsumer;
    private int lowestPriority = 11;
    private int requestedBytes;
    private short consumerSessionId;
    private boolean readAheadPermitted;
    private boolean noLocal;
    private boolean connectionReceive = false;
    private short messageBatchNumber = 0;
    private boolean started = false;
    private Reliability unrecoverableReliability = null;
    private boolean multicastSession = false;
    private BrowserSession browserSession = null;

    public CATMainConsumer(Conversation conversation, short s, ConsumerSession consumerSession, boolean bl, boolean bl2, boolean bl3, Reliability reliability) {
        this.conversation = conversation;
        this.clientSessionId = s;
        this.consumerSession = consumerSession;
        this.readAheadPermitted = bl;
        this.noLocal = bl3;
        this.unrecoverableReliability = reliability;
        this.multicastSession = bl2;
    }

    public CATMainConsumer(Conversation conversation, short s, BrowserSession browserSession) {
        this.conversation = conversation;
        this.clientSessionId = s;
        this.browserSession = browserSession;
        this.subConsumer = new CATBrowseConsumer(this);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean getUsingConnectionReceive() {
        return this.connectionReceive;
    }

    public void setUsingConnectionReceive(boolean bl) {
        this.connectionReceive = bl;
    }

    protected Conversation getConversation() {
        return this.conversation;
    }

    protected boolean getNoLocal() {
        this.checkNotBrowserSession();
        return this.noLocal;
    }

    protected boolean getReadAheadPermitted() {
        this.checkNotBrowserSession();
        return this.readAheadPermitted;
    }

    protected short getClientSessionId() {
        return this.clientSessionId;
    }

    protected void setClientSessionId(short s) {
        this.clientSessionId = s;
    }

    protected ConsumerSession getConsumerSession() {
        this.checkNotBrowserSession();
        return this.consumerSession;
    }

    protected int getLowestPriority() {
        this.checkNotBrowserSession();
        return this.lowestPriority;
    }

    protected void setLowestPriority(int n) {
        this.checkNotBrowserSession();
        if (n < this.lowestPriority) {
            this.lowestPriority = n;
        }
    }

    protected short getConsumerSessionId() {
        return this.consumerSessionId;
    }

    protected void setConsumerSessionId(short s) {
        this.consumerSessionId = s;
    }

    protected int getRequestedBytes() {
        return this.requestedBytes;
    }

    protected void setRequestedBytes(int n) {
        this.requestedBytes = n;
    }

    protected short getMessageBatchNumber() {
        this.checkNotBrowserSession();
        return this.messageBatchNumber;
    }

    protected void incremenetMessageBatchNumber() {
        this.checkNotBrowserSession();
        this.messageBatchNumber = (short)(this.messageBatchNumber + 1);
    }

    protected boolean getMulticast() {
        return this.multicastSession;
    }

    protected Reliability getUnrecoverableReliability() {
        return this.unrecoverableReliability;
    }

    protected boolean isRecoverable(SIBusMessage sIBusMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isRecoverable");
        }
        boolean bl = false;
        Reliability reliability = sIBusMessage.getReliability();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Message Reliability: ", reliability);
            SibTr.debug(tc, "Session Unrecoverable Reliability: ", this.getUnrecoverableReliability());
        }
        if (reliability.compareTo(this.getUnrecoverableReliability()) > 0) {
            bl = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Message is recoverable");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isRecoverable");
        }
        return bl;
    }

    public void receive(int n, CATTransaction cATTransaction, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receive");
        }
        if (this.subConsumer == null) {
            this.subConsumer = new CATSessSynchConsumer(this);
        }
        this.subConsumer.receive(n, cATTransaction, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receive");
        }
    }

    public void close(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        if (this.subConsumer != null) {
            this.subConsumer.close(n);
        } else {
            if (this.getMulticast()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Removing multicast consumer from conversation state");
                }
                ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
                conversationState.removeMulticastConsumer(this.getConsumerSession());
            }
            super.close(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public void setAsynchConsumerCallback(int n, int n2, long l, int n3, OrderingContext orderingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback");
        }
        this.checkNotBrowserSession();
        this.subConsumer = this.getReadAheadPermitted() ? new CATProxyConsumer(this) : new CATAsynchConsumer(this);
        this.subConsumer.setAsynchConsumerCallback(n, n2, l, n3, orderingContext);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setAsynchConsumerCallback");
        }
    }

    public void unsetAsynchConsumerCallback(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unsetAsynchConsumerCallback");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unsetAsynchConsumerCallback(n);
        }
        this.subConsumer = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unsetAsynchConsumerCallback");
        }
    }

    public void start(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "start");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.start(n, bl);
        } else {
            super.start(n, bl);
        }
        this.started = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stop");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.stop(n);
        } else {
            super.stop(n);
        }
        this.started = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stop");
        }
    }

    public void unlockSet(int n, SIMessageHandle[] sIMessageHandleArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockSet");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockSet(n, sIMessageHandleArray, bl);
        } else {
            super.unlockSet(n, sIMessageHandleArray, bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockSet");
        }
    }

    public void readSet(int n, SIMessageHandle[] sIMessageHandleArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readSet");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.readSet(n, sIMessageHandleArray);
        } else {
            super.readSet(n, sIMessageHandleArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readSet");
        }
    }

    public void readAndDeleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readAndDeleteSet");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.readAndDeleteSet(n, sIMessageHandleArray, cATTransaction);
        } else {
            super.readAndDeleteSet(n, sIMessageHandleArray, cATTransaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readAndDeleteSet");
        }
    }

    public void deleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSet");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.deleteSet(n, sIMessageHandleArray, cATTransaction, bl);
        } else {
            super.deleteSet(n, sIMessageHandleArray, cATTransaction, bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSet");
        }
    }

    public void unlockAll(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockAll(n);
        } else {
            super.unlockAll(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockAll");
        }
    }

    public void flush(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flush");
        }
        if (this.subConsumer != null) {
            this.subConsumer.flush(n);
        } else {
            super.flush(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flush");
        }
    }

    public void requestMsgs(int n, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "requestMsgs");
        }
        if (this.subConsumer != null) {
            this.subConsumer.requestMsgs(n, n2, n3);
        } else {
            super.requestMsgs(n, n2, n3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMsgs");
        }
    }

    private void checkNotBrowserSession() {
        if (this.browserSession != null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_UNEXPECTED_SICO2041", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".checkNotBrowserSession"), (String)"3-027-0001", (Object)this);
            throw sIErrorException;
        }
    }

    protected BrowserSession getBrowserSession() {
        if (this.browserSession == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_EXPECTED_SICO2042", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getBrowserSession"), (String)"3-027-0002", (Object)this);
            throw sIErrorException;
        }
        return this.browserSession;
    }

    public void setBifurcatedSession(BifurcatedConsumerSession bifurcatedConsumerSession) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBifurcatedSession");
        }
        this.subConsumer = new CATBifurcatedConsumer(this, bifurcatedConsumerSession);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBifurcatedSession");
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": started: " + this.started + ", readAhead: " + this.readAheadPermitted + ", unrecovReliability: " + this.unrecoverableReliability + ", batchNumber: " + this.messageBatchNumber + ", multicastSession: " + this.multicastSession + ", noLocal: " + this.noLocal + ", requestedBytes: " + this.requestedBytes + ", -> SubConsumer: " + this.subConsumer;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATMainConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.35");
        }
    }
}

