/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.List;

public abstract class CATConsumer {
    private static String CLASS_NAME = CATConsumer.class.getName();
    protected static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(CATConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    protected boolean started = false;
    protected long messagesSent = 0L;
    protected long batchesSent = 0L;
    protected long requestsReceived = 0L;

    public CATConsumer() {
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
    }

    protected abstract ConsumerSession getConsumerSession();

    protected abstract Conversation getConversation();

    protected abstract int getLowestPriority();

    protected abstract short getClientSessionId();

    protected abstract Reliability getUnrecoverableReliability();

    public void receive(int n, CATTransaction cATTransaction, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receive");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".receive"), (String)"3-019-0001", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receive");
        }
        throw sIErrorException;
    }

    public void close(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            ConsumerSession consumerSession = this.getConsumerSession();
            if (consumerSession != null) {
                consumerSession.close();
            }
            try {
                this.getConversation().send(list, 201, n, this.getLowestPriority(), true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-019-0003", (Object)this);
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2013", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-019-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-019-0002", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public void setAsynchConsumerCallback(int n, int n2, long l, int n3, OrderingContext orderingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-019-0004", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setAsynchConsumerCallback");
        }
        throw sIErrorException;
    }

    public void unsetAsynchConsumerCallback(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unsetAsynchConsumerCallback");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            this.getConsumerSession().deregisterAsynchConsumerCallback();
            try {
                this.getConversation().send(list, 212, n, this.getLowestPriority(), true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unsetAsynchConsumerCallback"), (String)"3-019-0012", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2013", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unsetAsynchConsumerCallback"), (String)"3-019-0013", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-019-0013", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unsetAsynchConsumerCallback");
        }
    }

    public void start(int n, boolean bl) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "start");
            }
            try {
                this.getConsumerSession().start(bl);
                this.started = true;
                ++this.requestsReceived;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".start"), (String)"3-019-0005", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stop");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            this.getConsumerSession().stop();
            this.started = false;
            try {
                this.getConversation().send(list, 214, n, this.getLowestPriority(), true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".stop"), (String)"3-019-0007", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2013", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".stop"), (String)"3-019-0006", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-019-0006", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stop");
        }
    }

    public void readSet(int n, SIMessageHandle[] sIMessageHandleArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readSet");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".readSet"), (String)"3-019-0016", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readSet");
        }
        throw sIErrorException;
    }

    public void readAndDeleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readAndDeleteSet");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-019-0017", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readAndDeleteSet");
        }
        throw sIErrorException;
    }

    public void unlockSet(int n, SIMessageHandle[] sIMessageHandleArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockSet");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-019-0008", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockSet");
        }
        throw sIErrorException;
    }

    public void deleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSet");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-019-0009", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSet");
        }
        throw sIErrorException;
    }

    public void unlockAll(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".unlockAll"), (String)"3-019-0010", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        throw sIErrorException;
    }

    public void requestMsgs(int n, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "requestMsgs");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".requestMsgs"), (String)"3-019-0011", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMsgs");
        }
        throw sIErrorException;
    }

    public void flush(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flush");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".flush"), (String)"3-019-0014", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flush");
        }
        throw sIErrorException;
    }

    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "reset");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".reset"), (String)"3-019-0015", (Object)this);
        SibTr.error(tc, "PROTOCOL_ERROR_SICO2003", sIErrorException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "reset");
        }
        throw sIErrorException;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": Started:" + this.started + ", messagesSent: " + this.messagesSent + ", batchesSent: " + this.batchesSent + ", startRequestsReceived: " + this.requestsReceived;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.39");
        }
    }
}

