/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.List;

public class CATBrowseConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATBrowseConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATBrowseConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private CATMainConsumer mainConsumer = null;
    private long sentBytes = 0L;
    private short msgBatch = 0;

    public CATBrowseConsumer(CATMainConsumer cATMainConsumer) {
        this.mainConsumer = cATMainConsumer;
    }

    private long sendMessage(SIBusMessage sIBusMessage, Conversation conversation, short s) throws OperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMessage", new Object[]{sIBusMessage, conversation, "" + s});
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        int n = 0;
        try {
            n = CommsUtils.encodeMessage(list, conversation, (JsMessage)sIBusMessage);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendMessage"), (String)"3-023-0001", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception(tc, exception);
            }
            SIResourceException sIResourceException = new SIResourceException();
            sIResourceException.initCause(exception);
            StaticCATHelper.sendExceptionToClient(sIResourceException, "3-023-0001", conversation, s);
            throw new OperationFailedException();
        }
        int n2 = 14;
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(n2);
        wsByteBuffer.putShort(conversationState.getConnectionObjectId());
        wsByteBuffer.putShort(this.mainConsumer.getClientSessionId());
        wsByteBuffer.putShort(this.msgBatch);
        wsByteBuffer.putLong((long)n);
        wsByteBuffer.flip();
        list.add(0, wsByteBuffer);
        long l = 0L;
        try {
            l = this.getConversation().send(list, 222, 0, -1, false, null, null);
            CommsPMI.getClientStats().onWriteMessage(n);
            CommsPMI.getClientDetailedStats().onSendMessage(-1);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendMessage"), (String)"3-023-0002", (Object)this);
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2012", sIException);
            throw new OperationFailedException();
        }
        finally {
            conversationState.returnList(list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMessage", (Object)("" + l));
        }
        return l;
    }

    private SIBusMessage getNextMessage(BrowserSession browserSession, Conversation conversation, short s) throws OperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getNextMessage", new Object[]{browserSession, conversation, "" + s});
        }
        SIBusMessage sIBusMessage = null;
        try {
            sIBusMessage = browserSession.next();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".getNextMessage"), (String)"3-023-0003", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-023-0003", conversation, s);
            throw new OperationFailedException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getNextMessage", sIBusMessage);
        }
        return sIBusMessage;
    }

    public void requestMsgs(int n, int n2, int n3) {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "requestMessages", new Object[]{"" + n, "" + n2, "" + n3});
            }
            BrowserSession browserSession = this.mainConsumer.getBrowserSession();
            Conversation conversation = this.getConversation();
            this.sentBytes -= (long)n2;
            try {
                for (boolean bl = this.sentBytes > (long)n3 ? true : false; !bl; bl |= this.sentBytes > (long)n3) {
                    SIBusMessage sIBusMessage = null;
                    sIBusMessage = this.getNextMessage(browserSession, conversation, (short)n);
                    boolean bl2 = bl = sIBusMessage == null;
                    if (bl) continue;
                    this.sentBytes += this.sendMessage(sIBusMessage, this.getConversation(), (short)n);
                }
            }
            catch (OperationFailedException operationFailedException) {
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception(tc, operationFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMessages");
        }
    }

    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        BrowserSession browserSession = this.mainConsumer.getBrowserSession();
        this.msgBatch = (short)(this.msgBatch + 1);
        browserSession.reset();
    }

    public void flush(int n) {
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "flush", (Object)("" + n));
            }
            BrowserSession browserSession = this.mainConsumer.getBrowserSession();
            SIBusMessage sIBusMessage = null;
            try {
                sIBusMessage = this.getNextMessage(browserSession, this.getConversation(), (short)n);
                if (sIBusMessage != null) {
                    this.sendMessage(sIBusMessage, this.getConversation(), (short)n);
                }
                ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
                List list = conversationState.getList();
                try {
                    this.getConversation().send(list, 215, n, -1, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".flush"), (String)"3-023-0004", (Object)this);
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2012", sIException);
                }
            }
            catch (OperationFailedException operationFailedException) {
                if (!tc.isEventEnabled()) break block7;
                SibTr.exception(tc, operationFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close", (Object)("" + n));
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        BrowserSession browserSession = this.mainConsumer.getBrowserSession();
        try {
            browserSession.close();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-023-0005", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-023-0005", this.getConversation(), n);
        }
        try {
            this.getConversation().send(list, 201, n, -1, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-023-0006", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
        }
        finally {
            conversationState.returnList(list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    protected ConsumerSession getConsumerSession() {
        return this.mainConsumer.getConsumerSession();
    }

    protected Conversation getConversation() {
        return this.mainConsumer.getConversation();
    }

    protected int getLowestPriority() {
        return this.mainConsumer.getLowestPriority();
    }

    protected short getClientSessionId() {
        return this.mainConsumer.getClientSessionId();
    }

    protected Reliability getUnrecoverableReliability() {
        return this.mainConsumer.getUnrecoverableReliability();
    }

    private class OperationFailedException
    extends Exception {
        private static final long serialVersionUID = -5191481178136106792L;

        private OperationFailedException() {
        }
    }
}

