/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.List;

public class CATBifurcatedConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATBifurcatedConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATBifurcatedConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private CATMainConsumer mainConsumer;
    private BifurcatedConsumerSession bifSession = null;

    public CATBifurcatedConsumer(CATMainConsumer cATMainConsumer, BifurcatedConsumerSession bifurcatedConsumerSession) {
        this.mainConsumer = cATMainConsumer;
        this.bifSession = bifurcatedConsumerSession;
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
    }

    protected ConsumerSession getConsumerSession() {
        return null;
    }

    protected Conversation getConversation() {
        return this.mainConsumer.getConversation();
    }

    protected int getLowestPriority() {
        return this.mainConsumer.getLowestPriority();
    }

    protected short getClientSessionId() {
        return this.mainConsumer.getClientSessionId();
    }

    protected Reliability getUnrecoverableReliability() {
        return this.mainConsumer.getUnrecoverableReliability();
    }

    public void close(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            this.bifSession.close();
            try {
                this.getConversation().send(list, 201, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-025-0012", (Object)this);
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2033", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".close"), (String)"3-025-0013", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-025-0013", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public void readSet(int n, SIMessageHandle[] sIMessageHandleArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to read " + sIMessageHandleArray.length + " message(s)");
        }
        try {
            SIBusMessage[] sIBusMessageArray = this.bifSession.readSet(sIMessageHandleArray);
            ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
            List list = conversationState.getList();
            WsByteBuffer wsByteBuffer = bbPoolManager.allocate(4);
            wsByteBuffer.putInt(sIBusMessageArray.length);
            wsByteBuffer.flip();
            list.add(wsByteBuffer);
            for (int i = 0; i < sIBusMessageArray.length; ++i) {
                this.addSIBusMessageToList(list, sIBusMessageArray[i]);
            }
            try {
                this.getConversation().send(list, 234, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".readSet"), (String)"3-025-0007", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2033", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".readSet"), (String)"3-025-0008", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-025-0008", this.getConversation(), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readSet");
        }
    }

    public void readAndDeleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readAndDeleteSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to read / delete " + sIMessageHandleArray.length + " message(s)");
        }
        try {
            SITransaction sITransaction = null;
            if (cATTransaction != null) {
                sITransaction = cATTransaction.getSITransaction();
            }
            SIBusMessage[] sIBusMessageArray = this.bifSession.readAndDeleteSet(sIMessageHandleArray, sITransaction);
            ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
            List list = conversationState.getList();
            WsByteBuffer wsByteBuffer = bbPoolManager.allocate(4);
            wsByteBuffer.putInt(sIBusMessageArray.length);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Added length of: " + sIBusMessageArray.length);
            }
            wsByteBuffer.flip();
            list.add(wsByteBuffer);
            for (int i = 0; i < sIBusMessageArray.length; ++i) {
                this.addSIBusMessageToList(list, sIBusMessageArray[i]);
            }
            try {
                this.getConversation().send(list, 235, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-025-0009", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2033", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-025-0010", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-025-0010", this.getConversation(), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readAndDeleteSet");
        }
    }

    public void unlockSet(int n, SIMessageHandle[] sIMessageHandleArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to delete " + sIMessageHandleArray.length + " message(s)");
            if (bl) {
                SibTr.debug(tc, "The client is expecting a reply");
            }
        }
        try {
            this.bifSession.unlockSet(sIMessageHandleArray);
            if (bl) {
                ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
                List list = conversationState.getList();
                try {
                    this.getConversation().send(list, 233, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0005", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2033", sIException);
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0006", (Object)this);
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-025-0006", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_UNLOCK_MSGS_SICO2032", sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockSet");
        }
    }

    public void deleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to delete " + sIMessageHandleArray.length + " message(s)");
            if (bl) {
                SibTr.debug(tc, "Client is expecting a reply");
            }
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            SITransaction sITransaction = null;
            if (cATTransaction != null) {
                sITransaction = cATTransaction.getSITransaction();
            }
            this.bifSession.deleteSet(sIMessageHandleArray, sITransaction);
            try {
                if (bl) {
                    this.getConversation().send(list, 219, n, 7, true, null, null);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-025-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2033", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-025-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            if (cATTransaction != null) {
                cATTransaction.markAsError(sIException);
            }
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-025-0003", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_DELETE_MSGS_SICO2034", sIException);
            StaticCATHelper.sendAsyncExceptionToClient(sIException, "3-025-0004", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSet");
        }
    }

    private void addSIBusMessageToList(List list, SIBusMessage sIBusMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "addSIBusMessageToList");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list2 = conversationState.getList();
        int n = 0;
        try {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Encoding JsMessage");
            }
            n = CommsUtils.encodeMessage(list2, this.getConversation(), (JsMessage)sIBusMessage);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".addSIBusMessageToList"), (String)"3-025-0011", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Encode failed: " + exception.getMessage(), exception);
            }
            throw new SIResourceException(exception);
        }
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(8);
        wsByteBuffer.putLong((long)n);
        wsByteBuffer.flip();
        list.add(wsByteBuffer);
        list.addAll(list2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "addSIBusMessageToList");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATBifurcatedConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }
}

