/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.List;

public class CATAsynchConsumer
extends CATConsumer
implements AsynchConsumerCallback {
    private static String CLASS_NAME = CATAsynchConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATAsynchConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private CATMainConsumer mainConsumer;

    public CATAsynchConsumer(CATMainConsumer cATMainConsumer) {
        this.mainConsumer = cATMainConsumer;
    }

    protected ConsumerSession getConsumerSession() {
        return this.mainConsumer.getConsumerSession();
    }

    protected Conversation getConversation() {
        return this.mainConsumer.getConversation();
    }

    protected int getLowestPriority() {
        return this.mainConsumer.getLowestPriority();
    }

    protected short getClientSessionId() {
        return this.mainConsumer.getClientSessionId();
    }

    protected Reliability getUnrecoverableReliability() {
        return this.mainConsumer.getUnrecoverableReliability();
    }

    protected boolean isRecoverable(SIBusMessage sIBusMessage) {
        return this.mainConsumer.isRecoverable(sIBusMessage);
    }

    public void setAsynchConsumerCallback(int n, int n2, long l, int n3, OrderingContext orderingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback", new Object[]{"" + n, "" + n3, orderingContext});
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            boolean bl = CommsUtils.getRuntimeBooleanProperty("sib.comms.InlineAsyncCBacks", CommsConstants.INLINE_ASYNC_CBACKS);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Inline async callbacks: " + bl);
            }
            MPConsumerSession mPConsumerSession = (MPConsumerSession)this.getConsumerSession();
            mPConsumerSession.registerAsynchConsumerCallback((AsynchConsumerCallback)this, n2, l, n3, this.getUnrecoverableReliability(), bl, orderingContext);
            try {
                this.getConversation().send(list, 211, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-018-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-018-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-018-0002", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setAsynchConsumerCallback");
        }
    }

    public void unlockSet(int n, SIMessageHandle[] sIMessageHandleArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to unlock " + sIMessageHandleArray.length + " message(s)");
        }
        try {
            this.getConsumerSession().unlockSet(sIMessageHandleArray);
            if (bl) {
                ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
                List list = conversationState.getList();
                try {
                    this.getConversation().send(list, 233, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0004", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0003", (Object)this);
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-018-0003", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_UNLOCK_MSGS_SICO2002", sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockSet");
        }
    }

    public void deleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to delete " + sIMessageHandleArray.length + " message(s)");
            if (bl) {
                SibTr.debug(tc, "Client is expecting a reply");
            }
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            SITransaction sITransaction = null;
            if (cATTransaction != null) {
                sITransaction = cATTransaction.getSITransaction();
            }
            this.getConsumerSession().deleteSet(sIMessageHandleArray, sITransaction);
            try {
                if (bl) {
                    this.getConversation().send(list, 219, n, 7, true, null, null);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-024-0003", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-018-0005", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            if (cATTransaction != null) {
                cATTransaction.markAsError(sIException);
            }
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-018-0005", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_DELETE_MSGS_SICO2028", sIException);
            StaticCATHelper.sendAsyncExceptionToClient(sIException, "3-018-0005", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
                this.started = false;
            }
            CATAsynchConsumer cATAsynchConsumer = this;
            synchronized (cATAsynchConsumer) {
                this.mainConsumer.incremenetMessageBatchNumber();
                this.getConsumerSession().unlockAll();
            }
            short s = JFapChannelConstants.getJFAPPriority(new Integer(this.mainConsumer.getLowestPriority()));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Sending with JFAP priority of " + s);
            }
            try {
                this.getConversation().send(list, 216, n, s, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0007", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
            }
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().start(false);
                this.started = true;
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0006", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-018-0006", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockAll");
        }
    }

    public void flush(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flush", (Object)("" + n));
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
            }
            this.getConsumerSession().activateAsynchConsumer(true);
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().start(false);
            }
            short s = JFapChannelConstants.getJFAPPriority(new Integer(this.mainConsumer.getLowestPriority()));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Sending with JFAP priority of " + s);
            }
            try {
                this.getConversation().send(list, 215, n, s, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".flush"), (String)"3-024-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".flush"), (String)"3-024-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-024-0002", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flush");
        }
    }

    private boolean sendMessage(SIBusMessage sIBusMessage, boolean bl, Integer n) throws MessageEncodeFailedException, IncorrectMessageTypeException, MessageCopyFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMessage");
        }
        if (bl && tc.isDebugEnabled()) {
            SibTr.debug(tc, "Sending last in batch");
        }
        LinkLevelState linkLevelState = (LinkLevelState)this.getConversation().getLinkLevelAttachment();
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        Object var7_7 = null;
        boolean bl2 = true;
        int n2 = 0;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoding JsMessage");
        }
        n2 = CommsUtils.encodeMessage(list, this.getConversation(), (JsMessage)sIBusMessage);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Completed");
        }
        List list2 = conversationState.getList();
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(16);
        short s = 0;
        if (bl) {
            s = (short)(s | 1);
        }
        wsByteBuffer.putShort(conversationState.getConnectionObjectId());
        wsByteBuffer.putShort(this.mainConsumer.getClientSessionId());
        wsByteBuffer.putShort(s);
        wsByteBuffer.putShort(this.mainConsumer.getMessageBatchNumber());
        wsByteBuffer.putLong((long)n2);
        wsByteBuffer.flip();
        list2.add(wsByteBuffer);
        list2.addAll(list);
        short s2 = JFapChannelConstants.getJFAPPriority(n);
        try {
            this.getConversation().send(list2, 221, 0, s2, false, null, null);
            CommsPMI.getClientStats().onWriteMessage(n2);
            CommsPMI.getClientDetailedStats().onSendMessage(s2);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendMessage"), (String)"3-018-0008", (Object)this);
            bl2 = false;
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2017", sIException);
        }
        conversationState.returnList(list2);
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMessage");
        }
        return bl2;
    }

    public synchronized void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "consumeMessages");
        }
        Integer n = new Integer(0);
        int n2 = 0;
        SIBusMessage sIBusMessage = null;
        block4: while (true) {
            try {
                while (true) {
                    if ((sIBusMessage = lockedMessageEnumeration.nextLocked()) == null) {
                        lockedMessageEnumeration.resetCursor();
                        break block4;
                    }
                    ++n2;
                    Integer n3 = sIBusMessage.getPriority();
                    if (n3 > n) {
                        n = n3;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug(tc, "Message " + sIBusMessage.getMessageHandle() + " has priority " + n3);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-018-0009", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                StaticCATHelper.sendAsyncExceptionToClient(sIException, "3-018-0009", this.getClientSessionId(), this.getConversation(), 0);
                continue;
            }
            break;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "There are " + n2 + " messages in the LME");
            SibTr.debug(tc, "The highest message priority is " + n);
        }
        boolean bl = true;
        for (int i = 0; i < n2 && bl; ++i) {
            try {
                sIBusMessage = lockedMessageEnumeration.nextLocked();
                if (i + 1 == n2) {
                    this.getConsumerSession().stop();
                    this.started = false;
                    ++this.batchesSent;
                    ++this.messagesSent;
                    bl = this.sendMessage(sIBusMessage, true, n);
                } else {
                    bl = this.sendMessage(sIBusMessage, false, n);
                    ++this.messagesSent;
                }
                if (this.isRecoverable(sIBusMessage)) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Deleting message");
                }
                lockedMessageEnumeration.deleteCurrent(null);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-018-0010");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, exception.getMessage(), exception);
                }
                StaticCATHelper.sendAsyncExceptionToClient(exception, "3-018-0010", this.getClientSessionId(), this.getConversation(), 0);
            }
        }
        this.mainConsumer.setLowestPriority(JFapChannelConstants.getJFAPPriority(n));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "consumeMessages");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATAsynchConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.58");
        }
    }
}

