/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.IdToObjectMap;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.xa.Xid;

public class TransactionToDispatchableMap {
    private static final TraceComponent tc = SibTr.register(TransactionToDispatchableMap.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = TransactionToDispatchableMap.class.getName();
    private final IdToObjectMap idToFirstLevelEntryMap = new IdToObjectMap();

    public Dispatchable addDispatchableForLocalTransaction(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addDispatchableForLocalTransaction", "" + n);
        }
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            SIErrorException sIErrorException = new SIErrorException("5-005-0001");
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".addDispatchableForLocalTransaction"), (String)"5-005-0001", (Object[])new Object[]{"" + n, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIErrorException);
            }
            throw sIErrorException;
        }
        LocalFirstLevelMapEntry localFirstLevelMapEntry = new LocalFirstLevelMapEntry();
        Dispatchable dispatchable = localFirstLevelMapEntry.getDispatchable();
        this.idToFirstLevelEntryMap.put(n, localFirstLevelMapEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addDispatchableForLocalTransaction", dispatchable);
        }
        return dispatchable;
    }

    public Dispatchable addEnlistedDispatchableForGlobalTransaction(int n, Xid xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addEnlistedDispatchableForGlobalTransaction", new Object[]{"" + n, xid});
        }
        AbstractFirstLevelMapEntry abstractFirstLevelMapEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            abstractFirstLevelMapEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(n);
        }
        GlobalFirstLevelMapEntry globalFirstLevelMapEntry = null;
        if (abstractFirstLevelMapEntry == null) {
            globalFirstLevelMapEntry = new GlobalFirstLevelMapEntry();
            this.idToFirstLevelEntryMap.put(n, globalFirstLevelMapEntry);
        } else {
            if (abstractFirstLevelMapEntry.isLocalTransaction()) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0002");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".addEnlistedDispatchableForGlobalTransaction"), (String)"5-005-0002", (Object[])new Object[]{"" + n, xid, this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            globalFirstLevelMapEntry = (GlobalFirstLevelMapEntry)abstractFirstLevelMapEntry;
        }
        Dispatchable dispatchable = globalFirstLevelMapEntry.createNewEnlistedDispatchable(xid);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addEnlistedDispatchableForGlobalTransaction", dispatchable);
        }
        return dispatchable;
    }

    public void markDispatchableAsNotEnlisted(int n, Xid xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "markDispatchableAsNotEnlisted", new Object[]{"" + n, xid});
        }
        AbstractFirstLevelMapEntry abstractFirstLevelMapEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            abstractFirstLevelMapEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(n);
        }
        if (abstractFirstLevelMapEntry == null || abstractFirstLevelMapEntry.isLocalTransaction()) {
            SIErrorException sIErrorException = new SIErrorException("5-005-0003");
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".markDispatchableAsNotEnlisted"), (String)"5-005-0003", (Object[])new Object[]{"" + n, xid, abstractFirstLevelMapEntry, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIErrorException);
            }
            throw sIErrorException;
        }
        GlobalFirstLevelMapEntry globalFirstLevelMapEntry = (GlobalFirstLevelMapEntry)abstractFirstLevelMapEntry;
        globalFirstLevelMapEntry.markDispatchableAsNotEnlisted();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "markDispatchableAsNotEnlisted");
        }
    }

    public Dispatchable getDispatchable(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDispatchable", "" + n);
        }
        AbstractFirstLevelMapEntry abstractFirstLevelMapEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            abstractFirstLevelMapEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(n);
        }
        Dispatchable dispatchable = abstractFirstLevelMapEntry == null ? null : (abstractFirstLevelMapEntry.isLocalTransaction() ? ((LocalFirstLevelMapEntry)abstractFirstLevelMapEntry).getDispatchable() : ((GlobalFirstLevelMapEntry)abstractFirstLevelMapEntry).getEnlistedDispatchable());
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDispatchable", dispatchable);
        }
        return dispatchable;
    }

    public Dispatchable removeDispatchableForLocalTransaction(int n) {
        Dispatchable dispatchable;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeDispatchableForLocalTransaction", "" + n);
        }
        AbstractFirstLevelMapEntry abstractFirstLevelMapEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            abstractFirstLevelMapEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(n);
        }
        if (abstractFirstLevelMapEntry == null) {
            dispatchable = null;
        } else if (abstractFirstLevelMapEntry.isLocalTransaction()) {
            dispatchable = ((LocalFirstLevelMapEntry)abstractFirstLevelMapEntry).getDispatchable();
            this.idToFirstLevelEntryMap.remove(n);
        } else {
            SIErrorException sIErrorException = new SIErrorException("5-005-0004");
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".removeDispatchableForLocalTransaction"), (String)"5-005-0004", (Object[])new Object[]{"" + n, abstractFirstLevelMapEntry, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIErrorException);
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeDispatchableForLocalTransaction", dispatchable);
        }
        return dispatchable;
    }

    public Dispatchable removeDispatchableForGlobalTransaction(int n, Xid xid) {
        Dispatchable dispatchable;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeDispatchableForGlobalTransaction", new Object[]{"" + n, xid});
        }
        AbstractFirstLevelMapEntry abstractFirstLevelMapEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(n)) {
            abstractFirstLevelMapEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(n);
        }
        if (abstractFirstLevelMapEntry == null) {
            dispatchable = null;
        } else if (!abstractFirstLevelMapEntry.isLocalTransaction()) {
            GlobalFirstLevelMapEntry globalFirstLevelMapEntry = (GlobalFirstLevelMapEntry)abstractFirstLevelMapEntry;
            dispatchable = globalFirstLevelMapEntry.removeDispatchable(xid);
            if (globalFirstLevelMapEntry.isEmpty()) {
                this.idToFirstLevelEntryMap.remove(n);
            }
        } else {
            SIErrorException sIErrorException = new SIErrorException("5-005-0005");
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".removeDispatchableForGlobalTransaction"), (String)"5-005-0005", (Object[])new Object[]{"" + n, xid, abstractFirstLevelMapEntry, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIErrorException);
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeDispatchableForGlobalTransaction", dispatchable);
        }
        return dispatchable;
    }

    public int getTotalDispatchables() {
        int n = 0;
        Iterator iterator = this.idToFirstLevelEntryMap.iterator();
        while (iterator.hasNext()) {
            ++n;
        }
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/TransactionToDispatchableMap.java, SIB.comms, WAS602.SIB, o0610.11 1.1");
        }
    }

    private class DispatchableImpl
    implements Dispatchable {
        private DispatchQueue queue;
        private Object dispatchLockObject = new Object();
        private int refCount;

        private DispatchableImpl() {
        }

        public void setDispatchQueue(DispatchQueue dispatchQueue) {
            this.queue = dispatchQueue;
        }

        public DispatchQueue getDispatchQueue() {
            return this.queue;
        }

        public Object getDispatchLockObject() {
            return this.dispatchLockObject;
        }

        public void incrementDispatchQueueRefCount() {
            ++this.refCount;
        }

        public void decrementDispatchQueueRefCount() {
            --this.refCount;
        }

        public int getDispatchQueueRefCount() {
            return this.refCount;
        }
    }

    private class GlobalFirstLevelMapEntry
    extends AbstractFirstLevelMapEntry {
        private Dispatchable enlistedDispatchable;
        private Xid enlistedXid;
        private HashMap unenlistedXidToDispatchableMap;

        private GlobalFirstLevelMapEntry() {
            this.unenlistedXidToDispatchableMap = new HashMap();
        }

        public boolean isLocalTransaction() {
            return false;
        }

        public Dispatchable getEnlistedDispatchable() {
            if (this.enlistedDispatchable == null) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0006");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".GlobalFirstLevelMapEntry.getEnlistedDispatchable"), (String)"5-005-0006", (Object[])new Object[]{TransactionToDispatchableMap.this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            return this.enlistedDispatchable;
        }

        public Dispatchable createNewEnlistedDispatchable(Xid xid) {
            if (this.enlistedDispatchable != null) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0007");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".GlobalFirstLevelMapEntry.createNewEnlistedDispatchable"), (String)"5-005-0007", (Object[])new Object[]{TransactionToDispatchableMap.this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            this.enlistedXid = xid;
            this.enlistedDispatchable = new DispatchableImpl();
            return this.enlistedDispatchable;
        }

        public void markDispatchableAsNotEnlisted() {
            if (this.enlistedDispatchable == null) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0008");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".GlobalFirstLevelMapEntry.markDispatchableAsNotEnlisted"), (String)"5-005-0008", (Object[])new Object[]{TransactionToDispatchableMap.this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            if (this.unenlistedXidToDispatchableMap.containsKey(this.enlistedXid)) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0009");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".GlobalFirstLevelMapEntry.markDispatchableAsNotEnlisted"), (String)"5-005-0009", (Object[])new Object[]{this.unenlistedXidToDispatchableMap, this.enlistedXid, TransactionToDispatchableMap.this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            this.unenlistedXidToDispatchableMap.put(this.enlistedXid, this.enlistedDispatchable);
            this.enlistedDispatchable = null;
            this.enlistedXid = null;
        }

        public Dispatchable removeDispatchable(Xid xid) {
            if (this.enlistedXid != null && this.enlistedXid.equals(xid)) {
                SIErrorException sIErrorException = new SIErrorException("5-005-0010");
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".GlobalFirstLevelMapEntry.removeDispatchable"), (String)"5-005-0010", (Object[])new Object[]{this.enlistedXid, xid, TransactionToDispatchableMap.this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, sIErrorException);
                }
                throw sIErrorException;
            }
            Dispatchable dispatchable = (Dispatchable)this.unenlistedXidToDispatchableMap.remove(xid);
            return dispatchable;
        }

        boolean isEmpty() {
            return this.enlistedDispatchable == null && this.unenlistedXidToDispatchableMap.isEmpty();
        }
    }

    private class LocalFirstLevelMapEntry
    extends AbstractFirstLevelMapEntry {
        private Dispatchable dispatchable;

        private LocalFirstLevelMapEntry() {
            this.dispatchable = new DispatchableImpl();
        }

        public boolean isLocalTransaction() {
            return true;
        }

        public Dispatchable getDispatchable() {
            return this.dispatchable;
        }
    }

    private abstract class AbstractFirstLevelMapEntry {
        private AbstractFirstLevelMapEntry() {
        }

        public abstract boolean isLocalTransaction();
    }
}

