/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.comms.server.mesupport.METransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class GenericTransportReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = GenericTransportReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(GenericTransportReceiveListener.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static GenericTransportReceiveListener instance;
    private static METransportAcceptListener meTransportAcceptListener;
    private static ServerTransportAcceptListener serverTransportAcceptListener;

    protected static GenericTransportReceiveListener getInstance() {
        return instance;
    }

    public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dataReceived");
        }
        ConversationReceiveListener conversationReceiveListener = null;
        int n4 = -1;
        LinkLevelState linkLevelState = null;
        if (tc.isDebugEnabled()) {
            objectArray = new Object[]{new String("Segment type  : " + JFapChannelConstants.getSegmentName(n) + " - " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3), new String("Exchange?     : " + bl2)};
            SibTr.debug(tc, "Data information:", objectArray);
        }
        if (n == 6) {
            wsByteBuffer.flip();
            n4 = wsByteBuffer.get();
            switch (n4) {
                case 1: {
                    conversationReceiveListener = serverTransportAcceptListener.acceptConnection(conversation);
                    linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                    linkLevelState.setConnectionType(1);
                    break;
                }
                case 2: {
                    conversationReceiveListener = meTransportAcceptListener.acceptConnection(conversation);
                    linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                    linkLevelState.setConnectionType(2);
                    break;
                }
                default: {
                    objectArray = nls.getFormattedMessage("INVALID_PROP_SICO8008", new Object[]{"" + n4}, null);
                    SIConnectionLostException sIConnectionLostException = new SIConnectionLostException((String)objectArray);
                    StaticCATHelper.sendExceptionToClient(sIConnectionLostException, null, conversation, n2);
                    break;
                }
            }
        } else {
            linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            n4 = linkLevelState.getConnectionType();
            switch (n4) {
                case 1: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Conversation was initiated by a Client. Filtering accordingly");
                    }
                    conversationReceiveListener = serverTransportAcceptListener.acceptConnection(conversation);
                    break;
                }
                case 2: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Conversation was initiated by an ME. Filtering accordingly");
                    }
                    conversationReceiveListener = meTransportAcceptListener.acceptConnection(conversation);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug(tc, "Conversation was initiated by an unknown entity ", (Object)("" + n4));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "dataReceived", conversationReceiveListener);
        }
        return conversationReceiveListener;
    }

    public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "errorOccurred");
        }
        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-001-0001", (Object)this);
        if (tc.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new String("Segment type  : " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3)};
            SibTr.debug(tc, "Received an error in the GenericTransportReceiveListener", objectArray);
            SibTr.debug(tc, "Primary exception:");
            SibTr.exception(tc, sIConnectionLostException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "errorOccurred");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getThreadContext");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getThreadContext", null);
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/GenericTransportReceiveListener.java, SIB.comms, WAS602.SIB, o0610.11 1.27");
        }
        instance = new GenericTransportReceiveListener();
        meTransportAcceptListener = METransportAcceptListener.getInstance();
        serverTransportAcceptListener = ServerTransportAcceptListener.getInstance();
    }
}

