/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.pmi;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.pmi.StatsUpdateListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;

public class MEStats
implements StatisticActionListener {
    private static final TraceComponent tc = SibTr.register(MEStats.class, "SIBCommunications", null);
    private StatsInstance stats = null;
    private boolean pmiEnabled = false;
    private static final int CLIENTS_ATTACHED_ID = 1;
    private static final int API_CONNECTIONS_ID = 2;
    private static final int ERRORS_ID = 3;
    private static final int WRITES_ID = 4;
    private static final int READS_ID = 5;
    private static final int WRITES_BLOCKED_ID = 6;
    private static final int READS_BLOCKED_ID = 7;
    private static final int BUFFERED_WRITE_BYTES_ID = 10;
    private static final int BUFFERED_READ_BYTES_ID = 11;
    private static final int MESSAGE_BYTES_WRITTEN_ID = 12;
    private static final int MESSAGE_BYTES_READ_ID = 13;
    private static final int TOTAL_BYTES_WRITTEN_ID = 14;
    private static final int TOTAL_BYTES_READ_ID = 15;
    private SPICountStatistic clientsAttached = null;
    private SPICountStatistic apiConnections = null;
    private SPICountStatistic errors = null;
    private SPICountStatistic writes = null;
    private SPICountStatistic reads = null;
    private SPICountStatistic writesBlocked = null;
    private SPICountStatistic readsBlocked = null;
    private SPICountStatistic bufferedWriteBytes = null;
    private SPICountStatistic bufferedReadBytes = null;
    private SPICountStatistic messageBytesWritten = null;
    private SPICountStatistic messageBytesRead = null;
    private SPICountStatistic totalBytesWritten = null;
    private SPICountStatistic totalBytesRead = null;
    private ArrayList bufferedReadsListeners = new ArrayList();
    private ArrayList bufferedWritesListeners = new ArrayList();

    public void setPMIEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setPMIEnabled", (Object)("" + bl));
        }
        this.pmiEnabled = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setPMIEnabled");
        }
    }

    protected void setStatsInstance(StatsInstance statsInstance) {
        this.stats = statsInstance;
    }

    public void addBufferedReadsUpdateListener(StatsUpdateListener statsUpdateListener) {
        this.addGenericUpdateListener(statsUpdateListener, this.bufferedReadsListeners);
    }

    public boolean removeBufferedReadsUpdateListener(StatsUpdateListener statsUpdateListener) {
        return this.removeGenericUpdateListener(statsUpdateListener, this.bufferedReadsListeners);
    }

    public void addBufferedWritesUpdateListener(StatsUpdateListener statsUpdateListener) {
        this.addGenericUpdateListener(statsUpdateListener, this.bufferedWritesListeners);
    }

    public boolean removeBufferedWritesUpdateListener(StatsUpdateListener statsUpdateListener) {
        return this.removeGenericUpdateListener(statsUpdateListener, this.bufferedWritesListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGenericUpdateListener(StatsUpdateListener statsUpdateListener, ArrayList arrayList) {
        if (this.pmiEnabled && statsUpdateListener != null) {
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                if (!arrayList.contains(statsUpdateListener)) {
                    arrayList.add(statsUpdateListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeGenericUpdateListener(StatsUpdateListener statsUpdateListener, ArrayList arrayList) {
        boolean bl = false;
        if (this.pmiEnabled && statsUpdateListener != null) {
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                bl = arrayList.remove(statsUpdateListener);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int gatherGenericUpdateListenerStats(ArrayList arrayList) {
        int n = 0;
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                StatsUpdateListener statsUpdateListener = (StatsUpdateListener)arrayList.get(i);
                try {
                    n += statsUpdateListener.statChanged();
                    continue;
                }
                catch (Throwable throwable) {
                    if (!tc.isEventEnabled()) continue;
                    SibTr.exception((Object)this, tc, throwable);
                }
            }
        }
        return n;
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "statisticCreated", sPIStatistic);
        }
        switch (sPIStatistic.getId()) {
            case 1: {
                this.clientsAttached = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this.apiConnections = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this.errors = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this.writes = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this.reads = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this.writesBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this.readsBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this.bufferedWriteBytes = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this.bufferedReadBytes = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this.messageBytesWritten = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this.messageBytesRead = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this.totalBytesWritten = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 15: {
                this.totalBytesRead = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug(tc, "Received an unknown stat Id", (Object)("" + sPIStatistic.getId()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "updateStatisticOnRequest", (Object)("" + n));
        }
        switch (n) {
            case 10: {
                if (!this.pmiEnabled || !this.bufferedWriteBytes.isEnabled()) break;
                this.bufferedWriteBytes.setCount((long)this.gatherGenericUpdateListenerStats(this.bufferedWritesListeners));
                break;
            }
            case 11: {
                if (!this.pmiEnabled || !this.bufferedReadBytes.isEnabled()) break;
                this.bufferedReadBytes.setCount((long)this.gatherGenericUpdateListenerStats(this.bufferedReadsListeners));
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug(tc, "Received an request for update on an unexpected stat", (Object)("" + n));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "updateStatisticOnRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientAttach() {
        if (this.pmiEnabled && this.clientsAttached != null && this.clientsAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.clientsAttached;
            synchronized (sPICountStatistic) {
                this.clientsAttached.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientDetach() {
        if (this.pmiEnabled && this.clientsAttached != null && this.clientsAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.clientsAttached;
            synchronized (sPICountStatistic) {
                this.clientsAttached.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApiConnect() {
        if (this.pmiEnabled && this.apiConnections != null && this.apiConnections.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.apiConnections;
            synchronized (sPICountStatistic) {
                this.apiConnections.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApiDisconnect() {
        if (this.pmiEnabled && this.apiConnections != null && this.apiConnections.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.apiConnections;
            synchronized (sPICountStatistic) {
                this.apiConnections.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError() {
        if (this.pmiEnabled && this.errors != null && this.errors.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.errors;
            synchronized (sPICountStatistic) {
                this.errors.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWrite() {
        if (this.pmiEnabled && this.writes != null && this.writes.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.writes;
            synchronized (sPICountStatistic) {
                this.writes.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRead() {
        if (this.pmiEnabled && this.reads != null && this.reads.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.reads;
            synchronized (sPICountStatistic) {
                this.reads.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteBlocked() {
        if (this.pmiEnabled && this.writesBlocked != null && this.writesBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.writesBlocked;
            synchronized (sPICountStatistic) {
                this.writesBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadBlocked() {
        if (this.pmiEnabled && this.readsBlocked != null && this.readsBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.readsBlocked;
            synchronized (sPICountStatistic) {
                this.readsBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteMessage(int n) {
        if (this.pmiEnabled && this.messageBytesWritten != null && this.messageBytesWritten.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messageBytesWritten;
            synchronized (sPICountStatistic) {
                this.messageBytesWritten.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadMessage(int n) {
        if (this.pmiEnabled && this.messageBytesRead != null && this.messageBytesRead.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messageBytesRead;
            synchronized (sPICountStatistic) {
                this.messageBytesRead.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteBytes(int n) {
        if (this.pmiEnabled && this.totalBytesWritten != null && this.totalBytesWritten.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.totalBytesWritten;
            synchronized (sPICountStatistic) {
                this.totalBytesWritten.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadBytes(int n) {
        if (this.pmiEnabled && this.totalBytesRead != null && this.totalBytesRead.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.totalBytesRead;
            synchronized (sPICountStatistic) {
                this.totalBytesRead.increment((long)n);
            }
        }
    }
}

