/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIDataGraphException;
import com.ibm.websphere.sib.exception.SIDataGraphFormatMismatchException;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIMessageDomainNotSupportedException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.xa.XAException;

public class JFAPCommunicator {
    private static String CLASS_NAME = JFAPCommunicator.class.getName();
    private static final long MAX_MESSAGE_SIZE = 10000L;
    private static final short HEARTBEAT_INTERVAL = 300;
    private static final short CAPABILITIES_DEFAULT = 7;
    private static final String CAPABILITIES_VALUE = CommsUtils.getRuntimeProperty("sib.comms.Capabilities", Integer.toString(7));
    private static final short CAPABILITIES = new Integer(CAPABILITIES_VALUE).shortValue();
    private static final int MAX_TRANSMISSION_SIZE = 10000;
    private ClientConversationState cConState = null;
    private ConversationState sConState = null;
    private boolean serverMode = false;
    private Conversation con = null;
    private static CommsString cStr = new CommsString();
    private static final TraceComponent tc = SibTr.register(JFAPCommunicator.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public JFAPCommunicator(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", "" + bl);
        }
        this.serverMode = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected Conversation getConversation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConversation");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConversation", this.con);
        }
        return this.con;
    }

    protected void setConversation(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConversation", conversation);
        }
        this.con = conversation;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConversation");
        }
    }

    protected int getConnectionObjectID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConnectionObjectID");
        }
        int n = 0;
        this.validateConversationState();
        n = this.serverMode ? this.sConState.getConnectionObjectId() : this.cConState.getConnectionObjectID();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getConnectionObjectID", (Object)("" + n));
        }
        return n;
    }

    protected void setConnectionObjectID(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConnectionObjectID", "" + n);
        }
        this.validateConversationState();
        if (this.serverMode) {
            this.sConState.setConnectionObjectId((short)n);
        } else {
            this.cConState.setConnectionObjectID(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConnectionObjectID");
        }
    }

    protected CommsConnection getCommsConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCommsConnection");
        }
        CommsConnection commsConnection = null;
        this.validateConversationState();
        commsConnection = this.serverMode ? this.sConState.getCommsConnection() : this.cConState.getCommsConnection();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCommsConnection", commsConnection);
        }
        return commsConnection;
    }

    protected void setCommsConnection(CommsConnection commsConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setCommsConnection");
        }
        this.validateConversationState();
        if (this.serverMode) {
            this.sConState.setCommsConnection(commsConnection);
        } else {
            this.cConState.setCommsConnection(commsConnection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setCommsConnection");
        }
    }

    protected void setSICoreConnection(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setSICoreConnection", sICoreConnection);
        }
        this.validateConversationState();
        this.cConState.setSICoreConnection(sICoreConnection);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setSICoreConnection");
        }
    }

    protected ReceivedData JFAPExchange(List list, int n, int n2, boolean bl) throws SIConnectionDroppedException, SIConnectionLostException, NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "JFAPExchange");
        }
        ReceivedData receivedData = null;
        if (list == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_DATA_LIST_PASSED_IN_SICO1046", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".JFAPExchange"), (String)"5-001-0001", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIErrorException.getMessage(), sIErrorException);
            }
            throw sIErrorException;
        }
        int n3 = this.getRequestNumber();
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "About to Exchange segment conversation: " + this.con + " " + JFapChannelConstants.getSegmentName(n) + " - " + n + " (0x" + Integer.toHexString(n) + ") " + "using request number " + n3);
        }
        try {
            receivedData = this.con.exchange(list, n, n3, n2, bl);
        }
        catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
            NoCapacityException noCapacityException2 = new NoCapacityException();
            noCapacityException2.initCause(noCapacityException);
            throw noCapacityException2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Exchange completed successfully. Segment returned " + JFapChannelConstants.getSegmentName(receivedData.getSegmentType()) + " - " + receivedData.getSegmentType() + " (0x" + Integer.toHexString(receivedData.getSegmentType()) + ")");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "JFAPExchange");
        }
        return receivedData;
    }

    protected void JFAPSend(List list, int n, int n2, boolean bl) throws SIConnectionDroppedException, SIConnectionLostException, com.ibm.ws.sib.jfapchannel.NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "JFAPSend");
        }
        if (list == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_DATA_LIST_PASSED_IN_SICO1046", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".JFAPSend"), (String)"5-001-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIErrorException.getMessage(), sIErrorException);
            }
            throw sIErrorException;
        }
        int n3 = 0;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "About to Send segment conversation: " + this.con + " " + JFapChannelConstants.getSegmentName(n) + " - " + n + " (0x" + Integer.toHexString(n) + ") " + "using request number " + n3);
        }
        this.con.send(list, n, n3, n2, bl, null, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "JFAPSend");
        }
    }

    public short getCommandCompletionCode(ReceivedData receivedData, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCommandCompletionCode", new Object[]{receivedData, "" + n});
        }
        short s = -1;
        if (receivedData == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_RCVDATA_PASSED_IN_SICO1047", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getCommandCompletionCode"), (String)"5-001-0006", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIErrorException.getMessage(), sIErrorException);
            }
            throw sIErrorException;
        }
        if (receivedData.getSegmentType() == n) {
            s = 0;
        } else if (receivedData.getSegmentType() == 11) {
            receivedData.getBuffer().flip();
            receivedData.getBuffer().getShort();
            s = receivedData.getBuffer().getShort();
        } else {
            String string = n + " (0x" + Integer.toHexString(n).toUpperCase() + ")";
            String string2 = receivedData.getSegmentType() + " (0x" + Integer.toHexString(receivedData.getSegmentType()).toUpperCase() + ")";
            throw new SIErrorException(nls.getFormattedMessage("JFAP_SEG_MISMATCH_EXCEPTION_SICO1006", new Object[]{string, string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCommandCompletionCode", "" + s);
        }
        return s;
    }

    protected WsByteBuffer getWsBuffer(int n) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getWsBuffer", "" + n);
        }
        WsByteBufferPoolManager wsByteBufferPoolManager = null;
        if (this.serverMode) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Getting Buffer from ServerConnectionManager");
            }
            object = ServerConnectionManager.getRef();
            wsByteBufferPoolManager = ((ServerConnectionManager)object).getBufferPoolManager();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Getting Buffer from ClientConnectionManager");
            }
            object = ClientConnectionManager.getRef();
            wsByteBufferPoolManager = ((ClientConnectionManager)object).getBufferPoolManager();
        }
        object = wsByteBufferPoolManager.allocate(n);
        object.limit(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getWsBuffer", object);
        }
        return object;
    }

    protected WsByteBuffer wrapToWsBuffer(byte[] byArray) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "wrapToWsBuffer", byArray);
        }
        WsByteBufferPoolManager wsByteBufferPoolManager = null;
        if (this.serverMode) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Getting Buffer from ServerConnectionManager");
            }
            object = ServerConnectionManager.getRef();
            wsByteBufferPoolManager = ((ServerConnectionManager)object).getBufferPoolManager();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Getting Buffer from ClientConnectionManager");
            }
            object = ClientConnectionManager.getRef();
            wsByteBufferPoolManager = ((ClientConnectionManager)object).getBufferPoolManager();
        }
        object = wsByteBufferPoolManager.wrap(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "wrapToWsBuffer", object);
        }
        return object;
    }

    private int getRequestNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getRequestNumber");
        }
        int n = 0;
        this.validateConversationState();
        n = this.serverMode ? this.sConState.getUniqueRequestNumber() : this.cConState.getUniqueRequestNumber();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getRequestNumber", "" + n);
        }
        return n;
    }

    private void validateConversationState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "validateConversationState");
        }
        if (this.con == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NO_CONVERSATION_SICO1008", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".validateConversationState"), (String)"5-001-0007", (Object)this);
            throw sIErrorException;
        }
        if (this.serverMode && this.sConState == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "No server conversation state found, go get one");
            }
            this.sConState = (ConversationState)this.con.getAttachment();
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "getAttachment found server conversation state with reference ", this.sConState);
            }
        } else if (!this.serverMode && this.cConState == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "No conversation state found, go get one");
            }
            this.cConState = (ClientConversationState)this.con.getAttachment();
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "getAttachment found conversation state with reference ", this.cConState);
            }
        }
        if (this.serverMode && this.sConState == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NO_CONVERSATION_STATE_SICO1009", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".validateConversationState"), (String)"5-001-0008", (Object)this);
            throw sIErrorException;
        }
        if (!this.serverMode && this.cConState == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NO_CONVERSATION_STATE_SICO1009", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".validateConversationState"), (String)"5-001-0009", (Object)this);
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "validateConversationState");
        }
    }

    protected void createConversationState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createConversationState");
        }
        if (this.serverMode) {
            ConversationState conversationState = new ConversationState();
            this.con.setAttachment(conversationState);
            LinkLevelState linkLevelState = (LinkLevelState)this.con.getLinkLevelAttachment();
            if (linkLevelState == null) {
                this.con.setLinkLevelAttachment(new LinkLevelState());
            }
        } else {
            ClientConversationState clientConversationState = new ClientConversationState();
            this.con.setAttachment(clientConversationState);
            ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)this.con.getLinkLevelAttachment();
            if (clientLinkLevelState == null) {
                this.con.setLinkLevelAttachment(new ClientLinkLevelState());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createConversationState");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initiateCommsHandshaking() throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        block30: {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "initiateHandshaking");
            }
            CATHandshakeProperties cATHandshakeProperties = null;
            CommsConnection commsConnection = null;
            if (this.serverMode) {
                object = (LinkLevelState)this.getConversation().getLinkLevelAttachment();
                cATHandshakeProperties = ((LinkLevelState)object).getCatHandshakeProperties();
                commsConnection = ((ConversationState)this.getConversation().getAttachment()).getCommsConnection();
            } else {
                object = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
                cATHandshakeProperties = ((ClientLinkLevelState)object).getCatHandshakeProperties();
                commsConnection = ((ClientConversationState)this.getConversation().getAttachment()).getCommsConnection();
            }
            object = "Unknown";
            if (commsConnection != null) {
                object = commsConnection.getConnectionInfo();
            }
            int n = 51;
            WsByteBuffer wsByteBuffer = this.getWsBuffer(n);
            if (this.serverMode) {
                wsByteBuffer.put((byte)2);
            } else {
                wsByteBuffer.put((byte)1);
            }
            byte by = 6;
            byte by2 = 0;
            wsByteBuffer.putShort((short)1);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.put(by);
            wsByteBuffer.put(by2);
            cATHandshakeProperties.setMajorVersion(by);
            cATHandshakeProperties.setMinorVersion(by2);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort((short)2);
            cATHandshakeProperties.setFapLevel((short)2);
            wsByteBuffer.putShort((short)3);
            wsByteBuffer.putShort((short)8);
            wsByteBuffer.putLong(10000L);
            cATHandshakeProperties.setMaxMessageSize(10000L);
            wsByteBuffer.putShort((short)4);
            wsByteBuffer.putShort((short)4);
            wsByteBuffer.putInt(10000);
            cATHandshakeProperties.setMaxTransmissionSize(10000);
            wsByteBuffer.putShort((short)5);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort((short)300);
            cATHandshakeProperties.setHeartbeatInterval((short)300);
            wsByteBuffer.putShort((short)7);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort(CAPABILITIES);
            cATHandshakeProperties.setCapabilites(CAPABILITIES);
            wsByteBuffer.putShort((short)11);
            wsByteBuffer.putShort((short)2);
            wsByteBuffer.putShort((short)1);
            cATHandshakeProperties.setProductId((short)1);
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 6, 7, true);
            try {
                try {
                    short s = this.getCommandCompletionCode(receivedData, 6);
                    if (s != 0) {
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
                    wsByteBuffer2.flip();
                    byte by3 = wsByteBuffer2.get();
                    if (this.serverMode && by3 != 2 || !this.serverMode && by3 != 1) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Unexpected connection type returned!", Byte.toString(by3));
                        }
                        throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{object}, null));
                    }
                    block13: while (wsByteBuffer2.hasRemaining()) {
                        short s2 = wsByteBuffer2.getShort();
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "fieldId", new Short(s2));
                        }
                        switch (s2) {
                            case 1: {
                                short s3 = wsByteBuffer2.getShort();
                                byte by4 = wsByteBuffer2.get();
                                byte by5 = wsByteBuffer2.get();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(this, tc, "Server Product Versions", new Object[]{new Byte(by4), new Byte(by5)});
                                }
                                cATHandshakeProperties.setMajorVersion(by4);
                                cATHandshakeProperties.setMinorVersion(by5);
                                continue block13;
                            }
                            case 2: {
                                short s4 = wsByteBuffer2.getShort();
                                short s5 = wsByteBuffer2.getShort();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(this, tc, "Negotiated FAP Levels", new Object[]{new Short(s5)});
                                }
                                if (s5 > 2) {
                                    throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{object}, null));
                                }
                                cATHandshakeProperties.setFapLevel(s5);
                                continue block13;
                            }
                            case 3: {
                                short s6 = wsByteBuffer2.getShort();
                                long l = wsByteBuffer2.getLong();
                                cATHandshakeProperties.setMaxMessageSize(Math.min(l, 10000L));
                                if (!tc.isDebugEnabled()) continue block13;
                                SibTr.debug(this, tc, "Negotiated Message Size", new Object[]{new Long(l)});
                                continue block13;
                            }
                            case 4: {
                                short s7 = wsByteBuffer2.getShort();
                                int n2 = wsByteBuffer2.getInt();
                                cATHandshakeProperties.setMaxTransmissionSize(Math.min(n2, 10000));
                                if (!tc.isDebugEnabled()) continue block13;
                                SibTr.debug(this, tc, "Negotiated Transmission Sizes", new Object[]{new Integer(n2)});
                                continue block13;
                            }
                            case 5: {
                                short s8 = wsByteBuffer2.getShort();
                                short s9 = wsByteBuffer2.getShort();
                                cATHandshakeProperties.setHeartbeatInterval((short)Math.max(s9, 300));
                                this.getConversation().setHeartbeatInterval(cATHandshakeProperties.getHeartbeatInterval());
                                if (!tc.isDebugEnabled()) continue block13;
                                SibTr.debug(this, tc, "Negotiated Heartbeat Info", new Object[]{new Short(s9)});
                                continue block13;
                            }
                            case 7: {
                                short s10 = wsByteBuffer2.getShort();
                                short s11 = wsByteBuffer2.getShort();
                                cATHandshakeProperties.setCapabilites(s11);
                                if (!tc.isDebugEnabled()) continue block13;
                                SibTr.debug(this, tc, "Negotiated Capability Info", new Object[]{new Short(s11)});
                                continue block13;
                            }
                            case 11: {
                                short s12 = wsByteBuffer2.getShort();
                                short s13 = wsByteBuffer2.getShort();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(this, tc, "Server product id", new Short(s13));
                                }
                                cATHandshakeProperties.setProductId(s13);
                                continue block13;
                            }
                        }
                        SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("INVALID_PROP_SICO8009", new Object[]{"" + s2}, null));
                        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".initiateHandshaking"), (String)"5-001-0005", (Object)this);
                        throw sIConnectionLostException;
                    }
                    Object var32_31 = null;
                    if (receivedData == null) break block30;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".initiateHandshaking"), (String)"5-001-0004", (Object)this);
                    throw new SIConnectionLostException(nls.getFormattedMessage("UNKNOWN_CORE_EXCP_SICO8002", new Object[]{sIException}, null), sIException);
                }
            }
            catch (Throwable throwable) {
                Object var32_32 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "initiateHandshaking");
        }
    }

    public void checkFor_SIIncorrectCallException(ReceivedData receivedData, short s) throws SIIncorrectCallException {
        if (s == 2) {
            throw (SIIncorrectCallException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIInvalidDestinationPrefixException(ReceivedData receivedData, short s) throws SIInvalidDestinationPrefixException {
        if (s == 3) {
            throw (SIInvalidDestinationPrefixException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDiscriminatorSyntaxException(ReceivedData receivedData, short s) throws SIDiscriminatorSyntaxException {
        if (s == 4) {
            throw (SIDiscriminatorSyntaxException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SISelectorSyntaxException(ReceivedData receivedData, short s) throws SISelectorSyntaxException {
        if (s == 5) {
            throw (SISelectorSyntaxException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIInsufficientDataForFactoryTypeException(ReceivedData receivedData, short s) throws SIInsufficientDataForFactoryTypeException {
        if (s == 6) {
            throw (SIInsufficientDataForFactoryTypeException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIAuthenticationException(ReceivedData receivedData, short s) throws SIAuthenticationException {
        if (s == 7) {
            throw (SIAuthenticationException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SINotPossibleInCurrentConfigurationException(ReceivedData receivedData, short s) throws SINotPossibleInCurrentConfigurationException {
        if (s == 8) {
            throw (SINotPossibleInCurrentConfigurationException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SINotAuthorizedException(ReceivedData receivedData, short s) throws SINotAuthorizedException {
        if (s == 9) {
            throw (SINotAuthorizedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SISessionUnavailableException(ReceivedData receivedData, short s) throws SISessionUnavailableException {
        if (s == 10) {
            throw (SISessionUnavailableException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SISessionDroppedException(ReceivedData receivedData, short s) throws SISessionDroppedException {
        if (s == 11) {
            throw (SISessionDroppedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDurableSubscriptionAlreadyExistsException(ReceivedData receivedData, short s) throws SIDurableSubscriptionAlreadyExistsException {
        if (s == 12) {
            throw (SIDurableSubscriptionAlreadyExistsException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDurableSubscriptionMismatchException(ReceivedData receivedData, short s) throws SIDurableSubscriptionMismatchException {
        if (s == 13) {
            throw (SIDurableSubscriptionMismatchException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDurableSubscriptionNotFoundException(ReceivedData receivedData, short s) throws SIDurableSubscriptionNotFoundException {
        if (s == 14) {
            throw (SIDurableSubscriptionNotFoundException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIConnectionUnavailableException(ReceivedData receivedData, short s) throws SIConnectionUnavailableException {
        if (s == 15) {
            throw (SIConnectionUnavailableException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIConnectionDroppedException(ReceivedData receivedData, short s) throws SIConnectionDroppedException {
        if (s == 16) {
            throw (SIConnectionDroppedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDataGraphFormatMismatchException(ReceivedData receivedData, short s) throws SIDataGraphFormatMismatchException {
        if (s == 17) {
            throw (SIDataGraphFormatMismatchException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDataGraphSchemaNotFoundException(ReceivedData receivedData, short s) throws SIDataGraphSchemaNotFoundException {
        if (s == 18) {
            throw (SIDataGraphSchemaNotFoundException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDestinationLockedException(ReceivedData receivedData, short s) throws SIDestinationLockedException {
        if (s == 19) {
            throw (SIDestinationLockedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SITemporaryDestinationNotFoundException(ReceivedData receivedData, short s) throws SITemporaryDestinationNotFoundException {
        if (s == 20) {
            throw (SITemporaryDestinationNotFoundException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIMessageException(ReceivedData receivedData, short s) throws SIMessageException {
        if (s == 21) {
            throw (SIMessageException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIResourceException(ReceivedData receivedData, short s) throws SIResourceException {
        if (s == 22) {
            throw (SIResourceException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SILimitExceededException(ReceivedData receivedData, short s) throws SILimitExceededException {
        if (s == 23) {
            throw (SILimitExceededException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIConnectionLostException(ReceivedData receivedData, short s) throws SIConnectionLostException {
        if (s == 24) {
            throw (SIConnectionLostException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIRollbackException(ReceivedData receivedData, short s) throws SIRollbackException {
        if (s == 25) {
            throw (SIRollbackException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SINotSupportedException(ReceivedData receivedData, short s) throws SINotSupportedException {
        if (s == 26) {
            throw (SINotSupportedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIMessageDomainNotSupportedException(ReceivedData receivedData, short s) throws SIMessageDomainNotSupportedException {
        if (s == 27) {
            throw (SIMessageDomainNotSupportedException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIDataGraphCreationException(ReceivedData receivedData, short s) throws SIDataGraphException {
        if (s == 28) {
            throw (SIDataGraphException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void checkFor_SIErrorException(ReceivedData receivedData, short s) throws SIErrorException {
        if (s == 29) {
            throw (SIErrorException)JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
    }

    public void defaultChecker(ReceivedData receivedData, short s) throws SIErrorException {
        if (s != 0) {
            throw new SIErrorException(JFAPCommunicator.getException(receivedData.getBuffer(), s));
        }
    }

    protected void checkXACommandCompletionStatus(ReceivedData receivedData, int n) throws XAException, Exception {
        short s;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "checkXACommandCompletionStatus");
        }
        if ((s = this.getCommandCompletionCode(receivedData, n)) != 0) {
            throw JFAPCommunicator.getException(receivedData.getBuffer(), s);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "No exception");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "checkXACommandCompletionStatus");
        }
    }

    public static Exception getException(WsByteBuffer wsByteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getException", new Object[]{wsByteBuffer, "" + n});
        }
        wsByteBuffer.rewind();
        int n2 = wsByteBuffer.getShort();
        Exception exception = null;
        Throwable throwable = null;
        for (int i = 0; i < n2; ++i) {
            short s = wsByteBuffer.getShort();
            Exception exception2 = JFAPCommunicator.parseSingleException(wsByteBuffer, s);
            if (exception == null) {
                exception = exception2;
                throwable = exception;
                continue;
            }
            throwable.initCause(exception2);
            throwable = exception2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getException", exception);
        }
        return exception;
    }

    private static Exception parseSingleException(WsByteBuffer wsByteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseSingleException");
        }
        short s = 0;
        short s2 = 0;
        int n2 = 0;
        String string = null;
        String string2 = null;
        int n3 = wsByteBuffer.getShort();
        Exception exception = null;
        block36: for (int i = 0; i < n3; ++i) {
            s = wsByteBuffer.getShort();
            switch (s) {
                case 2: {
                    s2 = wsByteBuffer.getShort();
                    byte[] byArray = new byte[s2];
                    wsByteBuffer.get(byArray);
                    cStr.setBytes(byArray);
                    string2 = cStr.getString();
                    continue block36;
                }
                case 1: {
                    s2 = wsByteBuffer.getShort();
                    byte[] byArray = new byte[s2];
                    wsByteBuffer.get(byArray);
                    cStr.setBytes(byArray);
                    string = cStr.getString();
                    continue block36;
                }
                case 3: {
                    s2 = wsByteBuffer.getShort();
                    n2 = wsByteBuffer.getInt();
                    continue block36;
                }
            }
        }
        if (string != null) {
            string2 = nls.getFormattedMessage("CORE_EXCEPTION_SICO8007", new Object[]{string2, string}, null);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Exception Id, Message, ProbeID, Reason", new Object[]{"" + n, string2, string, "" + n2});
        }
        switch (n) {
            case 257: {
                exception = new XAException(string2);
                exception.errorCode = n2;
                break;
            }
            case 2: {
                exception = new SIIncorrectCallException(string2);
                break;
            }
            case 3: {
                exception = new SIInvalidDestinationPrefixException(string2);
                break;
            }
            case 4: {
                exception = new SIDiscriminatorSyntaxException(string2);
                break;
            }
            case 5: {
                exception = new SISelectorSyntaxException(string2);
                break;
            }
            case 6: {
                exception = new SIInsufficientDataForFactoryTypeException(string2);
                break;
            }
            case 7: {
                exception = new SIAuthenticationException(string2);
                break;
            }
            case 8: {
                exception = new SINotPossibleInCurrentConfigurationException(string2);
                break;
            }
            case 9: {
                exception = new SINotAuthorizedException(string2);
                break;
            }
            case 10: {
                exception = new SISessionUnavailableException(string2);
                break;
            }
            case 11: {
                exception = new SISessionDroppedException(string2);
                break;
            }
            case 12: {
                exception = new SIDurableSubscriptionAlreadyExistsException(string2);
                break;
            }
            case 13: {
                exception = new SIDurableSubscriptionMismatchException(string2);
                break;
            }
            case 14: {
                exception = new SIDurableSubscriptionNotFoundException(string2);
                break;
            }
            case 15: {
                exception = new SIConnectionUnavailableException(string2);
                break;
            }
            case 16: {
                exception = new SIConnectionDroppedException(string2);
                break;
            }
            case 17: {
                exception = new SIDataGraphFormatMismatchException(string2);
                break;
            }
            case 18: {
                exception = new SIDataGraphSchemaNotFoundException(string2);
                break;
            }
            case 19: {
                exception = new SIDestinationLockedException(string2);
                break;
            }
            case 20: {
                exception = new SITemporaryDestinationNotFoundException(string2);
                break;
            }
            case 21: {
                exception = new SIMessageException(string2);
                break;
            }
            case 22: {
                exception = new SIResourceException(string2);
                break;
            }
            case 23: {
                exception = new SILimitExceededException(string2);
                break;
            }
            case 24: {
                exception = new SIConnectionLostException(string2);
                break;
            }
            case 25: {
                exception = new SIRollbackException(string2);
                break;
            }
            case 26: {
                exception = new SINotSupportedException(string2);
                break;
            }
            case 27: {
                exception = new SIMessageDomainNotSupportedException(string2);
                break;
            }
            case 28: {
                exception = new SIDataGraphException(string2);
                break;
            }
            case 29: {
                exception = new SIErrorException(string2);
                break;
            }
            default: {
                string2 = nls.getFormattedMessage("UNKNOWN_CORE_EXCP_SICO8002", new Object[]{string2}, null);
                exception = new SIErrorException(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseSingleException");
        }
        return exception;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/common/JFAPCommunicator.java, SIB.comms, WAS602.SIB, o0610.11 1.52.1.1");
        }
    }
}

