/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessagePart;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.util.List;

public class CommsUtils {
    private static String CLASS_NAME = CommsUtils.class.getName();
    private static final TraceComponent tc = SibTr.register(CommsUtils.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static boolean initialised = false;

    public static void initialise(ServerConnectionManager serverConnectionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialise", serverConnectionManager);
        }
        if (!initialised) {
            bbPoolManager = serverConnectionManager.getBufferPoolManager();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialise");
        }
    }

    public static void initialise(ClientConnectionManager clientConnectionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialise", clientConnectionManager);
        }
        if (!initialised) {
            bbPoolManager = clientConnectionManager.getBufferPoolManager();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialise");
        }
    }

    private static WsByteBuffer getWsByteBuffer(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getWsByteBuffer", (Object)("" + n));
        }
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(n);
        wsByteBuffer.limit(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getWsByteBuffer", wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public static WsByteBuffer getDestinationAddressAsBytes(SIDestinationAddress sIDestinationAddress) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDestinationAddressAsBytes", sIDestinationAddress);
        }
        CommsString commsString = new CommsString();
        CommsString commsString2 = new CommsString();
        byte[] byArray = new byte[]{};
        if (sIDestinationAddress != null) {
            commsString.setString(sIDestinationAddress.getDestinationName());
            commsString2.setString(sIDestinationAddress.getBusName());
            if (sIDestinationAddress instanceof JsDestinationAddress) {
                JsDestinationAddress jsDestinationAddress = (JsDestinationAddress)sIDestinationAddress;
                if (jsDestinationAddress.isFromMediation()) {
                    byArray = new byte[]{1};
                } else if (jsDestinationAddress.getME() != null) {
                    byArray = jsDestinationAddress.getME().toByteArray();
                }
            }
        }
        int n = commsString.getLength() + commsString2.getLength() + byArray.length + 2 + 2 + 2;
        WsByteBuffer wsByteBuffer = CommsUtils.getWsByteBuffer(n);
        wsByteBuffer.putShort((short)byArray.length);
        if (byArray.length != 0) {
            wsByteBuffer.put(byArray);
        }
        wsByteBuffer.putShort(commsString.getLength());
        wsByteBuffer.put(commsString.getBytes());
        wsByteBuffer.putShort(commsString2.getLength());
        wsByteBuffer.put(commsString2.getBytes());
        wsByteBuffer.flip();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDestinationAddressAsBytes");
        }
        return wsByteBuffer;
    }

    public static WsByteBuffer getSelectionCriteriaAsBytes(SelectionCriteria selectionCriteria) {
        SelectorDomain selectorDomain;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSelectionCriteriaAsBytes", selectionCriteria);
        }
        CommsString commsString = new CommsString();
        CommsString commsString2 = new CommsString();
        short s = (short)SelectorDomain.SIMESSAGE.toInt();
        if (selectionCriteria != null) {
            commsString.setString(selectionCriteria.getDiscriminator());
            commsString2.setString(selectionCriteria.getSelectorString());
            selectorDomain = selectionCriteria.getSelectorDomain();
            if (selectorDomain != null) {
                s = (short)selectorDomain.toInt();
            }
        }
        selectorDomain = CommsUtils.getWsByteBuffer(4 + commsString.getLength() + 2 + commsString2.getLength());
        selectorDomain.putShort(s);
        selectorDomain.putShort(commsString.getLength());
        selectorDomain.put(commsString.getBytes());
        selectorDomain.putShort(commsString2.getLength());
        selectorDomain.put(commsString2.getBytes());
        selectorDomain.flip();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSelectionCriteriaAsBytes");
        }
        return selectorDomain;
    }

    public static SIDestinationAddress getSIDestinationAddress(WsByteBuffer wsByteBuffer) throws SIErrorException {
        short s;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSIDestinationAddress", wsByteBuffer);
        }
        CommsString commsString = new CommsString();
        boolean bl = false;
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Uuid length:", (Object)("" + s2));
        }
        SIBUuid8 sIBUuid8 = null;
        if (s2 != 0) {
            if (s2 == 1) {
                s = wsByteBuffer.get();
                if (s == 1) {
                    bl = true;
                }
            } else {
                byte[] byArray = new byte[s2];
                wsByteBuffer.get(byArray);
                sIBUuid8 = new SIBUuid8(byArray);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Uuid:", sIBUuid8);
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Uuid was null");
        }
        s = wsByteBuffer.getShort();
        byte[] byArray = new byte[s];
        wsByteBuffer.get(byArray);
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Destination name:", (Object)string);
        }
        short s3 = wsByteBuffer.getShort();
        byte[] byArray2 = new byte[s3];
        wsByteBuffer.get(byArray2);
        commsString.setBytes(byArray2);
        String string2 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Bus name:", (Object)string2);
        }
        JsDestinationAddress jsDestinationAddress = null;
        if (sIBUuid8 == null && string == null && string2 == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Both UUID and destination name were null");
            }
        } else {
            jsDestinationAddress = bl ? ((JsDestinationAddressFactory)JsDestinationAddressFactory.getInstance()).createJsMediationdestinationAddress(string) : ((JsDestinationAddressFactory)JsDestinationAddressFactory.getInstance()).createJsDestinationAddress(string, false, sIBUuid8, string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSIDestinationAddress", jsDestinationAddress);
        }
        return jsDestinationAddress;
    }

    public static SelectionCriteria getSelectionCriteria(WsByteBuffer wsByteBuffer) throws SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSelectionCriteria", wsByteBuffer);
        }
        CommsString commsString = new CommsString();
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain(wsByteBuffer.getShort());
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Selector domain", selectorDomain);
        }
        short s = wsByteBuffer.getShort();
        byte[] byArray = new byte[s];
        wsByteBuffer.get(byArray);
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Discriminator:", (Object)string);
        }
        short s2 = wsByteBuffer.getShort();
        byte[] byArray2 = new byte[s2];
        wsByteBuffer.get(byArray2);
        commsString.setBytes(byArray2);
        String string2 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Selector:", (Object)string2);
        }
        SelectionCriteria selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(string, string2, selectorDomain);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSelectionCriteria", selectionCriteria);
        }
        return selectionCriteria;
    }

    public static String getRuntimeProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRuntimeProperty", new Object[]{string, string2});
        }
        String string3 = RuntimeInfo.getPropertyWithMsg(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRuntimeProperty", (Object)string3);
        }
        return string3;
    }

    public static boolean getRuntimeBooleanProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRuntimeBooleanProperty", new Object[]{string, string2});
        }
        boolean bl = Boolean.valueOf(RuntimeInfo.getPropertyWithMsg(string, string2));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRuntimeBooleanProperty", (Object)("" + bl));
        }
        return bl;
    }

    public static int getRuntimeIntProperty(String string, String string2) {
        int n;
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getRuntimeIntProperty", new Object[]{string, string2});
            }
            n = Integer.parseInt(string2);
            try {
                n = Integer.parseInt(RuntimeInfo.getPropertyWithMsg(string, string2));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)(CLASS_NAME + ".getRuntimeIntProperty"), (String)"5-003-0001");
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, "NumberFormatException: ", numberFormatException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRuntimeIntProperty", (Object)("" + n));
        }
        return n;
    }

    public static double getRuntimeDoubleProperty(String string, String string2) {
        double d;
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getRuntimeDoubleProperty", new Object[]{string, string2});
            }
            d = Double.parseDouble(string2);
            try {
                d = Double.parseDouble(RuntimeInfo.getPropertyWithMsg(string, string2));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)(CLASS_NAME + ".getRuntimeDoubleProperty"), (String)"5-003-0002");
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, "NumberFormatException: ", numberFormatException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRuntimeDoubleProperty", (Object)("" + d));
        }
        return d;
    }

    public static String getWsByteBufferContents(WsByteBuffer wsByteBuffer, int n) {
        StringBuffer stringBuffer = new StringBuffer("----> Beginning WsByteBuffer dump:");
        if (wsByteBuffer == null) {
            stringBuffer.append("\nBuffer was null");
        } else {
            int n2;
            byte[] byArray = null;
            int n3 = n;
            int n4 = wsByteBuffer.position();
            int n5 = wsByteBuffer.limit();
            wsByteBuffer.flip();
            if (n3 < 1 || n3 > wsByteBuffer.remaining()) {
                n3 = wsByteBuffer.remaining();
            }
            if (wsByteBuffer.hasArray()) {
                byArray = wsByteBuffer.array();
                n2 = wsByteBuffer.arrayOffset() + wsByteBuffer.position();
            } else {
                byArray = new byte[n3];
                int n6 = wsByteBuffer.position();
                wsByteBuffer.get(byArray);
                wsByteBuffer.position(n6);
                n2 = 0;
            }
            stringBuffer.append("\nBuffer         :  ");
            stringBuffer.append(wsByteBuffer.toString());
            stringBuffer.append("\nBuffer hashcode:  ");
            stringBuffer.append(wsByteBuffer.hashCode());
            stringBuffer.append("\nBuffer position:  ");
            stringBuffer.append(wsByteBuffer.position());
            stringBuffer.append("\nBuffer remaining: ");
            stringBuffer.append(wsByteBuffer.remaining());
            stringBuffer.append("\n");
            stringBuffer.append("First " + n3 + " bytes of buffer data:");
            stringBuffer.append("\n");
            stringBuffer.append(SibTr.formatBytes(byArray, n2, n3));
            wsByteBuffer.limit(n5);
            wsByteBuffer.position(n4);
        }
        return stringBuffer.toString();
    }

    public static int encodeMessage(List list, Conversation conversation, JsMessage jsMessage) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeMessage", new Object[]{list, conversation, jsMessage});
        }
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list2 = conversationState.getList();
        short s = linkLevelState.getCatHandshakeProperties().getCapabilites();
        boolean bl2 = (s & 0x20) != 0;
        boolean bl3 = bl = (s & 0x10) != 0;
        if (bl2 || bl) {
            jsMessage = jsMessage.makeInboundJmsMessage();
        }
        if (bl2) {
            jsMessage = jsMessage.transcribeToJmf();
        }
        List list3 = jsMessage.encodeFast(conversationState.getCommsConnection());
        WsByteBufferPoolManager wsByteBufferPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        int n = 0;
        for (int i = 0; i < list3.size(); ++i) {
            MessagePart messagePart = (MessagePart)list3.get(i);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "MessagePart[" + i + "]: " + "Array: " + messagePart.getBytes() + ", " + "Offset: " + messagePart.getOffset() + ", " + "Length: " + messagePart.getLength());
            }
            WsByteBuffer wsByteBuffer = wsByteBufferPoolManager.wrap(messagePart.getBytes(), messagePart.getOffset(), messagePart.getLength());
            n += messagePart.getLength();
            list.add(wsByteBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeMessage", (Object)("" + n));
        }
        return n;
    }

    public static void checkFapLevel(CATHandshakeProperties cATHandshakeProperties, short s) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkFapLevel", (Object)("" + s));
        }
        short s2 = cATHandshakeProperties.getFapLevel();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Actual FAP Level: ", (Object)("" + s2));
        }
        if (s > s2) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"This call is not supported for FAP Level " + s2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkFapLevel");
        }
    }
}

