/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CommsServiceUtility
extends Thread {
    private int port = 21179;
    private boolean started = false;
    private static CommsServiceUtility instance = null;
    private LinkedList convList = new LinkedList();

    public static CommsServiceUtility getInstance() {
        if (instance == null) {
            instance = new CommsServiceUtility();
        }
        return instance;
    }

    public CommsServiceUtility() {
        String string = RuntimeInfo.getProperty("sib.comms.ServicePort");
        if (string != null) {
            try {
                this.port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Ignoring invalid port number: " + string);
            }
        }
        this.setName("WPM Comms Service Utility Thread [" + this.port + "]");
        this.setDaemon(true);
    }

    public void registerConversation(Conversation conversation) {
        this.start();
        this.convList.add(conversation);
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            super.start();
        }
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            System.err.println("Started comms service utility on port " + this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (IOException iOException) {
            System.err.println("CommsServiceUtility has failed: ");
            iOException.printStackTrace();
            return;
        }
    }

    private void processSocket(Socket socket) throws IOException {
        Object object;
        Object object2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintStream printStream = new PrintStream(socket.getOutputStream());
        AdminService adminService = AdminServiceFactory.getAdminService();
        printStream.println("WebSphere Platform Messaging Comms Service Utility Version 1");
        printStream.println("------------------------------------------------------------");
        printStream.println(" You are connected to   : " + socket.getLocalAddress());
        printStream.println(" You are                : " + socket.getRemoteSocketAddress());
        printStream.println(" Connected to a server? : " + (adminService != null));
        printStream.println("------------------------------------------------------------");
        if (adminService != null) {
            printStream.println(" Server details:");
            printStream.println();
            printStream.println(" Node name              : " + adminService.getNodeName());
            printStream.println(" Cell name              : " + adminService.getCellName());
            printStream.println(" Process name           : " + adminService.getProcessName());
            printStream.println(" Process type           : " + adminService.getProcessType());
            printStream.println("------------------------------------------------------------");
            printStream.println(" Messaging engine details:");
            object2 = JsAdminService.getInstance().listMessagingEngines();
            while (object2.hasMoreElements()) {
                object = (JsMessagingEngine)object2.nextElement();
                printStream.println();
                printStream.println(" ME name                : " + object.getName());
                printStream.println(" ME Uuid                : " + object.getUuid());
                printStream.println(" ME resides in bus      : " + object.getBusName());
            }
            printStream.println("------------------------------------------------------------");
        }
        while (true) {
            printStream.println();
            printStream.print("Enter command > ");
            object2 = bufferedReader.readLine();
            if (object2 == null) {
                socket.close();
                break;
            }
            if (((String)object2).equals("")) continue;
            printStream.println();
            printStream.println("Received command '" + (String)object2 + "'");
            printStream.println();
            if (((String)object2).equalsIgnoreCase("EXIT")) {
                printStream.println("Closing connection");
                socket.close();
                break;
            }
            if (((String)object2).equalsIgnoreCase("HELP")) {
                printStream.println("Help:");
                this.showHelp(printStream);
                continue;
            }
            if (((String)object2).equalsIgnoreCase("DUMP")) {
                object = "";
                printStream.println("Processing dump request:");
                this.dump(printStream, (String)object);
                continue;
            }
            if (((String)object2).toUpperCase().startsWith("DUMP ")) {
                object = ((String)object2).toUpperCase().substring(5);
                printStream.println("Processing dump request:");
                this.dump(printStream, (String)object);
                continue;
            }
            printStream.println("Command not recognised");
        }
    }

    private void dump(PrintStream printStream, String string) {
        try {
            int n;
            Conversation conversation;
            printStream.println(" Options: " + string);
            Conversation[] conversationArray = new Conversation[this.convList.size()];
            Conversation[] conversationArray2 = new Conversation[this.convList.size()];
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = this.convList.iterator();
            while (iterator.hasNext()) {
                conversation = (Conversation)iterator.next();
                if (conversation.isClosed()) {
                    conversationArray2[n3] = conversation;
                    ++n3;
                    continue;
                }
                conversationArray[n2] = conversation;
                ++n2;
            }
            for (n = 0; n < n3; ++n) {
                this.convList.remove(conversationArray2[n]);
            }
            if (n2 == 0) {
                printStream.println();
                printStream.println("No conversations registered");
                printStream.println();
            } else {
                printStream.println("--------------------------------------------------------------------------------");
                printStream.println("Dumping conversations (" + this.convList.size() + "):");
                printStream.println();
                for (n = 0; n < n2; ++n) {
                    conversation = conversationArray[n];
                    printStream.println(n + 1 + ": " + conversation);
                }
                if (string.equalsIgnoreCase("ALL")) {
                    printStream.println();
                    printStream.println("--------------------------------------------------------------------------------");
                    printStream.println("Dumping conversation detail:");
                    for (n = 0; n < n2; ++n) {
                        boolean bl = false;
                        printStream.println();
                        Conversation conversation2 = conversationArray[n];
                        Object object = conversation2.getAttachment();
                        if (object instanceof ClientConversationState) {
                            bl = true;
                        }
                        printStream.print("Conversation " + conversation2.getId() + " ");
                        if (bl) {
                            printStream.println("[CLIENT]:");
                        } else {
                            printStream.println("[SERVER]:");
                        }
                        ConversationMetaData conversationMetaData = conversation2.getMetaData();
                        printStream.println("Using chain: " + conversationMetaData.getChainName() + ", Inbound: " + conversationMetaData.isInbound() + ", Contains HTTP Tunnel: " + conversationMetaData.containsHTTPTunnelChannel() + ", Contains SSL: " + conversationMetaData.containsSSLChannel());
                        printStream.println();
                        if (bl) {
                            this.clientConversationDump(printStream, string, conversation2);
                            continue;
                        }
                        this.serverConversationDump(printStream, string, conversation2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            printStream.println("Caught an exception: " + throwable);
            throwable.printStackTrace(printStream);
            printStream.println();
            printStream.println("Dump aborted");
        }
    }

    private void clientConversationDump(PrintStream printStream, String string, Conversation conversation) throws SIException {
        ClientConversationState clientConversationState = (ClientConversationState)conversation.getAttachment();
        SICoreConnection sICoreConnection = clientConversationState.getSICoreConnection();
        printStream.println("  Connected using: " + clientConversationState.getCommsConnection());
        printStream.println("  Connected to ME: " + sICoreConnection.getMeName() + " [" + sICoreConnection.getMeUuid() + "]");
        printStream.println("  Resolved UserId: " + sICoreConnection.getResolvedUserid());
        printStream.println("  ME is version " + sICoreConnection.getApiLevelDescription());
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = (ProxyQueueConversationGroupImpl)clientConversationState.getProxyQueueConversationHGroup();
        if (proxyQueueConversationGroupImpl == null) {
            printStream.println("  No proxy queues found");
        } else {
            Map map = proxyQueueConversationGroupImpl.getProxyQueues();
            printStream.println("  Found " + map.size() + " proxy queue(s)");
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ProxyQueue proxyQueue = (ProxyQueue)iterator.next();
                printStream.println("  > " + proxyQueue);
            }
        }
    }

    private void serverConversationDump(PrintStream printStream, String string, Conversation conversation) {
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getAllObjects();
        printStream.println(list.size() + " associated resource(s):");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SICoreConnection) {
                SICoreConnection sICoreConnection = (SICoreConnection)e;
                printStream.println("  > SICoreConnection@" + Integer.toHexString(e.hashCode()) + ": " + "ME Name: " + sICoreConnection.getMeName() + " [" + sICoreConnection.getMeUuid() + "] " + "Version: " + sICoreConnection.getApiLevelDescription());
                continue;
            }
            this.dumpObject(printStream, e);
        }
    }

    private void dumpObject(PrintStream printStream, Object object) {
        String string = object.toString();
        printStream.print(" -> ");
        if (string.indexOf(",") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            printStream.println(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                printStream.println("      " + stringTokenizer.nextToken());
            }
        } else {
            printStream.println(object);
        }
    }

    private void showHelp(PrintStream printStream) {
        printStream.println();
        printStream.println("Valid commands are:");
        printStream.println("  HELP: Displays this help");
        printStream.println("  EXIT: Closes the connection to the JVM");
        printStream.println("  DUMP: Performs a dump");
    }
}

