/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public abstract class BaseQueue
implements Queue {
    private static String CLASS_NAME;
    private static final TraceComponent tc;
    private static JsMessageFactory messageFactoryImpl;

    protected JsMessage convert(WsByteBuffer wsByteBuffer) throws MessageDecodeFailedException {
        return this.convert(wsByteBuffer, null);
    }

    protected JsMessage convert(WsByteBuffer wsByteBuffer, CommsConnection commsConnection) throws MessageDecodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "convert", new Object[]{wsByteBuffer, commsConnection});
        }
        JsMessage jsMessage = null;
        if (messageFactoryImpl != null) {
            int n = wsByteBuffer.limit() - wsByteBuffer.position();
            if (wsByteBuffer.hasArray()) {
                jsMessage = messageFactoryImpl.createInboundJsMessage(wsByteBuffer.array(), wsByteBuffer.position() + wsByteBuffer.arrayOffset(), n, commsConnection);
            } else {
                byte[] byArray = new byte[n];
                wsByteBuffer.get(byArray);
                jsMessage = messageFactoryImpl.createInboundJsMessage(byArray, 0, n, commsConnection);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "messageFactoryImp == null");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "convert", jsMessage);
        }
        return jsMessage;
    }

    static {
        block3: {
            CLASS_NAME = BaseQueue.class.getName();
            tc = SibTr.register(BaseQueue.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
            messageFactoryImpl = null;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Source info: @(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/queue/BaseQueue.java, SIB.comms, WAS602.SIB, o0610.11 1.14");
            }
            try {
                messageFactoryImpl = JsMessageFactory.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".<clinit>"), (String)"2-014-0001");
                if (!tc.isEventEnabled()) break block3;
                SibTr.exception(tc, exception);
            }
        }
    }
}

