/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.AsynchConsumerProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.BrowserProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.IdAllocatorException;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.MulticastReadAheadProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.NonReadAheadSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.OrderedSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupFactoryImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ReadAheadSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ShortIdAllocator;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.multicast.MulticastReceiver;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ProxyQueueConversationGroupImpl
implements ProxyQueueConversationGroup {
    private static String CLASS_NAME = ProxyQueueConversationGroupImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(ProxyQueueConversationGroup.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private Conversation conversation = null;
    private ProxyQueueConversationGroupFactoryImpl factory = null;
    private ShortIdAllocator idAllocator = new ShortIdAllocator(false);
    private boolean closed = false;
    private HashMap idToProxyQueueMap = null;

    public ProxyQueueConversationGroupImpl(Conversation conversation, ProxyQueueConversationGroupFactoryImpl proxyQueueConversationGroupFactoryImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{conversation, proxyQueueConversationGroupFactoryImpl});
        }
        this.conversation = conversation;
        this.factory = proxyQueueConversationGroupFactoryImpl;
        this.idToProxyQueueMap = new HashMap();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public synchronized BrowserProxyQueue createBrowserProxyQueue() throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createBrowserProxyQueue");
        }
        this.checkClosed();
        short s = this.nextId();
        BrowserProxyQueueImpl browserProxyQueueImpl = new BrowserProxyQueueImpl(this, s, this.conversation);
        this.idToProxyQueueMap.put(new Short(s), browserProxyQueueImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createBrowserProxyQueue", browserProxyQueueImpl);
        }
        return browserProxyQueueImpl;
    }

    public synchronized AsynchConsumerProxyQueue createAsynchConsumerProxyQueue(OrderingContext orderingContext) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createAsynchConsumerProxyQueue");
        }
        short s = this.nextId();
        AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = null;
        asynchConsumerProxyQueueImpl = orderingContext == null ? new NonReadAheadSessionProxyQueueImpl(this, s, this.conversation) : new OrderedSessionProxyQueueImpl(this, s, this.conversation, orderingContext);
        this.idToProxyQueueMap.put(new Short(s), asynchConsumerProxyQueueImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createAsynchConsumerProxyQueue", asynchConsumerProxyQueueImpl);
        }
        return asynchConsumerProxyQueueImpl;
    }

    public synchronized AsynchConsumerProxyQueue createAsynchConsumerProxyQueue(short s, short s2, OrderingContext orderingContext) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createAsynchConsumerProxyQueue");
        }
        this.checkClosed();
        AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = null;
        asynchConsumerProxyQueueImpl = orderingContext == null ? new NonReadAheadSessionProxyQueueImpl(this, s, this.conversation) : new OrderedSessionProxyQueueImpl(this, s, this.conversation, orderingContext);
        this.idToProxyQueueMap.put(new Short(s), asynchConsumerProxyQueueImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createAsynchConsumerProxyQueue", asynchConsumerProxyQueueImpl);
        }
        return asynchConsumerProxyQueueImpl;
    }

    public synchronized AsynchConsumerProxyQueue createReadAheadProxyQueue(Reliability reliability) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createReadAheadProxyQueue");
        }
        this.checkClosed();
        short s = this.nextId();
        ReadAheadSessionProxyQueueImpl readAheadSessionProxyQueueImpl = new ReadAheadSessionProxyQueueImpl(this, s, this.conversation, reliability);
        this.idToProxyQueueMap.put(new Short(s), readAheadSessionProxyQueueImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createReadAheadProxyQueue", readAheadSessionProxyQueueImpl);
        }
        return readAheadSessionProxyQueueImpl;
    }

    public synchronized AsynchConsumerProxyQueue createOrderedProxyQueue(OrderingContext orderingContext) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createOrderedProxyQueue", orderingContext);
        }
        short s = this.nextId();
        AsynchConsumerProxyQueue asynchConsumerProxyQueue = this.createOrderedProxyQueue(orderingContext, s, (short)0);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createOrderedProxyQueue", asynchConsumerProxyQueue);
        }
        return asynchConsumerProxyQueue;
    }

    public synchronized AsynchConsumerProxyQueue createOrderedProxyQueue(OrderingContext orderingContext, short s, short s2) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createOrderedProxyQueue", orderingContext);
        }
        this.checkClosed();
        OrderedSessionProxyQueueImpl orderedSessionProxyQueueImpl = new OrderedSessionProxyQueueImpl(this, s, this.conversation, orderingContext);
        this.idToProxyQueueMap.put(new Short(s), orderedSessionProxyQueueImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createOrderedProxyQueue", orderedSessionProxyQueueImpl);
        }
        return orderedSessionProxyQueueImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AsynchConsumerProxyQueue convertMulticastProxyQueue(AsynchConsumerProxyQueue asynchConsumerProxyQueue, MulticastReceiver multicastReceiver) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "convertMulticastProxyQueue", new Object[]{asynchConsumerProxyQueue, multicastReceiver});
        }
        ReadAheadSessionProxyQueueImpl readAheadSessionProxyQueueImpl = (ReadAheadSessionProxyQueueImpl)asynchConsumerProxyQueue;
        MulticastReadAheadProxyQueueImpl multicastReadAheadProxyQueueImpl = null;
        AsynchConsumerProxyQueue asynchConsumerProxyQueue2 = asynchConsumerProxyQueue;
        synchronized (asynchConsumerProxyQueue2) {
            ReadAheadQueue readAheadQueue = (ReadAheadQueue)readAheadSessionProxyQueueImpl.getQueue();
            readAheadQueue.setTrackBytes(false);
            multicastReadAheadProxyQueueImpl = new MulticastReadAheadProxyQueueImpl(this, readAheadSessionProxyQueueImpl.getId(), this.conversation, multicastReceiver, readAheadQueue, readAheadSessionProxyQueueImpl.getExceptionQueue());
            this.idToProxyQueueMap.remove(new Short(asynchConsumerProxyQueue.getId()));
            this.idToProxyQueueMap.put(new Short(asynchConsumerProxyQueue.getId()), multicastReadAheadProxyQueueImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "convertMulticastProxyQueue", multicastReadAheadProxyQueueImpl);
        }
        return multicastReadAheadProxyQueueImpl;
    }

    public synchronized void bury(ProxyQueue proxyQueue) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "bury");
        }
        short s = proxyQueue.getId();
        this.idToProxyQueueMap.remove(new Short(s));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "bury");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNotification() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        LinkedList linkedList = null;
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
        synchronized (proxyQueueConversationGroupImpl) {
            if (!this.closed) {
                this.closed = true;
                linkedList = new LinkedList();
                linkedList.addAll(this.idToProxyQueueMap.values());
            }
        }
        if (linkedList != null) {
            Object object;
            proxyQueueConversationGroupImpl = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (ProxyQueue)iterator.next();
                if (object.getDestinationSessionProxy() instanceof ConsumerSessionProxy) {
                    ((ConsumerSessionProxy)object.getDestinationSessionProxy()).close(true);
                    continue;
                }
                object.getDestinationSessionProxy().close();
            }
            if (proxyQueueConversationGroupImpl != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "exception caught when closing queues");
                }
                object = new SIConnectionLostException(nls.getFormattedMessage("ERROR_CLOSING_PROXYQUEUE_GROUP_SICO1025", new Object[]{proxyQueueConversationGroupImpl}, null));
                ((Throwable)object).initCause((Throwable)((Object)proxyQueueConversationGroupImpl));
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public synchronized ProxyQueue find(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "find", (Object)("" + s));
        }
        ProxyQueue proxyQueue = (ProxyQueue)this.idToProxyQueueMap.get(new Short(s));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "find", proxyQueue);
        }
        return proxyQueue;
    }

    public Conversation getConversation() throws SIIncorrectCallException {
        this.checkClosed();
        return this.conversation;
    }

    public Map getProxyQueues() {
        return this.idToProxyQueueMap;
    }

    protected void notifyClose(ProxyQueue proxyQueue) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "notifyClose", proxyQueue);
            }
            try {
                this.idAllocator.releaseId(proxyQueue.getId());
            }
            catch (IdAllocatorException idAllocatorException) {
                FFDCFilter.processException((Throwable)idAllocatorException, (String)(CLASS_NAME + ".notifyClose"), (String)"2-002-0002", (Object)this);
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, idAllocatorException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "notifyClose");
        }
    }

    private short nextId() throws SIResourceException {
        short s;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "nextId");
        }
        try {
            s = this.idAllocator.allocateId();
        }
        catch (IdAllocatorException idAllocatorException) {
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("MAX_SESSIONS_REACHED_SICO1019", new Object[]{"32767"}, null));
            sIResourceException.initCause(idAllocatorException);
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "nextId", (Object)("" + s));
        }
        return s;
    }

    private void checkClosed() throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkClosed", (Object)("" + this.closed));
        }
        if (this.closed) {
            throw new SIIncorrectCallException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"TEMPORARY_CWSIC9999", null, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
        synchronized (proxyQueueConversationGroupImpl) {
            if (this.closed) {
                this.idToProxyQueueMap.clear();
                this.factory.groupCloseNotification(this.conversation, this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/ProxyQueueConversationGroupImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.38");
        }
    }
}

