/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.LocalTransactionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class LockedMessageEnumerationImpl
implements LockedMessageEnumeration {
    private static final TraceComponent tc = SibTr.register(LockedMessageEnumerationImpl.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ConsumerSessionProxy consumerSession = null;
    private JsMessage[] messages = null;
    private int nextIndex = 0;
    ConversationHelper convHelper = null;
    private volatile boolean invalid = false;
    private Thread owningThread = null;
    private Queue sourceQueue = null;
    private Object lmeOperationMonitor;
    private ProxyQueue proxyQueue;

    public LockedMessageEnumerationImpl(ProxyQueue proxyQueue, Queue queue, JsMessage[] jsMessageArray, Thread thread, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{proxyQueue, queue, jsMessageArray, thread});
        }
        this.messages = jsMessageArray;
        this.consumerSession = (ConsumerSessionProxy)proxyQueue.getDestinationSessionProxy();
        this.proxyQueue = proxyQueue;
        this.convHelper = proxyQueue.getConversationHelper();
        this.owningThread = thread;
        this.sourceQueue = queue;
        this.lmeOperationMonitor = object;
        if (this.consumerSession.isMulticastSession()) {
            for (int i = 0; i < jsMessageArray.length; ++i) {
                if (!this.isRecoverable(jsMessageArray[i])) continue;
                this.consumerSession.lockMessage(jsMessageArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public LockedMessageEnumerationImpl(ConversationHelper conversationHelper, ConsumerSessionProxy consumerSessionProxy, JsMessage[] jsMessageArray, Thread thread) {
        this.convHelper = conversationHelper;
        this.consumerSession = consumerSessionProxy;
        this.messages = jsMessageArray;
        this.owningThread = thread;
        this.lmeOperationMonitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "nextLocked");
        }
        JsMessage jsMessage = null;
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            while (this.nextIndex != this.messages.length) {
                jsMessage = this.messages[this.nextIndex];
                ++this.nextIndex;
                if (jsMessage == null) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "nextLocked", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockCurrent");
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            if (this.nextIndex == 0 || this.messages[this.nextIndex - 1] == null) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("LME_UNLOCK_INVALID_MSG_SICO1017", null, null));
            }
            JsMessage jsMessage = this.messages[this.nextIndex - 1];
            if (this.isRecoverable(jsMessage)) {
                if (this.consumerSession.isMulticastSession()) {
                    this.consumerSession.unlockMulticastMessage(jsMessage.getMessageHandle());
                } else {
                    this.convHelper.unlockSet(new SIMessageHandle[]{jsMessage.getMessageHandle()});
                }
            }
            this.messages[this.nextIndex - 1] = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockCurrent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrent(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteCurrent", sITransaction);
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            if (this.nextIndex == 0 || this.messages[this.nextIndex - 1] == null) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("LME_DELETE_INVALID_MSG_SICO1018", null, null));
            }
            JsMessage jsMessage = this.messages[this.nextIndex - 1];
            if (this.isRecoverable(jsMessage)) {
                JsMessage[] jsMessageArray = new JsMessage[]{jsMessage};
                if (sITransaction != null) {
                    SITransaction sITransaction2 = sITransaction;
                    synchronized (sITransaction2) {
                        if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                            throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                        }
                        this.deleteMessages(jsMessageArray, sITransaction);
                    }
                } else {
                    this.deleteMessages(jsMessageArray, null);
                }
            }
            this.messages[this.nextIndex - 1] = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteCurrent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeen(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSeen", sITransaction);
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            int n = this.getSeenMessageCount();
            if (n > 0) {
                JsMessage[] jsMessageArray = new JsMessage[n];
                int n2 = 0;
                for (int i = 0; i < this.nextIndex; ++i) {
                    if (this.messages[i] == null) continue;
                    if (this.isRecoverable(this.messages[i])) {
                        jsMessageArray[n2] = this.messages[i];
                        ++n2;
                    }
                    this.messages[i] = null;
                }
                if (n2 > 0) {
                    if (sITransaction != null) {
                        SITransaction sITransaction2 = sITransaction;
                        synchronized (sITransaction2) {
                            if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                                throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                            }
                            this.deleteMessages(jsMessageArray, sITransaction);
                        }
                    } else {
                        this.deleteMessages(jsMessageArray, null);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSeen");
        }
    }

    private void deleteMessages(JsMessage[] jsMessageArray, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteMessages");
        }
        if (this.consumerSession.isMulticastSession()) {
            int n;
            if (sITransaction != null) {
                for (n = 0; n < jsMessageArray.length; ++n) {
                    if (jsMessageArray[n] == null) continue;
                    ((Transaction)((Object)sITransaction)).addMulticastMessage(jsMessageArray[n], this.proxyQueue);
                }
            }
            for (n = 0; n < jsMessageArray.length; ++n) {
                this.consumerSession.discardMessage(jsMessageArray[n].getMessageHandle());
            }
        } else {
            int n = 0;
            int n2 = 7;
            if (sITransaction != null) {
                n = ((Transaction)((Object)sITransaction)).getTransactionId();
                n2 = ((Transaction)((Object)sITransaction)).getLowestMessagePriority();
            }
            SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[jsMessageArray.length];
            for (int i = 0; i < jsMessageArray.length; ++i) {
                if (jsMessageArray[i] == null) continue;
                sIMessageHandleArray[i] = jsMessageArray[i].getMessageHandle();
            }
            this.convHelper.deleteMessages(sIMessageHandleArray, n, n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteMessages");
        }
    }

    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "resetCursor");
        }
        this.nextIndex = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "resetCursor");
        }
    }

    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRemainingMessageCount");
        }
        this.checkValid();
        int n = this.getUnSeenMessageCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRemainingMessageCount", (Object)("" + n));
        }
        return n;
    }

    private int getSeenMessageCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSeenMessageCount");
        }
        int n = 0;
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.messages[i] == null) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSeenMessageCount", (Object)("" + n));
        }
        return n;
    }

    private int getUnSeenMessageCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUnseenMessageCount");
        }
        int n = 0;
        for (int i = this.nextIndex; i < this.messages.length; ++i) {
            if (this.messages[i] == null) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUnseenMessageCount", (Object)("" + n));
        }
        return n;
    }

    public void unlockUnseen() throws SIResourceException, SIConnectionDroppedException, SIConnectionLostException, SIIncorrectCallException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "unlockUnseen");
        }
        SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[this.getUnSeenMessageCount()];
        int n = 0;
        for (int i = this.nextIndex; i < this.messages.length; ++i) {
            if (this.messages[i] == null) continue;
            if (this.isRecoverable(this.messages[i])) {
                sIMessageHandleArray[n] = this.messages[i].getMessageHandle();
                ++n;
            }
            this.messages[i] = null;
        }
        if (this.consumerSession.isMulticastSession()) {
            this.consumerSession.unlockMulticastMessages(sIMessageHandleArray);
        } else {
            this.convHelper.unlockSet(sIMessageHandleArray);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "unlockUnseen");
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getConsumerSession");
        }
        this.checkValid();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getConsumerSession");
        }
        return this.consumerSession;
    }

    private void checkValid() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkValid");
        }
        if (this.invalid || this.consumerSession.isClosed() || Thread.currentThread() != this.owningThread) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "not valid", this);
            }
            this.invalid = true;
            throw new SISessionUnavailableException(null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkValid");
        }
    }

    protected void markInvalid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "markInvalid");
        }
        this.invalid = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "markInvalid");
        }
    }

    private boolean isRecoverable(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isRecoverable");
        }
        boolean bl = false;
        Reliability reliability = jsMessage.getReliability();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Message Reliability: ", reliability);
        }
        if (reliability.compareTo(this.consumerSession.getUnrecoverableReliability()) > 0) {
            bl = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Message is recoverable");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isRecoverable");
        }
        return bl;
    }

    public String toString() {
        String string = "[ ";
        for (int i = 0; i < this.messages.length; ++i) {
            string = i == this.nextIndex ? string + "* " + this.messages[i] : string + this.messages[i];
            string = i == this.messages.length - 1 ? string + " ]" : string + ", ";
        }
        return "LockedMessageEnumerationImpl@" + Integer.toHexString(this.hashCode()) + "- contents: " + string + ", invalid: " + this.invalid + ", nextIndex: " + this.nextIndex + ", consumerSession: " + this.consumerSession + ", owningThread: " + this.owningThread + ", currentThread: " + Thread.currentThread();
    }

    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "hasNext");
        }
        boolean bl2 = bl = this.getRemainingMessageCount() > 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "hasNext", (Object)("" + bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/LockedMessageEnumerationImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.38");
        }
    }
}

