/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.asynch;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import java.util.LinkedList;

public class AsynchConsumerThreadPool {
    private static final TraceComponent tc = SibTr.register(AsynchConsumerThreadPool.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final int MAX_THREADS = 10;
    private static final String THREADPOOL_NAME = "Asynchronous Consumer";
    private int roundRobinCounter = 0;
    private ScheduleQueue[] scheduleQueues;
    private EmptyScheduleQueueStack emptyStack;
    private static AsynchConsumerThreadPool instance;

    public static AsynchConsumerThreadPool getInstance() {
        return instance;
    }

    private AsynchConsumerThreadPool() {
        ThreadPool threadPool = new ThreadPool(THREADPOOL_NAME, 0, 10);
        this.scheduleQueues = new ScheduleQueue[10];
        this.emptyStack = new EmptyScheduleQueueStack(10);
        for (int i = 0; i < 10; ++i) {
            this.scheduleQueues[i] = new ScheduleQueue(threadPool);
            this.emptyStack.push(this.scheduleQueues[i]);
        }
    }

    public void dispatch(AsynchConsumerProxyQueue asynchConsumerProxyQueue) {
        ScheduleQueue scheduleQueue = this.emptyStack.pop();
        if (scheduleQueue == null) {
            scheduleQueue = this.scheduleQueues[this.roundRobinCounter];
            this.roundRobinCounter = (this.roundRobinCounter + 1) % 10;
        }
        scheduleQueue.addWork(asynchConsumerProxyQueue);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/asynch/AsynchConsumerThreadPool.java, SIB.comms, WAS602.SIB, o0610.11 1.16");
        }
        instance = new AsynchConsumerThreadPool();
    }

    private class EmptyScheduleQueueStack {
        private int maxStackSize;
        private ScheduleQueue[] stackArray;
        private int currentStackSize = 0;

        private EmptyScheduleQueueStack(int n) {
            this.maxStackSize = n;
            this.stackArray = new ScheduleQueue[n];
        }

        public synchronized void push(ScheduleQueue scheduleQueue) {
            boolean bl = false;
            for (int i = 0; i < this.currentStackSize; ++i) {
                bl |= this.stackArray[i] == scheduleQueue;
            }
            if (!bl) {
                this.stackArray[this.currentStackSize] = scheduleQueue;
                ++this.currentStackSize;
            }
        }

        public synchronized ScheduleQueue pop() {
            if (this.currentStackSize == 0) {
                return null;
            }
            return this.stackArray[--this.currentStackSize];
        }
    }

    private class ScheduleQueue
    implements Runnable {
        LinkedList work = new LinkedList();
        private final String IDLE_STATE = "idle";
        private final String RUNNING_STATE = "running";
        private final String WAITING_STATE = "waiting";
        private String state = "idle";
        ThreadPool threadPool;

        public ScheduleQueue(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public synchronized void addWork(AsynchConsumerProxyQueue asynchConsumerProxyQueue) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ScheduleQueue.addWork", asynchConsumerProxyQueue);
            }
            this.work.addLast(asynchConsumerProxyQueue);
            if (this.state != "running") {
                if (this.state == "waiting") {
                    this.state = "running";
                    this.notify();
                } else {
                    try {
                        this.state = "running";
                        this.threadPool.execute((Runnable)this);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ScheduleQueue.addWork");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ScheduleQueue.run");
            }
            AsynchConsumerProxyQueue asynchConsumerProxyQueue = null;
            ScheduleQueue scheduleQueue = this;
            synchronized (scheduleQueue) {
                asynchConsumerProxyQueue = (AsynchConsumerProxyQueue)this.work.removeFirst();
            }
            while (this.state == "running") {
                asynchConsumerProxyQueue.deliverMessages();
                scheduleQueue = this;
                synchronized (scheduleQueue) {
                    if (this.work.isEmpty()) {
                        this.state = "waiting";
                        AsynchConsumerThreadPool.this.emptyStack.push(this);
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.state == "running") {
                        asynchConsumerProxyQueue = (AsynchConsumerProxyQueue)this.work.removeFirst();
                    } else {
                        this.state = "idle";
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ScheduleQueue.run");
            }
        }
    }
}

