/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.LinkedList;

public class OrderingContextProxy
extends Proxy
implements OrderingContext {
    private static String CLASS_NAME = OrderingContextProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(OrderingContextProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private int useCount = 0;
    private boolean dead = false;
    private Queue queue;

    public OrderingContextProxy(Conversation conversation, ConnectionProxy connectionProxy) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.create();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public OrderingContextProxy(int n) {
        super(null, null);
        this.setProxyID((short)n);
    }

    public short getId() {
        return this.getProxyID();
    }

    public int getUseCount() {
        return this.useCount;
    }

    public synchronized void incrementUseCount() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "incrementUseCount");
        }
        if (this.dead) {
            this.create();
            this.dead = false;
        }
        ++this.useCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Use count is now: " + this.useCount);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "incrementUseCount");
        }
    }

    public synchronized void decrementUseCount() throws SIConnectionDroppedException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "decrementUseCount");
        }
        --this.useCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Use count is now: " + this.useCount);
        }
        if (this.useCount == 0) {
            this.close();
            this.dead = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "decrementUseCount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        block13: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "create");
            }
            WsByteBuffer wsByteBuffer = this.getWsBuffer(2);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = null;
            try {
                try {
                    receivedData = this.JFAPExchange(linkedList, 107, 11, true);
                    short s = this.getCommandCompletionCode(receivedData, 236);
                    if (s != 0) {
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    receivedData.getBuffer().flip();
                    short s2 = receivedData.getBuffer().getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Created the order proxy. ID: " + s2);
                    }
                    this.setProxyID(s2);
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    throw new SIConnectionDroppedException("", sIConnectionLostException);
                }
                catch (NoCapacityException noCapacityException) {
                    FFDCFilter.processException((Throwable)noCapacityException, (String)(CLASS_NAME + ".create"), (String)"1-012-0001", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "NoCapacityException caught!");
                    }
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, noCapacityException);
                    }
                    Object var7_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    break block13;
                }
                Object var7_8 = null;
                if (receivedData == null) break block13;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "create");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SIConnectionDroppedException, SIErrorException {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "close");
            }
            this.queue = null;
            WsByteBuffer wsByteBuffer = this.getWsBuffer(4);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putShort(this.getProxyID());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = null;
            try {
                block11: {
                    try {
                        receivedData = this.JFAPExchange(linkedList, 109, -1, true);
                        short s = this.getCommandCompletionCode(receivedData, 238);
                        if (s == 0) break block11;
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    catch (SIConnectionLostException sIConnectionLostException) {
                        throw new SIConnectionDroppedException("", sIConnectionLostException);
                    }
                    catch (NoCapacityException noCapacityException) {
                        FFDCFilter.processException((Throwable)noCapacityException, (String)(CLASS_NAME + ".close"), (String)"1-012-0002", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "NoCapacityException caught!");
                        }
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, tc, noCapacityException);
                        }
                        Object var6_8 = null;
                        if (receivedData != null) {
                            receivedData.getBuffer().release();
                        }
                        break block12;
                    }
                }
                Object var6_7 = null;
                if (receivedData == null) break block12;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    public String toString() {
        return "CommsOrderContext@" + Integer.toHexString(this.hashCode()) + ". Id: " + this.getProxyID() + ". Use count: " + this.useCount + ". Dead: " + this.dead;
    }

    public void associateWithQueue(Queue queue) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "associateWithQueue", queue);
        }
        this.queue = queue;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "associateWithQueue");
        }
    }

    public Queue getAssociatedQueue() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getAssociatedQueue");
        }
        Queue queue = this.queue;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getAssociatedQueue", queue);
        }
        return queue;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/OrderingContextProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.11");
        }
    }
}

