/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public abstract class DestinationSessionProxy
extends Proxy
implements DestinationSession {
    private static final TraceComponent tc = SibTr.register(DestinationSessionProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    protected SIDestinationAddress destinationAddress = null;

    public DestinationSessionProxy(Conversation conversation, ConnectionProxy connectionProxy) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public abstract void close() throws SIResourceException, SIConnectionLostException, SIConnectionDroppedException, SIErrorException;

    public SICoreConnection getConnection() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConnection");
        }
        this.checkAlreadyClosed();
        ConnectionProxy connectionProxy = this.getConnectionProxy();
        connectionProxy.checkAlreadyClosed();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConnection", connectionProxy);
        }
        return connectionProxy;
    }

    protected void checkAlreadyClosed() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "checkAlreadyClosed");
        }
        if (this.isClosed()) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "checkAlreadyClosed");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDestinationAddress");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDestinationAddress", this.destinationAddress);
        }
        return this.destinationAddress;
    }

    protected void setDestinationAddress(SIDestinationAddress sIDestinationAddress) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setDestinationAddress", sIDestinationAddress);
        }
        this.destinationAddress = sIDestinationAddress;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setDestinationAddress");
        }
    }

    protected void inflateData(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "inflateData");
        }
        this.setProxyID(wsByteBuffer.getShort());
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Session ID", "" + this.getProxyID());
        }
        if (wsByteBuffer.hasRemaining()) {
            this.setDestinationAddress(CommsUtils.getSIDestinationAddress(wsByteBuffer));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "inflateData");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/DestinationSessionProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.15");
        }
    }
}

