/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.LocalTransactionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroupFactory;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.MulticastReadAheadProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.JsMessageHandle;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConsumerSessionProxy
extends DestinationSessionProxy
implements ConsumerSession {
    private static String CLASS_NAME;
    private AsynchConsumerProxyQueue proxyQueue = null;
    private boolean isReadAhead = false;
    private Object synchLock = new Object();
    private Object asynchLock = new Object();
    boolean asynchConsumerRegistered = false;
    private static String STOPPED;
    private static String STOPPING;
    private static String CLOSED;
    private static String CLOSING;
    private static String STARTED;
    private String state = STOPPED;
    private Object lmeMonitor = new Object();
    private Reliability unrecoverableReliabilty = null;
    private boolean multicastSession = false;
    private long messageProcessorId;
    private OrderingContextProxy currentOrderingContext = null;
    private static final TraceComponent tc;
    private static final TraceNLS nls;
    private static SIBPmiRm sibPmiRm;
    private boolean executingReceiveWithWait = false;
    private LinkedHashMap lockedMulticastMessages = new LinkedHashMap();

    public ConsumerSessionProxy(Conversation conversation, ConnectionProxy connectionProxy, WsByteBuffer wsByteBuffer, AsynchConsumerProxyQueue asynchConsumerProxyQueue, Reliability reliability, boolean bl, SIDestinationAddress sIDestinationAddress, long l, boolean bl2) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.setDestinationAddress(sIDestinationAddress);
        this.inflateData(wsByteBuffer);
        this.isReadAhead = asynchConsumerProxyQueue != null;
        this.proxyQueue = asynchConsumerProxyQueue;
        this.multicastSession = bl;
        this.unrecoverableReliabilty = reliability;
        this.messageProcessorId = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public ConsumerSessionProxy() {
        super(null, null);
        this.setProxyID((short)123);
    }

    public boolean isMulticastSession() {
        return this.multicastSession;
    }

    public Reliability getUnrecoverableReliability() {
        return this.unrecoverableReliabilty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveNoWait(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "receiveNoWait", sITransaction);
        }
        SIBusMessage sIBusMessage = null;
        Object object = this.synchLock;
        synchronized (object) {
            if (this.state == CLOSED || this.state == CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.executingReceiveWithWait) {
                throw new SIIncorrectCallException();
            }
            if (sITransaction != null) {
                SITransaction sITransaction2 = sITransaction;
                synchronized (sITransaction2) {
                    if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    sIBusMessage = this._receiveNoWait(sITransaction);
                }
            } else {
                sIBusMessage = this._receiveNoWait(sITransaction);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "receiveNoWait");
        }
        return sIBusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIBusMessage _receiveNoWait(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_receiveNoWait");
        }
        JsMessage jsMessage = null;
        Object object = null;
        if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
            object = sibPmiRm.syncConsumeMessageBlock(this.destinationAddress.getBusName(), this.destinationAddress.getDestinationName());
        }
        boolean bl = false;
        try {
            if (this.isReadAhead) {
                try {
                    jsMessage = this.proxyQueue.receiveNoWait(sITransaction);
                }
                catch (MessageDecodeFailedException messageDecodeFailedException) {
                    FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)(CLASS_NAME + "._receiveNoWait"), (String)"1-003-0001", (Object)this);
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1002", null, null));
                    sIResourceException.initCause(messageDecodeFailedException);
                    if (tc.isEventEnabled()) {
                        SibTr.event(this, tc, "receiveNoWait", sIResourceException);
                    }
                    throw sIResourceException;
                }
            } else {
                jsMessage = this.performReceive(-1L, sITransaction);
            }
            bl = true;
            if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 0);
            }
            Object var8_7 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_receiveNoWait");
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveWithWait(SITransaction sITransaction, long l) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "receiveWithWait", new Object[]{sITransaction, "" + l});
        }
        SIBusMessage sIBusMessage = null;
        Object object2 = this.synchLock;
        synchronized (object2) {
            if (this.state == CLOSED || this.state == CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            this.executingReceiveWithWait = true;
        }
        try {
            if (sITransaction != null) {
                object2 = sITransaction;
                synchronized (object2) {
                    if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    sIBusMessage = this._receiveWithWait(sITransaction, l);
                }
            } else {
                sIBusMessage = this._receiveWithWait(sITransaction, l);
            }
            Object var9_7 = null;
            object = this.synchLock;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Object object3 = this.synchLock;
            synchronized (object3) {
                this.executingReceiveWithWait = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.executingReceiveWithWait = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "receiveWithWait");
        }
        return sIBusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIBusMessage _receiveWithWait(SITransaction sITransaction, long l) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_receiveWithWait");
        }
        JsMessage jsMessage = null;
        Object object = null;
        if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
            object = sibPmiRm.syncConsumeMessageBlock(this.destinationAddress.getBusName(), this.destinationAddress.getDestinationName());
        }
        boolean bl = false;
        try {
            if (this.isReadAhead) {
                try {
                    jsMessage = this.proxyQueue.receiveWithWait(l, sITransaction);
                }
                catch (MessageDecodeFailedException messageDecodeFailedException) {
                    FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)(CLASS_NAME + "._receiveWithWait"), (String)"1-003-0002", (Object)this);
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1002", null, null));
                    sIResourceException.initCause(messageDecodeFailedException);
                    if (tc.isEventEnabled()) {
                        SibTr.event(this, tc, "receiveWithWait", sIResourceException);
                    }
                    throw sIResourceException;
                }
            } else {
                jsMessage = this.performReceive(l, sITransaction);
            }
            bl = true;
            if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 0);
            }
            Object var10_8 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_receiveWithWait");
        }
        return jsMessage;
    }

    private JsMessage performReceive(long l, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "performReceive");
        }
        if (this.proxyQueue != null && !this.isReadAhead) {
            throw new SIIncorrectCallException();
        }
        if (l < -1L) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8004", new Object[]{"" + l}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".performReceive"), (String)"1-003-0006", (Object)this);
            throw sIErrorException;
        }
        JsMessage jsMessage = null;
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        WsByteBuffer wsByteBuffer = this.getWsBuffer(18);
        wsByteBuffer.putShort((short)this.getConnectionObjectID());
        wsByteBuffer.putShort(this.getProxyID());
        if (sITransaction != null) {
            wsByteBuffer.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
        } else {
            wsByteBuffer.putInt(0);
        }
        wsByteBuffer.putLong(l);
        wsByteBuffer.flip();
        linkedList.add(wsByteBuffer);
        ReceivedData receivedData = this.JFAPExchange(linkedList, 78, 7, true);
        short s = this.getCommandCompletionCode(receivedData, 206);
        if (s != 0) {
            this.checkFor_SISessionUnavailableException(receivedData, s);
            this.checkFor_SISessionDroppedException(receivedData, s);
            this.checkFor_SIConnectionUnavailableException(receivedData, s);
            this.checkFor_SIConnectionDroppedException(receivedData, s);
            this.checkFor_SIResourceException(receivedData, s);
            this.checkFor_SIConnectionLostException(receivedData, s);
            this.checkFor_SILimitExceededException(receivedData, s);
            this.checkFor_SINotAuthorizedException(receivedData, s);
            this.checkFor_SIIncorrectCallException(receivedData, s);
            this.checkFor_SIErrorException(receivedData, s);
            this.defaultChecker(receivedData, s);
        }
        WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
        wsByteBuffer2.flip();
        short s2 = wsByteBuffer2.getShort();
        short s3 = wsByteBuffer2.getShort();
        int n = (int)wsByteBuffer2.getLong();
        if (n > -1) {
            try {
                if (wsByteBuffer2.hasArray()) {
                    jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer2.array(), wsByteBuffer2.position() + wsByteBuffer2.arrayOffset(), n);
                }
                byte[] byArray = new byte[n];
                wsByteBuffer2.get(byArray);
                jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(byArray, 0, n);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".performReceive"), (String)"1-003-0005", (Object)this);
                throw new SIErrorException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1002", new Object[]{throwable}, null));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "No Message received!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "performReceive", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "_close");
            }
            WsByteBuffer wsByteBuffer = this.getWsBuffer(4);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putShort(this.getProxyID());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 73, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 201);
                if (s != 0) {
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var6_5 = null;
                if (receivedData == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        if (this.executingOnCallbackThread()) {
            Object object = this.synchLock;
            synchronized (object) {
                this.state = CLOSED;
            }
            this.proxyQueue.closeInsideAsynchConsumerNotification();
        } else {
            Object object = this.synchLock;
            synchronized (object) {
                if (this.state != CLOSED && this.state != CLOSING) {
                    this.state = CLOSING;
                    if (this.proxyQueue != null) {
                        this.proxyQueue.closing();
                    } else {
                        this.state = CLOSED;
                        if (!bl && !this.isClosed()) {
                            this._close();
                            if (this.currentOrderingContext != null) {
                                this.currentOrderingContext.decrementUseCount();
                                this.currentOrderingContext = null;
                            }
                        }
                    }
                }
            }
            object = this.asynchLock;
            synchronized (object) {
                Object object2 = this.synchLock;
                synchronized (object2) {
                    if (this.state == CLOSING) {
                        this.state = CLOSED;
                        if (!bl && this.proxyQueue != null) {
                            this.proxyQueue.closed();
                            if (this.currentOrderingContext != null) {
                                this.currentOrderingContext.decrementUseCount();
                                this.currentOrderingContext = null;
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "start");
        }
        if (this.executingOnCallbackThread()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Start is being called on the callback thread");
            }
            if (this.state == CLOSED || this.state == CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            this.proxyQueue.startInsideAsynchConsumerNotification();
        } else {
            Object object = this.asynchLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Got asynch lock");
                }
                Object object2 = this.synchLock;
                synchronized (object2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Got sync lock");
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Current state is: " + this.state);
                    }
                    if (this.state != STARTED) {
                        while (this.state == STOPPING) {
                            try {
                                this.synchLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.state == CLOSED || this.state == CLOSING) {
                            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
                        }
                        if (this.state != STARTED) {
                            this.state = STARTED;
                            if (this.proxyQueue != null) {
                                this.proxyQueue.start();
                            } else {
                                WsByteBuffer wsByteBuffer = this.getWsBuffer(4);
                                wsByteBuffer.putShort((short)this.getConnectionObjectID());
                                wsByteBuffer.putShort(this.getProxyID());
                                wsByteBuffer.flip();
                                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                                linkedList.add(wsByteBuffer);
                                this.JFAPSend(linkedList, 85, 7, true);
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "stop");
        }
        if (this.executingOnCallbackThread()) {
            if (this.state == CLOSED || this.state == CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            this.proxyQueue.stopInsideAsynchConsumerNotification();
        } else {
            Object object;
            Object object2;
            block21: {
                object2 = this.synchLock;
                synchronized (object2) {
                    if (this.state == CLOSED || this.state == CLOSING) {
                        throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
                    }
                    if (this.state != STOPPED && this.state != STOPPING) {
                        this.state = STOPPING;
                        if (this.proxyQueue != null) {
                            this.proxyQueue.stopping();
                        } else {
                            this.state = STOPPED;
                            object = this.getWsBuffer(4);
                            object.putShort((short)this.getConnectionObjectID());
                            object.putShort(this.getProxyID());
                            object.flip();
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            linkedList.add(object);
                            ReceivedData receivedData = this.JFAPExchange(linkedList, 86, 7, true);
                            try {
                                short s = this.getCommandCompletionCode(receivedData, 214);
                                if (s != 0) {
                                    this.checkFor_SISessionUnavailableException(receivedData, s);
                                    this.checkFor_SISessionDroppedException(receivedData, s);
                                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                                    this.checkFor_SIResourceException(receivedData, s);
                                    this.checkFor_SIConnectionLostException(receivedData, s);
                                    this.checkFor_SIErrorException(receivedData, s);
                                    this.defaultChecker(receivedData, s);
                                }
                                Object var7_6 = null;
                                if (receivedData == null) break block21;
                            }
                            catch (Throwable throwable) {
                                Object var7_7 = null;
                                if (receivedData != null) {
                                    receivedData.getBuffer().release();
                                }
                                throw throwable;
                            }
                            receivedData.getBuffer().release();
                        }
                    }
                }
            }
            object2 = this.asynchLock;
            synchronized (object2) {
                object = this.synchLock;
                synchronized (object) {
                    if (this.state == STOPPING) {
                        this.state = STOPPED;
                        if (this.proxyQueue != null) {
                            this.proxyQueue.stopped();
                        }
                    }
                    this.synchLock.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockAll");
        }
        Object object = this.synchLock;
        // MONITORENTER : object
        if (this.state == CLOSED) throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        if (this.state == CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        if (this.isMulticastSession()) {
            this.unlockAllLockedMulticastMessages();
        } else if (this.proxyQueue != null) {
            this.proxyQueue.unlockAll();
        } else {
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            WsByteBuffer wsByteBuffer = this.getWsBuffer(4);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putShort(this.getProxyID());
            wsByteBuffer.flip();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 88, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 216);
                if (s != 0) {
                    this.checkFor_SISessionUnavailableException(receivedData, s);
                    this.checkFor_SISessionDroppedException(receivedData, s);
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var7_6 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (receivedData == null) throw throwable;
                receivedData.getBuffer().release();
                throw throwable;
            }
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(this, tc, "unlockAll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void unlockSet(SIMessageHandle[] sIMessageHandleArray) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockSet", new Object[]{sIMessageHandleArray.length + " msg ids"});
        }
        Object object = this.synchLock;
        // MONITORENTER : object
        if (this.state == CLOSED) throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        if (this.state == CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        if (this.isMulticastSession()) {
            this.unlockMulticastMessages(sIMessageHandleArray);
        } else {
            WsByteBuffer wsByteBuffer = this.getWsBuffer(16 * sIMessageHandleArray.length + 4 + 2 + 2);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putShort(this.getProxyID());
            this.appendHandlesToByteBuffer(sIMessageHandleArray, wsByteBuffer);
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 104, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 233);
                if (s != 0) {
                    this.checkFor_SISessionUnavailableException(receivedData, s);
                    this.checkFor_SISessionDroppedException(receivedData, s);
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIIncorrectCallException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var8_7 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (receivedData == null) throw throwable;
                receivedData.getBuffer().release();
                throw throwable;
            }
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(this, tc, "unlockSet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _deleteSet(SIMessageHandle[] sIMessageHandleArray, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        block16: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "deleteSet", new Object[]{sIMessageHandleArray.length + " msg handles", sITransaction});
            }
            if (this.isMulticastSession()) {
                int n;
                if (sITransaction != null) {
                    for (n = 0; n < sIMessageHandleArray.length; ++n) {
                        LinkedHashMap linkedHashMap = this.lockedMulticastMessages;
                        synchronized (linkedHashMap) {
                            JsMessage jsMessage = (JsMessage)this.lockedMulticastMessages.get(sIMessageHandleArray[n]);
                            if (jsMessage != null) {
                                ((Transaction)((Object)sITransaction)).addMulticastMessage(jsMessage, this.proxyQueue);
                            }
                            continue;
                        }
                    }
                }
                for (n = 0; n < sIMessageHandleArray.length; ++n) {
                    this.discardMessage(sIMessageHandleArray[n]);
                }
            } else {
                WsByteBuffer wsByteBuffer = this.getWsBuffer(16 * sIMessageHandleArray.length + 4 + 2 + 2 + 4);
                wsByteBuffer.putShort((short)this.getConnectionObjectID());
                wsByteBuffer.putShort(this.getProxyID());
                if (sITransaction == null) {
                    wsByteBuffer.putInt(0);
                } else {
                    wsByteBuffer.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
                }
                this.appendHandlesToByteBuffer(sIMessageHandleArray, wsByteBuffer);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 91, 7, true);
                try {
                    short s = this.getCommandCompletionCode(receivedData, 219);
                    if (s != 0) {
                        this.checkFor_SISessionUnavailableException(receivedData, s);
                        this.checkFor_SISessionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIResourceException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SILimitExceededException(receivedData, s);
                        this.checkFor_SIIncorrectCallException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    Object var8_10 = null;
                    if (receivedData == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSet(SIMessageHandle[] sIMessageHandleArray, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deleteSet", new Object[]{sIMessageHandleArray.length + " msg handles", sITransaction});
        }
        Object object = this.synchLock;
        synchronized (object) {
            if (this.state == CLOSED || this.state == CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (sITransaction == null) {
                this._deleteSet(sIMessageHandleArray, sITransaction);
            } else {
                SITransaction sITransaction2 = sITransaction;
                synchronized (sITransaction2) {
                    if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    this._deleteSet(sIMessageHandleArray, sITransaction);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, OrderingContext orderingContext) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "registerAsynchConsumerCallback", new Object[]{asynchConsumerCallback, "" + n, "" + l, "" + n2, orderingContext});
        }
        Object object = this.asynchLock;
        synchronized (object) {
            Object object2 = this.synchLock;
            synchronized (object2) {
                this._registerAsynchConsumerCallback(asynchConsumerCallback, n, l, n2, orderingContext);
                if (this.proxyQueue != null) {
                    this.proxyQueue.setAsynchCallback(asynchConsumerCallback, n, l, n2, orderingContext);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "registerAsynchConsumerCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _registerAsynchConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, OrderingContext orderingContext) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        block27: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "_registerAsynchConsumerCallback");
            }
            boolean bl = false;
            if (asynchConsumerCallback != null) {
                OrderingContextProxy orderingContextProxy = (OrderingContextProxy)orderingContext;
                if (orderingContextProxy == null) {
                    if (this.currentOrderingContext != null) {
                        this.currentOrderingContext.decrementUseCount();
                        this.currentOrderingContext = null;
                    }
                } else if (this.currentOrderingContext == null && this.asynchConsumerRegistered) {
                    orderingContextProxy.incrementUseCount();
                } else if (this.currentOrderingContext != null && this.asynchConsumerRegistered) {
                    if (orderingContextProxy != this.currentOrderingContext) {
                        this.currentOrderingContext.decrementUseCount();
                        orderingContextProxy.incrementUseCount();
                    }
                } else if (!this.asynchConsumerRegistered) {
                    orderingContextProxy.incrementUseCount();
                }
                try {
                    block26: {
                        try {
                            if (this.isReadAhead) {
                                if (n != 0 || l != 0L) {
                                    short s = this.proxyQueue.getCurrentMessageBatchSequenceNumber();
                                    short s2 = this.proxyQueue.getId();
                                    ProxyQueueConversationGroup proxyQueueConversationGroup = ((ClientConversationState)this.getConversation().getAttachment()).getProxyQueueConversationHGroup();
                                    s = (short)(s + 1);
                                    this.isReadAhead = false;
                                    this.proxyQueue = proxyQueueConversationGroup.createAsynchConsumerProxyQueue(s2, s, orderingContext);
                                    this.proxyQueue.setConsumerSession(this);
                                    this.proxyQueue.setAsynchCallback(asynchConsumerCallback, n, l, n2, orderingContext);
                                    break block26;
                                } else {
                                    this.proxyQueue.setAsynchCallback(asynchConsumerCallback, n, l, n2, null);
                                }
                                break block26;
                            }
                            if (this.proxyQueue != null) {
                                this.proxyQueue.setAsynchCallback(asynchConsumerCallback, n, l, n2, orderingContext);
                            } else {
                                ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                                ProxyQueueConversationGroup proxyQueueConversationGroup = clientConversationState.getProxyQueueConversationHGroup();
                                if (proxyQueueConversationGroup == null) {
                                    ProxyQueueConversationGroupFactory proxyQueueConversationGroupFactory = ProxyQueueConversationGroupFactory.getRef();
                                    proxyQueueConversationGroup = proxyQueueConversationGroupFactory.create(this.getConversation());
                                    clientConversationState.setProxyQueueConversationGroup(proxyQueueConversationGroup);
                                }
                                this.proxyQueue = proxyQueueConversationGroup.createAsynchConsumerProxyQueue(orderingContext);
                                this.proxyQueue.setConsumerSession(this);
                                this.proxyQueue.setAsynchCallback(asynchConsumerCallback, n, l, n2, orderingContext);
                            }
                        }
                        catch (SIResourceException sIResourceException) {
                            FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + "._registerAsynchConsumerCallback"), (String)"1-003-0004", (Object)this);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Caught a resource exception", sIResourceException);
                            }
                            throw new SIConnectionDroppedException(sIResourceException.getMessage(), sIResourceException);
                        }
                    }
                    bl = true;
                    this.currentOrderingContext = orderingContextProxy;
                    this.asynchConsumerRegistered = true;
                    Object var13_15 = null;
                    if (bl || orderingContextProxy == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (!bl && orderingContextProxy != null) {
                        orderingContextProxy.decrementUseCount();
                    }
                    throw throwable;
                }
                orderingContextProxy.decrementUseCount();
            } else {
                this.deregisterAsynchConsumerCallback();
                if (this.currentOrderingContext != null) {
                    this.currentOrderingContext.decrementUseCount();
                    this.currentOrderingContext = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_registerAsynchConsumerCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deregisterAsynchConsumerCallback");
        }
        Object object = this.asynchLock;
        synchronized (object) {
            Object object2 = this.synchLock;
            synchronized (object2) {
                if (this.state == STARTED) {
                    throw new SIIncorrectCallException(nls.getFormattedMessage("CALLBACK_CHANGE_WHILE_STARTED_SICO1015", null, null));
                }
                if (this.asynchConsumerRegistered) {
                    this.asynchConsumerRegistered = false;
                    this.proxyQueue.setAsynchCallback(null, 0, 0L, 0, null);
                    if (!this.isReadAhead) {
                        this.proxyQueue = null;
                    }
                    if (this.currentOrderingContext != null) {
                        this.currentOrderingContext.decrementUseCount();
                        this.currentOrderingContext = null;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deregisterAsynchConsumerCallback");
        }
    }

    public void activateAsynchConsumer(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "activateAsynchConsumer");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "activateAsynchConsumer");
        }
        throw new SIErrorException(nls.getFormattedMessage("CLIENT_METHOD_INVALID_SICO1021", new Object[]{"activateAsynchConsumer"}, null));
    }

    public long getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getId", "" + this.messageProcessorId);
        }
        return this.messageProcessorId;
    }

    public void deliverAsyncException(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deliverAsyncException", throwable);
        }
        if (this.proxyQueue != null) {
            this.proxyQueue.deliverException(throwable);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "** Odd - we are not async?!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deliverAsyncException");
        }
    }

    private void appendHandlesToByteBuffer(SIMessageHandle[] sIMessageHandleArray, WsByteBuffer wsByteBuffer) {
        wsByteBuffer.putInt(sIMessageHandleArray.length);
        for (int i = 0; i < sIMessageHandleArray.length; ++i) {
            JsMessageHandle jsMessageHandle = (JsMessageHandle)sIMessageHandleArray[i];
            wsByteBuffer.putLong(jsMessageHandle.getSystemMessageValue());
            wsByteBuffer.put(jsMessageHandle.getSystemMessageSourceUuid().toByteArray());
            if (!tc.isDebugEnabled()) continue;
            SibTr.debug(this, tc, "message handle: " + sIMessageHandleArray[i]);
        }
    }

    private boolean executingOnCallbackThread() {
        return this.proxyQueue != null && this.proxyQueue.getAsynchConsumerThread() == Thread.currentThread();
    }

    public Object getAsynchLock() {
        return this.asynchLock;
    }

    public Object getSynchLock() {
        return this.synchLock;
    }

    public Object getLMEMonitor() {
        return this.lmeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockMessage(JsMessage jsMessage) {
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "lockMessage", jsMessage);
            }
            try {
                SIMessageHandle sIMessageHandle = jsMessage.getMessageHandle();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Adding message handle: " + sIMessageHandle);
                }
                LinkedHashMap linkedHashMap = this.lockedMulticastMessages;
                synchronized (linkedHashMap) {
                    this.lockedMulticastMessages.put(sIMessageHandle, jsMessage.getReceived());
                }
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)(CLASS_NAME + ".lockMessage"), (String)"1-003-0007", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                SibTr.debug(this, tc, "Unable to lock the message due to an MFP Exception:", messageCopyFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "lockMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardMessage(SIMessageHandle sIMessageHandle) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "discardMessage", sIMessageHandle);
        }
        LinkedHashMap linkedHashMap = this.lockedMulticastMessages;
        synchronized (linkedHashMap) {
            this.lockedMulticastMessages.remove(sIMessageHandle);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "discardMessage");
        }
    }

    private void unlockAllLockedMulticastMessages() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockAllLockedMulticastMessages");
        }
        Set set = this.lockedMulticastMessages.keySet();
        SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[set.size()];
        set.toArray(sIMessageHandleArray);
        this.unlockMulticastMessages(sIMessageHandleArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlockAllLockedMulticastMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockMulticastMessages(SIMessageHandle[] sIMessageHandleArray) throws SIResourceException {
        ReadAheadQueue readAheadQueue;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockMulticastMessages", sIMessageHandleArray);
        }
        ReadAheadQueue readAheadQueue2 = readAheadQueue = (ReadAheadQueue)((MulticastReadAheadProxyQueueImpl)this.proxyQueue).getQueue();
        synchronized (readAheadQueue2) {
            for (int i = sIMessageHandleArray.length - 1; i >= 0; --i) {
                this.unlockMulticastMessage(readAheadQueue, sIMessageHandleArray[i]);
            }
            this.proxyQueue.nudge();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlockMulticastMessages");
        }
    }

    public void unlockMulticastMessage(SIMessageHandle sIMessageHandle) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockMessage", sIMessageHandle);
        }
        ReadAheadQueue readAheadQueue = (ReadAheadQueue)((MulticastReadAheadProxyQueueImpl)this.proxyQueue).getQueue();
        this.unlockMulticastMessage(readAheadQueue, sIMessageHandle);
        this.discardMessage(sIMessageHandle);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlockMessage");
        }
    }

    private void unlockMulticastMessage(ReadAheadQueue readAheadQueue, SIMessageHandle sIMessageHandle) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockMessage", new Object[]{readAheadQueue, sIMessageHandle});
        }
        try {
            JsMessage jsMessage = (JsMessage)this.lockedMulticastMessages.get(sIMessageHandle);
            if (jsMessage != null) {
                jsMessage.setRedeliveredCount(jsMessage.getRedeliveredCount() + 1);
                QueueData queueData = new QueueData(this.proxyQueue, false, this.getMessageBufferFromMessage(jsMessage));
                readAheadQueue.putToFront(queueData, (short)0);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "** The message was not locked! **");
            }
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + ".unlockMessage"), (String)"1-003-0008", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Caught an MFP Exception:", messageEncodeFailedException);
            }
            throw new SIResourceException(messageEncodeFailedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlockMessage");
        }
    }

    public WsByteBuffer getMessageBufferFromMessage(JsMessage jsMessage) throws MessageEncodeFailedException {
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        List list = jsMessage.encode(clientConversationState.getCommsConnection());
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += ((byte[])list.get(i)).length;
        }
        WsByteBuffer wsByteBuffer = this.getWsBuffer(n);
        for (int i = 0; i < list.size(); ++i) {
            wsByteBuffer.put((byte[])list.get(i));
        }
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    static {
        block4: {
            CLASS_NAME = ConsumerSessionProxy.class.getName();
            STOPPED = "STOPPED";
            STOPPING = "STOPPING";
            CLOSED = "CLOSED";
            CLOSING = "CLOSING";
            STARTED = "STARTED";
            tc = SibTr.register(ConsumerSessionProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
            nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/ConsumerSessionProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.82.1.1");
            }
            try {
                sibPmiRm = SIBPmiRm.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".<clinit>"), (String)"1-003-0003", null);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Encountered error obtaining PMI RM instance - RM disabled for this consumer");
                }
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, exception);
            }
        }
    }
}

