/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BifurcatedConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.BrowserSessionProxy;
import com.ibm.ws.sib.comms.client.CatConnectionListenerGroup;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.LocalTransactionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.ProducerSessionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.client.ProxyReceiveListener;
import com.ibm.ws.sib.comms.client.SIXAResourceProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroupFactory;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.DestinationConfigurationImpl;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.multicast.MulticastFactory;
import com.ibm.ws.sib.multicast.MulticastReceiver;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ConnectionProxy
extends Proxy
implements SICoreConnection {
    private static String CLASS_NAME;
    private static final TraceComponent tc;
    private static final TraceNLS nls;
    private static SIBPmiRm sibPmiRm;
    private Object generalLock = new Object();
    protected WriterPriorityReadersWriterLock closeLock = new WriterPriorityReadersWriterLock();
    private final int HIGH_QUEUE_BYTES = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytes", "102400");
    private byte[] initialUniqueId = null;
    private String meUuid = null;
    private String resolvedUserId = null;
    private boolean exchangeTransactedSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceTransactedSendExchange", "false");
    private boolean exchangeExpressSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceExpressSendExchange", "false");

    public ConnectionProxy(Conversation conversation) {
        super(conversation, null);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BrowserSession createBrowserSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        BrowserSessionProxy browserSessionProxy;
        block19: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "createBrowserSession", new Object[]{sIDestinationAddress, destinationType, selectionCriteria, string});
            }
            browserSessionProxy = null;
            Object object = this.generalLock;
            // MONITORENTER : object
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    ProxyQueueConversationGroup proxyQueueConversationGroup = this.getProxyQueueConversationGroup();
                    BrowserProxyQueue browserProxyQueue = proxyQueueConversationGroup.createBrowserProxyQueue();
                    ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                    WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                    WsByteBuffer wsByteBuffer2 = CommsUtils.getSelectionCriteriaAsBytes(selectionCriteria);
                    CommsString commsString = new CommsString(string);
                    int n = 10 + wsByteBuffer.remaining() + wsByteBuffer2.remaining() + 2 + commsString.getLength();
                    WsByteBuffer wsByteBuffer3 = this.getWsBuffer(n);
                    wsByteBuffer3.putShort((short)this.getConnectionObjectID());
                    if (browserProxyQueue != null) {
                        wsByteBuffer3.putShort(browserProxyQueue.getId());
                    } else {
                        wsByteBuffer3.putShort((short)0);
                    }
                    wsByteBuffer3.putInt(this.HIGH_QUEUE_BYTES);
                    if (destinationType == null) {
                        wsByteBuffer3.putShort((short)-1);
                    } else {
                        wsByteBuffer3.putShort((short)destinationType.toInt());
                    }
                    wsByteBuffer3.put(wsByteBuffer);
                    wsByteBuffer.release();
                    wsByteBuffer3.put(wsByteBuffer2);
                    wsByteBuffer2.release();
                    wsByteBuffer3.putShort(commsString.getLength());
                    wsByteBuffer3.put(commsString.getBytes());
                    wsByteBuffer3.flip();
                    LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                    linkedList.add(wsByteBuffer3);
                    ReceivedData receivedData = this.JFAPExchange(linkedList, 95, 7, true);
                    try {
                        short s = 0;
                        try {
                            s = this.getCommandCompletionCode(receivedData, 223);
                            if (s != 0) {
                                this.checkFor_SIConnectionUnavailableException(receivedData, s);
                                this.checkFor_SIConnectionDroppedException(receivedData, s);
                                this.checkFor_SIResourceException(receivedData, s);
                                this.checkFor_SIConnectionLostException(receivedData, s);
                                this.checkFor_SILimitExceededException(receivedData, s);
                                this.checkFor_SINotAuthorizedException(receivedData, s);
                                this.checkFor_SIIncorrectCallException(receivedData, s);
                                this.checkFor_SISelectorSyntaxException(receivedData, s);
                                this.checkFor_SIDiscriminatorSyntaxException(receivedData, s);
                                this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                                this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                                this.checkFor_SIErrorException(receivedData, s);
                                this.defaultChecker(receivedData, s);
                            }
                            Object var19_19 = null;
                            if (s != 0 && browserProxyQueue != null) {
                                clientConversationState.getProxyQueueConversationHGroup().bury(browserProxyQueue);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_20 = null;
                            if (s == 0) throw throwable;
                            if (browserProxyQueue == null) throw throwable;
                            clientConversationState.getProxyQueueConversationHGroup().bury(browserProxyQueue);
                            throw throwable;
                        }
                        receivedData.getBuffer().flip();
                        browserSessionProxy = new BrowserSessionProxy(this.getConversation(), this, receivedData.getBuffer(), browserProxyQueue, sIDestinationAddress);
                        browserProxyQueue.setBrowserSession(browserSessionProxy);
                        Object var21_22 = null;
                        if (receivedData != null) {
                            receivedData.getBuffer().release();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var21_23 = null;
                        if (receivedData == null) throw throwable;
                        receivedData.getBuffer().release();
                        throw throwable;
                    }
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) break block19;
                SibTr.debug(this, tc, "interrupted exception");
            }
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return browserSessionProxy;
        SibTr.exit(tc, "createBrowserSession", browserSessionProxy);
        return browserSessionProxy;
    }

    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SITemporaryDestinationNotFoundException {
        return this.createProducerSession(sIDestinationAddress, null, destinationType, orderingContext, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, String string, DestinationType destinationType, OrderingContext orderingContext, String string2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createProducerSession", new Object[]{sIDestinationAddress, string, destinationType, orderingContext, string2});
        }
        ProducerSessionProxy producerSessionProxy = null;
        OrderingContextProxy orderingContextProxy = null;
        Object object = this.generalLock;
        // MONITORENTER : object
        try {
            this.closeLock.startReading();
            try {
                this.checkAlreadyClosed();
                if (orderingContext != null) {
                    orderingContextProxy = (OrderingContextProxy)orderingContext;
                    orderingContextProxy.incrementUseCount();
                }
                WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                CommsString commsString = clientConversationState.getCommsString();
                commsString.setString(string);
                CommsString commsString2 = new CommsString(string2);
                WsByteBuffer wsByteBuffer2 = this.getWsBuffer(6 + wsByteBuffer.remaining() + 2 + commsString.getLength() + 2 + commsString2.getLength());
                wsByteBuffer2.putShort((short)this.getConnectionObjectID());
                if (orderingContext != null) {
                    orderingContextProxy = (OrderingContextProxy)orderingContext;
                    wsByteBuffer2.putShort(orderingContextProxy.getId());
                } else {
                    wsByteBuffer2.putShort((short)0);
                }
                if (destinationType == null) {
                    wsByteBuffer2.putShort((short)-1);
                } else {
                    wsByteBuffer2.putShort((short)destinationType.toInt());
                }
                wsByteBuffer2.put(wsByteBuffer);
                wsByteBuffer.release();
                wsByteBuffer2.putShort(commsString.getLength());
                wsByteBuffer2.put(commsString.getBytes());
                wsByteBuffer2.putShort(commsString2.getLength());
                wsByteBuffer2.put(commsString2.getBytes());
                wsByteBuffer2.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer2);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 72, 7, true);
                try {
                    short s = this.getCommandCompletionCode(receivedData, 200);
                    if (s != 0) {
                        if (orderingContextProxy != null) {
                            orderingContextProxy.decrementUseCount();
                        }
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIResourceException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SILimitExceededException(receivedData, s);
                        this.checkFor_SINotAuthorizedException(receivedData, s);
                        this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                        this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                        this.checkFor_SIIncorrectCallException(receivedData, s);
                        this.checkFor_SIDiscriminatorSyntaxException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    receivedData.getBuffer().flip();
                    producerSessionProxy = new ProducerSessionProxy(this.getConversation(), this, orderingContextProxy, receivedData.getBuffer(), sIDestinationAddress);
                    Object var18_18 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                }
                catch (Throwable throwable) {
                    Object var18_19 = null;
                    if (receivedData == null) throw throwable;
                    receivedData.getBuffer().release();
                    throw throwable;
                }
            }
            finally {
                this.closeLock.stopReading();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return producerSessionProxy;
        SibTr.exit(this, tc, "createProducerSession", producerSessionProxy);
        return producerSessionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ConsumerSession createConsumerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, Reliability reliability2, boolean bl3, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        boolean bl4;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createConsumerSession", new Object[]{sIDestinationAddress, destinationType, selectionCriteria, reliability, new Boolean(bl), new Boolean(bl2), reliability2, "" + bl3, string});
        }
        ConsumerSessionProxy consumerSessionProxy = null;
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        if (bl3) {
            bl = false;
        }
        boolean bl5 = clientConversationState.isMulticastEnabled();
        boolean bl6 = bl4 = clientConversationState.isMulticastEnabled() && !clientConversationState.isUnicastEnabled();
        if (destinationType == null || destinationType != DestinationType.TOPICSPACE) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Disabling multicast for this destination type: " + destinationType);
            }
            bl5 = false;
        }
        Object object = this.generalLock;
        // MONITORENTER : object
        try {
            this.closeLock.startReading();
            try {
                Object object2;
                this.checkAlreadyClosed();
                AsynchConsumerProxyQueue asynchConsumerProxyQueue = null;
                ProxyQueueConversationGroup proxyQueueConversationGroup = null;
                if (bl) {
                    proxyQueueConversationGroup = clientConversationState.getProxyQueueConversationHGroup();
                    if (proxyQueueConversationGroup == null) {
                        object2 = ProxyQueueConversationGroupFactory.getRef();
                        proxyQueueConversationGroup = ((ProxyQueueConversationGroupFactory)object2).create(this.getConversation());
                        clientConversationState.setProxyQueueConversationGroup(proxyQueueConversationGroup);
                    }
                    asynchConsumerProxyQueue = proxyQueueConversationGroup.createReadAheadProxyQueue(reliability2);
                }
                object2 = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                WsByteBuffer wsByteBuffer = CommsUtils.getSelectionCriteriaAsBytes(selectionCriteria);
                CommsString commsString = new CommsString(string);
                WsByteBuffer wsByteBuffer2 = this.getWsBuffer(14 + object2.remaining() + 2 + wsByteBuffer.remaining() + 2 + commsString.getLength());
                wsByteBuffer2.putShort((short)this.getConnectionObjectID());
                if (asynchConsumerProxyQueue != null) {
                    wsByteBuffer2.putShort(asynchConsumerProxyQueue.getId());
                } else {
                    wsByteBuffer2.putShort((short)0);
                }
                short s = 0;
                if (bl) {
                    s = (short)(s | 1);
                }
                if (bl2) {
                    s = (short)(s | 2);
                }
                if (bl5 || bl4) {
                    s = (short)(s | 0x10);
                }
                if (!bl4) {
                    s = (short)(s | 8);
                }
                if (bl3) {
                    s = (short)(s | 0x40);
                }
                wsByteBuffer2.putShort(s);
                if (reliability != null) {
                    wsByteBuffer2.putShort((short)reliability.toInt());
                } else {
                    wsByteBuffer2.putShort((short)-1);
                }
                wsByteBuffer2.putInt(this.HIGH_QUEUE_BYTES);
                if (destinationType == null) {
                    wsByteBuffer2.putShort((short)-1);
                } else {
                    wsByteBuffer2.putShort((short)destinationType.toInt());
                }
                if (reliability2 == null) {
                    reliability2 = Reliability.NONE;
                }
                wsByteBuffer2.putShort((short)reliability2.toInt());
                wsByteBuffer2.put((WsByteBuffer)object2);
                object2.release();
                wsByteBuffer2.put(wsByteBuffer);
                wsByteBuffer.release();
                wsByteBuffer2.putShort(commsString.getLength());
                wsByteBuffer2.put(commsString.getBytes());
                wsByteBuffer2.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer2);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 77, 7, true);
                try {
                    short s2 = 0;
                    try {
                        s2 = this.getCommandCompletionCode(receivedData, 205);
                        if (s2 != 0) {
                            this.checkFor_SIConnectionUnavailableException(receivedData, s2);
                            this.checkFor_SIConnectionDroppedException(receivedData, s2);
                            this.checkFor_SIResourceException(receivedData, s2);
                            this.checkFor_SIConnectionLostException(receivedData, s2);
                            this.checkFor_SILimitExceededException(receivedData, s2);
                            this.checkFor_SINotAuthorizedException(receivedData, s2);
                            this.checkFor_SIIncorrectCallException(receivedData, s2);
                            this.checkFor_SIDestinationLockedException(receivedData, s2);
                            this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s2);
                            this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s2);
                            this.checkFor_SISelectorSyntaxException(receivedData, s2);
                            this.checkFor_SIDiscriminatorSyntaxException(receivedData, s2);
                            this.checkFor_SIErrorException(receivedData, s2);
                            this.defaultChecker(receivedData, s2);
                        }
                        Object var26_26 = null;
                        if (s2 != 0 && asynchConsumerProxyQueue != null) {
                            clientConversationState.getProxyQueueConversationHGroup().bury(asynchConsumerProxyQueue);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_27 = null;
                        if (s2 == 0) throw throwable;
                        if (asynchConsumerProxyQueue == null) throw throwable;
                        clientConversationState.getProxyQueueConversationHGroup().bury(asynchConsumerProxyQueue);
                        throw throwable;
                    }
                    WsByteBuffer wsByteBuffer3 = receivedData.getBuffer();
                    wsByteBuffer3.flip();
                    long l = wsByteBuffer3.getLong();
                    short s3 = wsByteBuffer3.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Message Processor Id", "" + l);
                        SibTr.debug(this, tc, "Consumer flags", "" + s3);
                    }
                    if (bl5 && (s3 & 0x10) != 0) {
                        CommsString commsString2 = clientConversationState.getCommsString();
                        boolean bl7 = (s3 & 0x20) != 0;
                        short s4 = wsByteBuffer3.getShort();
                        byte[] byArray = new byte[s4];
                        wsByteBuffer3.get(byArray);
                        commsString2.setBytes(byArray);
                        String string2 = commsString2.getString();
                        int n = wsByteBuffer3.getShort();
                        if (n < 0) {
                            n += 65536;
                        }
                        short s5 = wsByteBuffer3.getShort();
                        byte[] byArray2 = new byte[s5];
                        wsByteBuffer3.get(byArray2);
                        commsString2.setBytes(byArray2);
                        String string3 = commsString2.getString();
                        clientConversationState.returnCommsString(commsString2);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "A multicast session will be used:", new Object[]{"Multicast IP Address: " + string2, "Data port           : " + n, "RMM Stream          : " + string3, "Use reliable RMM    : " + bl7});
                        }
                        MulticastFactory multicastFactory = MulticastFactory.getFactory();
                        MulticastReceiver multicastReceiver = multicastFactory.getReceiver(string2, clientConversationState.getMulticastInterface(), string3, bl7, n);
                        asynchConsumerProxyQueue = proxyQueueConversationGroup.convertMulticastProxyQueue(asynchConsumerProxyQueue, multicastReceiver);
                    } else {
                        if (!bl5 && (s3 & 0x10) != 0) {
                            if (!tc.isDebugEnabled()) throw new SIErrorException(nls.getFormattedMessage("SERVER_REQUESTED_MULTICAST_SICO1026", null, null));
                            SibTr.debug(this, tc, "The server told us to go multicast even though we did not ask for it");
                            throw new SIErrorException(nls.getFormattedMessage("SERVER_REQUESTED_MULTICAST_SICO1026", null, null));
                        }
                        bl5 = false;
                    }
                    consumerSessionProxy = new ConsumerSessionProxy(this.getConversation(), this, receivedData.getBuffer(), asynchConsumerProxyQueue, reliability2, bl5, sIDestinationAddress, l, false);
                    Object var41_43 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                }
                catch (Throwable throwable) {
                    Object var41_44 = null;
                    if (receivedData == null) throw throwable;
                    receivedData.getBuffer().release();
                    throw throwable;
                }
                if (asynchConsumerProxyQueue != null) {
                    asynchConsumerProxyQueue.setConsumerSession(consumerSessionProxy);
                }
            }
            finally {
                this.closeLock.stopReading();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return consumerSessionProxy;
        SibTr.exit(this, tc, "createConsumerSession", consumerSessionProxy);
        return consumerSessionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BifurcatedConsumerSession createBifurcatedConsumerSession(long l) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createBifurcatedConsumerSession", "" + l);
        }
        BifurcatedConsumerSessionProxy bifurcatedConsumerSessionProxy = null;
        Object object = this.generalLock;
        // MONITORENTER : object
        try {
            this.closeLock.startReading();
            try {
                this.checkAlreadyClosed();
                WsByteBuffer wsByteBuffer = this.getWsBuffer(10);
                wsByteBuffer.putShort((short)this.getConnectionObjectID());
                wsByteBuffer.putLong(l);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 103, 7, true);
                try {
                    short s = this.getCommandCompletionCode(receivedData, 232);
                    if (s != 0) {
                        this.checkFor_SISessionUnavailableException(receivedData, s);
                        this.checkFor_SISessionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIResourceException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SILimitExceededException(receivedData, s);
                        this.checkFor_SINotAuthorizedException(receivedData, s);
                        this.checkFor_SIIncorrectCallException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    receivedData.getBuffer().flip();
                    bifurcatedConsumerSessionProxy = new BifurcatedConsumerSessionProxy(this.getConversation(), this, receivedData.getBuffer());
                    Object var10_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (receivedData == null) throw throwable;
                    receivedData.getBuffer().release();
                    throw throwable;
                }
            }
            finally {
                this.closeLock.stopReading();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        // MONITOREXIT : object
        if (!tc.isEntryEnabled()) return bifurcatedConsumerSessionProxy;
        SibTr.exit(this, tc, "createBifurcatedConsumerSession", bifurcatedConsumerSessionProxy);
        return bifurcatedConsumerSessionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, String string3) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createDurableSubscription", new Object[]{string, string2, sIDestinationAddress, selectionCriteria, "" + bl, "" + bl2, string3});
        }
        Object object = this.generalLock;
        synchronized (object) {
            block17: {
                try {
                    this.closeLock.startReading();
                    try {
                        CommsString commsString;
                        CommsString commsString2;
                        ClientConversationState clientConversationState;
                        block16: {
                            this.checkAlreadyClosed();
                            clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                            commsString2 = clientConversationState.getCommsString();
                            commsString = clientConversationState.getCommsString();
                            commsString2.setString(string);
                            commsString.setString(string2);
                            WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                            WsByteBuffer wsByteBuffer2 = CommsUtils.getSelectionCriteriaAsBytes(selectionCriteria);
                            CommsString commsString3 = new CommsString(string3);
                            WsByteBuffer wsByteBuffer3 = this.getWsBuffer(4 + wsByteBuffer.remaining() + 2 + commsString2.getLength() + 2 + commsString.getLength() + wsByteBuffer2.remaining() + 2 + commsString3.getLength());
                            wsByteBuffer3.putShort((short)this.getConnectionObjectID());
                            short s = 0;
                            if (bl2) {
                                s = (short)(s | 2);
                            }
                            if (bl) {
                                s = (short)(s | 4);
                            }
                            wsByteBuffer3.putShort(s);
                            wsByteBuffer3.put(wsByteBuffer);
                            wsByteBuffer.release();
                            wsByteBuffer3.putShort(commsString2.getLength());
                            wsByteBuffer3.put(commsString2.getBytes());
                            wsByteBuffer3.putShort(commsString.getLength());
                            wsByteBuffer3.put(commsString.getBytes());
                            wsByteBuffer3.put(wsByteBuffer2);
                            wsByteBuffer2.release();
                            wsByteBuffer3.putShort(commsString3.getLength());
                            wsByteBuffer3.put(commsString3.getBytes());
                            wsByteBuffer3.flip();
                            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                            linkedList.add(wsByteBuffer3);
                            ReceivedData receivedData = this.JFAPExchange(linkedList, 67, 7, true);
                            try {
                                short s2 = this.getCommandCompletionCode(receivedData, 195);
                                if (s2 != 0) {
                                    this.checkFor_SIConnectionUnavailableException(receivedData, s2);
                                    this.checkFor_SIConnectionDroppedException(receivedData, s2);
                                    this.checkFor_SIResourceException(receivedData, s2);
                                    this.checkFor_SIConnectionLostException(receivedData, s2);
                                    this.checkFor_SILimitExceededException(receivedData, s2);
                                    this.checkFor_SINotAuthorizedException(receivedData, s2);
                                    this.checkFor_SIIncorrectCallException(receivedData, s2);
                                    this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s2);
                                    this.checkFor_SIDurableSubscriptionAlreadyExistsException(receivedData, s2);
                                    this.checkFor_SISelectorSyntaxException(receivedData, s2);
                                    this.checkFor_SIDiscriminatorSyntaxException(receivedData, s2);
                                    this.checkFor_SIErrorException(receivedData, s2);
                                    this.defaultChecker(receivedData, s2);
                                }
                                Object var21_21 = null;
                                if (receivedData == null) break block16;
                            }
                            catch (Throwable throwable) {
                                Object var21_22 = null;
                                if (receivedData != null) {
                                    receivedData.getBuffer().release();
                                }
                                clientConversationState.returnCommsString(commsString2);
                                clientConversationState.returnCommsString(commsString);
                                throw throwable;
                            }
                            receivedData.getBuffer().release();
                        }
                        clientConversationState.returnCommsString(commsString2);
                        clientConversationState.returnCommsString(commsString);
                        {
                        }
                    }
                    finally {
                        this.closeLock.stopReading();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block17;
                    SibTr.debug(this, tc, "Interrupted", interruptedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerSession createConsumerSessionForDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, Reliability reliability, boolean bl3, Reliability reliability2, boolean bl4, String string3) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createConsumerSessionForDurableSubscription", new Object[]{string, string2, sIDestinationAddress, selectionCriteria, reliability, "" + bl3, "" + bl, "" + bl2, reliability2, "" + bl4, string3});
        }
        ConsumerSessionProxy consumerSessionProxy = null;
        Object object = this.generalLock;
        synchronized (object) {
            block33: {
                try {
                    this.closeLock.startReading();
                    try {
                        Object object2;
                        Object object3;
                        ClientConversationState clientConversationState;
                        block32: {
                            this.checkAlreadyClosed();
                            if (bl4) {
                                bl3 = false;
                            }
                            AsynchConsumerProxyQueue asynchConsumerProxyQueue = null;
                            if (bl3) {
                                clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                                object3 = clientConversationState.getProxyQueueConversationHGroup();
                                if (object3 == null) {
                                    object2 = ProxyQueueConversationGroupFactory.getRef();
                                    object3 = ((ProxyQueueConversationGroupFactory)object2).create(this.getConversation());
                                    clientConversationState.setProxyQueueConversationGroup((ProxyQueueConversationGroup)object3);
                                }
                                asynchConsumerProxyQueue = object3.createReadAheadProxyQueue(reliability2);
                            }
                            clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                            object3 = clientConversationState.getCommsString();
                            object2 = clientConversationState.getCommsString();
                            ((CommsString)object3).setString(string);
                            ((CommsString)object2).setString(string2);
                            WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                            WsByteBuffer wsByteBuffer2 = CommsUtils.getSelectionCriteriaAsBytes(selectionCriteria);
                            CommsString commsString = new CommsString(string3);
                            WsByteBuffer wsByteBuffer3 = this.getWsBuffer(14 + wsByteBuffer.remaining() + 2 + ((CommsString)object3).getLength() + 2 + ((CommsString)object2).getLength() + wsByteBuffer2.remaining() + 2 + commsString.getLength());
                            wsByteBuffer3.putShort((short)this.getConnectionObjectID());
                            if (asynchConsumerProxyQueue != null) {
                                wsByteBuffer3.putShort(asynchConsumerProxyQueue.getId());
                            } else {
                                wsByteBuffer3.putShort((short)0);
                            }
                            short s = 0;
                            if (bl3) {
                                s = 1;
                            }
                            if (bl2) {
                                s = (short)(s | 2);
                            }
                            if (bl) {
                                s = (short)(s | 4);
                            }
                            if (bl4) {
                                s = (short)(s | 0x40);
                            }
                            wsByteBuffer3.putShort(s);
                            if (reliability != null) {
                                wsByteBuffer3.putShort((short)reliability.toInt());
                            } else {
                                wsByteBuffer3.putShort((short)-1);
                            }
                            wsByteBuffer3.putInt(this.HIGH_QUEUE_BYTES);
                            if (reliability2 == null) {
                                reliability2 = Reliability.NONE;
                            }
                            wsByteBuffer3.putShort((short)reliability2.toInt());
                            wsByteBuffer3.put(wsByteBuffer);
                            wsByteBuffer.release();
                            wsByteBuffer3.putShort(((CommsString)object3).getLength());
                            wsByteBuffer3.put(((CommsString)object3).getBytes());
                            wsByteBuffer3.putShort(((CommsString)object2).getLength());
                            wsByteBuffer3.put(((CommsString)object2).getBytes());
                            wsByteBuffer3.put(wsByteBuffer2);
                            wsByteBuffer2.release();
                            wsByteBuffer3.putShort(commsString.getLength());
                            wsByteBuffer3.put(commsString.getBytes());
                            wsByteBuffer3.flip();
                            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                            linkedList.add(wsByteBuffer3);
                            ReceivedData receivedData = this.JFAPExchange(linkedList, 102, 7, true);
                            try {
                                short s2 = 0;
                                try {
                                    s2 = this.getCommandCompletionCode(receivedData, 231);
                                    if (s2 != 0) {
                                        this.checkFor_SIConnectionUnavailableException(receivedData, s2);
                                        this.checkFor_SIConnectionDroppedException(receivedData, s2);
                                        this.checkFor_SIResourceException(receivedData, s2);
                                        this.checkFor_SIConnectionLostException(receivedData, s2);
                                        this.checkFor_SILimitExceededException(receivedData, s2);
                                        this.checkFor_SINotAuthorizedException(receivedData, s2);
                                        this.checkFor_SIIncorrectCallException(receivedData, s2);
                                        this.checkFor_SIDurableSubscriptionNotFoundException(receivedData, s2);
                                        this.checkFor_SIDurableSubscriptionMismatchException(receivedData, s2);
                                        this.checkFor_SIDestinationLockedException(receivedData, s2);
                                        this.checkFor_SIErrorException(receivedData, s2);
                                        this.defaultChecker(receivedData, s2);
                                    }
                                    Object var27_27 = null;
                                    if (s2 != 0 && asynchConsumerProxyQueue != null) {
                                        clientConversationState.getProxyQueueConversationHGroup().bury(asynchConsumerProxyQueue);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var27_28 = null;
                                    if (s2 != 0 && asynchConsumerProxyQueue != null) {
                                        clientConversationState.getProxyQueueConversationHGroup().bury(asynchConsumerProxyQueue);
                                    }
                                    throw throwable;
                                }
                                receivedData.getBuffer().flip();
                                long l = receivedData.getBuffer().getLong();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(this, tc, "Message processor Id:", "" + l);
                                }
                                consumerSessionProxy = new ConsumerSessionProxy(this.getConversation(), this, receivedData.getBuffer(), asynchConsumerProxyQueue, reliability2, false, sIDestinationAddress, l, true);
                                if (asynchConsumerProxyQueue != null) {
                                    asynchConsumerProxyQueue.setConsumerSession(consumerSessionProxy);
                                }
                                Object var29_31 = null;
                                if (receivedData == null) break block32;
                            }
                            catch (Throwable throwable) {
                                Object var29_32 = null;
                                if (receivedData != null) {
                                    receivedData.getBuffer().release();
                                }
                                clientConversationState.returnCommsString((CommsString)object3);
                                clientConversationState.returnCommsString((CommsString)object2);
                                throw throwable;
                            }
                            receivedData.getBuffer().release();
                        }
                        clientConversationState.returnCommsString((CommsString)object3);
                        clientConversationState.returnCommsString((CommsString)object2);
                        {
                        }
                    }
                    finally {
                        this.closeLock.stopReading();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block33;
                    SibTr.debug(this, tc, "Interrupted", interruptedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createConsumerSessionForDurableSubscription", consumerSessionProxy);
        }
        return consumerSessionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDurableSubscription(String string, String string2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deleteDurableSubscription", new Object[]{string, string2});
        }
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                    CommsString commsString = clientConversationState.getCommsString();
                    commsString.setString(string);
                    CommsString commsString2 = clientConversationState.getCommsString();
                    commsString2.setString(string2);
                    WsByteBuffer wsByteBuffer = this.getWsBuffer(6 + commsString.getLength() + commsString2.getLength());
                    wsByteBuffer.putShort((short)this.getConnectionObjectID());
                    wsByteBuffer.putShort(commsString.getLength());
                    wsByteBuffer.put(commsString.getBytes());
                    wsByteBuffer.putShort(commsString2.getLength());
                    wsByteBuffer.put(commsString2.getBytes());
                    wsByteBuffer.flip();
                    LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                    linkedList.add(wsByteBuffer);
                    ReceivedData receivedData = this.JFAPExchange(linkedList, 68, 7, true);
                    try {
                        short s = this.getCommandCompletionCode(receivedData, 196);
                        if (s != 0) {
                            this.checkFor_SIConnectionUnavailableException(receivedData, s);
                            this.checkFor_SIConnectionDroppedException(receivedData, s);
                            this.checkFor_SIResourceException(receivedData, s);
                            this.checkFor_SIConnectionLostException(receivedData, s);
                            this.checkFor_SINotAuthorizedException(receivedData, s);
                            this.checkFor_SIIncorrectCallException(receivedData, s);
                            this.checkFor_SIDurableSubscriptionNotFoundException(receivedData, s);
                            this.checkFor_SIDestinationLockedException(receivedData, s);
                            this.checkFor_SIErrorException(receivedData, s);
                            this.defaultChecker(receivedData, s);
                        }
                    }
                    finally {
                        clientConversationState.returnCommsString(commsString);
                    }
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deleteDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress sIDestinationAddress) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationConfigurationImpl destinationConfigurationImpl;
        block21: {
            destinationConfigurationImpl = null;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "getDestinationConfiguration");
            }
            this.checkAlreadyClosed();
            ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
            WsByteBuffer wsByteBuffer = this.getWsBuffer(2);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.flip();
            WsByteBuffer wsByteBuffer2 = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            linkedList.add(wsByteBuffer2);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 101, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 229);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SINotAuthorizedException(receivedData, s);
                    this.checkFor_SIIncorrectCallException(receivedData, s);
                    this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                    this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                WsByteBuffer wsByteBuffer3 = receivedData.getBuffer();
                wsByteBuffer3.flip();
                int n = wsByteBuffer3.getInt();
                int n2 = wsByteBuffer3.getInt();
                short s2 = wsByteBuffer3.getShort();
                short s3 = wsByteBuffer3.getShort();
                short s4 = wsByteBuffer3.getShort();
                short s5 = wsByteBuffer3.getShort();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Default Priority     :", "" + n);
                    SibTr.debug(this, tc, "Max failed deliveries:", "" + n2);
                    SibTr.debug(this, tc, "Default Reliability  :", "" + s2);
                    SibTr.debug(this, tc, "Max Reliability      :", "" + s3);
                    SibTr.debug(this, tc, "Destination Type     :", "" + s4);
                    SibTr.debug(this, tc, "Destination Flags    :", "" + s5);
                }
                Reliability reliability = null;
                if (s2 != -1) {
                    reliability = Reliability.getReliability(s2);
                }
                Reliability reliability2 = null;
                if (s3 != -1) {
                    reliability2 = Reliability.getReliability(s3);
                }
                DestinationType destinationType = null;
                if (s4 != -1) {
                    destinationType = DestinationType.getDestinationType(s4);
                }
                boolean bl = (s5 & 1) != 0;
                boolean bl2 = (s5 & 2) != 0;
                boolean bl3 = (s5 & 4) != 0;
                boolean bl4 = (s5 & 8) != 0;
                CommsString commsString = clientConversationState.getCommsString();
                String string = null;
                short s6 = wsByteBuffer3.getShort();
                byte[] byArray = new byte[s6];
                wsByteBuffer3.get(byArray, 0, new Integer(s6).intValue());
                commsString.setBytes(byArray);
                string = commsString.getString();
                clientConversationState.returnCommsString(commsString);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "UUID:", string);
                }
                CommsString commsString2 = clientConversationState.getCommsString();
                String string2 = null;
                short s7 = wsByteBuffer3.getShort();
                byte[] byArray2 = new byte[s7];
                wsByteBuffer3.get(byArray2, 0, new Integer(s7).intValue());
                commsString2.setBytes(byArray2);
                string2 = commsString2.getString();
                clientConversationState.returnCommsString(commsString2);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Description:", string2);
                }
                CommsString commsString3 = clientConversationState.getCommsString();
                String string3 = null;
                short s8 = wsByteBuffer3.getShort();
                byte[] byArray3 = new byte[s8];
                wsByteBuffer3.get(byArray3, 0, new Integer(s8).intValue());
                commsString3.setBytes(byArray3);
                string3 = commsString3.getString();
                clientConversationState.returnCommsString(commsString3);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "ExceptionDestination name:", string3);
                }
                CommsString commsString4 = clientConversationState.getCommsString();
                String string4 = null;
                short s9 = wsByteBuffer3.getShort();
                byte[] byArray4 = new byte[s9];
                wsByteBuffer3.get(byArray4, 0, new Integer(s9).intValue());
                commsString4.setBytes(byArray4);
                string4 = commsString4.getString();
                clientConversationState.returnCommsString(commsString4);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Name:", string4);
                }
                SIDestinationAddress sIDestinationAddress2 = CommsUtils.getSIDestinationAddress(wsByteBuffer3);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n3 = wsByteBuffer3.getShort();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Number of name value pairs: ", "" + n3);
                }
                for (int i = 0; i < n3; ++i) {
                    CommsString commsString5 = clientConversationState.getCommsString();
                    String string5 = null;
                    short s10 = wsByteBuffer3.getShort();
                    byte[] byArray5 = new byte[s10];
                    wsByteBuffer3.get(byArray5, 0, (int)s10);
                    commsString5.setBytes(byArray5);
                    string5 = commsString5.getString();
                    clientConversationState.returnCommsString(commsString5);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Name:", string5);
                    }
                    CommsString commsString6 = clientConversationState.getCommsString();
                    String string6 = null;
                    short s11 = wsByteBuffer3.getShort();
                    byte[] byArray6 = new byte[s11];
                    wsByteBuffer3.get(byArray6, 0, (int)s11);
                    commsString6.setBytes(byArray6);
                    string6 = commsString6.getString();
                    clientConversationState.returnCommsString(commsString6);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Value:", string6);
                    }
                    hashMap.put(string5, string6);
                }
                SIDestinationAddress[] sIDestinationAddressArray = null;
                int n4 = wsByteBuffer3.getShort();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Number of SI Destination Address: ", "" + n4);
                }
                if (n4 != 0) {
                    sIDestinationAddressArray = new SIDestinationAddress[n4];
                    for (int i = 0; i < n4; ++i) {
                        sIDestinationAddressArray[i] = CommsUtils.getSIDestinationAddress(wsByteBuffer3);
                    }
                }
                destinationConfigurationImpl = new DestinationConfigurationImpl(n, reliability, string2, hashMap, destinationType, string3, n2, reliability2, string4, string, bl, bl2, bl3, bl4, sIDestinationAddressArray, sIDestinationAddress2);
                Object var52_54 = null;
                if (receivedData == null) break block21;
            }
            catch (Throwable throwable) {
                Object var52_55 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDestinationConfiguration", destinationConfigurationImpl);
        }
        return destinationConfigurationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIInvalidDestinationPrefixException {
        JsDestinationAddress jsDestinationAddress;
        CommsString commsString;
        ClientConversationState clientConversationState;
        block10: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "createTemporaryDestination", new Object[]{distribution, string});
            }
            this.checkAlreadyClosed();
            clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
            commsString = clientConversationState.getCommsString();
            commsString.setString(string);
            WsByteBuffer wsByteBuffer = this.getWsBuffer(6 + commsString.getLength());
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putShort((short)distribution.toInt());
            wsByteBuffer.putShort(commsString.getLength());
            wsByteBuffer.put(commsString.getBytes());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 65, 7, true);
            jsDestinationAddress = null;
            try {
                short s = this.getCommandCompletionCode(receivedData, 193);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SILimitExceededException(receivedData, s);
                    this.checkFor_SINotAuthorizedException(receivedData, s);
                    this.checkFor_SIInvalidDestinationPrefixException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
                wsByteBuffer2.flip();
                short s2 = wsByteBuffer2.getShort();
                SIBUuid8 sIBUuid8 = null;
                if (s2 != 0) {
                    byte[] byArray = new byte[s2];
                    wsByteBuffer2.get(byArray);
                    sIBUuid8 = new SIBUuid8(byArray);
                }
                short s3 = wsByteBuffer2.getShort();
                byte[] byArray = new byte[s3];
                wsByteBuffer2.get(byArray);
                commsString.setBytes(byArray);
                CommsString commsString2 = clientConversationState.getCommsString();
                short s4 = wsByteBuffer2.getShort();
                byte[] byArray2 = new byte[s4];
                wsByteBuffer2.get(byArray2);
                commsString2.setBytes(byArray2);
                String string2 = commsString2.getString();
                clientConversationState.returnCommsString(commsString2);
                try {
                    jsDestinationAddress = ((JsDestinationAddressFactory)JsDestinationAddressFactory.getInstance()).createJsDestinationAddress(commsString.getString(), false, sIBUuid8, string2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Unable to get JsDestinationFactory: ", exception);
                    }
                    throw new SIErrorException(exception.getMessage(), exception);
                }
                Object var21_21 = null;
                if (receivedData == null) break block10;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                clientConversationState.returnCommsString(commsString);
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        clientConversationState.returnCommsString(commsString);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTemporaryDestination", jsDestinationAddress);
        }
        return jsDestinationAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteTemporaryDestination(SIDestinationAddress sIDestinationAddress) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "deleteTemporaryDestination", sIDestinationAddress);
            }
            this.checkAlreadyClosed();
            WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
            WsByteBuffer wsByteBuffer2 = this.getWsBuffer(2);
            wsByteBuffer2.putShort((short)this.getConnectionObjectID());
            wsByteBuffer2.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer2);
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 66, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 194);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SINotAuthorizedException(receivedData, s);
                    this.checkFor_SIDestinationLockedException(receivedData, s);
                    this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var8_7 = null;
                if (receivedData == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deleteTemporaryDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendToExceptionDestination(SIDestinationAddress sIDestinationAddress, SIBusMessage sIBusMessage, int n, String[] stringArray, SITransaction sITransaction, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        block15: {
            Object object;
            List list;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "sendToExceptionDestination", new Object[]{sIDestinationAddress, sIBusMessage, "" + n, stringArray == null ? "<null>" : "" + stringArray.length, sITransaction, string});
            }
            this.checkAlreadyClosed();
            ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
            try {
                list = ((JsMessage)sIBusMessage).encode(clientConversationState.getCommsConnection());
            }
            catch (MessageEncodeFailedException messageEncodeFailedException) {
                FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + ".sendToExceptionDestination"), (String)"1-002-0002", (Object)this);
                throw new SIResourceException(messageEncodeFailedException);
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n2 = 0;
            for (int i = 0; i < list.size(); n2 += object.limit(), ++i) {
                object = this.wrapToWsBuffer((byte[])list.get(i));
                linkedList.add(object);
            }
            WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
            object = new CommsString(string);
            WsByteBuffer wsByteBuffer2 = this.getWsBuffer(2 + wsByteBuffer.remaining() + 4 + 4 + 8 + 2 + ((CommsString)object).getLength());
            wsByteBuffer2.putShort((short)this.getConnectionObjectID());
            if (sITransaction != null) {
                wsByteBuffer2.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
            } else {
                wsByteBuffer2.putInt(0);
            }
            wsByteBuffer2.put(wsByteBuffer);
            wsByteBuffer.release();
            wsByteBuffer2.putInt(n);
            wsByteBuffer2.putShort(((CommsString)object).getLength());
            wsByteBuffer2.put(((CommsString)object).getBytes());
            wsByteBuffer2.putLong((long)n2);
            wsByteBuffer2.flip();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            linkedList2.add(wsByteBuffer2);
            linkedList2.addAll(linkedList);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Adding " + stringArray.length + " insert(s)");
            }
            WsByteBuffer wsByteBuffer3 = this.getWsBuffer(2);
            wsByteBuffer3.putShort((short)stringArray.length);
            wsByteBuffer3.flip();
            linkedList2.add(wsByteBuffer3);
            CommsString commsString = clientConversationState.getCommsString();
            for (int i = 0; i < stringArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Adding insert [" + i + "]: " + stringArray[i]);
                }
                commsString.setString(stringArray[i]);
                WsByteBuffer wsByteBuffer4 = this.getWsBuffer(2 + commsString.getLength());
                wsByteBuffer4.putShort(commsString.getLength());
                wsByteBuffer4.put(commsString.getBytes());
                wsByteBuffer4.flip();
                linkedList2.add(wsByteBuffer4);
            }
            clientConversationState.returnCommsString(commsString);
            ReceivedData receivedData = this.JFAPExchange(linkedList2, 108, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 237);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SILimitExceededException(receivedData, s);
                    this.checkFor_SINotAuthorizedException(receivedData, s);
                    this.checkFor_SIIncorrectCallException(receivedData, s);
                    this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var20_23 = null;
                if (receivedData == null) break block15;
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "sendToExceptionDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SICoreConnection cloneConnection() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException {
        ConnectionProxy connectionProxy;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "cloneConnection");
            }
            this.checkAlreadyClosed();
            connectionProxy = null;
            WsByteBuffer wsByteBuffer = this.getWsBuffer(2);
            wsByteBuffer.putShort((short)this.getConversation().getId());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            connectionProxy = new ConnectionProxy(this.getConversation().cloneConversation(new ProxyReceiveListener()));
            connectionProxy.createConversationState();
            connectionProxy.setCommsConnection(this.getCommsConnection());
            connectionProxy.setMeUuid(this.getMeUuid());
            connectionProxy.setResolvedUserId(this.getResolvedUserid());
            ClientConversationState clientConversationState = (ClientConversationState)connectionProxy.getConversation().getAttachment();
            ClientConversationState clientConversationState2 = (ClientConversationState)this.getConversation().getAttachment();
            clientConversationState.setMulticastEnabled(clientConversationState2.isMulticastEnabled());
            clientConversationState.setUnicastEnabled(clientConversationState2.isUnicastEnabled());
            clientConversationState.setMulticastInterface(clientConversationState2.getMulticastInterface());
            ReceivedData receivedData = connectionProxy.JFAPExchange(linkedList, 99, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 227);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SILimitExceededException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                receivedData.getBuffer().flip();
                connectionProxy.setConnectionObjectID(receivedData.getBuffer().getShort());
                connectionProxy.setSICoreConnection(connectionProxy);
                ClientConversationState clientConversationState3 = (ClientConversationState)this.getConversation().getAttachment();
                SICoreConnectionListener[] sICoreConnectionListenerArray = clientConversationState3.getCatConnectionListeners().getConnectionListeners();
                for (int i = 0; i < sICoreConnectionListenerArray.length; ++i) {
                    connectionProxy.addConnectionListener(sICoreConnectionListenerArray[i]);
                }
                Object var12_11 = null;
                if (receivedData == null) break block7;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cloneConnection", connectionProxy);
        }
        return connectionProxy;
    }

    public boolean isEquivalentTo(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isEquivalentTo");
        }
        boolean bl = false;
        if (sICoreConnection.getMeName().equals(this.getMeName()) && ((ConnectionProxy)sICoreConnection).getConversation().sharesSameLinkAs(this.getConversation())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isEquivalentTo", "" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createUncoordinatedTransaction");
        }
        LocalTransactionProxy localTransactionProxy = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    localTransactionProxy = new LocalTransactionProxy(this.getConversation(), this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Created the transaction proxy. ID: " + localTransactionProxy.getTransactionId());
                    }
                    WsByteBuffer wsByteBuffer = this.getWsBuffer(6);
                    wsByteBuffer.putShort((short)this.getConnectionObjectID());
                    wsByteBuffer.putInt(localTransactionProxy.getTransactionId());
                    wsByteBuffer.flip();
                    LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                    linkedList.add(wsByteBuffer);
                    this.JFAPSend(linkedList, 80, 11, true);
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createUncoordinatedTransaction", localTransactionProxy);
        }
        return localTransactionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIXAResource getSIXAResource() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        SIXAResourceProxy sIXAResourceProxy;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "getSIXAResource");
            }
            this.checkAlreadyClosed();
            sIXAResourceProxy = new SIXAResourceProxy(this.getConversation(), this);
            WsByteBuffer wsByteBuffer = this.getWsBuffer(6);
            wsByteBuffer.putShort((short)this.getConnectionObjectID());
            wsByteBuffer.putInt(sIXAResourceProxy.getTransactionId());
            wsByteBuffer.flip();
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 48, 7, true);
            try {
                short s = this.getCommandCompletionCode(receivedData, 176);
                if (s != 0) {
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIResourceException(receivedData, s);
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                Object var7_6 = null;
                if (receivedData == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSIXAResource", sIXAResourceProxy);
        }
        return sIXAResourceProxy;
    }

    public void addConnectionListener(SICoreConnectionListener sICoreConnectionListener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addConnectionListener", sICoreConnectionListener);
        }
        this.checkAlreadyClosed();
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListenerGroup = clientConversationState.getCatConnectionListeners();
        catConnectionListenerGroup.add(sICoreConnectionListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addConnectionListener");
        }
    }

    public void removeConnectionListener(SICoreConnectionListener sICoreConnectionListener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeConnectionListener", sICoreConnectionListener);
        }
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListenerGroup = clientConversationState.getCatConnectionListeners();
        catConnectionListenerGroup.remove(sICoreConnectionListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeConnectionListener");
        }
    }

    public SICoreConnectionListener[] getConnectionListeners() throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConnectionListener");
        }
        this.checkAlreadyClosed();
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListenerGroup = clientConversationState.getCatConnectionListeners();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConnectionListener");
        }
        return catConnectionListenerGroup.getConnectionListeners();
    }

    private void removeAllConnectionListeners() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeAllsConnectionListeners");
        }
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListenerGroup = clientConversationState.getCatConnectionListeners();
        catConnectionListenerGroup.removeAllElements();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeAllConnectionListeners");
        }
    }

    public String getApiLevelDescription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getApiLevelDescription");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getApiLevelDescription");
        }
        return new String(this.getApiMajorVersion() + "." + this.getApiMinorVersion());
    }

    public long getApiMajorVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getApiMajorVersion");
        }
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
        CATHandshakeProperties cATHandshakeProperties = clientLinkLevelState.getCatHandshakeProperties();
        long l = 6L;
        if ((long)cATHandshakeProperties.getMajorVersion() < 6L) {
            l = cATHandshakeProperties.getMajorVersion();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getApiMajorVersion", "" + l);
        }
        return l;
    }

    public long getApiMinorVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getApiMinorVersion");
        }
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
        CATHandshakeProperties cATHandshakeProperties = clientLinkLevelState.getCatHandshakeProperties();
        long l = 0L;
        l = (long)cATHandshakeProperties.getMajorVersion() < 6L ? (long)cATHandshakeProperties.getMinorVersion() : ((long)cATHandshakeProperties.getMajorVersion() > 6L ? 0L : ((long)cATHandshakeProperties.getMinorVersion() < 0L ? (long)cATHandshakeProperties.getMinorVersion() : 0L));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getApiMinorVersion", "" + l);
        }
        return l;
    }

    public String getMeName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMeName");
        }
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMeName");
        }
        return clientLinkLevelState.getCatHandshakeProperties().getSourceMEName();
    }

    public String getMeUuid() {
        return this.meUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress sIDestinationAddress, SIDestinationAddress sIDestinationAddress2, DestinationType destinationType, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        SIDestinationAddress sIDestinationAddress3;
        block14: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "checkMessagingRequired", new Object[]{sIDestinationAddress, sIDestinationAddress2, destinationType, string});
            }
            sIDestinationAddress3 = null;
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    CATHandshakeProperties cATHandshakeProperties = ((ClientLinkLevelState)this.getConversation().getLinkLevelAttachment()).getCatHandshakeProperties();
                    CommsUtils.checkFapLevel(cATHandshakeProperties, (short)2);
                    WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                    WsByteBuffer wsByteBuffer2 = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress2);
                    CommsString commsString = new CommsString(string);
                    WsByteBuffer wsByteBuffer3 = this.getWsBuffer(2 + wsByteBuffer.remaining() + wsByteBuffer2.remaining() + 2 + 2 + commsString.getLength());
                    wsByteBuffer3.putShort((short)this.getConnectionObjectID());
                    wsByteBuffer3.put(wsByteBuffer);
                    wsByteBuffer.release();
                    wsByteBuffer3.put(wsByteBuffer2);
                    wsByteBuffer2.release();
                    if (destinationType == null) {
                        wsByteBuffer3.putShort((short)-1);
                    } else {
                        wsByteBuffer3.putShort((short)destinationType.toInt());
                    }
                    wsByteBuffer3.putShort(commsString.getLength());
                    wsByteBuffer3.put(commsString.getBytes());
                    wsByteBuffer3.flip();
                    LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                    linkedList.add(wsByteBuffer3);
                    ReceivedData receivedData = this.JFAPExchange(linkedList, 111, 7, true);
                    try {
                        short s = this.getCommandCompletionCode(receivedData, 242);
                        if (s != 0) {
                            this.checkFor_SIConnectionUnavailableException(receivedData, s);
                            this.checkFor_SIConnectionDroppedException(receivedData, s);
                            this.checkFor_SIResourceException(receivedData, s);
                            this.checkFor_SINotAuthorizedException(receivedData, s);
                            this.checkFor_SIIncorrectCallException(receivedData, s);
                            this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                            this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                            this.checkFor_SIErrorException(receivedData, s);
                            this.defaultChecker(receivedData, s);
                        }
                        WsByteBuffer wsByteBuffer4 = receivedData.getBuffer();
                        wsByteBuffer4.flip();
                        if (wsByteBuffer4.remaining() > 0) {
                            sIDestinationAddress3 = CommsUtils.getSIDestinationAddress(wsByteBuffer4);
                        }
                        Object var16_16 = null;
                        if (receivedData == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        if (receivedData != null) {
                            receivedData.getBuffer().release();
                        }
                        throw throwable;
                    }
                    receivedData.getBuffer().release();
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "checkMessagingRequired", sIDestinationAddress3);
        }
        return sIDestinationAddress3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderingContext createOrderingContext() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "createOrderingContext");
        }
        this.checkAlreadyClosed();
        OrderingContextProxy orderingContextProxy = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    orderingContextProxy = new OrderingContextProxy(this.getConversation(), this);
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createOrderingContext", orderingContextProxy);
        }
        return orderingContextProxy;
    }

    public String getResolvedUserid() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        return this.resolvedUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createUniqueId() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        byte[] byArray;
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "createUniqueId");
            }
            this.checkAlreadyClosed();
            byArray = null;
            if (this.initialUniqueId != null) {
                byArray = this.initialUniqueId;
                this.initialUniqueId = null;
            } else {
                WsByteBuffer wsByteBuffer = this.getWsBuffer(2);
                wsByteBuffer.putShort((short)this.getConnectionObjectID());
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 100, 7, true);
                try {
                    short s = this.getCommandCompletionCode(receivedData, 228);
                    if (s != 0) {
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIResourceException(receivedData, s);
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    receivedData.getBuffer().flip();
                    short s2 = receivedData.getBuffer().getShort();
                    byArray = new byte[s2];
                    receivedData.getBuffer().get(byArray, 0, (int)s2);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "ID:");
                        SibTr.bytes(this, tc, byArray);
                    }
                    Object var8_7 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "createUniqueId", byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        block13: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "close");
            }
            try {
                this.closeLock.startWriting();
                try {
                    ProxyQueueConversationGroup proxyQueueConversationGroup;
                    block14: {
                        if (this.isClosed()) break block13;
                        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
                        proxyQueueConversationGroup = clientConversationState.getProxyQueueConversationHGroup();
                        if (proxyQueueConversationGroup != null) {
                            proxyQueueConversationGroup.closeNotification();
                        }
                        WsByteBuffer wsByteBuffer = this.getWsBuffer(10);
                        wsByteBuffer.putShort((short)this.getConnectionObjectID());
                        wsByteBuffer.flip();
                        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                        linkedList.add(wsByteBuffer);
                        ReceivedData receivedData = this.JFAPExchange(linkedList, 64, -1, true);
                        try {
                            short s = this.getCommandCompletionCode(receivedData, 192);
                            if (s != 0) {
                                this.checkFor_SIResourceException(receivedData, s);
                                this.checkFor_SIConnectionLostException(receivedData, s);
                                this.checkFor_SIConnectionUnavailableException(receivedData, s);
                                this.checkFor_SIConnectionDroppedException(receivedData, s);
                                this.checkFor_SIErrorException(receivedData, s);
                                this.defaultChecker(receivedData, s);
                            }
                            Object var8_8 = null;
                            if (receivedData == null) break block14;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            if (receivedData != null) {
                                receivedData.getBuffer().release();
                            }
                            throw throwable;
                        }
                        receivedData.getBuffer().release();
                    }
                    this.setClosed();
                    this.removeAllConnectionListeners();
                    this.getConversation().close();
                    if (proxyQueueConversationGroup != null) {
                        proxyQueueConversationGroup.close();
                    }
                }
                finally {
                    this.closeLock.stopWriting();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send", new Object[]{sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, string});
        }
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    if (orderingContext != null) {
                        ((OrderingContextProxy)orderingContext).incrementUseCount();
                    }
                    if (sITransaction != null) {
                        SITransaction sITransaction2 = sITransaction;
                        synchronized (sITransaction2) {
                            if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                                throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                            }
                            this._send(sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, string);
                        }
                    } else {
                        this._send(sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, string);
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.closeLock.stopReading();
                    if (orderingContext != null) {
                        ((OrderingContextProxy)orderingContext).decrementUseCount();
                    }
                    throw throwable;
                }
                this.closeLock.stopReading();
                if (orderingContext != null) {
                    ((OrderingContextProxy)orderingContext).decrementUseCount();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _send(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_send");
        }
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        Object object = null;
        if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
            sibPmiRm.attachCurrentContextCorrelators(sIBusMessage, true);
            object = sibPmiRm.produceMessageBlock(sIDestinationAddress.getBusName(), sIDestinationAddress.getDestinationName());
        }
        boolean bl = false;
        try {
            block25: {
                Object object2;
                List list;
                try {
                    list = ((JsMessage)sIBusMessage).encode(clientConversationState.getCommsConnection());
                }
                catch (MessageEncodeFailedException messageEncodeFailedException) {
                    FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + "._send"), (String)"1-002-0001", (Object)this);
                    throw new SIResourceException(messageEncodeFailedException);
                }
                LinkedList<Object> linkedList = new LinkedList<Object>();
                int n = 0;
                for (int i = 0; i < list.size(); n += object2.limit(), ++i) {
                    object2 = this.wrapToWsBuffer((byte[])list.get(i));
                    linkedList.add(object2);
                }
                WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
                object2 = new CommsString(string);
                WsByteBuffer wsByteBuffer2 = this.getWsBuffer(12 + ((CommsString)object2).getLength() + wsByteBuffer.remaining() + 8);
                wsByteBuffer2.putShort((short)this.getConnectionObjectID());
                if (orderingContext != null) {
                    wsByteBuffer2.putShort(((OrderingContextProxy)orderingContext).getId());
                } else {
                    wsByteBuffer2.putShort((short)0);
                }
                if (sITransaction != null) {
                    wsByteBuffer2.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
                } else {
                    wsByteBuffer2.putInt(0);
                }
                if (destinationType != null) {
                    wsByteBuffer2.putShort((short)destinationType.toInt());
                } else {
                    wsByteBuffer2.putShort((short)-1);
                }
                wsByteBuffer2.putShort(((CommsString)object2).getLength());
                wsByteBuffer2.put(((CommsString)object2).getBytes());
                wsByteBuffer2.put(wsByteBuffer);
                wsByteBuffer.release();
                wsByteBuffer2.putLong((long)n);
                wsByteBuffer2.flip();
                linkedList.add(0, wsByteBuffer2);
                short s = JFapChannelConstants.getJFAPPriority(sIBusMessage.getPriority());
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Sending with JFAP priority of " + s);
                }
                if (sITransaction != null && !this.exchangeTransactedSends || (sIBusMessage.getReliability() == Reliability.BEST_EFFORT_NONPERSISTENT || sIBusMessage.getReliability() == Reliability.EXPRESS_NONPERSISTENT) && !this.exchangeExpressSends) {
                    this.JFAPSend(linkedList, 70, s, false);
                    if (sITransaction != null) {
                        ((Transaction)((Object)sITransaction)).updateLowestMessagePriority(s);
                    }
                } else {
                    ReceivedData receivedData = this.JFAPExchange(linkedList, 69, s, false);
                    try {
                        short s2 = this.getCommandCompletionCode(receivedData, 197);
                        if (s2 != 0) {
                            this.checkFor_SIConnectionUnavailableException(receivedData, s2);
                            this.checkFor_SIConnectionDroppedException(receivedData, s2);
                            this.checkFor_SIResourceException(receivedData, s2);
                            this.checkFor_SIConnectionLostException(receivedData, s2);
                            this.checkFor_SILimitExceededException(receivedData, s2);
                            this.checkFor_SINotAuthorizedException(receivedData, s2);
                            this.checkFor_SIIncorrectCallException(receivedData, s2);
                            this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s2);
                            this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s2);
                            this.checkFor_SIErrorException(receivedData, s2);
                            this.defaultChecker(receivedData, s2);
                        }
                        Object var20_21 = null;
                        if (receivedData == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var20_22 = null;
                        if (receivedData != null) {
                            receivedData.getBuffer().release();
                        }
                        throw throwable;
                    }
                    receivedData.getBuffer().release();
                }
            }
            bl = true;
            if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 0);
            }
            Object var22_24 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 1);
            }
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 1);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveNoWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "receiveNoWait", new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, string});
        }
        JsMessage jsMessage = null;
        Object object = this.generalLock;
        synchronized (object) {
            block15: {
                try {
                    this.closeLock.startReading();
                    try {
                        this.checkAlreadyClosed();
                        if (sITransaction != null) {
                            SITransaction sITransaction2 = sITransaction;
                            synchronized (sITransaction2) {
                                if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                                    throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                                }
                                jsMessage = this._receive(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, -1L, string);
                                break block15;
                            }
                        }
                        jsMessage = this._receive(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, -1L, string);
                    }
                    finally {
                        this.closeLock.stopReading();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "receiveNoWait", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveWithWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "receiveWithWait", new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, "" + l, string});
        }
        JsMessage jsMessage = null;
        Object object = this.generalLock;
        synchronized (object) {
            this.checkAlreadyClosed();
            if (sITransaction != null) {
                SITransaction sITransaction2 = sITransaction;
                synchronized (sITransaction2) {
                    if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    jsMessage = this._receive(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, l, string);
                }
            } else {
                jsMessage = this._receive(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, l, string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "receiveWithWait", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsMessage _receive(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_receive", new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, "" + l, string});
        }
        WsByteBuffer wsByteBuffer = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress);
        WsByteBuffer wsByteBuffer2 = CommsUtils.getSelectionCriteriaAsBytes(selectionCriteria);
        CommsString commsString = new CommsString(string);
        JsMessage jsMessage = null;
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        WsByteBuffer wsByteBuffer3 = this.getWsBuffer(20 + wsByteBuffer.remaining() + wsByteBuffer2.remaining() + 2 + commsString.getLength());
        wsByteBuffer3.putShort((short)this.getConnectionObjectID());
        if (sITransaction != null) {
            wsByteBuffer3.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
        } else {
            wsByteBuffer3.putInt(0);
        }
        if (reliability2 != null) {
            wsByteBuffer3.putShort((short)reliability2.toInt());
        } else {
            wsByteBuffer3.putShort((short)-1);
        }
        wsByteBuffer3.putLong(l);
        if (destinationType != null) {
            wsByteBuffer3.putShort((short)destinationType.toInt());
        } else {
            wsByteBuffer3.putShort((short)-1);
        }
        if (reliability == null) {
            reliability = Reliability.NONE;
        }
        wsByteBuffer3.putShort((short)reliability.toInt());
        wsByteBuffer3.put(wsByteBuffer);
        wsByteBuffer.release();
        wsByteBuffer3.put(wsByteBuffer2);
        wsByteBuffer2.release();
        wsByteBuffer3.putShort(commsString.getLength());
        wsByteBuffer3.put(commsString.getBytes());
        wsByteBuffer3.flip();
        linkedList.add(wsByteBuffer3);
        Object object = null;
        if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
            object = sibPmiRm.syncConsumeMessageBlock(sIDestinationAddress.getBusName(), sIDestinationAddress.getDestinationName());
        }
        boolean bl = false;
        ReceivedData receivedData = null;
        try {
            receivedData = this.JFAPExchange(linkedList, 71, 7, true);
            short s = this.getCommandCompletionCode(receivedData, 199);
            if (s != 0) {
                this.checkFor_SIConnectionUnavailableException(receivedData, s);
                this.checkFor_SIConnectionDroppedException(receivedData, s);
                this.checkFor_SIResourceException(receivedData, s);
                this.checkFor_SIConnectionLostException(receivedData, s);
                this.checkFor_SILimitExceededException(receivedData, s);
                this.checkFor_SINotAuthorizedException(receivedData, s);
                this.checkFor_SIIncorrectCallException(receivedData, s);
                this.checkFor_SIDestinationLockedException(receivedData, s);
                this.checkFor_SITemporaryDestinationNotFoundException(receivedData, s);
                this.checkFor_SINotPossibleInCurrentConfigurationException(receivedData, s);
                this.checkFor_SIErrorException(receivedData, s);
                this.defaultChecker(receivedData, s);
            }
            bl = true;
            if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 0);
            }
            byArray = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.syncConsumeMessageUnblock(object, 1);
            }
            throw throwable;
        }
        WsByteBuffer wsByteBuffer4 = receivedData.getBuffer();
        wsByteBuffer4.flip();
        wsByteBuffer4.getShort();
        int n = (int)wsByteBuffer4.getLong();
        if (n > -1) {
            try {
                if (wsByteBuffer4.hasArray()) {
                    jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(wsByteBuffer4.array(), wsByteBuffer4.position() + wsByteBuffer4.arrayOffset(), n);
                } else {
                    byArray = new byte[n];
                    wsByteBuffer4.get(byArray);
                    jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "._receive"), (String)"1-002-0004", (Object)this);
                throw new SIErrorException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1003", new Object[]{exception}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "_receive", jsMessage);
        }
        return jsMessage;
    }

    private ProxyQueueConversationGroup getProxyQueueConversationGroup() throws SIResourceException {
        ClientConversationState clientConversationState;
        ProxyQueueConversationGroup proxyQueueConversationGroup;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getProxyQueueConversationGroup");
        }
        if ((proxyQueueConversationGroup = (clientConversationState = (ClientConversationState)this.getConversation().getAttachment()).getProxyQueueConversationHGroup()) == null) {
            ProxyQueueConversationGroupFactory proxyQueueConversationGroupFactory = ProxyQueueConversationGroupFactory.getRef();
            proxyQueueConversationGroup = proxyQueueConversationGroupFactory.create(this.getConversation());
            clientConversationState.setProxyQueueConversationGroup(proxyQueueConversationGroup);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getProxyQueueConversationGroup", proxyQueueConversationGroup);
        }
        return proxyQueueConversationGroup;
    }

    protected void checkAlreadyClosed() throws SIConnectionUnavailableException {
        if (this.isClosed()) {
            throw new SIConnectionUnavailableException(nls.getFormattedMessage("CONNECTION_CLOSED_SICO1014", null, null));
        }
    }

    void setInitialUniqueId(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setInitialUnqiueId");
        }
        this.initialUniqueId = byArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setInitialUniqueId");
        }
    }

    void setMeUuid(String string) {
        this.meUuid = string;
    }

    void setResolvedUserId(String string) {
        this.resolvedUserId = string;
    }

    static {
        block4: {
            CLASS_NAME = ConnectionProxy.class.getName();
            tc = SibTr.register(ConnectionProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
            nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/ConnectionProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.137");
            }
            try {
                sibPmiRm = SIBPmiRm.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".<clinit>"), (String)"1-002-0003", null);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Encountered error obtaining PMI RM instance - RM disabled for this connection");
                }
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, exception);
            }
        }
    }
}

