/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class BrowserSessionProxy
extends DestinationSessionProxy
implements BrowserSession {
    private static String CLASS_NAME = BrowserSessionProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(BrowserSessionProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private BrowserProxyQueue proxyQueue;
    private WriterPriorityReadersWriterLock closeLock = null;
    private Object lock = new Object();

    protected BrowserSessionProxy(Conversation conversation, ConnectionProxy connectionProxy, WsByteBuffer wsByteBuffer, BrowserProxyQueue browserProxyQueue, SIDestinationAddress sIDestinationAddress) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{conversation, connectionProxy, browserProxyQueue, sIDestinationAddress});
        }
        this.setDestinationAddress(sIDestinationAddress);
        this.inflateData(wsByteBuffer);
        this.closeLock = connectionProxy.closeLock;
        this.proxyQueue = browserProxyQueue;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage next() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "next");
        }
        this.checkAlreadyClosed();
        JsMessage jsMessage = null;
        Object object = this.lock;
        synchronized (object) {
            block12: {
                try {
                    this.closeLock.startReading();
                    try {
                        jsMessage = this.proxyQueue.next();
                    }
                    catch (MessageDecodeFailedException messageDecodeFailedException) {
                        FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)(CLASS_NAME + ".next"), (String)"1-005-0001", (Object)this);
                        SIResourceException sIResourceException = new SIResourceException(messageDecodeFailedException);
                        throw sIResourceException;
                    }
                    finally {
                        this.closeLock.stopReading();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block12;
                    SibTr.debug(this, tc, "interrupted exception");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "next", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        Object object = this.lock;
        synchronized (object) {
            block11: {
                if (!this.isClosed()) {
                    try {
                        this.closeLock.startWriting();
                        try {
                            this.proxyQueue.close();
                            this.setClosed();
                        }
                        finally {
                            this.closeLock.stopWriting();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!tc.isDebugEnabled()) break block11;
                        SibTr.debug(this, tc, "interrupted exception");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reset");
        }
        this.checkAlreadyClosed();
        Object object = this.lock;
        synchronized (object) {
            block10: {
                try {
                    this.closeLock.startReading();
                    try {
                        this.proxyQueue.reset();
                    }
                    finally {
                        this.closeLock.stopReading();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block10;
                    SibTr.debug(this, tc, "interrupted exception");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reset");
        }
    }
}

